/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class UpdatableRow {
    private final JdbcConnection conn;
    private final ResultInterface result;
    private final int columnCount;
    private String schemaName;
    private String tableName;
    private ArrayList<String> key;
    private boolean isUpdatable;

    public UpdatableRow(JdbcConnection jdbcConnection, ResultInterface resultInterface) throws SQLException {
        String string;
        Object object;
        this.conn = jdbcConnection;
        this.result = resultInterface;
        this.columnCount = resultInterface.getVisibleColumnCount();
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            object = resultInterface.getTableName(i2);
            string = resultInterface.getSchemaName(i2);
            if (object == null || string == null) {
                return;
            }
            if (this.tableName == null) {
                this.tableName = object;
            } else if (!this.tableName.equals(object)) {
                return;
            }
            if (this.schemaName == null) {
                this.schemaName = string;
                continue;
            }
            if (this.schemaName.equals(string)) continue;
            return;
        }
        DatabaseMetaData databaseMetaData = jdbcConnection.getMetaData();
        object = databaseMetaData.getTables(null, StringUtils.escapeMetaDataPattern(this.schemaName), StringUtils.escapeMetaDataPattern(this.tableName), new String[]{"TABLE"});
        if (!object.next()) {
            return;
        }
        if (object.getString("SQL") == null) {
            return;
        }
        string = object.getString("TABLE_NAME");
        boolean bl2 = !string.equals(this.tableName) && string.equalsIgnoreCase(this.tableName);
        this.key = New.arrayList();
        object = databaseMetaData.getPrimaryKeys(null, StringUtils.escapeMetaDataPattern(this.schemaName), this.tableName);
        while (object.next()) {
            String string2 = object.getString("COLUMN_NAME");
            this.key.add(bl2 ? StringUtils.toUpperEnglish(string2) : string2);
        }
        if (this.isIndexUsable(this.key)) {
            this.isUpdatable = true;
            return;
        }
        this.key.clear();
        object = databaseMetaData.getIndexInfo(null, StringUtils.escapeMetaDataPattern(this.schemaName), this.tableName, true, true);
        while (object.next()) {
            short s2 = object.getShort("ORDINAL_POSITION");
            if (s2 == 1) {
                if (this.isIndexUsable(this.key)) {
                    this.isUpdatable = true;
                    return;
                }
                this.key.clear();
            }
            String string3 = object.getString("COLUMN_NAME");
            this.key.add(bl2 ? StringUtils.toUpperEnglish(string3) : string3);
        }
        if (this.isIndexUsable(this.key)) {
            this.isUpdatable = true;
            return;
        }
        this.key = null;
    }

    private boolean isIndexUsable(ArrayList<String> arrayList) {
        if (arrayList.size() == 0) {
            return false;
        }
        for (String string : arrayList) {
            if (this.findColumnIndex(string) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    private int findColumnIndex(String string) {
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            String string2 = this.result.getColumnName(i2);
            if (!string2.equals(string)) continue;
            return i2;
        }
        return -1;
    }

    private int getColumnIndex(String string) {
        int n2 = this.findColumnIndex(string);
        if (n2 < 0) {
            throw DbException.get(42122, string);
        }
        return n2;
    }

    private void appendColumnList(StatementBuilder statementBuilder, boolean bl2) {
        statementBuilder.resetCount();
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            statementBuilder.appendExceptFirst(",");
            String string = this.result.getColumnName(i2);
            statementBuilder.append(StringUtils.quoteIdentifier(string));
            if (!bl2) continue;
            statementBuilder.append("=? ");
        }
    }

    private void appendKeyCondition(StatementBuilder statementBuilder) {
        statementBuilder.append(" WHERE ");
        statementBuilder.resetCount();
        for (String string : this.key) {
            statementBuilder.appendExceptFirst(" AND ");
            statementBuilder.append(StringUtils.quoteIdentifier(string)).append("=?");
        }
    }

    private void setKey(PreparedStatement preparedStatement, int n2, Value[] valueArray) throws SQLException {
        int n3 = this.key.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            String string = this.key.get(i2);
            int n4 = this.getColumnIndex(string);
            Value value = valueArray[n4];
            if (value == null || value == ValueNull.INSTANCE) {
                throw DbException.get(2000);
            }
            value.set(preparedStatement, n2 + i2);
        }
    }

    private void appendTableName(StatementBuilder statementBuilder) {
        if (this.schemaName != null && this.schemaName.length() > 0) {
            statementBuilder.append(StringUtils.quoteIdentifier(this.schemaName)).append('.');
        }
        statementBuilder.append(StringUtils.quoteIdentifier(this.tableName));
    }

    public Value[] readRow(Value[] valueArray) throws SQLException {
        StatementBuilder statementBuilder = new StatementBuilder("SELECT ");
        this.appendColumnList(statementBuilder, false);
        statementBuilder.append(" FROM ");
        this.appendTableName(statementBuilder);
        this.appendKeyCondition(statementBuilder);
        PreparedStatement preparedStatement = this.conn.prepareStatement(statementBuilder.toString());
        this.setKey(preparedStatement, 1, valueArray);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            throw DbException.get(2000);
        }
        Value[] valueArray2 = new Value[this.columnCount];
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            int n2 = this.result.getColumnType(i2);
            valueArray2[i2] = DataType.readValue(this.conn.getSession(), resultSet, i2 + 1, n2);
        }
        return valueArray2;
    }

    public void deleteRow(Value[] valueArray) throws SQLException {
        StatementBuilder statementBuilder = new StatementBuilder("DELETE FROM ");
        this.appendTableName(statementBuilder);
        this.appendKeyCondition(statementBuilder);
        PreparedStatement preparedStatement = this.conn.prepareStatement(statementBuilder.toString());
        this.setKey(preparedStatement, 1, valueArray);
        int n2 = preparedStatement.executeUpdate();
        if (n2 != 1) {
            throw DbException.get(2000);
        }
    }

    public void updateRow(Value[] valueArray, Value[] valueArray2) throws SQLException {
        int n2;
        StatementBuilder statementBuilder = new StatementBuilder("UPDATE ");
        this.appendTableName(statementBuilder);
        statementBuilder.append(" SET ");
        this.appendColumnList(statementBuilder, true);
        this.appendKeyCondition(statementBuilder);
        PreparedStatement preparedStatement = this.conn.prepareStatement(statementBuilder.toString());
        int n3 = 1;
        for (n2 = 0; n2 < this.columnCount; ++n2) {
            Value value = valueArray2[n2];
            if (value == null) {
                value = valueArray[n2];
            }
            value.set(preparedStatement, n3++);
        }
        this.setKey(preparedStatement, n3, valueArray);
        n2 = preparedStatement.executeUpdate();
        if (n2 != 1) {
            throw DbException.get(2000);
        }
    }

    public void insertRow(Value[] valueArray) throws SQLException {
        int n2;
        StatementBuilder statementBuilder = new StatementBuilder("INSERT INTO ");
        this.appendTableName(statementBuilder);
        statementBuilder.append('(');
        this.appendColumnList(statementBuilder, false);
        statementBuilder.append(")VALUES(");
        statementBuilder.resetCount();
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            statementBuilder.appendExceptFirst(",");
            Value value = valueArray[i2];
            if (value == null) {
                statementBuilder.append("DEFAULT");
                continue;
            }
            statementBuilder.append('?');
        }
        statementBuilder.append(')');
        PreparedStatement preparedStatement = this.conn.prepareStatement(statementBuilder.toString());
        int n3 = 0;
        for (n2 = 0; n2 < this.columnCount; ++n2) {
            Value value = valueArray[n2];
            if (value == null) continue;
            value.set(preparedStatement, n3++ + 1);
        }
        n2 = preparedStatement.executeUpdate();
        if (n2 != 1) {
            throw DbException.get(2000);
        }
    }
}

