/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.util.New;
import org.h2.value.Value;

public class RowList {
    private final Session session;
    private final ArrayList<Row> list = New.arrayList();
    private int size;
    private int index;
    private int listIndex;
    private FileStore file;
    private Data rowBuff;
    private ArrayList<Value> lobs;
    private final int maxMemory;
    private int memory;
    private boolean written;
    private boolean readUncached;

    public RowList(Session session) {
        this.session = session;
        this.maxMemory = session.getDatabase().isPersistent() ? session.getDatabase().getMaxOperationMemory() : 0;
    }

    private void writeRow(Data data, Row row) {
        data.checkCapacity(33);
        data.writeByte((byte)1);
        data.writeInt(row.getMemory());
        int n2 = row.getColumnCount();
        data.writeInt(n2);
        data.writeLong(row.getKey());
        data.writeInt(row.getVersion());
        data.writeInt(row.isDeleted() ? 1 : 0);
        data.writeInt(row.getSessionId());
        for (int i2 = 0; i2 < n2; ++i2) {
            Value value = row.getValue(i2);
            data.checkCapacity(1);
            if (value == null) {
                data.writeByte((byte)0);
                continue;
            }
            data.writeByte((byte)1);
            if ((value.getType() == 16 || value.getType() == 15) && value.getSmall() == null && value.getTableId() == 0) {
                if (this.lobs == null) {
                    this.lobs = New.arrayList();
                }
                value = value.copyToTemp();
                this.lobs.add(value);
            }
            data.checkCapacity(data.getValueLen(value));
            data.writeValue(value);
        }
    }

    private void writeAllRows() {
        Object object;
        if (this.file == null) {
            object = this.session.getDatabase();
            String string = ((Database)object).createTempFile();
            this.file = ((Database)object).openFile(string, "rw", false);
            this.file.setCheckedWriting(false);
            this.file.seek(48L);
            this.rowBuff = Data.create((DataHandler)object, 4096);
            this.file.seek(48L);
        }
        object = this.rowBuff;
        RowList.initBuffer((Data)object);
        int n2 = this.list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0 && ((Data)object).length() > 4096) {
                this.flushBuffer((Data)object);
                RowList.initBuffer((Data)object);
            }
            Row row = this.list.get(i2);
            this.writeRow((Data)object, row);
        }
        this.flushBuffer((Data)object);
        this.file.autoDelete();
        this.list.clear();
        this.memory = 0;
    }

    private static void initBuffer(Data data) {
        data.reset();
        data.writeInt(0);
    }

    private void flushBuffer(Data data) {
        data.checkCapacity(1);
        data.writeByte((byte)0);
        data.fillAligned();
        data.setInt(0, data.length() / 16);
        this.file.write(data.getBytes(), 0, data.length());
    }

    public void add(Row row) {
        this.list.add(row);
        this.memory += row.getMemory() + 8;
        if (this.maxMemory > 0 && this.memory > this.maxMemory) {
            this.writeAllRows();
        }
        ++this.size;
    }

    public void reset() {
        this.index = 0;
        if (this.file != null) {
            this.listIndex = 0;
            if (!this.written) {
                this.writeAllRows();
                this.written = true;
            }
            this.list.clear();
            this.file.seek(48L);
        }
    }

    public boolean hasNext() {
        return this.index < this.size;
    }

    private Row readRow(Data data) {
        if (data.readByte() == 0) {
            return null;
        }
        int n2 = data.readInt();
        int n3 = data.readInt();
        long l2 = data.readLong();
        int n4 = data.readInt();
        if (this.readUncached) {
            l2 = 0L;
        }
        boolean bl2 = data.readInt() == 1;
        int n5 = data.readInt();
        Value[] valueArray = new Value[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            Value value;
            if (data.readByte() == 0) {
                value = null;
            } else {
                value = data.readValue();
                if (value.isLinkedToTable() && value.getTableId() == 0) {
                    this.session.removeAtCommit(value);
                }
            }
            valueArray[i2] = value;
        }
        Row row = this.session.createRow(valueArray, n2);
        row.setKey(l2);
        row.setVersion(n4);
        row.setDeleted(bl2);
        row.setSessionId(n5);
        return row;
    }

    public Row next() {
        Row row;
        if (this.file == null) {
            row = this.list.get(this.index++);
        } else {
            if (this.listIndex >= this.list.size()) {
                this.list.clear();
                this.listIndex = 0;
                Data data = this.rowBuff;
                data.reset();
                int n2 = 16;
                this.file.readFully(data.getBytes(), 0, n2);
                int n3 = data.readInt() * 16;
                data.checkCapacity(n3);
                if (n3 - n2 > 0) {
                    this.file.readFully(data.getBytes(), n2, n3 - n2);
                }
                while ((row = this.readRow(data)) != null) {
                    this.list.add(row);
                }
            }
            ++this.index;
            row = this.list.get(this.listIndex++);
        }
        return row;
    }

    public int size() {
        return this.size;
    }

    public void invalidateCache() {
        this.readUncached = true;
    }

    public void close() {
        if (this.file != null) {
            this.file.autoDelete();
            this.file.closeAndDeleteSilently();
            this.file = null;
            this.rowBuff = null;
        }
    }
}

