/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;
import org.h2.value.ValueLong;

public class RowImpl
extends Row {
    private long key;
    private final Value[] data;
    private int memory;
    private int version;
    private boolean deleted;
    private int sessionId;

    public RowImpl(Value[] valueArray, int n2) {
        this.data = valueArray;
        this.memory = n2;
    }

    @Override
    public Row getCopy() {
        Value[] valueArray = new Value[this.data.length];
        System.arraycopy(this.data, 0, valueArray, 0, this.data.length);
        RowImpl rowImpl = new RowImpl(valueArray, this.memory);
        rowImpl.key = this.key;
        rowImpl.version = this.version + 1;
        rowImpl.sessionId = this.sessionId;
        return rowImpl;
    }

    @Override
    public void setKeyAndVersion(SearchRow searchRow) {
        this.setKey(searchRow.getKey());
        this.setVersion(searchRow.getVersion());
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int n2) {
        this.version = n2;
    }

    @Override
    public long getKey() {
        return this.key;
    }

    @Override
    public void setKey(long l2) {
        this.key = l2;
    }

    @Override
    public Value getValue(int n2) {
        return n2 == -1 ? ValueLong.get(this.key) : this.data[n2];
    }

    @Override
    public int getByteCount(Data data) {
        int n2 = 0;
        for (Value value : this.data) {
            n2 += data.getValueLen(value);
        }
        return n2;
    }

    @Override
    public void setValue(int n2, Value value) {
        if (n2 == -1) {
            this.key = value.getLong();
        } else {
            this.data[n2] = value;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.data == null;
    }

    @Override
    public int getColumnCount() {
        return this.data.length;
    }

    @Override
    public int getMemory() {
        if (this.memory != -1) {
            return this.memory;
        }
        int n2 = 40;
        if (this.data != null) {
            int n3 = this.data.length;
            n2 += 24 + n3 * 8;
            for (int i2 = 0; i2 < n3; ++i2) {
                Value value = this.data[i2];
                if (value == null) continue;
                n2 += value.getMemory();
            }
        }
        this.memory = n2;
        return n2;
    }

    public String toString() {
        StatementBuilder statementBuilder = new StatementBuilder("( /* key:");
        statementBuilder.append(this.getKey());
        if (this.version != 0) {
            statementBuilder.append(" v:" + this.version);
        }
        if (this.isDeleted()) {
            statementBuilder.append(" deleted");
        }
        statementBuilder.append(" */ ");
        if (this.data != null) {
            for (Value value : this.data) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(value == null ? "null" : value.getTraceSQL());
            }
        }
        return statementBuilder.append(')').toString();
    }

    @Override
    public void setDeleted(boolean bl2) {
        this.deleted = bl2;
    }

    @Override
    public void setSessionId(int n2) {
        this.sessionId = n2;
    }

    @Override
    public int getSessionId() {
        return this.sessionId;
    }

    @Override
    public void commit() {
        this.sessionId = 0;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public Value[] getValueList() {
        return this.data;
    }
}

