/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.io.IOException;
import java.util.ArrayList;
import org.h2.engine.SessionRemote;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.ResultColumn;
import org.h2.result.ResultInterface;
import org.h2.util.New;
import org.h2.value.Transfer;
import org.h2.value.Value;

public class ResultRemote
implements ResultInterface {
    private int fetchSize;
    private SessionRemote session;
    private Transfer transfer;
    private int id;
    private final ResultColumn[] columns;
    private Value[] currentRow;
    private final int rowCount;
    private int rowId;
    private int rowOffset;
    private ArrayList<Value[]> result;
    private final Trace trace;

    public ResultRemote(SessionRemote sessionRemote, Transfer transfer, int n2, int n3, int n4) throws IOException {
        this.session = sessionRemote;
        this.trace = sessionRemote.getTrace();
        this.transfer = transfer;
        this.id = n2;
        this.columns = new ResultColumn[n3];
        this.rowCount = transfer.readInt();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.columns[i2] = new ResultColumn(transfer);
        }
        this.rowId = -1;
        this.result = New.arrayList();
        this.fetchSize = n4;
        this.fetchRows(false);
    }

    @Override
    public String getAlias(int n2) {
        return this.columns[n2].alias;
    }

    @Override
    public String getSchemaName(int n2) {
        return this.columns[n2].schemaName;
    }

    @Override
    public String getTableName(int n2) {
        return this.columns[n2].tableName;
    }

    @Override
    public String getColumnName(int n2) {
        return this.columns[n2].columnName;
    }

    @Override
    public int getColumnType(int n2) {
        return this.columns[n2].columnType;
    }

    @Override
    public long getColumnPrecision(int n2) {
        return this.columns[n2].precision;
    }

    @Override
    public int getColumnScale(int n2) {
        return this.columns[n2].scale;
    }

    @Override
    public int getDisplaySize(int n2) {
        return this.columns[n2].displaySize;
    }

    @Override
    public boolean isAutoIncrement(int n2) {
        return this.columns[n2].autoIncrement;
    }

    @Override
    public int getNullable(int n2) {
        return this.columns[n2].nullable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.rowId = -1;
        this.currentRow = null;
        if (this.session == null) {
            return;
        }
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            this.session.checkClosed();
            try {
                this.session.traceOperation("RESULT_RESET", this.id);
                this.transfer.writeInt(6).writeInt(this.id).flush();
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, null);
            }
        }
    }

    @Override
    public Value[] currentRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() {
        if (this.rowId < this.rowCount) {
            ++this.rowId;
            this.remapIfOld();
            if (this.rowId < this.rowCount) {
                if (this.rowId - this.rowOffset >= this.result.size()) {
                    this.fetchRows(true);
                }
                this.currentRow = this.result.get(this.rowId - this.rowOffset);
                return true;
            }
            this.currentRow = null;
        }
        return false;
    }

    @Override
    public int getRowId() {
        return this.rowId;
    }

    @Override
    public int getVisibleColumnCount() {
        return this.columns.length;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendClose() {
        if (this.session == null) {
            return;
        }
        try {
            SessionRemote sessionRemote = this.session;
            synchronized (sessionRemote) {
                this.session.traceOperation("RESULT_CLOSE", this.id);
                this.transfer.writeInt(7).writeInt(this.id);
            }
        }
        catch (IOException iOException) {
            this.trace.error(iOException, "close");
        }
        finally {
            this.transfer = null;
            this.session = null;
        }
    }

    @Override
    public void close() {
        this.result = null;
        this.sendClose();
    }

    private void remapIfOld() {
        if (this.session == null) {
            return;
        }
        try {
            if (this.id <= this.session.getCurrentId() - SysProperties.SERVER_CACHED_OBJECTS / 2) {
                int n2 = this.session.getNextId();
                this.session.traceOperation("CHANGE_ID", this.id);
                this.transfer.writeInt(9).writeInt(this.id).writeInt(n2);
                this.id = n2;
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchRows(boolean bl2) {
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            this.session.checkClosed();
            try {
                boolean bl3;
                this.rowOffset += this.result.size();
                this.result.clear();
                int n2 = Math.min(this.fetchSize, this.rowCount - this.rowOffset);
                if (bl2) {
                    this.session.traceOperation("RESULT_FETCH_ROWS", this.id);
                    this.transfer.writeInt(5).writeInt(this.id).writeInt(n2);
                    this.session.done(this.transfer);
                }
                for (int i2 = 0; i2 < n2 && (bl3 = this.transfer.readBoolean()); ++i2) {
                    int n3 = this.columns.length;
                    Value[] valueArray = new Value[n3];
                    for (int i3 = 0; i3 < n3; ++i3) {
                        Value value;
                        valueArray[i3] = value = this.transfer.readValue();
                    }
                    this.result.add(valueArray);
                }
                if (this.rowOffset + this.result.size() >= this.rowCount) {
                    this.sendClose();
                }
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, null);
            }
        }
    }

    public String toString() {
        return "columns: " + this.columns.length + " rows: " + this.rowCount + " pos: " + this.rowId;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int n2) {
        this.fetchSize = n2;
    }

    @Override
    public boolean needToClose() {
        return true;
    }
}

