/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.type;

import java.nio.ByteBuffer;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;

public class StringDataType
implements DataType {
    public static final StringDataType INSTANCE = new StringDataType();

    @Override
    public int compare(Object object, Object object2) {
        return object.toString().compareTo(object2.toString());
    }

    @Override
    public int getMemory(Object object) {
        return 24 + 2 * object.toString().length();
    }

    @Override
    public void read(ByteBuffer byteBuffer, Object[] objectArray, int n2, boolean bl2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = this.read(byteBuffer);
        }
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object[] objectArray, int n2, boolean bl2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.write(writeBuffer, objectArray[i2]);
        }
    }

    @Override
    public String read(ByteBuffer byteBuffer) {
        int n2 = DataUtils.readVarInt(byteBuffer);
        return DataUtils.readString(byteBuffer, n2);
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object object) {
        String string = object.toString();
        int n2 = string.length();
        writeBuffer.putVarInt(n2).putStringData(string, n2);
    }
}

