/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.rtree;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.rtree.SpatialKey;
import org.h2.mvstore.type.DataType;
import org.h2.util.New;

public class SpatialDataType
implements DataType {
    private final int dimensions;

    public SpatialDataType(int n2) {
        DataUtils.checkArgument(n2 >= 1 && n2 < 32, "Dimensions must be between 1 and 31, is {0}", n2);
        this.dimensions = n2;
    }

    @Override
    public int compare(Object object, Object object2) {
        long l2;
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        long l3 = ((SpatialKey)object).getId();
        return l3 < (l2 = ((SpatialKey)object2).getId()) ? -1 : (l3 > l2 ? 1 : 0);
    }

    public boolean equals(Object object, Object object2) {
        long l2;
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        long l3 = ((SpatialKey)object).getId();
        return l3 == (l2 = ((SpatialKey)object2).getId());
    }

    @Override
    public int getMemory(Object object) {
        return 40 + this.dimensions * 4;
    }

    @Override
    public void read(ByteBuffer byteBuffer, Object[] objectArray, int n2, boolean bl2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = this.read(byteBuffer);
        }
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object[] objectArray, int n2, boolean bl2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.write(writeBuffer, objectArray[i2]);
        }
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object object) {
        int n2;
        SpatialKey spatialKey = (SpatialKey)object;
        if (spatialKey.isNull()) {
            writeBuffer.putVarInt(-1);
            writeBuffer.putVarLong(spatialKey.getId());
            return;
        }
        int n3 = 0;
        for (n2 = 0; n2 < this.dimensions; ++n2) {
            if (spatialKey.min(n2) != spatialKey.max(n2)) continue;
            n3 |= 1 << n2;
        }
        writeBuffer.putVarInt(n3);
        for (n2 = 0; n2 < this.dimensions; ++n2) {
            writeBuffer.putFloat(spatialKey.min(n2));
            if ((n3 & 1 << n2) != 0) continue;
            writeBuffer.putFloat(spatialKey.max(n2));
        }
        writeBuffer.putVarLong(spatialKey.getId());
    }

    @Override
    public Object read(ByteBuffer byteBuffer) {
        int n2 = DataUtils.readVarInt(byteBuffer);
        if (n2 == -1) {
            long l2 = DataUtils.readVarLong(byteBuffer);
            return new SpatialKey(l2, new float[0]);
        }
        float[] fArray = new float[this.dimensions * 2];
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            float f2 = byteBuffer.getFloat();
            float f3 = (n2 & 1 << i2) != 0 ? f2 : byteBuffer.getFloat();
            fArray[i2 + i2] = f2;
            fArray[i2 + i2 + 1] = f3;
        }
        long l3 = DataUtils.readVarLong(byteBuffer);
        return new SpatialKey(l3, fArray);
    }

    public boolean isOverlap(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object;
        SpatialKey spatialKey2 = (SpatialKey)object2;
        if (spatialKey.isNull() || spatialKey2.isNull()) {
            return false;
        }
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            if (!(spatialKey.max(i2) < spatialKey2.min(i2)) && !(spatialKey.min(i2) > spatialKey2.max(i2))) continue;
            return false;
        }
        return true;
    }

    public void increaseBounds(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object2;
        SpatialKey spatialKey2 = (SpatialKey)object;
        if (spatialKey.isNull() || spatialKey2.isNull()) {
            return;
        }
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            spatialKey2.setMin(i2, Math.min(spatialKey2.min(i2), spatialKey.min(i2)));
            spatialKey2.setMax(i2, Math.max(spatialKey2.max(i2), spatialKey.max(i2)));
        }
    }

    public float getAreaIncrease(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object2;
        SpatialKey spatialKey2 = (SpatialKey)object;
        if (spatialKey2.isNull() || spatialKey.isNull()) {
            return 0.0f;
        }
        float f2 = spatialKey2.min(0);
        float f3 = spatialKey2.max(0);
        float f4 = f3 - f2;
        f2 = Math.min(f2, spatialKey.min(0));
        f3 = Math.max(f3, spatialKey.max(0));
        float f5 = f3 - f2;
        for (int i2 = 1; i2 < this.dimensions; ++i2) {
            f2 = spatialKey2.min(i2);
            f3 = spatialKey2.max(i2);
            f4 *= f3 - f2;
            f2 = Math.min(f2, spatialKey.min(i2));
            f3 = Math.max(f3, spatialKey.max(i2));
            f5 *= f3 - f2;
        }
        return f5 - f4;
    }

    float getCombinedArea(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object;
        SpatialKey spatialKey2 = (SpatialKey)object2;
        if (spatialKey.isNull()) {
            return this.getArea(spatialKey2);
        }
        if (spatialKey2.isNull()) {
            return this.getArea(spatialKey);
        }
        float f2 = 1.0f;
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            float f3 = Math.min(spatialKey.min(i2), spatialKey2.min(i2));
            float f4 = Math.max(spatialKey.max(i2), spatialKey2.max(i2));
            f2 *= f4 - f3;
        }
        return f2;
    }

    private float getArea(SpatialKey spatialKey) {
        if (spatialKey.isNull()) {
            return 0.0f;
        }
        float f2 = 1.0f;
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            f2 *= spatialKey.max(i2) - spatialKey.min(i2);
        }
        return f2;
    }

    public boolean contains(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object;
        SpatialKey spatialKey2 = (SpatialKey)object2;
        if (spatialKey.isNull() || spatialKey2.isNull()) {
            return false;
        }
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            if (!(spatialKey.min(i2) > spatialKey2.min(i2)) && !(spatialKey.max(i2) < spatialKey2.max(i2))) continue;
            return false;
        }
        return true;
    }

    public boolean isInside(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object;
        SpatialKey spatialKey2 = (SpatialKey)object2;
        if (spatialKey.isNull() || spatialKey2.isNull()) {
            return false;
        }
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            if (!(spatialKey.min(i2) <= spatialKey2.min(i2)) && !(spatialKey.max(i2) >= spatialKey2.max(i2))) continue;
            return false;
        }
        return true;
    }

    Object createBoundingBox(Object object) {
        SpatialKey spatialKey = (SpatialKey)object;
        if (spatialKey.isNull()) {
            return spatialKey;
        }
        float[] fArray = new float[this.dimensions * 2];
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            fArray[i2 + i2] = spatialKey.min(i2);
            fArray[i2 + i2 + 1] = spatialKey.max(i2);
        }
        return new SpatialKey(0L, fArray);
    }

    public int[] getExtremes(ArrayList<Object> arrayList) {
        float f2;
        int n2;
        if ((arrayList = SpatialDataType.getNotNull(arrayList)).size() == 0) {
            return null;
        }
        SpatialKey spatialKey = (SpatialKey)this.createBoundingBox(arrayList.get(0));
        SpatialKey spatialKey2 = (SpatialKey)this.createBoundingBox(spatialKey);
        for (n2 = 0; n2 < this.dimensions; ++n2) {
            float f3 = spatialKey2.min(n2);
            spatialKey2.setMin(n2, spatialKey2.max(n2));
            spatialKey2.setMax(n2, f3);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            Object object = arrayList.get(n2);
            this.increaseBounds(spatialKey, object);
            this.increaseMaxInnerBounds(spatialKey2, object);
        }
        double d2 = 0.0;
        int n3 = 0;
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            float f4;
            float f5;
            f2 = spatialKey2.max(i2) - spatialKey2.min(i2);
            if (f2 < 0.0f || !((double)(f5 = f2 / (f4 = spatialKey.max(i2) - spatialKey.min(i2))) > d2)) continue;
            d2 = f5;
            n3 = i2;
        }
        if (d2 <= 0.0) {
            return null;
        }
        float f6 = spatialKey2.min(n3);
        f2 = spatialKey2.max(n3);
        int n4 = -1;
        int n5 = -1;
        for (int i3 = 0; i3 < arrayList.size() && (n4 < 0 || n5 < 0); ++i3) {
            SpatialKey spatialKey3 = (SpatialKey)arrayList.get(i3);
            if (n4 < 0 && spatialKey3.max(n3) == f6) {
                n4 = i3;
                continue;
            }
            if (n5 >= 0 || spatialKey3.min(n3) != f2) continue;
            n5 = i3;
        }
        return new int[]{n4, n5};
    }

    private static ArrayList<Object> getNotNull(ArrayList<Object> arrayList) {
        SpatialKey spatialKey;
        ArrayList arrayList2 = null;
        for (Object object : arrayList) {
            spatialKey = (SpatialKey)object;
            if (!spatialKey.isNull()) continue;
            arrayList2 = New.arrayList();
            break;
        }
        if (arrayList2 == null) {
            return arrayList;
        }
        for (Object object : arrayList) {
            spatialKey = (SpatialKey)object;
            if (spatialKey.isNull()) continue;
            arrayList2.add(spatialKey);
        }
        return arrayList2;
    }

    private void increaseMaxInnerBounds(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object;
        SpatialKey spatialKey2 = (SpatialKey)object2;
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            spatialKey.setMin(i2, Math.min(spatialKey.min(i2), spatialKey2.max(i2)));
            spatialKey.setMax(i2, Math.max(spatialKey.max(i2), spatialKey2.min(i2)));
        }
    }
}

