/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.rtree.SpatialDataType;
import org.h2.mvstore.rtree.SpatialKey;
import org.h2.result.SortOrder;
import org.h2.store.DataHandler;
import org.h2.tools.SimpleResultSet;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLobDb;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueTimestampUtc;
import org.h2.value.ValueUuid;

public class ValueDataType
implements org.h2.mvstore.type.DataType {
    private static final int INT_0_15 = 32;
    private static final int LONG_0_7 = 48;
    private static final int DECIMAL_0_1 = 56;
    private static final int DECIMAL_SMALL_0 = 58;
    private static final int DECIMAL_SMALL = 59;
    private static final int DOUBLE_0_1 = 60;
    private static final int FLOAT_0_1 = 62;
    private static final int BOOLEAN_FALSE = 64;
    private static final int BOOLEAN_TRUE = 65;
    private static final int INT_NEG = 66;
    private static final int LONG_NEG = 67;
    private static final int STRING_0_31 = 68;
    private static final int BYTES_0_31 = 100;
    private static final int SPATIAL_KEY_2D = 132;
    final DataHandler handler;
    final CompareMode compareMode;
    final int[] sortTypes;
    SpatialDataType spatialType;

    public ValueDataType(CompareMode compareMode, DataHandler dataHandler, int[] nArray) {
        this.compareMode = compareMode;
        this.handler = dataHandler;
        this.sortTypes = nArray;
    }

    private SpatialDataType getSpatialDataType() {
        if (this.spatialType == null) {
            this.spatialType = new SpatialDataType(2);
        }
        return this.spatialType;
    }

    @Override
    public int compare(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object instanceof ValueArray && object2 instanceof ValueArray) {
            Value[] valueArray = ((ValueArray)object).getList();
            Value[] valueArray2 = ((ValueArray)object2).getList();
            int n2 = valueArray.length;
            int n3 = valueArray2.length;
            int n4 = Math.min(n2, n3);
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = this.sortTypes[i2];
                int n6 = this.compareValues(valueArray[i2], valueArray2[i2], n5);
                if (n6 == 0) continue;
                return n6;
            }
            if (n4 < n2) {
                return -1;
            }
            if (n4 < n3) {
                return 1;
            }
            return 0;
        }
        return this.compareValues((Value)object, (Value)object2, 0);
    }

    private int compareValues(Value value, Value value2, int n2) {
        boolean bl2;
        if (value == value2) {
            return 0;
        }
        if (value == null) {
            return -1;
        }
        if (value2 == null) {
            return 1;
        }
        boolean bl3 = value == ValueNull.INSTANCE;
        boolean bl4 = bl2 = value2 == ValueNull.INSTANCE;
        if (bl3 || bl2) {
            return SortOrder.compareNull(bl3, n2);
        }
        int n3 = value.compareTypeSafe(value2, this.compareMode);
        if ((n2 & 1) != 0) {
            n3 = -n3;
        }
        return n3;
    }

    @Override
    public int getMemory(Object object) {
        if (object instanceof SpatialKey) {
            return this.getSpatialDataType().getMemory(object);
        }
        return ValueDataType.getMemory((Value)object);
    }

    private static int getMemory(Value value) {
        return value == null ? 0 : value.getMemory();
    }

    @Override
    public void read(ByteBuffer byteBuffer, Object[] objectArray, int n2, boolean bl2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = this.read(byteBuffer);
        }
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object[] objectArray, int n2, boolean bl2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.write(writeBuffer, objectArray[i2]);
        }
    }

    @Override
    public Object read(ByteBuffer byteBuffer) {
        return this.readValue(byteBuffer);
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object object) {
        if (object instanceof SpatialKey) {
            writeBuffer.put((byte)-124);
            this.getSpatialDataType().write(writeBuffer, object);
            return;
        }
        Value value = (Value)object;
        this.writeValue(writeBuffer, value);
    }

    private void writeValue(WriteBuffer writeBuffer, Value value) {
        if (value == ValueNull.INSTANCE) {
            writeBuffer.put((byte)0);
            return;
        }
        int n2 = value.getType();
        switch (n2) {
            case 1: {
                writeBuffer.put((byte)(value.getBoolean() != false ? 65 : 64));
                break;
            }
            case 2: {
                writeBuffer.put((byte)n2).put(value.getByte());
                break;
            }
            case 3: {
                writeBuffer.put((byte)n2).putShort(value.getShort());
                break;
            }
            case 4: {
                int n3 = value.getInt();
                if (n3 < 0) {
                    writeBuffer.put((byte)66).putVarInt(-n3);
                    break;
                }
                if (n3 < 16) {
                    writeBuffer.put((byte)(32 + n3));
                    break;
                }
                writeBuffer.put((byte)n2).putVarInt(n3);
                break;
            }
            case 5: {
                long l2 = value.getLong();
                if (l2 < 0L) {
                    writeBuffer.put((byte)67).putVarLong(-l2);
                    break;
                }
                if (l2 < 8L) {
                    writeBuffer.put((byte)(48L + l2));
                    break;
                }
                writeBuffer.put((byte)n2).putVarLong(l2);
                break;
            }
            case 6: {
                BigDecimal bigDecimal = value.getBigDecimal();
                if (BigDecimal.ZERO.equals(bigDecimal)) {
                    writeBuffer.put((byte)56);
                    break;
                }
                if (BigDecimal.ONE.equals(bigDecimal)) {
                    writeBuffer.put((byte)57);
                    break;
                }
                int n4 = bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.unscaledValue();
                int n5 = bigInteger.bitLength();
                if (n5 <= 63) {
                    if (n4 == 0) {
                        writeBuffer.put((byte)58).putVarLong(bigInteger.longValue());
                        break;
                    }
                    writeBuffer.put((byte)59).putVarInt(n4).putVarLong(bigInteger.longValue());
                    break;
                }
                byte[] byArray = bigInteger.toByteArray();
                writeBuffer.put((byte)n2).putVarInt(n4).putVarInt(byArray.length).put(byArray);
                break;
            }
            case 9: {
                ValueTime valueTime = (ValueTime)value;
                long l3 = valueTime.getNanos();
                long l4 = l3 / 1000000L;
                writeBuffer.put((byte)n2).putVarLong(l4).putVarLong(l3 -= l4 * 1000000L);
                break;
            }
            case 10: {
                long l5 = ((ValueDate)value).getDateValue();
                writeBuffer.put((byte)n2).putVarLong(l5);
                break;
            }
            case 11: {
                ValueTimestamp valueTimestamp = (ValueTimestamp)value;
                long l6 = valueTimestamp.getDateValue();
                long l7 = valueTimestamp.getTimeNanos();
                long l8 = l7 / 1000000L;
                writeBuffer.put((byte)n2).putVarLong(l6).putVarLong(l8).putVarLong(l7 -= l8 * 1000000L);
                break;
            }
            case 23: {
                ValueTimestampUtc valueTimestampUtc = (ValueTimestampUtc)value;
                long l9 = valueTimestampUtc.getUtcDateTimeNanos();
                writeBuffer.put((byte)n2).putVarLong(l9);
                break;
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
                long l10 = valueTimestampTimeZone.getDateValue();
                long l11 = valueTimestampTimeZone.getTimeNanos();
                long l12 = l11 / 1000000L;
                writeBuffer.put((byte)n2).putVarLong(l10).putVarLong(l12).putVarLong(l11 -= l12 * 1000000L).putVarInt(valueTimestampTimeZone.getTimeZoneOffsetMins());
                break;
            }
            case 19: {
                byte[] byArray = value.getBytesNoCopy();
                writeBuffer.put((byte)n2).putVarInt(byArray.length).put(byArray);
                break;
            }
            case 12: {
                byte[] byArray = value.getBytesNoCopy();
                int n6 = byArray.length;
                if (n6 < 32) {
                    writeBuffer.put((byte)(100 + n6)).put(byArray);
                    break;
                }
                writeBuffer.put((byte)n2).putVarInt(byArray.length).put(byArray);
                break;
            }
            case 20: {
                ValueUuid valueUuid = (ValueUuid)value;
                writeBuffer.put((byte)n2).putLong(valueUuid.getHigh()).putLong(valueUuid.getLow());
                break;
            }
            case 13: {
                String string = value.getString();
                int n7 = string.length();
                if (n7 < 32) {
                    writeBuffer.put((byte)(68 + n7)).putStringData(string, n7);
                    break;
                }
                writeBuffer.put((byte)n2);
                ValueDataType.writeString(writeBuffer, string);
                break;
            }
            case 14: 
            case 21: {
                writeBuffer.put((byte)n2);
                ValueDataType.writeString(writeBuffer, value.getString());
                break;
            }
            case 7: {
                double d2 = value.getDouble();
                if (d2 == 1.0) {
                    writeBuffer.put((byte)61);
                    break;
                }
                long l13 = Double.doubleToLongBits(d2);
                if (l13 == ValueDouble.ZERO_BITS) {
                    writeBuffer.put((byte)60);
                    break;
                }
                writeBuffer.put((byte)n2).putVarLong(Long.reverse(l13));
                break;
            }
            case 8: {
                float f2 = value.getFloat();
                if (f2 == 1.0f) {
                    writeBuffer.put((byte)63);
                    break;
                }
                int n8 = Float.floatToIntBits(f2);
                if (n8 == ValueFloat.ZERO_BITS) {
                    writeBuffer.put((byte)62);
                    break;
                }
                writeBuffer.put((byte)n2).putVarInt(Integer.reverse(n8));
                break;
            }
            case 15: 
            case 16: {
                writeBuffer.put((byte)n2);
                ValueLobDb valueLobDb = (ValueLobDb)value;
                byte[] byArray = valueLobDb.getSmall();
                if (byArray == null) {
                    writeBuffer.putVarInt(-3).putVarInt(valueLobDb.getTableId()).putVarLong(valueLobDb.getLobId()).putVarLong(valueLobDb.getPrecision());
                    break;
                }
                writeBuffer.putVarInt(byArray.length).put(byArray);
                break;
            }
            case 17: {
                Value[] valueArray = ((ValueArray)value).getList();
                writeBuffer.put((byte)n2).putVarInt(valueArray.length);
                for (Value value2 : valueArray) {
                    this.writeValue(writeBuffer, value2);
                }
                break;
            }
            case 18: {
                writeBuffer.put((byte)n2);
                try {
                    int n9;
                    ResultSet resultSet = ((ValueResultSet)value).getResultSet();
                    resultSet.beforeFirst();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n10 = resultSetMetaData.getColumnCount();
                    writeBuffer.putVarInt(n10);
                    for (n9 = 0; n9 < n10; ++n9) {
                        ValueDataType.writeString(writeBuffer, resultSetMetaData.getColumnName(n9 + 1));
                        writeBuffer.putVarInt(resultSetMetaData.getColumnType(n9 + 1)).putVarInt(resultSetMetaData.getPrecision(n9 + 1)).putVarInt(resultSetMetaData.getScale(n9 + 1));
                    }
                    while (resultSet.next()) {
                        writeBuffer.put((byte)1);
                        for (n9 = 0; n9 < n10; ++n9) {
                            int n11 = DataType.getValueTypeFromResultSet(resultSetMetaData, n9 + 1);
                            Value value3 = DataType.readValue(null, resultSet, n9 + 1, n11);
                            this.writeValue(writeBuffer, value3);
                        }
                    }
                    writeBuffer.put((byte)0);
                    resultSet.beforeFirst();
                    break;
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
            }
            case 22: {
                byte[] byArray = value.getBytes();
                int n12 = byArray.length;
                writeBuffer.put((byte)n2).putVarInt(n12).put(byArray);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + value.getType());
            }
        }
    }

    private static void writeString(WriteBuffer writeBuffer, String string) {
        int n2 = string.length();
        writeBuffer.putVarInt(n2).putStringData(string, n2);
    }

    private Object readValue(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.get() & 0xFF;
        switch (n2) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 65: {
                return ValueBoolean.get(true);
            }
            case 64: {
                return ValueBoolean.get(false);
            }
            case 66: {
                return ValueInt.get(-ValueDataType.readVarInt(byteBuffer));
            }
            case 4: {
                return ValueInt.get(ValueDataType.readVarInt(byteBuffer));
            }
            case 67: {
                return ValueLong.get(-ValueDataType.readVarLong(byteBuffer));
            }
            case 5: {
                return ValueLong.get(ValueDataType.readVarLong(byteBuffer));
            }
            case 2: {
                return ValueByte.get(byteBuffer.get());
            }
            case 3: {
                return ValueShort.get(byteBuffer.getShort());
            }
            case 56: {
                return ValueDecimal.ZERO;
            }
            case 57: {
                return ValueDecimal.ONE;
            }
            case 58: {
                return ValueDecimal.get(BigDecimal.valueOf(ValueDataType.readVarLong(byteBuffer)));
            }
            case 59: {
                int n3 = ValueDataType.readVarInt(byteBuffer);
                return ValueDecimal.get(BigDecimal.valueOf(ValueDataType.readVarLong(byteBuffer), n3));
            }
            case 6: {
                int n4 = ValueDataType.readVarInt(byteBuffer);
                int n5 = ValueDataType.readVarInt(byteBuffer);
                byte[] byArray = DataUtils.newBytes(n5);
                byteBuffer.get(byArray, 0, n5);
                BigInteger bigInteger = new BigInteger(byArray);
                return ValueDecimal.get(new BigDecimal(bigInteger, n4));
            }
            case 10: {
                return ValueDate.fromDateValue(ValueDataType.readVarLong(byteBuffer));
            }
            case 9: {
                long l2 = ValueDataType.readVarLong(byteBuffer) * 1000000L + ValueDataType.readVarLong(byteBuffer);
                return ValueTime.fromNanos(l2);
            }
            case 11: {
                long l3 = ValueDataType.readVarLong(byteBuffer);
                long l4 = ValueDataType.readVarLong(byteBuffer) * 1000000L + ValueDataType.readVarLong(byteBuffer);
                return ValueTimestamp.fromDateValueAndNanos(l3, l4);
            }
            case 23: {
                long l5 = ValueDataType.readVarLong(byteBuffer);
                return ValueTimestampUtc.fromNanos(l5);
            }
            case 24: {
                long l6 = ValueDataType.readVarLong(byteBuffer);
                long l7 = ValueDataType.readVarLong(byteBuffer) * 1000000L + ValueDataType.readVarLong(byteBuffer);
                short s2 = (short)ValueDataType.readVarInt(byteBuffer);
                return ValueTimestampTimeZone.fromDateValueAndNanos(l6, l7, s2);
            }
            case 12: {
                int n6 = ValueDataType.readVarInt(byteBuffer);
                byte[] byArray = DataUtils.newBytes(n6);
                byteBuffer.get(byArray, 0, n6);
                return ValueBytes.getNoCopy(byArray);
            }
            case 19: {
                int n7 = ValueDataType.readVarInt(byteBuffer);
                byte[] byArray = DataUtils.newBytes(n7);
                byteBuffer.get(byArray, 0, n7);
                return ValueJavaObject.getNoCopy(null, byArray, this.handler);
            }
            case 20: {
                return ValueUuid.get(byteBuffer.getLong(), byteBuffer.getLong());
            }
            case 13: {
                return ValueString.get(ValueDataType.readString(byteBuffer));
            }
            case 14: {
                return ValueStringIgnoreCase.get(ValueDataType.readString(byteBuffer));
            }
            case 21: {
                return ValueStringFixed.get(ValueDataType.readString(byteBuffer));
            }
            case 62: {
                return ValueFloat.get(0.0f);
            }
            case 63: {
                return ValueFloat.get(1.0f);
            }
            case 60: {
                return ValueDouble.get(0.0);
            }
            case 61: {
                return ValueDouble.get(1.0);
            }
            case 7: {
                return ValueDouble.get(Double.longBitsToDouble(Long.reverse(ValueDataType.readVarLong(byteBuffer))));
            }
            case 8: {
                return ValueFloat.get(Float.intBitsToFloat(Integer.reverse(ValueDataType.readVarInt(byteBuffer))));
            }
            case 15: 
            case 16: {
                int n8 = ValueDataType.readVarInt(byteBuffer);
                if (n8 >= 0) {
                    byte[] byArray = DataUtils.newBytes(n8);
                    byteBuffer.get(byArray, 0, n8);
                    return ValueLobDb.createSmallLob(n2, byArray);
                }
                if (n8 == -3) {
                    int n9 = ValueDataType.readVarInt(byteBuffer);
                    long l8 = ValueDataType.readVarLong(byteBuffer);
                    long l9 = ValueDataType.readVarLong(byteBuffer);
                    ValueLobDb valueLobDb = ValueLobDb.create(n2, this.handler, n9, l8, null, l9);
                    return valueLobDb;
                }
                throw DbException.get(90030, "lob type: " + n8);
            }
            case 17: {
                int n10 = ValueDataType.readVarInt(byteBuffer);
                Value[] valueArray = new Value[n10];
                for (int i2 = 0; i2 < n10; ++i2) {
                    valueArray[i2] = (Value)this.readValue(byteBuffer);
                }
                return ValueArray.get(valueArray);
            }
            case 18: {
                SimpleResultSet simpleResultSet = new SimpleResultSet();
                simpleResultSet.setAutoClose(false);
                int n11 = ValueDataType.readVarInt(byteBuffer);
                for (int i3 = 0; i3 < n11; ++i3) {
                    simpleResultSet.addColumn(ValueDataType.readString(byteBuffer), ValueDataType.readVarInt(byteBuffer), ValueDataType.readVarInt(byteBuffer), ValueDataType.readVarInt(byteBuffer));
                }
                while (byteBuffer.get() != 0) {
                    Object[] objectArray = new Object[n11];
                    for (int i4 = 0; i4 < n11; ++i4) {
                        objectArray[i4] = ((Value)this.readValue(byteBuffer)).getObject();
                    }
                    simpleResultSet.addRow(objectArray);
                }
                return ValueResultSet.get(simpleResultSet);
            }
            case 22: {
                int n12 = ValueDataType.readVarInt(byteBuffer);
                byte[] byArray = DataUtils.newBytes(n12);
                byteBuffer.get(byArray, 0, n12);
                return ValueGeometry.get(byArray);
            }
            case 132: {
                return this.getSpatialDataType().read(byteBuffer);
            }
        }
        if (n2 >= 32 && n2 < 48) {
            return ValueInt.get(n2 - 32);
        }
        if (n2 >= 48 && n2 < 56) {
            return ValueLong.get(n2 - 48);
        }
        if (n2 >= 100 && n2 < 132) {
            int n13 = n2 - 100;
            byte[] byArray = DataUtils.newBytes(n13);
            byteBuffer.get(byArray, 0, n13);
            return ValueBytes.getNoCopy(byArray);
        }
        if (n2 >= 68 && n2 < 100) {
            return ValueString.get(ValueDataType.readString(byteBuffer, n2 - 68));
        }
        throw DbException.get(90030, "type: " + n2);
    }

    private static int readVarInt(ByteBuffer byteBuffer) {
        return DataUtils.readVarInt(byteBuffer);
    }

    private static long readVarLong(ByteBuffer byteBuffer) {
        return DataUtils.readVarLong(byteBuffer);
    }

    private static String readString(ByteBuffer byteBuffer, int n2) {
        return DataUtils.readString(byteBuffer, n2);
    }

    private static String readString(ByteBuffer byteBuffer) {
        int n2 = ValueDataType.readVarInt(byteBuffer);
        return DataUtils.readString(byteBuffer, n2);
    }

    public int hashCode() {
        return this.compareMode.hashCode() ^ Arrays.hashCode(this.sortTypes);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ValueDataType)) {
            return false;
        }
        ValueDataType valueDataType = (ValueDataType)object;
        if (!this.compareMode.equals(valueDataType.compareMode)) {
            return false;
        }
        return Arrays.equals(this.sortTypes, valueDataType.sortTypes);
    }
}

