/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.ObjectDataType;
import org.h2.util.New;

public class TransactionStore {
    final MVStore store;
    final MVMap<Integer, Object[]> preparedTransactions;
    final MVMap<Long, Object[]> undoLog;
    private HashMap<Integer, MVMap<Object, VersionedValue>> maps = New.hashMap();
    private final DataType dataType;
    private final BitSet openTransactions = new BitSet();
    private boolean init;
    private int maxTransactionId = 65535;
    private int nextTempMapId;

    public TransactionStore(MVStore mVStore) {
        this(mVStore, new ObjectDataType());
    }

    public TransactionStore(MVStore mVStore, DataType dataType) {
        this.store = mVStore;
        this.dataType = dataType;
        this.preparedTransactions = mVStore.openMap("openTransactions", new MVMap.Builder());
        VersionedValueType versionedValueType = new VersionedValueType(dataType);
        ArrayType arrayType = new ArrayType(new DataType[]{new ObjectDataType(), dataType, versionedValueType});
        MVMap.Builder builder = new MVMap.Builder().valueType(arrayType);
        this.undoLog = mVStore.openMap("undoLog", builder);
        if (this.undoLog.getValueType() != arrayType) {
            throw DataUtils.newIllegalStateException(100, "Undo map open with a different value type", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        this.init = true;
        for (String object : this.store.getMapNames()) {
            if (!object.startsWith("temp.")) continue;
            MVMap<Object, Integer> mVMap = this.openTempMap(object);
            this.store.removeMap(mVMap);
        }
        MVMap<Long, Object[]> mVMap = this.undoLog;
        synchronized (mVMap) {
            if (this.undoLog.size() > 0) {
                for (Long l2 : this.undoLog.keySet()) {
                    int n2 = TransactionStore.getTransactionId(l2);
                    this.openTransactions.set(n2);
                }
            }
        }
    }

    public void setMaxTransactionId(int n2) {
        this.maxTransactionId = n2;
    }

    static long getOperationId(int n2, long l2) {
        DataUtils.checkArgument(n2 >= 0 && n2 < 0x1000000, "Transaction id out of range: {0}", n2);
        DataUtils.checkArgument(l2 >= 0L && l2 < 0x10000000000L, "Transaction log id out of range: {0}", l2);
        return (long)n2 << 40 | l2;
    }

    static int getTransactionId(long l2) {
        return (int)(l2 >>> 40);
    }

    static long getLogId(long l2) {
        return l2 & 0xFFFFFFFFFFL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Transaction> getOpenTransactions() {
        MVMap<Long, Object[]> mVMap = this.undoLog;
        synchronized (mVMap) {
            ArrayList<Transaction> arrayList = New.arrayList();
            Long l2 = this.undoLog.firstKey();
            while (l2 != null) {
                String string;
                int n2;
                int n3 = TransactionStore.getTransactionId(l2);
                l2 = this.undoLog.lowerKey(TransactionStore.getOperationId(n3 + 1, 0L));
                long l3 = TransactionStore.getLogId(l2) + 1L;
                Object[] objectArray = this.preparedTransactions.get(n3);
                if (objectArray == null) {
                    n2 = this.undoLog.containsKey(TransactionStore.getOperationId(n3, 0L)) ? 1 : 3;
                    string = null;
                } else {
                    n2 = (Integer)objectArray[0];
                    string = (String)objectArray[1];
                }
                Transaction transaction = new Transaction(this, n3, n2, string, l3);
                arrayList.add(transaction);
                l2 = this.undoLog.ceilingKey(TransactionStore.getOperationId(n3 + 1, 0L));
            }
            return arrayList;
        }
    }

    public synchronized void close() {
        this.store.commit();
    }

    public synchronized Transaction begin() {
        if (!this.init) {
            throw DataUtils.newIllegalStateException(103, "Not initialized", new Object[0]);
        }
        int n2 = this.openTransactions.nextClearBit(1);
        if (n2 > this.maxTransactionId) {
            throw DataUtils.newIllegalStateException(102, "There are {0} open transactions", n2 - 1);
        }
        this.openTransactions.set(n2);
        int n3 = 1;
        return new Transaction(this, n2, n3, null, 0L);
    }

    synchronized void storeTransaction(Transaction transaction) {
        if (transaction.getStatus() == 2 || transaction.getName() != null) {
            Object[] objectArray = new Object[]{transaction.getStatus(), transaction.getName()};
            this.preparedTransactions.put(transaction.getId(), objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void log(Transaction transaction, long l2, int n2, Object object, Object object2) {
        Long l3 = TransactionStore.getOperationId(transaction.getId(), l2);
        Object[] objectArray = new Object[]{n2, object, object2};
        MVMap<Long, Object[]> mVMap = this.undoLog;
        synchronized (mVMap) {
            if (l2 == 0L && this.undoLog.containsKey(l3)) {
                throw DataUtils.newIllegalStateException(102, "An old transaction with the same id is still open: {0}", transaction.getId());
            }
            this.undoLog.put(l3, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logUndo(Transaction transaction, long l2) {
        Long l3 = TransactionStore.getOperationId(transaction.getId(), l2);
        MVMap<Long, Object[]> mVMap = this.undoLog;
        synchronized (mVMap) {
            Object[] objectArray = this.undoLog.remove(l3);
            if (objectArray == null) {
                throw DataUtils.newIllegalStateException(103, "Transaction {0} was concurrently rolled back", transaction.getId());
            }
        }
    }

    synchronized <K, V> void removeMap(TransactionMap<K, V> transactionMap) {
        this.maps.remove(transactionMap.mapId);
        this.store.removeMap(transactionMap.map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(Transaction transaction, long l2) {
        if (this.store.isClosed()) {
            return;
        }
        MVMap<Long, Object[]> mVMap = this.undoLog;
        synchronized (mVMap) {
            transaction.setStatus(3);
            for (long i2 = 0L; i2 < l2; ++i2) {
                Object object;
                VersionedValue versionedValue;
                Long l3 = TransactionStore.getOperationId(transaction.getId(), i2);
                Object[] objectArray = this.undoLog.get(l3);
                if (objectArray == null) {
                    if ((l3 = this.undoLog.ceilingKey(l3)) == null || TransactionStore.getTransactionId(l3) != transaction.getId()) break;
                    i2 = TransactionStore.getLogId(l3) - 1L;
                    continue;
                }
                int n2 = (Integer)objectArray[0];
                MVMap<Object, VersionedValue> mVMap2 = this.openMap(n2);
                if (mVMap2 != null && (versionedValue = mVMap2.get(object = objectArray[1])) != null) {
                    if (versionedValue.value == null) {
                        mVMap2.remove(object);
                    } else {
                        VersionedValue versionedValue2 = new VersionedValue();
                        versionedValue2.value = versionedValue.value;
                        mVMap2.put(object, versionedValue2);
                    }
                }
                this.undoLog.remove(l3);
            }
        }
        this.endTransaction(transaction);
    }

    synchronized <K> MVMap<K, VersionedValue> openMap(String string, DataType dataType, DataType dataType2) {
        Object m2;
        if (dataType == null) {
            dataType = new ObjectDataType();
        }
        if (dataType2 == null) {
            dataType2 = new ObjectDataType();
        }
        VersionedValueType versionedValueType = new VersionedValueType(dataType2);
        MVMap.Builder builder = new MVMap.Builder().keyType(dataType).valueType(versionedValueType);
        Object m3 = m2 = this.store.openMap(string, builder);
        this.maps.put(((MVMap)m2).getId(), (MVMap<Object, VersionedValue>)m3);
        return m2;
    }

    synchronized MVMap<Object, VersionedValue> openMap(int n2) {
        MVMap<Object, VersionedValue> mVMap = this.maps.get(n2);
        if (mVMap != null) {
            return mVMap;
        }
        String string = this.store.getMapName(n2);
        if (string == null) {
            return null;
        }
        VersionedValueType versionedValueType = new VersionedValueType(this.dataType);
        MVMap.Builder builder = new MVMap.Builder().keyType(this.dataType).valueType(versionedValueType);
        mVMap = this.store.openMap(string, builder);
        this.maps.put(n2, mVMap);
        return mVMap;
    }

    synchronized MVMap<Object, Integer> createTempMap() {
        String string = "temp." + this.nextTempMapId++;
        return this.openTempMap(string);
    }

    MVMap<Object, Integer> openTempMap(String string) {
        MVMap.Builder builder = new MVMap.Builder().keyType(this.dataType);
        return this.store.openMap(string, builder);
    }

    synchronized void endTransaction(Transaction transaction) {
        int n2;
        int n3;
        if (transaction.getStatus() == 2) {
            this.preparedTransactions.remove(transaction.getId());
        }
        transaction.setStatus(0);
        this.openTransactions.clear(transaction.transactionId);
        if (this.store.getAutoCommitDelay() == 0) {
            this.store.commit();
            return;
        }
        if (this.undoLog.isEmpty() && (n3 = this.store.getUnsavedMemory()) * 4 > (n2 = this.store.getAutoCommitMemory()) * 3) {
            this.store.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackTo(Transaction transaction, long l2, long l3) {
        MVMap<Long, Object[]> mVMap = this.undoLog;
        synchronized (mVMap) {
            for (long i2 = l2 - 1L; i2 >= l3; --i2) {
                Long l4 = TransactionStore.getOperationId(transaction.getId(), i2);
                Object[] objectArray = this.undoLog.get(l4);
                if (objectArray == null) {
                    if ((l4 = this.undoLog.floorKey(l4)) == null || TransactionStore.getTransactionId(l4) != transaction.getId()) break;
                    i2 = TransactionStore.getLogId(l4) + 1L;
                    continue;
                }
                int n2 = (Integer)objectArray[0];
                MVMap<Object, VersionedValue> mVMap2 = this.openMap(n2);
                if (mVMap2 != null) {
                    Object object = objectArray[1];
                    VersionedValue versionedValue = (VersionedValue)objectArray[2];
                    if (versionedValue == null) {
                        mVMap2.remove(object);
                    } else {
                        mVMap2.put(object, versionedValue);
                    }
                }
                this.undoLog.remove(l4);
            }
        }
    }

    Iterator<Change> getChanges(final Transaction transaction, final long l2, final long l3) {
        return new Iterator<Change>(){
            private long logId;
            private Change current;
            {
                this.logId = l2 - 1L;
                this.fetchNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fetchNext() {
                MVMap<Long, Object[]> mVMap = TransactionStore.this.undoLog;
                synchronized (mVMap) {
                    while (this.logId >= l3) {
                        Long l22 = TransactionStore.getOperationId(transaction.getId(), this.logId);
                        Object[] objectArray = TransactionStore.this.undoLog.get(l22);
                        --this.logId;
                        if (objectArray == null) {
                            if ((l22 = TransactionStore.this.undoLog.floorKey(l22)) == null || TransactionStore.getTransactionId(l22) != transaction.getId()) break;
                            this.logId = TransactionStore.getLogId(l22);
                            continue;
                        }
                        int n2 = (Integer)objectArray[0];
                        MVMap<Object, VersionedValue> mVMap2 = TransactionStore.this.openMap(n2);
                        if (mVMap2 == null) continue;
                        this.current = new Change();
                        this.current.mapName = mVMap2.getName();
                        this.current.key = objectArray[1];
                        VersionedValue versionedValue = (VersionedValue)objectArray[2];
                        this.current.value = versionedValue == null ? null : versionedValue.value;
                        return;
                    }
                }
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public Change next() {
                if (this.current == null) {
                    throw DataUtils.newUnsupportedOperationException("no data");
                }
                Change change = this.current;
                this.fetchNext();
                return change;
            }

            @Override
            public void remove() {
                throw DataUtils.newUnsupportedOperationException("remove");
            }
        };
    }

    public static class ArrayType
    implements DataType {
        private final int arrayLength;
        private final DataType[] elementTypes;

        ArrayType(DataType[] dataTypeArray) {
            this.arrayLength = dataTypeArray.length;
            this.elementTypes = dataTypeArray;
        }

        @Override
        public int getMemory(Object object) {
            Object[] objectArray = (Object[])object;
            int n2 = 0;
            for (int i2 = 0; i2 < this.arrayLength; ++i2) {
                DataType dataType = this.elementTypes[i2];
                Object object2 = objectArray[i2];
                if (object2 == null) continue;
                n2 += dataType.getMemory(object2);
            }
            return n2;
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            for (int i2 = 0; i2 < this.arrayLength; ++i2) {
                DataType dataType = this.elementTypes[i2];
                int n2 = dataType.compare(objectArray[i2], objectArray2[i2]);
                if (n2 == 0) continue;
                return n2;
            }
            return 0;
        }

        @Override
        public void read(ByteBuffer byteBuffer, Object[] objectArray, int n2, boolean bl2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                objectArray[i2] = this.read(byteBuffer);
            }
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object[] objectArray, int n2, boolean bl2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.write(writeBuffer, objectArray[i2]);
            }
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            Object[] objectArray = (Object[])object;
            for (int i2 = 0; i2 < this.arrayLength; ++i2) {
                DataType dataType = this.elementTypes[i2];
                Object object2 = objectArray[i2];
                if (object2 == null) {
                    writeBuffer.put((byte)0);
                    continue;
                }
                writeBuffer.put((byte)1);
                dataType.write(writeBuffer, object2);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer) {
            Object[] objectArray = new Object[this.arrayLength];
            for (int i2 = 0; i2 < this.arrayLength; ++i2) {
                DataType dataType = this.elementTypes[i2];
                if (byteBuffer.get() != 1) continue;
                objectArray[i2] = dataType.read(byteBuffer);
            }
            return objectArray;
        }
    }

    public static class VersionedValueType
    implements DataType {
        private final DataType valueType;

        VersionedValueType(DataType dataType) {
            this.valueType = dataType;
        }

        @Override
        public int getMemory(Object object) {
            VersionedValue versionedValue = (VersionedValue)object;
            return this.valueType.getMemory(versionedValue.value) + 8;
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            VersionedValue versionedValue = (VersionedValue)object;
            VersionedValue versionedValue2 = (VersionedValue)object2;
            long l2 = versionedValue.operationId - versionedValue2.operationId;
            if (l2 == 0L) {
                return this.valueType.compare(versionedValue.value, versionedValue2.value);
            }
            return Long.signum(l2);
        }

        @Override
        public void read(ByteBuffer byteBuffer, Object[] objectArray, int n2, boolean bl2) {
            if (byteBuffer.get() == 0) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    VersionedValue versionedValue = new VersionedValue();
                    versionedValue.value = this.valueType.read(byteBuffer);
                    objectArray[i2] = versionedValue;
                }
            } else {
                for (int i3 = 0; i3 < n2; ++i3) {
                    objectArray[i3] = this.read(byteBuffer);
                }
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer) {
            VersionedValue versionedValue = new VersionedValue();
            versionedValue.operationId = DataUtils.readVarLong(byteBuffer);
            if (byteBuffer.get() == 1) {
                versionedValue.value = this.valueType.read(byteBuffer);
            }
            return versionedValue;
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object[] objectArray, int n2, boolean bl2) {
            VersionedValue versionedValue;
            int n3;
            boolean bl3 = true;
            for (n3 = 0; n3 < n2; ++n3) {
                versionedValue = (VersionedValue)objectArray[n3];
                if (versionedValue.operationId == 0L && versionedValue.value != null) continue;
                bl3 = false;
            }
            if (bl3) {
                writeBuffer.put((byte)0);
                for (n3 = 0; n3 < n2; ++n3) {
                    versionedValue = (VersionedValue)objectArray[n3];
                    this.valueType.write(writeBuffer, versionedValue.value);
                }
            } else {
                writeBuffer.put((byte)1);
                for (n3 = 0; n3 < n2; ++n3) {
                    this.write(writeBuffer, objectArray[n3]);
                }
            }
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            VersionedValue versionedValue = (VersionedValue)object;
            writeBuffer.putVarLong(versionedValue.operationId);
            if (versionedValue.value == null) {
                writeBuffer.put((byte)0);
            } else {
                writeBuffer.put((byte)1);
                this.valueType.write(writeBuffer, versionedValue.value);
            }
        }
    }

    static class VersionedValue {
        public long operationId;
        public Object value;

        VersionedValue() {
        }

        public String toString() {
            return this.value + (this.operationId == 0L ? "" : " " + TransactionStore.getTransactionId(this.operationId) + "/" + TransactionStore.getLogId(this.operationId));
        }
    }

    public static class TransactionMap<K, V> {
        final int mapId;
        long readLogId = Long.MAX_VALUE;
        final MVMap<K, VersionedValue> map;
        private Transaction transaction;

        TransactionMap(Transaction transaction, MVMap<K, VersionedValue> mVMap, int n2) {
            this.transaction = transaction;
            this.map = mVMap;
            this.mapId = n2;
        }

        public void setSavepoint(long l2) {
            this.readLogId = l2;
        }

        public TransactionMap<K, V> getInstance(Transaction transaction, long l2) {
            TransactionMap<K, V> transactionMap = new TransactionMap<K, V>(transaction, this.map, this.mapId);
            transactionMap.setSavepoint(l2);
            return transactionMap;
        }

        public long sizeAsLongMax() {
            return this.map.sizeAsLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long sizeAsLong() {
            long l2;
            MVMap<Long, Object[]> mVMap;
            long l3 = this.map.sizeAsLong();
            MVMap<Long, Object[]> mVMap2 = mVMap = this.transaction.store.undoLog;
            synchronized (mVMap2) {
                l2 = mVMap.sizeAsLong();
            }
            if (l2 == 0L) {
                return l3;
            }
            if (l2 > l3) {
                long l4 = 0L;
                Cursor<Object, VersionedValue> cursor = this.map.cursor(null);
                while (cursor.hasNext()) {
                    VersionedValue versionedValue;
                    MVMap<Long, Object[]> mVMap3 = this.transaction.store.undoLog;
                    synchronized (mVMap3) {
                        K k2 = cursor.next();
                        versionedValue = this.getValue(k2, this.readLogId, cursor.getValue());
                    }
                    if (versionedValue == null || versionedValue.value == null) continue;
                    ++l4;
                }
                return l4;
            }
            mVMap2 = mVMap;
            synchronized (mVMap2) {
                long l5 = this.map.sizeAsLong();
                MVMap<Object, Integer> mVMap4 = this.transaction.store.createTempMap();
                try {
                    for (Map.Entry<Long, Object[]> entry : mVMap.entrySet()) {
                        Integer n2;
                        Object object;
                        Object[] objectArray = entry.getValue();
                        int n3 = (Integer)objectArray[0];
                        if (n3 != this.mapId || this.get(object = objectArray[1]) != null || (n2 = mVMap4.put(object, 1)) != null) continue;
                        --l5;
                    }
                }
                finally {
                    this.transaction.store.store.removeMap(mVMap4);
                }
                return l5;
            }
        }

        public V remove(K k2) {
            return this.set(k2, null);
        }

        public V put(K k2, V v2) {
            DataUtils.checkArgument(v2 != null, "The value may not be null", new Object[0]);
            return this.set(k2, v2);
        }

        public V putCommitted(K k2, V v2) {
            DataUtils.checkArgument(v2 != null, "The value may not be null", new Object[0]);
            VersionedValue versionedValue = new VersionedValue();
            versionedValue.value = v2;
            VersionedValue versionedValue2 = this.map.put(k2, versionedValue);
            return (V)(versionedValue2 == null ? null : versionedValue2.value);
        }

        private V set(K k2, V v2) {
            this.transaction.checkNotClosed();
            V v3 = this.get(k2);
            boolean bl2 = this.trySet(k2, v2, false);
            if (bl2) {
                return v3;
            }
            throw DataUtils.newIllegalStateException(101, "Entry is locked", new Object[0]);
        }

        public boolean tryRemove(K k2) {
            return this.trySet(k2, null, false);
        }

        public boolean tryPut(K k2, V v2) {
            DataUtils.checkArgument(v2 != null, "The value may not be null", new Object[0]);
            return this.trySet(k2, v2, false);
        }

        public boolean trySet(K k2, V v2, boolean bl2) {
            long l2;
            VersionedValue versionedValue;
            VersionedValue versionedValue2 = this.map.get(k2);
            if (bl2 && !this.map.areValuesEqual(versionedValue = this.getValue(k2, this.readLogId), versionedValue2)) {
                l2 = TransactionStore.getTransactionId(versionedValue2.operationId);
                if (l2 == (long)this.transaction.transactionId) {
                    if (v2 == null) {
                        return true;
                    }
                    if (versionedValue2.value != null) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            versionedValue = new VersionedValue();
            versionedValue.operationId = TransactionStore.getOperationId(this.transaction.transactionId, this.transaction.logId);
            versionedValue.value = v2;
            if (versionedValue2 == null) {
                this.transaction.log(this.mapId, k2, versionedValue2);
                VersionedValue versionedValue3 = this.map.putIfAbsent(k2, versionedValue);
                if (versionedValue3 != null) {
                    this.transaction.logUndo();
                    return false;
                }
                return true;
            }
            l2 = versionedValue2.operationId;
            if (l2 == 0L) {
                this.transaction.log(this.mapId, k2, versionedValue2);
                if (!this.map.replace(k2, versionedValue2, versionedValue)) {
                    this.transaction.logUndo();
                    return false;
                }
                return true;
            }
            int n2 = TransactionStore.getTransactionId(versionedValue2.operationId);
            if (n2 == this.transaction.transactionId) {
                this.transaction.log(this.mapId, k2, versionedValue2);
                if (!this.map.replace(k2, versionedValue2, versionedValue)) {
                    this.transaction.logUndo();
                    return false;
                }
                return true;
            }
            return false;
        }

        public V get(K k2) {
            return this.get(k2, this.readLogId);
        }

        public V getLatest(K k2) {
            return this.get(k2, Long.MAX_VALUE);
        }

        public boolean containsKey(K k2) {
            return this.get(k2) != null;
        }

        public V get(K k2, long l2) {
            VersionedValue versionedValue = this.getValue(k2, l2);
            return (V)(versionedValue == null ? null : versionedValue.value);
        }

        public boolean isSameTransaction(K k2) {
            VersionedValue versionedValue = this.map.get(k2);
            if (versionedValue == null) {
                return false;
            }
            int n2 = TransactionStore.getTransactionId(versionedValue.operationId);
            return n2 == this.transaction.transactionId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VersionedValue getValue(K k2, long l2) {
            Object object = this.getUndoLog();
            synchronized (object) {
                VersionedValue versionedValue = this.map.get(k2);
                return this.getValue(k2, l2, versionedValue);
            }
        }

        Object getUndoLog() {
            return this.transaction.store.undoLog;
        }

        VersionedValue getValue(K k2, long l2, VersionedValue versionedValue) {
            while (versionedValue != null) {
                long l3 = versionedValue.operationId;
                if (l3 == 0L) {
                    return versionedValue;
                }
                int n2 = TransactionStore.getTransactionId(l3);
                if (n2 == this.transaction.transactionId && TransactionStore.getLogId(l3) < l2) {
                    return versionedValue;
                }
                Object[] objectArray = this.transaction.store.undoLog.get(l3);
                if (objectArray == null) {
                    versionedValue = this.map.get(k2);
                    continue;
                }
                versionedValue = (VersionedValue)objectArray[2];
            }
            return null;
        }

        public boolean isClosed() {
            return this.map.isClosed();
        }

        public void clear() {
            this.map.clear();
        }

        public K firstKey() {
            Iterator<Object> iterator = this.keyIterator(null);
            return (K)(iterator.hasNext() ? iterator.next() : null);
        }

        public K lastKey() {
            K k2 = this.map.lastKey();
            while (k2 != null) {
                if (this.get(k2) != null) {
                    return k2;
                }
                k2 = this.map.lowerKey(k2);
            }
            return null;
        }

        public K higherKey(K k2) {
            K k3;
            while ((k3 = this.map.higherKey(k2)) != null && this.get(k3) == null) {
                k2 = k3;
            }
            return k3;
        }

        public K relativeKey(K k2, long l2) {
            K k3;
            K k4 = k3 = l2 > 0L ? this.map.ceilingKey(k2) : this.map.floorKey(k2);
            if (k3 == null) {
                return k3;
            }
            long l3 = this.map.getKeyIndex(k3);
            return this.map.getKey(l3 + l2);
        }

        public K lowerKey(K k2) {
            K k3;
            while ((k3 = this.map.lowerKey(k2)) != null && this.get(k3) == null) {
                k2 = k3;
            }
            return k3;
        }

        public Iterator<K> keyIterator(K k2) {
            return this.keyIterator(k2, false);
        }

        public Iterator<K> keyIterator(final K k2, final boolean bl2) {
            return new Iterator<K>(){
                private K currentKey;
                private Cursor<K, VersionedValue> cursor;
                {
                    this.currentKey = k2;
                    this.cursor = TransactionMap.this.map.cursor(this.currentKey);
                    this.fetchNext();
                }

                private void fetchNext() {
                    while (this.cursor.hasNext()) {
                        Object k22;
                        try {
                            k22 = this.cursor.next();
                        }
                        catch (IllegalStateException illegalStateException) {
                            if (DataUtils.getErrorCode(illegalStateException.getMessage()) == 9) {
                                this.cursor = TransactionMap.this.map.cursor(this.currentKey);
                                if (!this.cursor.hasNext()) break;
                                this.cursor.next();
                                if (!this.cursor.hasNext()) break;
                                k22 = this.cursor.next();
                            }
                            throw illegalStateException;
                        }
                        this.currentKey = k22;
                        if (bl2) {
                            return;
                        }
                        if (!TransactionMap.this.containsKey(k22)) continue;
                        return;
                    }
                    this.currentKey = null;
                }

                @Override
                public boolean hasNext() {
                    return this.currentKey != null;
                }

                @Override
                public K next() {
                    Object k22 = this.currentKey;
                    this.fetchNext();
                    return k22;
                }

                @Override
                public void remove() {
                    throw DataUtils.newUnsupportedOperationException("Removing is not supported");
                }
            };
        }

        public Iterator<Map.Entry<K, V>> entryIterator(final K k2) {
            return new Iterator<Map.Entry<K, V>>(){
                private Map.Entry<K, V> current;
                private K currentKey;
                private Cursor<K, VersionedValue> cursor;
                {
                    this.currentKey = k2;
                    this.cursor = TransactionMap.this.map.cursor(this.currentKey);
                    this.fetchNext();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void fetchNext() {
                    while (this.cursor.hasNext()) {
                        Object object = TransactionMap.this.getUndoLog();
                        synchronized (object) {
                            Object k22;
                            try {
                                k22 = this.cursor.next();
                            }
                            catch (IllegalStateException illegalStateException) {
                                if (DataUtils.getErrorCode(illegalStateException.getMessage()) == 9) {
                                    this.cursor = TransactionMap.this.map.cursor(this.currentKey);
                                    if (!this.cursor.hasNext()) {
                                        break;
                                    }
                                    this.cursor.next();
                                    if (!this.cursor.hasNext()) {
                                        break;
                                    }
                                    k22 = this.cursor.next();
                                }
                                throw illegalStateException;
                            }
                            Object k3 = k22;
                            VersionedValue versionedValue = this.cursor.getValue();
                            versionedValue = TransactionMap.this.getValue(k3, TransactionMap.this.readLogId, versionedValue);
                            if (versionedValue != null && versionedValue.value != null) {
                                Object object2 = versionedValue.value;
                                this.current = new DataUtils.MapEntry(k3, object2);
                                this.currentKey = k3;
                                return;
                            }
                        }
                    }
                    this.current = null;
                    this.currentKey = null;
                }

                @Override
                public boolean hasNext() {
                    return this.current != null;
                }

                @Override
                public Map.Entry<K, V> next() {
                    Map.Entry entry = this.current;
                    this.fetchNext();
                    return entry;
                }

                @Override
                public void remove() {
                    throw DataUtils.newUnsupportedOperationException("Removing is not supported");
                }
            };
        }

        public Iterator<K> wrapIterator(final Iterator<K> iterator, final boolean bl2) {
            return new Iterator<K>(){
                private K current;
                {
                    this.fetchNext();
                }

                private void fetchNext() {
                    while (iterator.hasNext()) {
                        this.current = iterator.next();
                        if (bl2) {
                            return;
                        }
                        if (!TransactionMap.this.containsKey(this.current)) continue;
                        return;
                    }
                    this.current = null;
                }

                @Override
                public boolean hasNext() {
                    return this.current != null;
                }

                @Override
                public K next() {
                    Object k2 = this.current;
                    this.fetchNext();
                    return k2;
                }

                @Override
                public void remove() {
                    throw DataUtils.newUnsupportedOperationException("Removing is not supported");
                }
            };
        }

        public Transaction getTransaction() {
            return this.transaction;
        }

        public DataType getKeyType() {
            return this.map.getKeyType();
        }
    }

    public static class Transaction {
        public static final int STATUS_CLOSED = 0;
        public static final int STATUS_OPEN = 1;
        public static final int STATUS_PREPARED = 2;
        public static final int STATUS_COMMITTING = 3;
        final TransactionStore store;
        final int transactionId;
        long logId;
        private int status;
        private String name;

        Transaction(TransactionStore transactionStore, int n2, int n3, String string, long l2) {
            this.store = transactionStore;
            this.transactionId = n2;
            this.status = n3;
            this.name = string;
            this.logId = l2;
        }

        public int getId() {
            return this.transactionId;
        }

        public int getStatus() {
            return this.status;
        }

        void setStatus(int n2) {
            this.status = n2;
        }

        public void setName(String string) {
            this.checkNotClosed();
            this.name = string;
            this.store.storeTransaction(this);
        }

        public String getName() {
            return this.name;
        }

        public long setSavepoint() {
            return this.logId;
        }

        void log(int n2, Object object, Object object2) {
            this.store.log(this, this.logId, n2, object, object2);
            ++this.logId;
        }

        void logUndo() {
            this.store.logUndo(this, --this.logId);
        }

        public <K, V> TransactionMap<K, V> openMap(String string) {
            return this.openMap(string, null, null);
        }

        public <K, V> TransactionMap<K, V> openMap(String string, DataType dataType, DataType dataType2) {
            this.checkNotClosed();
            MVMap mVMap = this.store.openMap(string, dataType, dataType2);
            int n2 = mVMap.getId();
            return new TransactionMap(this, mVMap, n2);
        }

        public <K, V> TransactionMap<K, V> openMap(MVMap<K, VersionedValue> mVMap) {
            this.checkNotClosed();
            int n2 = mVMap.getId();
            return new TransactionMap(this, mVMap, n2);
        }

        public void prepare() {
            this.checkNotClosed();
            this.status = 2;
            this.store.storeTransaction(this);
        }

        public void commit() {
            this.checkNotClosed();
            this.store.commit(this, this.logId);
        }

        public void rollbackToSavepoint(long l2) {
            this.checkNotClosed();
            this.store.rollbackTo(this, this.logId, l2);
            this.logId = l2;
        }

        public void rollback() {
            this.checkNotClosed();
            this.store.rollbackTo(this, this.logId, 0L);
            this.store.endTransaction(this);
        }

        public Iterator<Change> getChanges(long l2) {
            return this.store.getChanges(this, this.logId, l2);
        }

        void checkNotClosed() {
            if (this.status == 0) {
                throw DataUtils.newIllegalStateException(4, "Transaction is closed", new Object[0]);
            }
        }

        public <K, V> void removeMap(TransactionMap<K, V> transactionMap) {
            this.store.removeMap(transactionMap);
        }

        public String toString() {
            return "" + this.transactionId;
        }
    }

    public static class Change {
        public String mapName;
        public Object key;
        public Object value;
    }
}

