/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.api.TableEngine;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreTool;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.TransactionStore;
import org.h2.mvstore.db.ValueDataType;
import org.h2.store.InDoubtTransaction;
import org.h2.store.fs.FileChannelInputStream;
import org.h2.store.fs.FileUtils;
import org.h2.table.TableBase;
import org.h2.util.BitField;
import org.h2.util.New;

public class MVTableEngine
implements TableEngine {
    public static Store init(final Database database) {
        Store store = database.getMvStore();
        if (store != null) {
            return store;
        }
        byte[] byArray = database.getFileEncryptionKey();
        String string = database.getDatabasePath();
        MVStore.Builder builder = new MVStore.Builder();
        store = new Store();
        boolean bl2 = false;
        if (string != null) {
            String string2 = string + ".mv.db";
            MVStoreTool.compactCleanUp(string2);
            builder.fileName(string2);
            builder.pageSplitSize(database.getPageSize());
            if (database.isReadOnly()) {
                builder.readOnly();
            } else {
                boolean bl3 = FileUtils.exists(string2);
                if (!bl3 || FileUtils.canWrite(string2)) {
                    String string3 = FileUtils.getParent(string2);
                    FileUtils.createDirectories(string3);
                }
            }
            if (byArray != null) {
                bl2 = true;
                char[] cArray = new char[byArray.length / 2];
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    cArray[i2] = (char)((byArray[i2 + i2] & 0xFF) << 16 | byArray[i2 + i2 + 1] & 0xFF);
                }
                builder.encryptionKey(cArray);
            }
            if (database.getSettings().compressData) {
                builder.compress();
                builder.pageSplitSize(65536);
            }
            builder.backgroundExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    database.setBackgroundException(DbException.convert(throwable));
                }
            });
        }
        store.open(database, builder, bl2);
        database.setMvStore(store);
        return store;
    }

    @Override
    public TableBase createTable(CreateTableData createTableData) {
        Database database = createTableData.session.getDatabase();
        Store store = MVTableEngine.init(database);
        MVTable mVTable = new MVTable(createTableData, store);
        mVTable.init(createTableData.session);
        store.tableMap.put(mVTable.getMapName(), mVTable);
        return mVTable;
    }

    private static class MVInDoubtTransaction
    implements InDoubtTransaction {
        private final MVStore store;
        private final TransactionStore.Transaction transaction;
        private int state = 0;

        MVInDoubtTransaction(MVStore mVStore, TransactionStore.Transaction transaction) {
            this.store = mVStore;
            this.transaction = transaction;
        }

        @Override
        public void setState(int n2) {
            if (n2 == 1) {
                this.transaction.commit();
            } else {
                this.transaction.rollback();
            }
            this.store.commit();
            this.state = n2;
        }

        @Override
        public String getState() {
            switch (this.state) {
                case 0: {
                    return "IN_DOUBT";
                }
                case 1: {
                    return "COMMIT";
                }
                case 2: {
                    return "ROLLBACK";
                }
            }
            throw DbException.throwInternalError("state=" + this.state);
        }

        @Override
        public String getTransactionName() {
            return this.transaction.getName();
        }
    }

    public static class Store {
        final ConcurrentHashMap<String, MVTable> tableMap = new ConcurrentHashMap();
        private MVStore store;
        private TransactionStore transactionStore;
        private long statisticsStart;
        private int temporaryMapId;
        private boolean encrypted;
        private String fileName;

        void open(Database database, MVStore.Builder builder, boolean bl2) {
            this.encrypted = bl2;
            try {
                this.store = builder.open();
                FileStore fileStore = this.store.getFileStore();
                if (fileStore != null) {
                    this.fileName = fileStore.getFileName();
                }
                if (!database.getSettings().reuseSpace) {
                    this.store.setReuseSpace(false);
                }
                this.transactionStore = new TransactionStore(this.store, new ValueDataType(null, database, null));
                this.transactionStore.init();
            }
            catch (IllegalStateException illegalStateException) {
                throw this.convertIllegalStateException(illegalStateException);
            }
        }

        DbException convertIllegalStateException(IllegalStateException illegalStateException) {
            int n2 = DataUtils.getErrorCode(illegalStateException.getMessage());
            if (n2 == 6) {
                if (this.encrypted) {
                    throw DbException.get(90049, illegalStateException, this.fileName);
                }
            } else {
                if (n2 == 7) {
                    throw DbException.get(90020, illegalStateException, this.fileName);
                }
                if (n2 == 1) {
                    throw DbException.get(90028, illegalStateException, this.fileName);
                }
            }
            throw DbException.get(90030, illegalStateException, this.fileName);
        }

        public MVStore getStore() {
            return this.store;
        }

        public TransactionStore getTransactionStore() {
            return this.transactionStore;
        }

        public HashMap<String, MVTable> getTables() {
            return new HashMap<String, MVTable>(this.tableMap);
        }

        public void removeTable(MVTable mVTable) {
            this.tableMap.remove(mVTable.getMapName());
        }

        public void flush() {
            FileStore fileStore = this.store.getFileStore();
            if (fileStore == null || fileStore.isReadOnly()) {
                return;
            }
            if (!this.store.compact(50, 0x400000)) {
                this.store.commit();
            }
        }

        public void closeImmediately() {
            if (this.store.isClosed()) {
                return;
            }
            this.store.closeImmediately();
        }

        public void initTransactions() {
            List<TransactionStore.Transaction> list = this.transactionStore.getOpenTransactions();
            for (TransactionStore.Transaction transaction : list) {
                if (transaction.getStatus() == 3) {
                    transaction.commit();
                    continue;
                }
                if (transaction.getStatus() == 2) continue;
                transaction.rollback();
            }
        }

        public void removeTemporaryMaps(BitField bitField) {
            for (String string : this.store.getMapNames()) {
                int n2;
                if (string.startsWith("temp.")) {
                    MVMap mVMap = this.store.openMap(string);
                    this.store.removeMap(mVMap);
                    continue;
                }
                if (!string.startsWith("table.") && !string.startsWith("index.") || bitField.get(n2 = Integer.parseInt(string.substring(1 + string.indexOf("."))))) continue;
                ValueDataType valueDataType = new ValueDataType(null, null, null);
                ValueDataType valueDataType2 = new ValueDataType(null, null, null);
                TransactionStore.Transaction transaction = this.transactionStore.begin();
                TransactionStore.TransactionMap transactionMap = transaction.openMap(string, valueDataType, valueDataType2);
                this.transactionStore.removeMap(transactionMap);
                transaction.commit();
            }
        }

        public synchronized String nextTemporaryMapName() {
            return "temp." + this.temporaryMapId++;
        }

        public void prepareCommit(Session session, String string) {
            TransactionStore.Transaction transaction = session.getTransaction();
            transaction.setName(string);
            transaction.prepare();
            this.store.commit();
        }

        public ArrayList<InDoubtTransaction> getInDoubtTransactions() {
            List<TransactionStore.Transaction> list = this.transactionStore.getOpenTransactions();
            ArrayList<InDoubtTransaction> arrayList = New.arrayList();
            for (TransactionStore.Transaction transaction : list) {
                if (transaction.getStatus() != 2) continue;
                arrayList.add(new MVInDoubtTransaction(this.store, transaction));
            }
            return arrayList;
        }

        public void setCacheSize(int n2) {
            this.store.setCacheSize(Math.max(1, n2 / 1024));
        }

        public InputStream getInputStream() {
            FileChannel fileChannel = this.store.getFileStore().getEncryptedFile();
            if (fileChannel == null) {
                fileChannel = this.store.getFileStore().getFile();
            }
            return new FileChannelInputStream(fileChannel, false);
        }

        public void sync() {
            this.flush();
            this.store.sync();
        }

        public void compactFile(long l2) {
            this.store.setRetentionTime(0);
            long l3 = System.currentTimeMillis();
            while (this.store.compact(95, 0x1000000)) {
                this.store.sync();
                this.store.compactMoveChunks(95, 0x1000000L);
                long l4 = System.currentTimeMillis() - l3;
                if (l4 <= l2) continue;
                break;
            }
        }

        public void close(long l2) {
            try {
                if (!this.store.isClosed() && this.store.getFileStore() != null) {
                    boolean bl2 = false;
                    if (!this.store.getFileStore().isReadOnly()) {
                        this.transactionStore.close();
                        if (l2 == Long.MAX_VALUE) {
                            bl2 = true;
                        }
                    }
                    String string = this.store.getFileStore().getFileName();
                    this.store.close();
                    if (bl2 && FileUtils.exists(string)) {
                        MVStoreTool.compact(string, true);
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                int n2 = DataUtils.getErrorCode(illegalStateException.getMessage());
                if (n2 == 2 || n2 == 6) {
                    // empty if block
                }
                this.store.closeImmediately();
                throw DbException.get(90028, illegalStateException, "Closing");
            }
        }

        public void statisticsStart() {
            FileStore fileStore = this.store.getFileStore();
            this.statisticsStart = fileStore == null ? 0L : fileStore.getReadCount();
        }

        public Map<String, Integer> statisticsEnd() {
            HashMap<String, Integer> hashMap = New.hashMap();
            FileStore fileStore = this.store.getFileStore();
            int n2 = fileStore == null ? 0 : (int)(fileStore.getReadCount() - this.statisticsStart);
            hashMap.put("reads", n2);
            return hashMap;
        }
    }
}

