/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.h2.mvstore.DataUtils;

public class CacheLongKeyLIRS<V> {
    private long maxMemory;
    private final Segment<V>[] segments;
    private final int segmentCount;
    private final int segmentShift;
    private final int segmentMask;
    private final int stackMoveDistance;
    private final int nonResidentQueueSize;

    public CacheLongKeyLIRS(Config config) {
        this.setMaxMemory(config.maxMemory);
        this.nonResidentQueueSize = config.nonResidentQueueSize;
        DataUtils.checkArgument(Integer.bitCount(config.segmentCount) == 1, "The segment count must be a power of 2, is {0}", config.segmentCount);
        this.segmentCount = config.segmentCount;
        this.segmentMask = this.segmentCount - 1;
        this.stackMoveDistance = config.stackMoveDistance;
        this.segments = new Segment[this.segmentCount];
        this.clear();
        this.segmentShift = 32 - Integer.bitCount(this.segmentMask);
    }

    public void clear() {
        long l2 = Math.max(1L, this.maxMemory / (long)this.segmentCount);
        for (int i2 = 0; i2 < this.segmentCount; ++i2) {
            this.segments[i2] = new Segment(l2, this.stackMoveDistance, 8, this.nonResidentQueueSize);
        }
    }

    private Entry<V> find(long l2) {
        int n2 = CacheLongKeyLIRS.getHash(l2);
        return this.getSegment(n2).find(l2, n2);
    }

    public boolean containsKey(long l2) {
        int n2 = CacheLongKeyLIRS.getHash(l2);
        return this.getSegment(n2).containsKey(l2, n2);
    }

    public V peek(long l2) {
        Entry<V> entry = this.find(l2);
        return entry == null ? null : (V)entry.value;
    }

    public V put(long l2, V v2) {
        return this.put(l2, v2, this.sizeOf(v2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(long l2, V v2, int n2) {
        Segment<V> segment;
        int n3 = CacheLongKeyLIRS.getHash(l2);
        int n4 = this.getSegmentIndex(n3);
        Segment<V> segment2 = segment = this.segments[n4];
        synchronized (segment2) {
            segment = this.resizeIfNeeded(segment, n4);
            return segment.put(l2, n3, v2, n2);
        }
    }

    private Segment<V> resizeIfNeeded(Segment<V> segment, int n2) {
        int n3 = segment.getNewMapLen();
        if (n3 == 0) {
            return segment;
        }
        Segment<V> segment2 = this.segments[n2];
        if (segment == segment2) {
            segment = new Segment<V>(segment, n3);
            this.segments[n2] = segment;
        }
        return segment;
    }

    protected int sizeOf(V v2) {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(long l2) {
        Segment<V> segment;
        int n2 = CacheLongKeyLIRS.getHash(l2);
        int n3 = this.getSegmentIndex(n2);
        Segment<V> segment2 = segment = this.segments[n3];
        synchronized (segment2) {
            segment = this.resizeIfNeeded(segment, n3);
            return segment.remove(l2, n2);
        }
    }

    public int getMemory(long l2) {
        int n2 = CacheLongKeyLIRS.getHash(l2);
        return this.getSegment(n2).getMemory(l2, n2);
    }

    public V get(long l2) {
        int n2 = CacheLongKeyLIRS.getHash(l2);
        return this.getSegment(n2).get(l2, n2);
    }

    private Segment<V> getSegment(int n2) {
        return this.segments[this.getSegmentIndex(n2)];
    }

    private int getSegmentIndex(int n2) {
        return n2 >>> this.segmentShift & this.segmentMask;
    }

    static int getHash(long l2) {
        int n2 = (int)(l2 >>> 32 ^ l2);
        n2 = (n2 >>> 16 ^ n2) * 73244475;
        n2 = (n2 >>> 16 ^ n2) * 73244475;
        n2 = n2 >>> 16 ^ n2;
        return n2;
    }

    public long getUsedMemory() {
        long l2 = 0L;
        for (Segment<V> segment : this.segments) {
            l2 += segment.usedMemory;
        }
        return l2;
    }

    public void setMaxMemory(long l2) {
        DataUtils.checkArgument(l2 > 0L, "Max memory must be larger than 0, is {0}", l2);
        this.maxMemory = l2;
        if (this.segments != null) {
            long l3 = 1L + l2 / (long)this.segments.length;
            for (Segment<V> segment : this.segments) {
                segment.setMaxMemory(l3);
            }
        }
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public synchronized Set<Map.Entry<Long, V>> entrySet() {
        HashMap hashMap = new HashMap();
        for (long l2 : this.keySet()) {
            hashMap.put(l2, this.find((long)l2).value);
        }
        return hashMap.entrySet();
    }

    public Set<Long> keySet() {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (Segment<V> segment : this.segments) {
            hashSet.addAll(segment.keySet());
        }
        return hashSet;
    }

    public int sizeNonResident() {
        int n2 = 0;
        for (Segment<V> segment : this.segments) {
            n2 += segment.queue2Size;
        }
        return n2;
    }

    public int sizeMapArray() {
        int n2 = 0;
        for (Segment<V> segment : this.segments) {
            n2 += segment.entries.length;
        }
        return n2;
    }

    public int sizeHot() {
        int n2 = 0;
        for (Segment<V> segment : this.segments) {
            n2 += segment.mapSize - segment.queueSize - segment.queue2Size;
        }
        return n2;
    }

    public long getHits() {
        long l2 = 0L;
        for (Segment<V> segment : this.segments) {
            l2 += segment.hits;
        }
        return l2;
    }

    public long getMisses() {
        int n2 = 0;
        for (Segment<V> segment : this.segments) {
            n2 = (int)((long)n2 + segment.misses);
        }
        return n2;
    }

    public int size() {
        int n2 = 0;
        for (Segment<V> segment : this.segments) {
            n2 += segment.mapSize - segment.queue2Size;
        }
        return n2;
    }

    public List<Long> keys(boolean bl2, boolean bl3) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (Segment<V> segment : this.segments) {
            arrayList.addAll(segment.keys(bl2, bl3));
        }
        return arrayList;
    }

    public List<V> values() {
        ArrayList arrayList = new ArrayList();
        for (long l2 : this.keySet()) {
            Object v2 = this.find((long)l2).value;
            if (v2 == null) continue;
            arrayList.add(v2);
        }
        return arrayList;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsValue(Object object) {
        return this.getMap().containsValue(object);
    }

    public Map<Long, V> getMap() {
        HashMap hashMap = new HashMap();
        for (long l2 : this.keySet()) {
            Object v2 = this.find((long)l2).value;
            if (v2 == null) continue;
            hashMap.put(l2, v2);
        }
        return hashMap;
    }

    public void putAll(Map<Long, ? extends V> map) {
        for (Map.Entry<Long, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public static class Config {
        public long maxMemory = 1L;
        public int segmentCount = 16;
        public int stackMoveDistance = 32;
        public int nonResidentQueueSize = 3;
    }

    static class Entry<V> {
        long key;
        V value;
        int memory;
        int topMove;
        Entry<V> stackNext;
        Entry<V> stackPrev;
        Entry<V> queueNext;
        Entry<V> queuePrev;
        Entry<V> mapNext;

        Entry() {
        }

        boolean isHot() {
            return this.queueNext == null;
        }
    }

    private static class Segment<V> {
        int mapSize;
        int queueSize;
        int queue2Size;
        long hits;
        long misses;
        final Entry<V>[] entries;
        long usedMemory;
        private final int stackMoveDistance;
        private long maxMemory;
        private final int mask;
        private final int nonResidentQueueSize;
        private final Entry<V> stack;
        private int stackSize;
        private final Entry<V> queue;
        private final Entry<V> queue2;
        private int stackMoveCounter;

        Segment(long l2, int n2, int n3, int n4) {
            this.setMaxMemory(l2);
            this.stackMoveDistance = n2;
            this.nonResidentQueueSize = n4;
            this.mask = n3 - 1;
            this.stack = new Entry();
            this.stack.stackNext = this.stack;
            this.stack.stackPrev = this.stack.stackNext;
            this.queue = new Entry();
            this.queue.queueNext = this.queue;
            this.queue.queuePrev = this.queue.queueNext;
            this.queue2 = new Entry();
            this.queue2.queueNext = this.queue2;
            this.queue2.queuePrev = this.queue2.queueNext;
            Entry[] entryArray = new Entry[n3];
            this.entries = entryArray;
        }

        Segment(Segment<V> segment, int n2) {
            this(segment.maxMemory, segment.stackMoveDistance, n2, segment.nonResidentQueueSize);
            Entry entry;
            this.hits = segment.hits;
            this.misses = segment.misses;
            Entry entry2 = segment.stack.stackPrev;
            while (entry2 != segment.stack) {
                entry = Segment.copy(entry2);
                super.addToMap(entry);
                super.addToStack(entry);
                entry2 = entry2.stackPrev;
            }
            entry2 = segment.queue.queuePrev;
            while (entry2 != segment.queue) {
                entry = this.find(entry2.key, CacheLongKeyLIRS.getHash(entry2.key));
                if (entry == null) {
                    entry = Segment.copy(entry2);
                    super.addToMap(entry);
                }
                super.addToQueue(this.queue, entry);
                entry2 = entry2.queuePrev;
            }
            entry2 = segment.queue2.queuePrev;
            while (entry2 != segment.queue2) {
                entry = this.find(entry2.key, CacheLongKeyLIRS.getHash(entry2.key));
                if (entry == null) {
                    entry = Segment.copy(entry2);
                    super.addToMap(entry);
                }
                super.addToQueue(this.queue2, entry);
                entry2 = entry2.queuePrev;
            }
        }

        int getNewMapLen() {
            int n2 = this.mask + 1;
            if (n2 * 3 < this.mapSize * 4 && n2 < 0x10000000) {
                return n2 * 2;
            }
            if (n2 > 32 && n2 / 8 > this.mapSize) {
                return n2 / 2;
            }
            return 0;
        }

        private void addToMap(Entry<V> entry) {
            int n2 = CacheLongKeyLIRS.getHash(entry.key) & this.mask;
            entry.mapNext = this.entries[n2];
            this.entries[n2] = entry;
            this.usedMemory += (long)entry.memory;
            ++this.mapSize;
        }

        private static <V> Entry<V> copy(Entry<V> entry) {
            Entry entry2 = new Entry();
            entry2.key = entry.key;
            entry2.value = entry.value;
            entry2.memory = entry.memory;
            entry2.topMove = entry.topMove;
            return entry2;
        }

        int getMemory(long l2, int n2) {
            Entry<V> entry = this.find(l2, n2);
            return entry == null ? 0 : entry.memory;
        }

        V get(long l2, int n2) {
            Entry<V> entry = this.find(l2, n2);
            if (entry == null) {
                ++this.misses;
                return null;
            }
            Object v2 = entry.value;
            if (v2 == null) {
                ++this.misses;
                return null;
            }
            if (entry.isHot()) {
                if (entry != this.stack.stackNext && (this.stackMoveDistance == 0 || this.stackMoveCounter - entry.topMove > this.stackMoveDistance)) {
                    this.access(l2, n2);
                }
            } else {
                this.access(l2, n2);
            }
            ++this.hits;
            return v2;
        }

        private synchronized void access(long l2, int n2) {
            Entry<V> entry = this.find(l2, n2);
            if (entry == null || entry.value == null) {
                return;
            }
            if (entry.isHot()) {
                if (entry != this.stack.stackNext && (this.stackMoveDistance == 0 || this.stackMoveCounter - entry.topMove > this.stackMoveDistance)) {
                    boolean bl2 = entry == this.stack.stackPrev;
                    this.removeFromStack(entry);
                    if (bl2) {
                        this.pruneStack();
                    }
                    this.addToStack(entry);
                }
            } else {
                this.removeFromQueue(entry);
                if (entry.stackNext != null) {
                    this.removeFromStack(entry);
                    this.convertOldestHotToCold();
                } else {
                    this.addToQueue(this.queue, entry);
                }
                this.addToStack(entry);
            }
        }

        synchronized V put(long l2, int n2, V v2, int n3) {
            V v3;
            if (v2 == null) {
                throw DataUtils.newIllegalArgumentException("The value may not be null", new Object[0]);
            }
            Entry<V> entry = this.find(l2, n2);
            if (entry == null) {
                v3 = null;
            } else {
                v3 = entry.value;
                this.remove(l2, n2);
            }
            if ((long)n3 > this.maxMemory) {
                return v3;
            }
            entry = new Entry();
            entry.key = l2;
            entry.value = v2;
            entry.memory = n3;
            int n4 = n2 & this.mask;
            entry.mapNext = this.entries[n4];
            this.entries[n4] = entry;
            this.usedMemory += (long)n3;
            if (this.usedMemory > this.maxMemory) {
                this.evict();
                if (this.stackSize > 0) {
                    this.addToQueue(this.queue, entry);
                }
            }
            ++this.mapSize;
            this.addToStack(entry);
            return v3;
        }

        synchronized V remove(long l2, int n2) {
            Object v2;
            int n3 = n2 & this.mask;
            Entry<V> entry = this.entries[n3];
            if (entry == null) {
                return null;
            }
            if (entry.key == l2) {
                v2 = entry.value;
                this.entries[n3] = entry.mapNext;
            } else {
                do {
                    Entry<V> entry2 = entry;
                    entry = entry.mapNext;
                    if (entry != null) continue;
                    return null;
                } while (entry.key != l2);
                v2 = entry.value;
                entry2.mapNext = entry.mapNext;
            }
            --this.mapSize;
            this.usedMemory -= (long)entry.memory;
            if (entry.stackNext != null) {
                this.removeFromStack(entry);
            }
            if (entry.isHot()) {
                entry = this.queue.queueNext;
                if (entry != this.queue) {
                    this.removeFromQueue(entry);
                    if (entry.stackNext == null) {
                        this.addToStackBottom(entry);
                    }
                }
            } else {
                this.removeFromQueue(entry);
            }
            this.pruneStack();
            return v2;
        }

        private void evict() {
            do {
                this.evictBlock();
            } while (this.usedMemory > this.maxMemory);
        }

        private void evictBlock() {
            while (this.queueSize <= this.mapSize >>> 5 && this.stackSize > 0) {
                this.convertOldestHotToCold();
            }
            while (this.usedMemory > this.maxMemory && this.queueSize > 0) {
                Entry entry = this.queue.queuePrev;
                this.usedMemory -= (long)entry.memory;
                this.removeFromQueue(entry);
                entry.value = null;
                entry.memory = 0;
                this.addToQueue(this.queue2, entry);
                int n2 = this.nonResidentQueueSize * (this.mapSize - this.queue2Size);
                if (n2 < 0) continue;
                while (this.queue2Size > n2) {
                    entry = this.queue2.queuePrev;
                    int n3 = CacheLongKeyLIRS.getHash(entry.key);
                    this.remove(entry.key, n3);
                }
            }
        }

        private void convertOldestHotToCold() {
            Entry entry = this.stack.stackPrev;
            if (entry == this.stack) {
                throw new IllegalStateException();
            }
            this.removeFromStack(entry);
            this.addToQueue(this.queue, entry);
            this.pruneStack();
        }

        private void pruneStack() {
            Entry entry;
            while (!(entry = this.stack.stackPrev).isHot()) {
                this.removeFromStack(entry);
            }
        }

        Entry<V> find(long l2, int n2) {
            int n3 = n2 & this.mask;
            Entry<V> entry = this.entries[n3];
            while (entry != null && entry.key != l2) {
                entry = entry.mapNext;
            }
            return entry;
        }

        private void addToStack(Entry<V> entry) {
            entry.stackPrev = this.stack;
            entry.stackNext = this.stack.stackNext;
            entry.stackNext.stackPrev = entry;
            this.stack.stackNext = entry;
            ++this.stackSize;
            entry.topMove = this.stackMoveCounter++;
        }

        private void addToStackBottom(Entry<V> entry) {
            entry.stackNext = this.stack;
            entry.stackPrev = this.stack.stackPrev;
            entry.stackPrev.stackNext = entry;
            this.stack.stackPrev = entry;
            ++this.stackSize;
        }

        private void removeFromStack(Entry<V> entry) {
            entry.stackPrev.stackNext = entry.stackNext;
            entry.stackNext.stackPrev = entry.stackPrev;
            entry.stackNext = null;
            entry.stackPrev = null;
            --this.stackSize;
        }

        private void addToQueue(Entry<V> entry, Entry<V> entry2) {
            entry2.queuePrev = entry;
            entry2.queueNext = entry.queueNext;
            entry2.queueNext.queuePrev = entry2;
            entry.queueNext = entry2;
            if (entry2.value != null) {
                ++this.queueSize;
            } else {
                ++this.queue2Size;
            }
        }

        private void removeFromQueue(Entry<V> entry) {
            entry.queuePrev.queueNext = entry.queueNext;
            entry.queueNext.queuePrev = entry.queuePrev;
            entry.queueNext = null;
            entry.queuePrev = null;
            if (entry.value != null) {
                --this.queueSize;
            } else {
                --this.queue2Size;
            }
        }

        synchronized List<Long> keys(boolean bl2, boolean bl3) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            if (bl2) {
                Entry<V> entry = bl3 ? this.queue2 : this.queue;
                Entry entry2 = entry.queueNext;
                while (entry2 != entry) {
                    arrayList.add(entry2.key);
                    entry2 = entry2.queueNext;
                }
            } else {
                Entry entry = this.stack.stackNext;
                while (entry != this.stack) {
                    arrayList.add(entry.key);
                    entry = entry.stackNext;
                }
            }
            return arrayList;
        }

        boolean containsKey(long l2, int n2) {
            Entry<V> entry = this.find(l2, n2);
            return entry != null && entry.value != null;
        }

        synchronized Set<Long> keySet() {
            HashSet<Long> hashSet = new HashSet<Long>();
            Entry entry = this.stack.stackNext;
            while (entry != this.stack) {
                hashSet.add(entry.key);
                entry = entry.stackNext;
            }
            entry = this.queue.queueNext;
            while (entry != this.queue) {
                hashSet.add(entry.key);
                entry = entry.queueNext;
            }
            return hashSet;
        }

        void setMaxMemory(long l2) {
            this.maxMemory = l2;
        }
    }
}

