/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.nio.ByteBuffer;
import org.h2.mvstore.DataUtils;

public class WriteBuffer {
    private static final int MAX_REUSE_CAPACITY = 0x400000;
    private static final int MIN_GROW = 0x100000;
    private ByteBuffer reuse;
    private ByteBuffer buff;

    public WriteBuffer(int n2) {
        this.buff = this.reuse = ByteBuffer.allocate(n2);
    }

    public WriteBuffer() {
        this(0x100000);
    }

    public WriteBuffer putVarInt(int n2) {
        DataUtils.writeVarInt(this.ensureCapacity(5), n2);
        return this;
    }

    public WriteBuffer putVarLong(long l2) {
        DataUtils.writeVarLong(this.ensureCapacity(10), l2);
        return this;
    }

    public WriteBuffer putStringData(String string, int n2) {
        ByteBuffer byteBuffer = this.ensureCapacity(3 * n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '\u0080') {
                byteBuffer.put((byte)c2);
                continue;
            }
            if (c2 >= '\u0800') {
                byteBuffer.put((byte)(0xE0 | c2 >> 12));
                byteBuffer.put((byte)(c2 >> 6 & 0x3F));
                byteBuffer.put((byte)(c2 & 0x3F));
                continue;
            }
            byteBuffer.put((byte)(0xC0 | c2 >> 6));
            byteBuffer.put((byte)(c2 & 0x3F));
        }
        return this;
    }

    public WriteBuffer put(byte by2) {
        this.ensureCapacity(1).put(by2);
        return this;
    }

    public WriteBuffer putChar(char c2) {
        this.ensureCapacity(2).putChar(c2);
        return this;
    }

    public WriteBuffer putShort(short s2) {
        this.ensureCapacity(2).putShort(s2);
        return this;
    }

    public WriteBuffer putInt(int n2) {
        this.ensureCapacity(4).putInt(n2);
        return this;
    }

    public WriteBuffer putLong(long l2) {
        this.ensureCapacity(8).putLong(l2);
        return this;
    }

    public WriteBuffer putFloat(float f2) {
        this.ensureCapacity(4).putFloat(f2);
        return this;
    }

    public WriteBuffer putDouble(double d2) {
        this.ensureCapacity(8).putDouble(d2);
        return this;
    }

    public WriteBuffer put(byte[] byArray) {
        this.ensureCapacity(byArray.length).put(byArray);
        return this;
    }

    public WriteBuffer put(byte[] byArray, int n2, int n3) {
        this.ensureCapacity(n3).put(byArray, n2, n3);
        return this;
    }

    public WriteBuffer put(ByteBuffer byteBuffer) {
        this.ensureCapacity(this.buff.remaining()).put(byteBuffer);
        return this;
    }

    public WriteBuffer limit(int n2) {
        this.ensureCapacity(n2 - this.buff.position()).limit(n2);
        return this;
    }

    public int capacity() {
        return this.buff.capacity();
    }

    public WriteBuffer position(int n2) {
        this.buff.position(n2);
        return this;
    }

    public int limit() {
        return this.buff.limit();
    }

    public int position() {
        return this.buff.position();
    }

    public WriteBuffer get(byte[] byArray) {
        this.buff.get(byArray);
        return this;
    }

    public WriteBuffer putInt(int n2, int n3) {
        this.buff.putInt(n2, n3);
        return this;
    }

    public WriteBuffer putShort(int n2, short s2) {
        this.buff.putShort(n2, s2);
        return this;
    }

    public WriteBuffer clear() {
        if (this.buff.limit() > 0x400000) {
            this.buff = this.reuse;
        } else if (this.buff != this.reuse) {
            this.reuse = this.buff;
        }
        this.buff.clear();
        return this;
    }

    public ByteBuffer getBuffer() {
        return this.buff;
    }

    private ByteBuffer ensureCapacity(int n2) {
        if (this.buff.remaining() < n2) {
            this.grow(n2);
        }
        return this.buff;
    }

    private void grow(int n2) {
        ByteBuffer byteBuffer = this.buff;
        int n3 = n2 - byteBuffer.remaining();
        long l2 = Math.max(n3, 0x100000);
        l2 = Math.max((long)(byteBuffer.capacity() / 2), l2);
        int n4 = (int)Math.min(Integer.MAX_VALUE, (long)byteBuffer.capacity() + l2);
        if (n4 < n3) {
            throw new OutOfMemoryError("Capacity: " + n4 + " needed: " + n3);
        }
        try {
            this.buff = ByteBuffer.allocate(n4);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new OutOfMemoryError("Capacity: " + n4);
        }
        byteBuffer.flip();
        this.buff.put(byteBuffer);
        if (n4 <= 0x400000) {
            this.reuse = this.buff;
        }
    }
}

