/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.h2.compress.Compressor;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;
import org.h2.util.New;

public class Page {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final MVMap<?, ?> map;
    private long version;
    private long pos;
    private long totalCount;
    private int cachedCompare;
    private int memory;
    private Object[] keys;
    private Object[] values;
    private PageReference[] children;
    private volatile boolean removedInMemory;

    Page(MVMap<?, ?> mVMap, long l2) {
        this.map = mVMap;
        this.version = l2;
    }

    static Page createEmpty(MVMap<?, ?> mVMap, long l2) {
        return Page.create(mVMap, l2, EMPTY_OBJECT_ARRAY, EMPTY_OBJECT_ARRAY, null, 0L, 128);
    }

    public static Page create(MVMap<?, ?> mVMap, long l2, Object[] objectArray, Object[] objectArray2, PageReference[] pageReferenceArray, long l3, int n2) {
        Page page = new Page(mVMap, l2);
        page.keys = objectArray;
        page.values = objectArray2;
        page.children = pageReferenceArray;
        page.totalCount = l3;
        if (n2 == 0) {
            page.recalculateMemory();
        } else {
            page.addMemory(n2);
        }
        MVStore mVStore = mVMap.store;
        if (mVStore != null) {
            mVStore.registerUnsavedPage(page.memory);
        }
        return page;
    }

    public static Page create(MVMap<?, ?> mVMap, long l2, Page page) {
        Page page2 = new Page(mVMap, l2);
        page2.keys = page.keys;
        page2.values = page.values;
        page2.children = page.children;
        page2.totalCount = page.totalCount;
        page2.memory = page.memory;
        MVStore mVStore = mVMap.store;
        if (mVStore != null) {
            mVStore.registerUnsavedPage(page2.memory);
        }
        return page2;
    }

    static Page read(FileStore fileStore, long l2, MVMap<?, ?> mVMap, long l3, long l4) {
        int n2;
        ByteBuffer byteBuffer;
        int n3 = DataUtils.getPageMaxLength(l2);
        if (n3 == 0x200000) {
            byteBuffer = fileStore.readFully(l3, 128);
            n3 = byteBuffer.getInt();
        }
        if ((n2 = (n3 = (int)Math.min(l4 - l3, (long)n3))) < 0) {
            throw DataUtils.newIllegalStateException(6, "Illegal page length {0} reading at {1}; max pos {2} ", n2, l3, l4);
        }
        byteBuffer = fileStore.readFully(l3, n2);
        Page page = new Page(mVMap, 0L);
        page.pos = l2;
        int n4 = DataUtils.getPageChunkId(l2);
        int n5 = DataUtils.getPageOffset(l2);
        page.read(byteBuffer, n4, n5, n3);
        return page;
    }

    public Object getKey(int n2) {
        return this.keys[n2];
    }

    public Page getChildPage(int n2) {
        PageReference pageReference = this.children[n2];
        return pageReference.page != null ? pageReference.page : this.map.readPage(pageReference.pos);
    }

    public long getChildPagePos(int n2) {
        return this.children[n2].pos;
    }

    public Object getValue(int n2) {
        return this.values[n2];
    }

    public int getKeyCount() {
        return this.keys.length;
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public long getPos() {
        return this.pos;
    }

    public String toString() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id: ").append(System.identityHashCode(this)).append('\n');
        stringBuilder.append("version: ").append(Long.toHexString(this.version)).append("\n");
        stringBuilder.append("pos: ").append(Long.toHexString(this.pos)).append("\n");
        if (this.pos != 0L) {
            n2 = DataUtils.getPageChunkId(this.pos);
            stringBuilder.append("chunk: ").append(Long.toHexString(n2)).append("\n");
        }
        for (n2 = 0; n2 <= this.keys.length; ++n2) {
            if (n2 > 0) {
                stringBuilder.append(" ");
            }
            if (this.children != null) {
                stringBuilder.append("[" + Long.toHexString(this.children[n2].pos) + "] ");
            }
            if (n2 >= this.keys.length) continue;
            stringBuilder.append(this.keys[n2]);
            if (this.values == null) continue;
            stringBuilder.append(':');
            stringBuilder.append(this.values[n2]);
        }
        return stringBuilder.toString();
    }

    public Page copy(long l2) {
        Page page = Page.create(this.map, l2, this.keys, this.values, this.children, this.totalCount, this.getMemory());
        this.removePage();
        page.cachedCompare = this.cachedCompare;
        return page;
    }

    public int binarySearch(Object object) {
        int n2 = 0;
        int n3 = this.keys.length - 1;
        int n4 = this.cachedCompare - 1;
        if (n4 < 0 || n4 > n3) {
            n4 = n3 >>> 1;
        }
        Object[] objectArray = this.keys;
        while (n2 <= n3) {
            int n5 = this.map.compare(object, objectArray[n4]);
            if (n5 > 0) {
                n2 = n4 + 1;
            } else if (n5 < 0) {
                n3 = n4 - 1;
            } else {
                this.cachedCompare = n4 + 1;
                return n4;
            }
            n4 = n2 + n3 >>> 1;
        }
        this.cachedCompare = n2;
        return -(n2 + 1);
    }

    Page split(int n2) {
        return this.isLeaf() ? this.splitLeaf(n2) : this.splitNode(n2);
    }

    private Page splitLeaf(int n2) {
        int n3 = n2;
        int n4 = this.keys.length - n3;
        Object[] objectArray = new Object[n3];
        Object[] objectArray2 = new Object[n4];
        System.arraycopy(this.keys, 0, objectArray, 0, n3);
        System.arraycopy(this.keys, n3, objectArray2, 0, n4);
        this.keys = objectArray;
        Object[] objectArray3 = new Object[n3];
        Object[] objectArray4 = new Object[n4];
        objectArray4 = new Object[n4];
        System.arraycopy(this.values, 0, objectArray3, 0, n3);
        System.arraycopy(this.values, n3, objectArray4, 0, n4);
        this.values = objectArray3;
        this.totalCount = n3;
        Page page = Page.create(this.map, this.version, objectArray2, objectArray4, null, objectArray2.length, 0);
        this.recalculateMemory();
        page.recalculateMemory();
        return page;
    }

    private Page splitNode(int n2) {
        int n3 = n2;
        int n4 = this.keys.length - n3;
        Object[] objectArray = new Object[n3];
        Object[] objectArray2 = new Object[n4 - 1];
        System.arraycopy(this.keys, 0, objectArray, 0, n3);
        System.arraycopy(this.keys, n3 + 1, objectArray2, 0, n4 - 1);
        this.keys = objectArray;
        PageReference[] pageReferenceArray = new PageReference[n3 + 1];
        PageReference[] pageReferenceArray2 = new PageReference[n4];
        System.arraycopy(this.children, 0, pageReferenceArray, 0, n3 + 1);
        System.arraycopy(this.children, n3 + 1, pageReferenceArray2, 0, n4);
        this.children = pageReferenceArray;
        long l2 = 0L;
        for (PageReference pageReference : pageReferenceArray) {
            l2 += pageReference.count;
        }
        this.totalCount = l2;
        l2 = 0L;
        for (PageReference pageReference : pageReferenceArray2) {
            l2 += pageReference.count;
        }
        Page page = Page.create(this.map, this.version, objectArray2, null, pageReferenceArray2, l2, 0);
        this.recalculateMemory();
        super.recalculateMemory();
        return page;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    long getCounts(int n2) {
        return this.children[n2].count;
    }

    public void setChild(int n2, Page page) {
        if (page == null) {
            PageReference pageReference;
            long l2 = this.children[n2].count;
            this.children = (PageReference[])this.children.clone();
            this.children[n2] = pageReference = new PageReference(null, 0L, 0L);
            this.totalCount -= l2;
        } else if (page != this.children[n2].page || page.getPos() != this.children[n2].pos) {
            PageReference pageReference;
            long l3 = this.children[n2].count;
            this.children = (PageReference[])this.children.clone();
            this.children[n2] = pageReference = new PageReference(page, page.pos, page.totalCount);
            this.totalCount += page.totalCount - l3;
        }
    }

    public void setKey(int n2, Object object) {
        this.keys = (Object[])this.keys.clone();
        Object object2 = this.keys[n2];
        DataType dataType = this.map.getKeyType();
        int n3 = dataType.getMemory(object);
        if (object2 != null) {
            n3 -= dataType.getMemory(object2);
        }
        this.addMemory(n3);
        this.keys[n2] = object;
    }

    public Object setValue(int n2, Object object) {
        Object object2 = this.values[n2];
        this.values = (Object[])this.values.clone();
        DataType dataType = this.map.getValueType();
        this.addMemory(dataType.getMemory(object) - dataType.getMemory(object2));
        this.values[n2] = object;
        return object2;
    }

    void removeAllRecursive() {
        if (this.children != null) {
            int n2 = this.map.getChildPageCount(this);
            for (int i2 = 0; i2 < n2; ++i2) {
                PageReference pageReference = this.children[i2];
                if (pageReference.page != null) {
                    pageReference.page.removeAllRecursive();
                    continue;
                }
                long l2 = this.children[i2].pos;
                int n3 = DataUtils.getPageType(l2);
                if (n3 == 0) {
                    int n4 = DataUtils.getPageMaxLength(l2);
                    this.map.removePage(l2, n4);
                    continue;
                }
                this.map.readPage(l2).removeAllRecursive();
            }
        }
        this.removePage();
    }

    public void insertLeaf(int n2, Object object, Object object2) {
        int n3 = this.keys.length + 1;
        Object[] objectArray = new Object[n3];
        DataUtils.copyWithGap(this.keys, objectArray, n3 - 1, n2);
        this.keys = objectArray;
        Object[] objectArray2 = new Object[n3];
        DataUtils.copyWithGap(this.values, objectArray2, n3 - 1, n2);
        this.values = objectArray2;
        this.keys[n2] = object;
        this.values[n2] = object2;
        ++this.totalCount;
        this.addMemory(this.map.getKeyType().getMemory(object) + this.map.getValueType().getMemory(object2));
    }

    public void insertNode(int n2, Object object, Page page) {
        Object[] objectArray = new Object[this.keys.length + 1];
        DataUtils.copyWithGap(this.keys, objectArray, this.keys.length, n2);
        objectArray[n2] = object;
        this.keys = objectArray;
        int n3 = this.children.length;
        PageReference[] pageReferenceArray = new PageReference[n3 + 1];
        DataUtils.copyWithGap(this.children, pageReferenceArray, n3, n2);
        pageReferenceArray[n2] = new PageReference(page, page.getPos(), page.totalCount);
        this.children = pageReferenceArray;
        this.totalCount += page.totalCount;
        this.addMemory(this.map.getKeyType().getMemory(object) + 16);
    }

    public void remove(int n2) {
        int n3 = this.keys.length;
        int n4 = n2 >= n3 ? n2 - 1 : n2;
        Object object = this.keys[n4];
        this.addMemory(-this.map.getKeyType().getMemory(object));
        Object[] objectArray = new Object[n3 - 1];
        DataUtils.copyExcept(this.keys, objectArray, n3, n4);
        this.keys = objectArray;
        if (this.values != null) {
            object = this.values[n2];
            this.addMemory(-this.map.getValueType().getMemory(object));
            Object[] objectArray2 = new Object[n3 - 1];
            DataUtils.copyExcept(this.values, objectArray2, n3, n2);
            this.values = objectArray2;
            --this.totalCount;
        }
        if (this.children != null) {
            this.addMemory(-16);
            long l2 = this.children[n2].count;
            int n5 = this.children.length;
            PageReference[] pageReferenceArray = new PageReference[n5 - 1];
            DataUtils.copyExcept(this.children, pageReferenceArray, n5, n2);
            this.children = pageReferenceArray;
            this.totalCount -= l2;
        }
    }

    void read(ByteBuffer byteBuffer, int n2, int n3, int n4) {
        boolean bl2;
        int n5;
        boolean bl3;
        int n6 = byteBuffer.position();
        int n7 = byteBuffer.getInt();
        if (n7 > n4 || n7 < 4) {
            throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected page length 4..{1}, got {2}", n2, n4, n7);
        }
        byteBuffer.limit(n6 + n7);
        short s2 = byteBuffer.getShort();
        int n8 = DataUtils.readVarInt(byteBuffer);
        if (n8 != this.map.getId()) {
            throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected map id {1}, got {2}", n2, this.map.getId(), n8);
        }
        int n9 = DataUtils.getCheckValue(n2) ^ DataUtils.getCheckValue(n3) ^ DataUtils.getCheckValue(n7);
        if (s2 != (short)n9) {
            throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected check value {1}, got {2}", n2, n9, s2);
        }
        int n10 = DataUtils.readVarInt(byteBuffer);
        this.keys = new Object[n10];
        byte by2 = byteBuffer.get();
        boolean bl4 = bl3 = (by2 & 1) == 1;
        if (bl3) {
            this.children = new PageReference[n10 + 1];
            long[] lArray = new long[n10 + 1];
            for (int i2 = 0; i2 <= n10; ++i2) {
                lArray[i2] = byteBuffer.getLong();
            }
            long l2 = 0L;
            for (n5 = 0; n5 <= n10; ++n5) {
                long l3 = DataUtils.readVarLong(byteBuffer);
                l2 += l3;
                this.children[n5] = new PageReference(null, lArray[n5], l3);
            }
            this.totalCount = l2;
        }
        boolean bl5 = bl2 = (by2 & 2) != 0;
        if (bl2) {
            Compressor compressor = (by2 & 6) == 6 ? this.map.getStore().getCompressorHigh() : this.map.getStore().getCompressorFast();
            int n11 = DataUtils.readVarInt(byteBuffer);
            n5 = n7 + n6 - byteBuffer.position();
            byte[] byArray = DataUtils.newBytes(n5);
            byteBuffer.get(byArray);
            int n12 = n5 + n11;
            byteBuffer = ByteBuffer.allocate(n12);
            compressor.expand(byArray, 0, n5, byteBuffer.array(), byteBuffer.arrayOffset(), n12);
        }
        this.map.getKeyType().read(byteBuffer, this.keys, n10, true);
        if (!bl3) {
            this.values = new Object[n10];
            this.map.getValueType().read(byteBuffer, this.values, n10, false);
            this.totalCount = n10;
        }
        this.recalculateMemory();
    }

    private int write(Chunk chunk, WriteBuffer writeBuffer) {
        int n2;
        int n3;
        int n4;
        int n5 = writeBuffer.position();
        int n6 = this.keys.length;
        int n7 = this.children != null ? 1 : 0;
        writeBuffer.putInt(0).putShort((short)0).putVarInt(this.map.getId()).putVarInt(n6);
        int n8 = writeBuffer.position();
        writeBuffer.put((byte)n7);
        if (n7 == 1) {
            this.writeChildren(writeBuffer);
            for (n4 = 0; n4 <= n6; ++n4) {
                writeBuffer.putVarLong(this.children[n4].count);
            }
        }
        n4 = writeBuffer.position();
        this.map.getKeyType().write(writeBuffer, this.keys, n6, true);
        if (n7 == 0) {
            this.map.getValueType().write(writeBuffer, this.values, n6, false);
        }
        MVStore mVStore = this.map.getStore();
        int n9 = writeBuffer.position() - n4;
        if (n9 > 16 && (n3 = mVStore.getCompressionLevel()) > 0) {
            Compressor compressor;
            if (n3 == 1) {
                compressor = this.map.getStore().getCompressorFast();
                n2 = 2;
            } else {
                compressor = this.map.getStore().getCompressorHigh();
                n2 = 6;
            }
            byte[] byArray = new byte[n9];
            writeBuffer.position(n4).get(byArray);
            byte[] byArray2 = new byte[n9 * 2];
            int n10 = compressor.compress(byArray, n9, byArray2, 0);
            int n11 = DataUtils.getVarIntLen(n10 - n9);
            if (n10 + n11 < n9) {
                writeBuffer.position(n8).put((byte)(n7 + n2));
                writeBuffer.position(n4).putVarInt(n9 - n10).put(byArray2, 0, n10);
            }
        }
        n3 = writeBuffer.position() - n5;
        int n12 = chunk.id;
        n2 = DataUtils.getCheckValue(n12) ^ DataUtils.getCheckValue(n5) ^ DataUtils.getCheckValue(n3);
        writeBuffer.putInt(n5, n3).putShort(n5 + 4, (short)n2);
        if (this.pos != 0L) {
            throw DataUtils.newIllegalStateException(3, "Page already stored", new Object[0]);
        }
        this.pos = DataUtils.getPagePos(n12, n5, n3, n7);
        mVStore.cachePage(this.pos, this, this.getMemory());
        if (n7 == 1) {
            mVStore.cachePage(this.pos, this, this.getMemory());
        }
        long l2 = DataUtils.getPageMaxLength(this.pos);
        chunk.maxLen += l2;
        chunk.maxLenLive += l2;
        ++chunk.pageCount;
        ++chunk.pageCountLive;
        if (this.removedInMemory) {
            this.map.removePage(this.pos, this.memory);
        }
        return n8 + 1;
    }

    private void writeChildren(WriteBuffer writeBuffer) {
        int n2 = this.keys.length;
        for (int i2 = 0; i2 <= n2; ++i2) {
            writeBuffer.putLong(this.children[i2].pos);
        }
    }

    void writeUnsavedRecursive(Chunk chunk, WriteBuffer writeBuffer) {
        if (this.pos != 0L) {
            return;
        }
        int n2 = this.write(chunk, writeBuffer);
        if (!this.isLeaf()) {
            int n3;
            int n4 = this.children.length;
            for (n3 = 0; n3 < n4; ++n3) {
                Page page = this.children[n3].page;
                if (page == null) continue;
                page.writeUnsavedRecursive(chunk, writeBuffer);
                this.children[n3] = new PageReference(page, page.getPos(), page.totalCount);
            }
            n3 = writeBuffer.position();
            writeBuffer.position(n2);
            this.writeChildren(writeBuffer);
            writeBuffer.position(n3);
        }
    }

    void writeEnd() {
        if (this.isLeaf()) {
            return;
        }
        for (PageReference pageReference : this.children) {
            if (pageReference.page == null) continue;
            if (pageReference.page.getPos() == 0L) {
                throw DataUtils.newIllegalStateException(3, "Page not written", new Object[0]);
            }
            pageReference.page.writeEnd();
            this.children[var2_2] = new PageReference(null, pageReference.pos, pageReference.count);
        }
    }

    long getVersion() {
        return this.version;
    }

    public int getRawChildPageCount() {
        return this.children.length;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Page) {
            if (this.pos != 0L && ((Page)object).pos == this.pos) {
                return true;
            }
            return this == object;
        }
        return false;
    }

    public int hashCode() {
        return this.pos != 0L ? (int)(this.pos | this.pos >>> 32) : super.hashCode();
    }

    public int getMemory() {
        return this.memory;
    }

    private void addMemory(int n2) {
        this.memory += n2;
    }

    private void recalculateMemory() {
        int n2 = 128;
        DataType dataType = this.map.getKeyType();
        for (int i2 = 0; i2 < this.keys.length; ++i2) {
            n2 += dataType.getMemory(this.keys[i2]);
        }
        if (this.isLeaf()) {
            DataType dataType2 = this.map.getValueType();
            for (int i3 = 0; i3 < this.keys.length; ++i3) {
                n2 += dataType2.getMemory(this.values[i3]);
            }
        } else {
            n2 += this.getRawChildPageCount() * 16;
        }
        this.addMemory(n2 - this.memory);
    }

    void setVersion(long l2) {
        this.version = l2;
    }

    public void removePage() {
        long l2 = this.pos;
        if (l2 == 0L) {
            this.removedInMemory = true;
        }
        this.map.removePage(l2, this.memory);
    }

    public static class PageChildren {
        public static final long[] EMPTY_ARRAY = new long[0];
        final long pos;
        long[] children;
        boolean chunkList;

        private PageChildren(long l2, long[] lArray) {
            this.pos = l2;
            this.children = lArray;
        }

        PageChildren(Page page) {
            this.pos = page.getPos();
            int n2 = page.getRawChildPageCount();
            this.children = new long[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.children[i2] = page.getChildPagePos(i2);
            }
        }

        int getMemory() {
            return 64 + 8 * this.children.length;
        }

        static PageChildren read(FileStore fileStore, long l2, int n2, long l3, long l4) {
            boolean bl2;
            int n3;
            ByteBuffer byteBuffer;
            int n4 = DataUtils.getPageMaxLength(l2);
            if (n4 == 0x200000) {
                byteBuffer = fileStore.readFully(l3, 128);
                n4 = byteBuffer.getInt();
            }
            if ((n3 = (n4 = (int)Math.min(l4 - l3, (long)n4))) < 0) {
                throw DataUtils.newIllegalStateException(6, "Illegal page length {0} reading at {1}; max pos {2} ", n3, l3, l4);
            }
            byteBuffer = fileStore.readFully(l3, n3);
            int n5 = DataUtils.getPageChunkId(l2);
            int n6 = DataUtils.getPageOffset(l2);
            int n7 = byteBuffer.position();
            int n8 = byteBuffer.getInt();
            if (n8 > n4) {
                throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected page length =< {1}, got {2}", n5, n4, n8);
            }
            byteBuffer.limit(n7 + n8);
            short s2 = byteBuffer.getShort();
            int n9 = DataUtils.readVarInt(byteBuffer);
            if (n9 != n2) {
                throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected map id {1}, got {2}", n5, n2, n9);
            }
            int n10 = DataUtils.getCheckValue(n5) ^ DataUtils.getCheckValue(n6) ^ DataUtils.getCheckValue(n8);
            if (s2 != (short)n10) {
                throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected check value {1}, got {2}", n5, n10, s2);
            }
            int n11 = DataUtils.readVarInt(byteBuffer);
            byte by2 = byteBuffer.get();
            boolean bl3 = bl2 = (by2 & 1) == 1;
            if (!bl2) {
                return null;
            }
            long[] lArray = new long[n11 + 1];
            for (int i2 = 0; i2 <= n11; ++i2) {
                lArray[i2] = byteBuffer.getLong();
            }
            return new PageChildren(l2, lArray);
        }

        void removeDuplicateChunkReferences() {
            HashSet hashSet = New.hashSet();
            hashSet.add(DataUtils.getPageChunkId(this.pos));
            for (int i2 = 0; i2 < this.children.length; ++i2) {
                long l2 = this.children[i2];
                int n2 = DataUtils.getPageChunkId(l2);
                boolean bl2 = hashSet.add(n2);
                if (DataUtils.getPageType(l2) == 1 || bl2) continue;
                this.removeChild(i2--);
            }
        }

        void collectReferencedChunks(Set<Integer> set) {
            set.add(DataUtils.getPageChunkId(this.pos));
            for (long l2 : this.children) {
                set.add(DataUtils.getPageChunkId(l2));
            }
        }

        private void removeChild(int n2) {
            if (n2 == 0 && this.children.length == 1) {
                this.children = EMPTY_ARRAY;
                return;
            }
            long[] lArray = new long[this.children.length - 1];
            DataUtils.copyExcept(this.children, lArray, this.children.length, n2);
            this.children = lArray;
        }
    }

    public static class PageReference {
        final long pos;
        final Page page;
        final long count;

        public PageReference(Page page, long l2, long l3) {
            this.page = page;
            this.pos = l2;
            this.count = l3;
        }
    }
}

