/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FileStore;

public class OffHeapStore
extends FileStore {
    private final TreeMap<Long, ByteBuffer> memory = new TreeMap();

    @Override
    public void open(String string, boolean bl2, char[] cArray) {
        this.memory.clear();
    }

    @Override
    public String toString() {
        return this.memory.toString();
    }

    @Override
    public ByteBuffer readFully(long l2, int n2) {
        Map.Entry<Long, ByteBuffer> entry = this.memory.floorEntry(l2);
        if (entry == null) {
            throw DataUtils.newIllegalStateException(1, "Could not read from position {0}", l2);
        }
        ++this.readCount;
        this.readBytes += (long)n2;
        ByteBuffer byteBuffer = entry.getValue();
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        int n3 = (int)(l2 - entry.getKey());
        byteBuffer2.position(n3);
        byteBuffer2.limit(n2 + n3);
        return byteBuffer2.slice();
    }

    @Override
    public void free(long l2, int n2) {
        this.freeSpace.free(l2, n2);
        ByteBuffer byteBuffer = this.memory.remove(l2);
        if (byteBuffer != null && byteBuffer.remaining() != n2) {
            throw DataUtils.newIllegalStateException(1, "Partial remove is not supported at position {0}", l2);
        }
    }

    @Override
    public void writeFully(long l2, ByteBuffer byteBuffer) {
        this.fileSize = Math.max(this.fileSize, l2 + (long)byteBuffer.remaining());
        Map.Entry<Long, ByteBuffer> entry = this.memory.floorEntry(l2);
        if (entry == null) {
            this.writeNewEntry(l2, byteBuffer);
            return;
        }
        long l3 = entry.getKey();
        ByteBuffer byteBuffer2 = entry.getValue();
        int n2 = byteBuffer2.capacity();
        int n3 = byteBuffer.remaining();
        if (l3 == l2) {
            if (n2 != n3) {
                throw DataUtils.newIllegalStateException(1, "Could not write to position {0}; partial overwrite is not supported", l2);
            }
            ++this.writeCount;
            this.writeBytes += (long)n3;
            byteBuffer2.rewind();
            byteBuffer2.put(byteBuffer);
            return;
        }
        if (l3 + (long)n2 > l2) {
            throw DataUtils.newIllegalStateException(1, "Could not write to position {0}; partial overwrite is not supported", l2);
        }
        this.writeNewEntry(l2, byteBuffer);
    }

    private void writeNewEntry(long l2, ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        ++this.writeCount;
        this.writeBytes += (long)n2;
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n2);
        byteBuffer2.put(byteBuffer);
        byteBuffer2.rewind();
        this.memory.put(l2, byteBuffer2);
    }

    @Override
    public void truncate(long l2) {
        long l3;
        ++this.writeCount;
        if (l2 == 0L) {
            this.fileSize = 0L;
            this.memory.clear();
            return;
        }
        this.fileSize = l2;
        Iterator<Long> iterator = this.memory.keySet().iterator();
        while (iterator.hasNext() && (l3 = iterator.next().longValue()) >= l2) {
            ByteBuffer byteBuffer = this.memory.get(l3);
            if ((long)byteBuffer.capacity() > l2) {
                throw DataUtils.newIllegalStateException(1, "Could not truncate to {0}; partial truncate is not supported", l3);
            }
            iterator.remove();
        }
    }

    @Override
    public void close() {
        this.memory.clear();
    }

    @Override
    public void sync() {
    }

    @Override
    public int getDefaultRetentionTime() {
        return 0;
    }
}

