/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.Timestamp;
import java.util.Map;
import java.util.TreeMap;
import org.h2.compress.CompressDeflate;
import org.h2.compress.CompressLZF;
import org.h2.compress.Compressor;
import org.h2.message.DbException;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.StringDataType;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;

public class MVStoreTool {
    public static void main(String ... stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string;
            if ("-dump".equals(stringArray[i2])) {
                string = stringArray[++i2];
                MVStoreTool.dump(string, new PrintWriter(System.out), true);
                continue;
            }
            if ("-info".equals(stringArray[i2])) {
                string = stringArray[++i2];
                MVStoreTool.info(string, new PrintWriter(System.out));
                continue;
            }
            if ("-compact".equals(stringArray[i2])) {
                string = stringArray[++i2];
                MVStoreTool.compact(string, false);
                continue;
            }
            if (!"-compress".equals(stringArray[i2])) continue;
            string = stringArray[++i2];
            MVStoreTool.compact(string, true);
        }
    }

    public static void dump(String string, boolean bl2) {
        MVStoreTool.dump(string, new PrintWriter(System.out), bl2);
    }

    public static void info(String string) {
        MVStoreTool.info(string, new PrintWriter(System.out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(String string, Writer writer, boolean bl2) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        if (!FilePath.get(string).exists()) {
            printWriter.println("File not found: " + string);
            return;
        }
        long l2 = FileUtils.size(string);
        printWriter.printf("File %s, %d bytes, %d MB\n", string, l2, l2 / 1024L / 1024L);
        FileChannel fileChannel = null;
        int n2 = 4096;
        TreeMap<Integer, Long> treeMap = new TreeMap<Integer, Long>();
        long l3 = 0L;
        try {
            int n3;
            fileChannel = FilePath.get(string).open("r");
            long l4 = fileChannel.size();
            int n4 = Long.toHexString(l4).length();
            ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
            long l5 = 0L;
            long l6 = 0L;
            while (l6 < l4) {
                int n5;
                int n6;
                Object object;
                byteBuffer.rewind();
                DataUtils.readFully(fileChannel, l6, byteBuffer);
                byteBuffer.rewind();
                n3 = byteBuffer.get();
                if (n3 == 72) {
                    object = new String(byteBuffer.array(), DataUtils.LATIN).trim();
                    printWriter.printf("%0" + n4 + "x fileHeader %s%n", l6, object);
                    l6 += (long)n2;
                    continue;
                }
                if (n3 != 99) {
                    l6 += (long)n2;
                    continue;
                }
                byteBuffer.position(0);
                object = null;
                try {
                    object = Chunk.readChunkHeader(byteBuffer, l6);
                }
                catch (IllegalStateException illegalStateException) {
                    l6 += (long)n2;
                    continue;
                }
                if (((Chunk)object).len <= 0) {
                    l6 += (long)n2;
                    continue;
                }
                int n7 = ((Chunk)object).len * 4096;
                printWriter.printf("%n%0" + n4 + "x chunkHeader %s%n", l6, ((Chunk)object).toString());
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n7);
                DataUtils.readFully(fileChannel, l6, byteBuffer2);
                int n8 = byteBuffer.position();
                l6 += (long)n7;
                int n9 = ((Chunk)object).pageCount;
                l5 += (long)((Chunk)object).pageCount;
                TreeMap<Integer, Integer> treeMap2 = new TreeMap<Integer, Integer>();
                int n10 = 0;
                while (n9 > 0) {
                    boolean bl3;
                    n6 = n8;
                    try {
                        byteBuffer2.position(n8);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        printWriter.printf("ERROR illegal position %d%n", n8);
                        break;
                    }
                    int n11 = byteBuffer2.getInt();
                    byteBuffer2.getShort();
                    n5 = DataUtils.readVarInt(byteBuffer2);
                    int n12 = DataUtils.readVarInt(byteBuffer2);
                    byte by2 = byteBuffer2.get();
                    boolean bl4 = (by2 & 2) != 0;
                    boolean bl5 = bl3 = (by2 & 1) != 0;
                    if (bl2) {
                        printWriter.printf("+%0" + n4 + "x %s, map %x, %d entries, %d bytes, maxLen %x%n", n8, (bl3 ? "node" : "leaf") + (bl4 ? " compressed" : ""), n5, bl3 ? n12 + 1 : n12, n11, DataUtils.getPageMaxLength(DataUtils.getPagePos(0, 0, n11, 0)));
                    }
                    n8 += n11;
                    Integer n13 = (Integer)treeMap2.get(n5);
                    if (n13 == null) {
                        n13 = 0;
                    }
                    treeMap2.put(n5, n13 + n11);
                    Long l7 = (Long)treeMap.get(n5);
                    if (l7 == null) {
                        l7 = 0L;
                    }
                    treeMap.put(n5, l7 + (long)n11);
                    n10 += n11;
                    l3 += (long)n11;
                    --n9;
                    long[] lArray = null;
                    long[] lArray2 = null;
                    if (bl3) {
                        int n14;
                        lArray = new long[n12 + 1];
                        for (n14 = 0; n14 <= n12; ++n14) {
                            lArray[n14] = byteBuffer2.getLong();
                        }
                        lArray2 = new long[n12 + 1];
                        for (n14 = 0; n14 <= n12; ++n14) {
                            long l8;
                            lArray2[n14] = l8 = DataUtils.readVarLong(byteBuffer2);
                        }
                    }
                    String[] stringArray = new String[n12];
                    if (n5 == 0 && bl2) {
                        int n15;
                        ByteBuffer byteBuffer3;
                        Object object2;
                        int n16;
                        if (bl4) {
                            n16 = (by2 & 6) != 6 ? 1 : 0;
                            object2 = MVStoreTool.getCompressor(n16 != 0);
                            int n17 = DataUtils.readVarInt(byteBuffer2);
                            int n18 = n11 + n6 - byteBuffer2.position();
                            byte[] byArray = DataUtils.newBytes(n18);
                            byteBuffer2.get(byArray);
                            int n19 = n18 + n17;
                            byteBuffer3 = ByteBuffer.allocate(n19);
                            object2.expand(byArray, 0, n18, byteBuffer3.array(), 0, n19);
                        } else {
                            byteBuffer3 = byteBuffer2;
                        }
                        for (n16 = 0; n16 < n12; ++n16) {
                            stringArray[n16] = object2 = StringDataType.INSTANCE.read(byteBuffer3);
                        }
                        if (bl3) {
                            for (n16 = 0; n16 < n12; ++n16) {
                                long l9 = lArray[n16];
                                printWriter.printf("    %d children < %s @ chunk %x +%0" + n4 + "x%n", lArray2[n16], stringArray[n16], DataUtils.getPageChunkId(l9), DataUtils.getPageOffset(l9));
                            }
                            long l10 = lArray[n12];
                            printWriter.printf("    %d children >= %s @ chunk %x +%0" + n4 + "x%n", lArray2[n12], stringArray.length >= n12 ? null : stringArray[n12], DataUtils.getPageChunkId(l10), DataUtils.getPageOffset(l10));
                            continue;
                        }
                        String[] stringArray2 = new String[n12];
                        for (n15 = 0; n15 < n12; ++n15) {
                            String string2;
                            stringArray2[n15] = string2 = StringDataType.INSTANCE.read(byteBuffer3);
                        }
                        for (n15 = 0; n15 < n12; ++n15) {
                            printWriter.println("    " + stringArray[n15] + " = " + stringArray2[n15]);
                        }
                        continue;
                    }
                    if (!bl3 || !bl2) continue;
                    for (int i2 = 0; i2 <= n12; ++i2) {
                        long l11 = lArray[i2];
                        printWriter.printf("    %d children @ chunk %x +%0" + n4 + "x%n", lArray2[i2], DataUtils.getPageChunkId(l11), DataUtils.getPageOffset(l11));
                    }
                }
                n10 = Math.max(1, n10);
                for (Integer n20 : treeMap2.keySet()) {
                    n5 = 100 * (Integer)treeMap2.get(n20) / n10;
                    printWriter.printf("map %x: %d bytes, %d%%%n", n20, treeMap2.get(n20), n5);
                }
                n6 = byteBuffer2.limit() - 128;
                try {
                    byteBuffer2.position(n6);
                    printWriter.printf("+%0" + n4 + "x chunkFooter %s%n", n6, new String(byteBuffer2.array(), byteBuffer2.position(), 128, DataUtils.LATIN).trim());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    printWriter.printf("ERROR illegal footer position %d%n", n6);
                }
            }
            printWriter.printf("%n%0" + n4 + "x eof%n", l4);
            printWriter.printf("\n", new Object[0]);
            l5 = Math.max(1L, l5);
            printWriter.printf("page size total: %d bytes, page count: %d, average page size: %d bytes\n", l3, l5, l3 / l5);
            l3 = Math.max(1L, l3);
            for (Integer n21 : treeMap.keySet()) {
                n3 = (int)(100L * (Long)treeMap.get(n21) / l3);
                printWriter.printf("map %x: %d bytes, %d%%%n", n21, treeMap.get(n21), n3);
            }
        }
        catch (IOException iOException) {
            printWriter.println("ERROR: " + iOException);
            iOException.printStackTrace(printWriter);
        }
        finally {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
        printWriter.flush();
    }

    private static Compressor getCompressor(boolean bl2) {
        return bl2 ? new CompressLZF() : new CompressDeflate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void info(String string, Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        if (!FilePath.get(string).exists()) {
            printWriter.println("File not found: " + string);
            return;
        }
        long l2 = FileUtils.size(string);
        try (MVStore mVStore = new MVStore.Builder().fileName(string).readOnly().open();){
            Object object;
            MVMap<String, String> mVMap = mVStore.getMetaMap();
            Map<String, Object> map = mVStore.getStoreHeader();
            long l3 = DataUtils.readHexLong(map, "created", 0L);
            TreeMap<Integer, Chunk> treeMap = new TreeMap<Integer, Chunk>();
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            long l7 = 0L;
            for (Map.Entry<String, String> entry : mVMap.entrySet()) {
                object = entry.getKey();
                if (!((String)object).startsWith("chunk.")) continue;
                Chunk chunk = Chunk.fromString(entry.getValue());
                treeMap.put(chunk.id, chunk);
                l4 += (long)(chunk.len * 4096);
                l5 += chunk.maxLen;
                l6 += chunk.maxLenLive;
                if (chunk.maxLenLive <= 0L) continue;
                l7 += chunk.maxLen;
            }
            printWriter.printf("Created: %s\n", MVStoreTool.formatTimestamp(l3, l3));
            printWriter.printf("Last modified: %s\n", MVStoreTool.formatTimestamp(FileUtils.lastModified(string), l3));
            printWriter.printf("File length: %d\n", l2);
            printWriter.printf("The last chunk is not listed\n", new Object[0]);
            printWriter.printf("Chunk length: %d\n", l4);
            printWriter.printf("Chunk count: %d\n", treeMap.size());
            printWriter.printf("Used space: %d%%\n", MVStoreTool.getPercent(l4, l2));
            printWriter.printf("Chunk fill rate: %d%%\n", l5 == 0L ? 100 : MVStoreTool.getPercent(l6, l5));
            printWriter.printf("Chunk fill rate excluding empty chunks: %d%%\n", l7 == 0L ? 100 : MVStoreTool.getPercent(l6, l7));
            for (Map.Entry<String, String> entry : treeMap.entrySet()) {
                object = (Chunk)((Object)entry.getValue());
                long l8 = l3 + ((Chunk)object).time;
                printWriter.printf("  Chunk %d: %s, %d%% used, %d blocks", ((Chunk)object).id, MVStoreTool.formatTimestamp(l8, l3), MVStoreTool.getPercent(((Chunk)object).maxLenLive, ((Chunk)object).maxLen), ((Chunk)object).len);
                if (((Chunk)object).maxLenLive == 0L) {
                    printWriter.printf(", unused: %s", MVStoreTool.formatTimestamp(l3 + ((Chunk)object).unused, l3));
                }
                printWriter.printf("\n", new Object[0]);
            }
            printWriter.printf("\n", new Object[0]);
        }
        printWriter.flush();
    }

    private static String formatTimestamp(long l2, long l3) {
        String string = new Timestamp(l2).toString();
        String string2 = string.substring(0, 19);
        string2 = string2 + " (+" + (l2 - l3) / 1000L + " s)";
        return string2;
    }

    private static int getPercent(long l2, long l3) {
        if (l2 == 0L) {
            return 0;
        }
        if (l2 == l3) {
            return 100;
        }
        return (int)(1L + 98L * l2 / Math.max(1L, l3));
    }

    public static void compact(String string, boolean bl2) {
        String string2 = string + ".tempFile";
        FileUtils.delete(string2);
        MVStoreTool.compact(string, string2, bl2);
        try {
            FileUtils.moveAtomicReplace(string2, string);
        }
        catch (DbException dbException) {
            String string3 = string + ".newFile";
            FileUtils.delete(string3);
            FileUtils.move(string2, string3);
            FileUtils.delete(string);
            FileUtils.move(string3, string);
        }
    }

    public static void compactCleanUp(String string) {
        String string2;
        String string3 = string + ".tempFile";
        if (FileUtils.exists(string3)) {
            FileUtils.delete(string3);
        }
        if (FileUtils.exists(string2 = string + ".newFile")) {
            if (FileUtils.exists(string)) {
                FileUtils.delete(string2);
            } else {
                FileUtils.move(string2, string);
            }
        }
    }

    public static void compact(String string, String string2, boolean bl2) {
        MVStore mVStore = new MVStore.Builder().fileName(string).readOnly().open();
        FileUtils.delete(string2);
        MVStore.Builder builder = new MVStore.Builder().fileName(string2);
        if (bl2) {
            builder.compress();
        }
        MVStore mVStore2 = builder.open();
        MVStoreTool.compact(mVStore, mVStore2);
        mVStore2.close();
        mVStore.close();
    }

    public static void compact(MVStore mVStore, MVStore mVStore2) {
        Object object;
        MVMap<String, String> mVMap = mVStore.getMetaMap();
        MVMap<String, String> mVMap2 = mVStore2.getMetaMap();
        for (Map.Entry<String, String> entry : mVMap.entrySet()) {
            object = entry.getKey();
            if (((String)object).startsWith("chunk.") || ((String)object).startsWith("map.") || ((String)object).startsWith("name.") || ((String)object).startsWith("root.")) continue;
            mVMap2.put((String)object, entry.getValue());
        }
        for (String string : mVStore.getMapNames()) {
            object = new MVMap.Builder().keyType(new GenericDataType()).valueType(new GenericDataType());
            Object m2 = mVStore.openMap(string, object);
            Object m3 = mVStore2.openMap(string, object);
            ((MVMap)m3).copyFrom(m2);
        }
    }

    static class GenericDataType
    implements DataType {
        GenericDataType() {
        }

        @Override
        public int compare(Object object, Object object2) {
            throw DataUtils.newUnsupportedOperationException("Can not compare");
        }

        @Override
        public int getMemory(Object object) {
            return object == null ? 0 : ((byte[])object).length * 8;
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            if (object != null) {
                writeBuffer.put((byte[])object);
            }
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object[] objectArray, int n2, boolean bl2) {
            for (Object object : objectArray) {
                this.write(writeBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer) {
            int n2 = byteBuffer.remaining();
            if (n2 == 0) {
                return null;
            }
            byte[] byArray = new byte[n2];
            byteBuffer.get(byArray);
            return byArray;
        }

        @Override
        public void read(ByteBuffer byteBuffer, Object[] objectArray, int n2, boolean bl2) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray[i2] = this.read(byteBuffer);
            }
        }
    }
}

