/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.compress.CompressDeflate;
import org.h2.compress.CompressLZF;
import org.h2.compress.Compressor;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.Page;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.cache.CacheLongKeyLIRS;
import org.h2.mvstore.type.StringDataType;
import org.h2.util.MathUtils;
import org.h2.util.New;

public class MVStore {
    public static final boolean ASSERT = false;
    static final int BLOCK_SIZE = 4096;
    private static final int FORMAT_WRITE = 1;
    private static final int FORMAT_READ = 1;
    private static final int MARKED_FREE = 10000000;
    volatile BackgroundWriterThread backgroundWriterThread;
    private volatile boolean reuseSpace = true;
    private boolean closed;
    private FileStore fileStore;
    private boolean fileStoreIsProvided;
    private final int pageSplitSize;
    private CacheLongKeyLIRS<Page> cache;
    private CacheLongKeyLIRS<Page.PageChildren> cacheChunkRef;
    private Chunk lastChunk;
    private final ConcurrentHashMap<Integer, Chunk> chunks = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, HashMap<Integer, Chunk>> freedPageSpace = new ConcurrentHashMap();
    private MVMap<String, String> meta;
    private final ConcurrentHashMap<Integer, MVMap<?, ?>> maps = new ConcurrentHashMap();
    private HashMap<String, Object> storeHeader = New.hashMap();
    private WriteBuffer writeBuffer;
    private int lastMapId;
    private int versionsToKeep = 5;
    private final int compressionLevel;
    private Compressor compressorFast;
    private Compressor compressorHigh;
    private final Thread.UncaughtExceptionHandler backgroundExceptionHandler;
    private long currentVersion;
    private long lastStoredVersion;
    private int unsavedMemory;
    private int autoCommitMemory;
    private boolean saveNeeded;
    private long creationTime;
    private int retentionTime;
    private long lastCommitTime;
    private Chunk retainChunk;
    private volatile long currentStoreVersion = -1L;
    private Thread currentStoreThread;
    private volatile boolean metaChanged;
    private int autoCommitDelay;
    private int autoCompactFillRate;
    private long autoCompactLastFileOpCount;
    private Object compactSync = new Object();
    private IllegalStateException panicException;
    private long lastTimeAbsolute;
    private long lastFreeUnusedChunks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MVStore(HashMap<String, Object> hashMap) {
        int n2;
        Object object = hashMap.get("compress");
        this.compressionLevel = object == null ? 0 : (Integer)object;
        String string = (String)hashMap.get("fileName");
        object = hashMap.get("pageSplitSize");
        this.pageSplitSize = object == null ? (string == null ? 4096 : 16384) : (Integer)object;
        object = hashMap.get("backgroundExceptionHandler");
        this.backgroundExceptionHandler = (Thread.UncaughtExceptionHandler)object;
        this.meta = new MVMap(StringDataType.INSTANCE, StringDataType.INSTANCE);
        HashMap<String, Object> hashMap2 = New.hashMap();
        hashMap2.put("id", 0);
        hashMap2.put("createVersion", this.currentVersion);
        this.meta.init(this, hashMap2);
        this.fileStore = (FileStore)hashMap.get("fileStore");
        if (string == null && this.fileStore == null) {
            this.cache = null;
            this.cacheChunkRef = null;
            return;
        }
        if (this.fileStore == null) {
            this.fileStoreIsProvided = false;
            this.fileStore = new FileStore();
        } else {
            this.fileStoreIsProvided = true;
        }
        this.retentionTime = this.fileStore.getDefaultRetentionTime();
        boolean bl2 = hashMap.containsKey("readOnly");
        object = hashMap.get("cacheSize");
        int n3 = n2 = object == null ? 16 : (Integer)object;
        if (n2 > 0) {
            CacheLongKeyLIRS.Config config = new CacheLongKeyLIRS.Config();
            config.maxMemory = (long)n2 * 1024L * 1024L;
            this.cache = new CacheLongKeyLIRS(config);
            config.maxMemory /= 4L;
            this.cacheChunkRef = new CacheLongKeyLIRS(config);
        }
        int n4 = (object = hashMap.get("autoCommitBufferSize")) == null ? 1024 : (Integer)object;
        this.autoCommitMemory = n4 * 1024 * 19;
        object = hashMap.get("autoCompactFillRate");
        this.autoCompactFillRate = object == null ? 50 : (Integer)object;
        char[] cArray = (char[])hashMap.get("encryptionKey");
        try {
            if (!this.fileStoreIsProvided) {
                this.fileStore.open(string, bl2, cArray);
            }
            if (this.fileStore.size() == 0L) {
                this.lastCommitTime = this.creationTime = this.getTimeAbsolute();
                this.storeHeader.put("H", 2);
                this.storeHeader.put("blockSize", 4096);
                this.storeHeader.put("format", 1);
                this.storeHeader.put("created", this.creationTime);
                this.writeStoreHeader();
            } else {
                this.readStoreHeader();
            }
        }
        catch (IllegalStateException illegalStateException) {
            this.panic(illegalStateException);
        }
        finally {
            if (cArray != null) {
                Arrays.fill(cArray, '\u0000');
            }
        }
        this.lastCommitTime = this.getTimeSinceCreation();
        object = hashMap.get("autoCommitDelay");
        int n5 = object == null ? 1000 : (Integer)object;
        this.setAutoCommitDelay(n5);
    }

    private void panic(IllegalStateException illegalStateException) {
        if (this.backgroundExceptionHandler != null) {
            this.backgroundExceptionHandler.uncaughtException(null, illegalStateException);
        }
        this.panicException = illegalStateException;
        this.closeImmediately();
        throw illegalStateException;
    }

    public static MVStore open(String string) {
        HashMap<String, Object> hashMap = New.hashMap();
        hashMap.put("fileName", string);
        return new MVStore(hashMap);
    }

    <T extends MVMap<?, ?>> T openMapVersion(long l2, int n2, MVMap<?, ?> mVMap) {
        MVMap<String, String> mVMap2 = this.getMetaMap(l2);
        long l3 = MVStore.getRootPos(mVMap2, n2);
        MVMap<?, ?> mVMap3 = mVMap.openReadOnly();
        mVMap3.setRootPos(l3, l2);
        return (T)mVMap3;
    }

    public <K, V> MVMap<K, V> openMap(String string) {
        return this.openMap(string, new MVMap.Builder());
    }

    public synchronized <M extends MVMap<K, V>, K, V> M openMap(String string, MVMap.MapBuilder<M, K, V> mapBuilder) {
        long l2;
        M m2;
        int n2;
        this.checkOpen();
        String string2 = this.meta.get("name." + string);
        if (string2 != null) {
            n2 = DataUtils.parseHexInt(string2);
            MVMap<?, ?> mVMap = this.maps.get(n2);
            if (mVMap != null) {
                return (M)mVMap;
            }
            m2 = mapBuilder.create();
            String string3 = this.meta.get(MVMap.getMapKey(n2));
            HashMap<String, Object> hashMap = New.hashMap();
            hashMap.putAll(DataUtils.parseMap(string3));
            hashMap.put("id", n2);
            ((MVMap)m2).init(this, hashMap);
            l2 = MVStore.getRootPos(this.meta, n2);
        } else {
            HashMap<String, Object> hashMap = New.hashMap();
            n2 = ++this.lastMapId;
            hashMap.put("id", n2);
            hashMap.put("createVersion", this.currentVersion);
            m2 = mapBuilder.create();
            ((MVMap)m2).init(this, hashMap);
            this.markMetaChanged();
            string2 = Integer.toHexString(n2);
            this.meta.put(MVMap.getMapKey(n2), ((MVMap)m2).asString(string));
            this.meta.put("name." + string, string2);
            l2 = 0L;
        }
        ((MVMap)m2).setRootPos(l2, -1L);
        this.maps.put(n2, (MVMap<?, ?>)m2);
        return m2;
    }

    public synchronized Set<String> getMapNames() {
        String string;
        HashSet<String> hashSet = New.hashSet();
        this.checkOpen();
        Iterator<String> iterator = this.meta.keyIterator("name.");
        while (iterator.hasNext() && (string = iterator.next()).startsWith("name.")) {
            hashSet.add(string.substring("name.".length()));
        }
        return hashSet;
    }

    public MVMap<String, String> getMetaMap() {
        this.checkOpen();
        return this.meta;
    }

    private MVMap<String, String> getMetaMap(long l2) {
        Chunk chunk = this.getChunkForVersion(l2);
        DataUtils.checkArgument(chunk != null, "Unknown version {0}", l2);
        chunk = this.readChunkHeader(chunk.block);
        MVMap<String, String> mVMap = this.meta.openReadOnly();
        mVMap.setRootPos(chunk.metaRootPos, l2);
        return mVMap;
    }

    private Chunk getChunkForVersion(long l2) {
        Chunk chunk = null;
        for (Chunk chunk2 : this.chunks.values()) {
            if (chunk2.version > l2 || chunk != null && chunk2.id <= chunk.id) continue;
            chunk = chunk2;
        }
        return chunk;
    }

    public boolean hasMap(String string) {
        return this.meta.containsKey("name." + string);
    }

    private void markMetaChanged() {
        this.metaChanged = true;
    }

    private synchronized void readStoreHeader() {
        Object object;
        int n2;
        Object object2 = null;
        boolean bl2 = false;
        ByteBuffer byteBuffer = this.fileStore.readFully(0L, 8192);
        byte[] byArray = new byte[4096];
        for (int i2 = 0; i2 <= 4096; i2 += 4096) {
            byteBuffer.get(byArray);
            try {
                String string = new String(byArray, 0, 4096, DataUtils.LATIN).trim();
                HashMap<String, String> hashMap = DataUtils.parseMap(string);
                int n3 = DataUtils.readHexInt(hashMap, "blockSize", 4096);
                if (n3 != 4096) {
                    throw DataUtils.newIllegalStateException(5, "Block size {0} is currently not supported", n3);
                }
                n2 = DataUtils.readHexInt(hashMap, "fletcher", 0);
                hashMap.remove("fletcher");
                string = string.substring(0, string.lastIndexOf("fletcher") - 1);
                object = string.getBytes(DataUtils.LATIN);
                int n4 = DataUtils.getFletcher32(object, ((byte[])object).length);
                if (n2 != n4) continue;
                long l2 = DataUtils.readHexLong(hashMap, "version", 0L);
                if (object2 != null && l2 <= object2.version) continue;
                bl2 = true;
                this.storeHeader.putAll(hashMap);
                this.creationTime = DataUtils.readHexLong(hashMap, "created", 0L);
                int n5 = DataUtils.readHexInt(hashMap, "chunk", 0);
                long l3 = DataUtils.readHexLong(hashMap, "block", 0L);
                Chunk chunk = this.readChunkHeaderAndFooter(l3);
                if (chunk == null || chunk.id != n5) continue;
                object2 = chunk;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl2) {
            throw DataUtils.newIllegalStateException(6, "Store header is corrupt: {0}", this.fileStore);
        }
        long l4 = DataUtils.readHexLong(this.storeHeader, "format", 1L);
        if (l4 > 1L && !this.fileStore.isReadOnly()) {
            throw DataUtils.newIllegalStateException(5, "The write format {0} is larger than the supported format {1}, and the file was not opened in read-only mode", l4, 1);
        }
        if ((l4 = DataUtils.readHexLong(this.storeHeader, "formatRead", l4)) > 1L) {
            throw DataUtils.newIllegalStateException(5, "The read format {0} is larger than the supported format {1}", l4, 1);
        }
        this.lastStoredVersion = -1L;
        this.chunks.clear();
        long l5 = System.currentTimeMillis();
        n2 = 1970 + (int)(l5 / 31557600000L);
        if (n2 < 2014) {
            this.creationTime = l5 - (long)this.fileStore.getDefaultRetentionTime();
        } else if (l5 < this.creationTime) {
            this.creationTime = l5;
            this.storeHeader.put("created", this.creationTime);
        }
        object = this.readChunkFooter(this.fileStore.size());
        if (object != null && (object = (Object)this.readChunkHeaderAndFooter(object.block)) != null && (object2 == null || object.version > object2.version)) {
            object2 = object;
        }
        if (object2 == null) {
            return;
        }
        while (object2.next != 0L && object2.next < this.fileStore.size() / 4096L && (object = (Object)this.readChunkHeaderAndFooter(object2.next)) != null && object.id > object2.id) {
            object2 = object;
        }
        this.setLastChunk((Chunk)object2);
        this.loadChunkMeta();
        this.verifyLastChunks();
        for (Chunk chunk : this.chunks.values()) {
            if (chunk.pageCountLive == 0) {
                this.registerFreePage(this.currentVersion, chunk.id, 0L, 0);
            }
            long l6 = chunk.block * 4096L;
            int n6 = chunk.len * 4096;
            this.fileStore.markUsed(l6, n6);
        }
    }

    private void loadChunkMeta() {
        String string;
        Iterator<String> iterator = this.meta.keyIterator("chunk.");
        while (iterator.hasNext() && (string = iterator.next()).startsWith("chunk.")) {
            string = this.meta.get(string);
            Chunk chunk = Chunk.fromString(string);
            if (this.chunks.containsKey(chunk.id)) continue;
            if (chunk.block == Long.MAX_VALUE) {
                throw DataUtils.newIllegalStateException(6, "Chunk {0} is invalid", chunk.id);
            }
            this.chunks.put(chunk.id, chunk);
        }
    }

    private void setLastChunk(Chunk chunk) {
        this.lastChunk = chunk;
        if (chunk == null) {
            this.lastMapId = 0;
            this.currentVersion = 0L;
            this.meta.setRootPos(0L, -1L);
        } else {
            this.lastMapId = chunk.mapId;
            this.currentVersion = chunk.version;
            this.chunks.put(chunk.id, chunk);
            this.meta.setRootPos(chunk.metaRootPos, -1L);
        }
        this.setWriteVersion(this.currentVersion);
    }

    private void verifyLastChunks() {
        long l2 = this.getTimeSinceCreation();
        ArrayList arrayList = new ArrayList(this.chunks.keySet());
        Collections.sort(arrayList);
        int n2 = -1;
        Chunk chunk = null;
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            Integer n3 = (Integer)object.next();
            Chunk chunk2 = this.chunks.get(n3);
            if (chunk != null && chunk2.time < chunk.time) break;
            chunk = chunk2;
            if (chunk2.time + (long)this.retentionTime < l2) {
                n2 = chunk2.id;
                continue;
            }
            Chunk chunk3 = this.readChunkHeaderAndFooter(chunk2.block);
            if (chunk3 == null || chunk3.id != chunk2.id) break;
            n2 = n3;
        }
        if ((object = this.chunks.get(n2)) != this.lastChunk) {
            this.rollbackTo(object == null ? 0L : ((Chunk)object).version);
        }
    }

    private Chunk readChunkHeaderAndFooter(long l2) {
        Chunk chunk;
        try {
            chunk = this.readChunkHeader(l2);
        }
        catch (Exception exception) {
            return null;
        }
        if (chunk == null) {
            return null;
        }
        Chunk chunk2 = this.readChunkFooter((l2 + (long)chunk.len) * 4096L);
        if (chunk2 == null || chunk2.id != chunk.id) {
            return null;
        }
        return chunk;
    }

    private Chunk readChunkFooter(long l2) {
        try {
            ByteBuffer byteBuffer = this.fileStore.readFully(l2 - 128L, 128);
            byte[] byArray = new byte[128];
            byteBuffer.get(byArray);
            String string = new String(byArray, DataUtils.LATIN).trim();
            HashMap<String, String> hashMap = DataUtils.parseMap(string);
            int n2 = DataUtils.readHexInt(hashMap, "fletcher", 0);
            hashMap.remove("fletcher");
            string = string.substring(0, string.lastIndexOf("fletcher") - 1);
            byte[] byArray2 = string.getBytes(DataUtils.LATIN);
            int n3 = DataUtils.getFletcher32(byArray2, byArray2.length);
            if (n2 == n3) {
                int n4 = DataUtils.readHexInt(hashMap, "chunk", 0);
                Chunk chunk = new Chunk(n4);
                chunk.version = DataUtils.readHexLong(hashMap, "version", 0L);
                chunk.block = DataUtils.readHexLong(hashMap, "block", 0L);
                return chunk;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void writeStoreHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.lastChunk != null) {
            this.storeHeader.put("block", this.lastChunk.block);
            this.storeHeader.put("chunk", this.lastChunk.id);
            this.storeHeader.put("version", this.lastChunk.version);
        }
        DataUtils.appendMap(stringBuilder, this.storeHeader);
        byte[] byArray = stringBuilder.toString().getBytes(DataUtils.LATIN);
        int n2 = DataUtils.getFletcher32(byArray, byArray.length);
        DataUtils.appendMap(stringBuilder, "fletcher", n2);
        stringBuilder.append("\n");
        byArray = stringBuilder.toString().getBytes(DataUtils.LATIN);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
        byteBuffer.put(byArray);
        byteBuffer.position(4096);
        byteBuffer.put(byArray);
        byteBuffer.rewind();
        this.write(0L, byteBuffer);
    }

    private void write(long l2, ByteBuffer byteBuffer) {
        try {
            this.fileStore.writeFully(l2, byteBuffer);
        }
        catch (IllegalStateException illegalStateException) {
            this.panic(illegalStateException);
            throw illegalStateException;
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        FileStore fileStore = this.fileStore;
        if (fileStore != null && !fileStore.isReadOnly()) {
            this.stopBackgroundThread();
            if (this.hasUnsavedChanges()) {
                this.commitAndSave();
            }
        }
        this.closeStore(true);
    }

    public void closeImmediately() {
        block2: {
            try {
                this.closeStore(false);
            }
            catch (Exception exception) {
                if (this.backgroundExceptionHandler == null) break block2;
                this.backgroundExceptionHandler.uncaughtException(null, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStore(boolean bl2) {
        if (this.closed) {
            return;
        }
        this.stopBackgroundThread();
        this.closed = true;
        if (this.fileStore == null) {
            return;
        }
        MVStore mVStore = this;
        synchronized (mVStore) {
            if (bl2) {
                this.shrinkFileIfPossible(0);
            }
            this.cache = null;
            this.cacheChunkRef = null;
            for (MVMap<?, ?> mVMap : New.arrayList(this.maps.values())) {
                mVMap.close();
            }
            this.meta = null;
            this.chunks.clear();
            this.maps.clear();
            try {
                if (!this.fileStoreIsProvided) {
                    this.fileStore.close();
                }
            }
            finally {
                this.fileStore = null;
            }
        }
    }

    boolean isChunkLive(int n2) {
        String string = this.meta.get(Chunk.getMetaKey(n2));
        return string != null;
    }

    private Chunk getChunk(long l2) {
        Chunk chunk = this.getChunkIfFound(l2);
        if (chunk == null) {
            int n2 = DataUtils.getPageChunkId(l2);
            throw DataUtils.newIllegalStateException(6, "Chunk {0} not found", n2);
        }
        return chunk;
    }

    private Chunk getChunkIfFound(long l2) {
        int n2 = DataUtils.getPageChunkId(l2);
        Chunk chunk = this.chunks.get(n2);
        if (chunk == null) {
            this.checkOpen();
            if (!Thread.holdsLock(this)) {
                throw DataUtils.newIllegalStateException(9, "Chunk {0} no longer exists", n2);
            }
            String string = this.meta.get(Chunk.getMetaKey(n2));
            if (string == null) {
                return null;
            }
            chunk = Chunk.fromString(string);
            if (chunk.block == Long.MAX_VALUE) {
                throw DataUtils.newIllegalStateException(6, "Chunk {0} is invalid", n2);
            }
            this.chunks.put(chunk.id, chunk);
        }
        return chunk;
    }

    private void setWriteVersion(long l2) {
        for (MVMap<?, ?> mVMap : this.maps.values()) {
            mVMap.setWriteVersion(l2);
        }
        MVMap<String, String> mVMap = this.meta;
        if (mVMap == null) {
            this.checkOpen();
        }
        mVMap.setWriteVersion(l2);
    }

    public long commit() {
        if (this.fileStore != null) {
            return this.commitAndSave();
        }
        long l2 = ++this.currentVersion;
        this.setWriteVersion(l2);
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long commitAndSave() {
        if (this.closed) {
            return this.currentVersion;
        }
        if (this.fileStore == null) {
            throw DataUtils.newIllegalStateException(2, "This is an in-memory store", new Object[0]);
        }
        if (this.currentStoreVersion >= 0L) {
            return this.currentVersion;
        }
        if (!this.hasUnsavedChanges()) {
            return this.currentVersion;
        }
        if (this.fileStore.isReadOnly()) {
            throw DataUtils.newIllegalStateException(2, "This store is read-only", new Object[0]);
        }
        try {
            this.currentStoreVersion = this.currentVersion;
            this.currentStoreThread = Thread.currentThread();
            long l2 = this.storeNow();
            return l2;
        }
        finally {
            this.currentStoreVersion = -1L;
            this.currentStoreThread = null;
        }
    }

    private long storeNow() {
        try {
            return this.storeNowTry();
        }
        catch (IllegalStateException illegalStateException) {
            this.panic(illegalStateException);
            return -1L;
        }
    }

    private long storeNowTry() {
        long l2;
        int n2;
        boolean bl2;
        Object object;
        Serializable serializable;
        Chunk chunk;
        int n3;
        int n4;
        long l3 = this.getTimeSinceCreation();
        if (l3 >= this.lastFreeUnusedChunks + (long)(n4 = this.retentionTime / 10)) {
            this.lastFreeUnusedChunks = l3;
            this.freeUnusedChunks();
        }
        int n5 = this.unsavedMemory;
        long l4 = this.currentStoreVersion;
        long l5 = ++this.currentVersion;
        this.setWriteVersion(l5);
        this.lastCommitTime = l3;
        this.retainChunk = null;
        if (this.lastChunk == null) {
            n3 = 0;
        } else {
            n3 = this.lastChunk.id;
            this.meta.put(Chunk.getMetaKey(n3), this.lastChunk.asString());
            l3 = Math.max(this.lastChunk.time, l3);
        }
        int n6 = n3;
        while ((chunk = this.chunks.get(n6 = (n6 + 1) % 0x3FFFFFF)) != null) {
            if (chunk.block != Long.MAX_VALUE) continue;
            serializable = DataUtils.newIllegalStateException(3, "Last block not stored, possibly due to out-of-memory", new Object[0]);
            this.panic((IllegalStateException)serializable);
        }
        chunk = new Chunk(n6);
        chunk.pageCount = Integer.MAX_VALUE;
        chunk.pageCountLive = Integer.MAX_VALUE;
        chunk.maxLen = Long.MAX_VALUE;
        chunk.maxLenLive = Long.MAX_VALUE;
        chunk.metaRootPos = Long.MAX_VALUE;
        chunk.block = Long.MAX_VALUE;
        chunk.len = Integer.MAX_VALUE;
        chunk.time = l3;
        chunk.version = l5;
        chunk.mapId = this.lastMapId;
        chunk.next = Long.MAX_VALUE;
        this.chunks.put(chunk.id, chunk);
        this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
        this.meta.remove(Chunk.getMetaKey(chunk.id));
        serializable = New.arrayList(this.maps.values());
        ArrayList<MVMap> arrayList = New.arrayList();
        Object object2 = ((ArrayList)serializable).iterator();
        while (object2.hasNext()) {
            MVMap mVMap = (MVMap)object2.next();
            mVMap.setWriteVersion(l5);
            long l6 = mVMap.getVersion();
            if (mVMap.getCreateVersion() > l4 || mVMap.isVolatile() || l6 < 0L || l6 < this.lastStoredVersion || ((MVMap)(object = mVMap.openVersion(l4))).getRoot().getPos() != 0L) continue;
            arrayList.add((MVMap)object);
        }
        this.applyFreedSpace(l4);
        object2 = this.getWriteBuffer();
        chunk.writeChunkHeader((WriteBuffer)object2, 0);
        int n7 = ((WriteBuffer)object2).position();
        chunk.pageCount = 0;
        chunk.pageCountLive = 0;
        chunk.maxLen = 0L;
        chunk.maxLenLive = 0L;
        for (MVMap mVMap : arrayList) {
            object = mVMap.getRoot();
            String string = MVMap.getMapRootKey(mVMap.getId());
            if (((Page)object).getTotalCount() == 0L) {
                this.meta.put(string, "0");
                continue;
            }
            ((Page)object).writeUnsavedRecursive(chunk, (WriteBuffer)object2);
            long l7 = ((Page)object).getPos();
            this.meta.put(string, Long.toHexString(l7));
        }
        this.meta.setWriteVersion(l5);
        Page page = this.meta.getRoot();
        page.writeUnsavedRecursive(chunk, (WriteBuffer)object2);
        int n8 = ((WriteBuffer)object2).position();
        int n9 = MathUtils.roundUpInt(n8 + 128, 4096);
        ((WriteBuffer)object2).limit(n9);
        long l8 = this.getFileLengthInUse();
        long l9 = this.reuseSpace ? this.fileStore.allocate(n9) : l8;
        boolean bl3 = bl2 = l9 + (long)n9 >= this.fileStore.size();
        if (!this.reuseSpace) {
            this.fileStore.markUsed(l8, n9);
        }
        chunk.block = l9 / 4096L;
        chunk.len = n9 / 4096;
        chunk.metaRootPos = page.getPos();
        if (this.reuseSpace) {
            n2 = chunk.len;
            l2 = this.fileStore.allocate(n2 * 4096);
            this.fileStore.free(l2, n2 * 4096);
            chunk.next = l2 / 4096L;
        } else {
            chunk.next = 0L;
        }
        ((WriteBuffer)object2).position(0);
        chunk.writeChunkHeader((WriteBuffer)object2, n7);
        this.revertTemp(l4);
        ((WriteBuffer)object2).position(((WriteBuffer)object2).limit() - 128);
        ((WriteBuffer)object2).put(chunk.getFooterBytes());
        ((WriteBuffer)object2).position(0);
        this.write(l9, ((WriteBuffer)object2).getBuffer());
        this.releaseWriteBuffer((WriteBuffer)object2);
        n2 = 0;
        if (!bl2) {
            if (this.lastChunk == null) {
                n2 = 1;
            } else if (this.lastChunk.next != chunk.block) {
                n2 = 1;
            } else {
                l2 = DataUtils.readHexLong(this.storeHeader, "version", 0L);
                if (this.lastChunk.version - l2 > 20L) {
                    n2 = 1;
                } else {
                    int n10 = DataUtils.readHexInt(this.storeHeader, "chunk", 0);
                    while (true) {
                        Chunk chunk2;
                        if ((chunk2 = this.chunks.get(n10)) == null) {
                            n2 = 1;
                            break;
                        }
                        if (n10 == this.lastChunk.id) break;
                        ++n10;
                    }
                }
            }
        }
        this.lastChunk = chunk;
        if (n2 != 0) {
            this.writeStoreHeader();
        }
        if (!bl2) {
            this.shrinkFileIfPossible(1);
        }
        for (MVMap mVMap : arrayList) {
            Page page2 = mVMap.getRoot();
            if (page2.getTotalCount() <= 0L) continue;
            page2.writeEnd();
        }
        page.writeEnd();
        this.unsavedMemory = Math.max(0, this.unsavedMemory - n5);
        this.metaChanged = false;
        this.lastStoredVersion = l4;
        return l5;
    }

    private synchronized void freeUnusedChunks() {
        if (this.lastChunk == null || !this.reuseSpace) {
            return;
        }
        Set<Integer> set = this.collectReferencedChunks();
        ArrayList<Chunk> arrayList = New.arrayList();
        long l2 = this.getTimeSinceCreation();
        for (Chunk chunk : this.chunks.values()) {
            if (set.contains(chunk.id)) continue;
            arrayList.add(chunk);
        }
        for (Chunk chunk : arrayList) {
            if (this.canOverwriteChunk(chunk, l2)) {
                this.chunks.remove(chunk.id);
                this.markMetaChanged();
                this.meta.remove(Chunk.getMetaKey(chunk.id));
                long l3 = chunk.block * 4096L;
                int n2 = chunk.len * 4096;
                this.fileStore.free(l3, n2);
                continue;
            }
            if (chunk.unused != 0L) continue;
            chunk.unused = l2;
            this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
            this.markMetaChanged();
        }
    }

    private Set<Integer> collectReferencedChunks() {
        String string;
        long l2 = this.lastChunk.version;
        DataUtils.checkArgument(l2 > 0L, "Collect references on version 0", new Object[0]);
        long l3 = this.getFileStore().readCount;
        HashSet<Integer> hashSet = New.hashSet();
        Cursor<String, String> cursor = this.meta.cursor("root.");
        while (cursor.hasNext() && (string = cursor.next()).startsWith("root.")) {
            long l4 = DataUtils.parseHexLong(cursor.getValue());
            if (l4 == 0L) continue;
            int n2 = DataUtils.parseHexInt(string.substring("root.".length()));
            this.collectReferencedChunks(hashSet, n2, l4, 0);
        }
        long l5 = this.lastChunk.metaRootPos;
        this.collectReferencedChunks(hashSet, 0, l5, 0);
        l3 = this.fileStore.readCount - l3;
        return hashSet;
    }

    private void collectReferencedChunks(Set<Integer> set, int n2, long l2, int n3) {
        int n4 = DataUtils.getPageChunkId(l2);
        set.add(n4);
        if (DataUtils.getPageType(l2) == 0) {
            return;
        }
        Page.PageChildren pageChildren = this.readPageChunkReferences(n2, l2, -1);
        if (!pageChildren.chunkList) {
            HashSet hashSet = New.hashSet();
            for (int i2 = 0; i2 < pageChildren.children.length; ++i2) {
                long l3 = pageChildren.children[i2];
                this.collectReferencedChunks(hashSet, n2, l3, n3 + 1);
            }
            hashSet.remove(n4);
            long[] lArray = new long[hashSet.size()];
            int n5 = 0;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Integer n6 = (Integer)iterator.next();
                lArray[n5++] = DataUtils.getPagePos(n6, 0, 0, 0);
            }
            pageChildren.children = lArray;
            pageChildren.chunkList = true;
            if (this.cacheChunkRef != null) {
                this.cacheChunkRef.put(pageChildren.pos, pageChildren, pageChildren.getMemory());
            }
        }
        for (Object object : (HashSet)pageChildren.children) {
            set.add(DataUtils.getPageChunkId((long)object));
        }
    }

    private Page.PageChildren readPageChunkReferences(int n2, long l2, int n3) {
        int n4;
        if (DataUtils.getPageType(l2) == 0) {
            return null;
        }
        Page.PageChildren pageChildren = this.cacheChunkRef != null ? this.cacheChunkRef.get(l2) : null;
        if (pageChildren == null) {
            Object object;
            if (this.cache != null && (object = this.cache.get(l2)) != null) {
                pageChildren = new Page.PageChildren((Page)object);
            }
            if (pageChildren == null) {
                object = this.getChunk(l2);
                long l3 = ((Chunk)object).block * 4096L;
                if ((l3 += (long)DataUtils.getPageOffset(l2)) < 0L) {
                    throw DataUtils.newIllegalStateException(6, "Negative position {0}; p={1}, c={2}", l3, l2, ((Chunk)object).toString());
                }
                long l4 = (((Chunk)object).block + (long)((Chunk)object).len) * 4096L;
                pageChildren = Page.PageChildren.read(this.fileStore, l2, n2, l3, l4);
            }
            pageChildren.removeDuplicateChunkReferences();
            if (this.cacheChunkRef != null) {
                this.cacheChunkRef.put(l2, pageChildren, pageChildren.getMemory());
            }
        }
        if (pageChildren.children.length == 0 && (n4 = DataUtils.getPageChunkId(l2)) == n3) {
            return null;
        }
        return pageChildren;
    }

    private WriteBuffer getWriteBuffer() {
        WriteBuffer writeBuffer;
        if (this.writeBuffer != null) {
            writeBuffer = this.writeBuffer;
            writeBuffer.clear();
        } else {
            writeBuffer = new WriteBuffer();
        }
        return writeBuffer;
    }

    private void releaseWriteBuffer(WriteBuffer writeBuffer) {
        if (writeBuffer.capacity() <= 0x400000) {
            this.writeBuffer = writeBuffer;
        }
    }

    private boolean canOverwriteChunk(Chunk chunk, long l2) {
        Chunk chunk2;
        if (this.retentionTime >= 0) {
            if (chunk.time + (long)this.retentionTime > l2) {
                return false;
            }
            if (chunk.unused == 0L || chunk.unused + (long)(this.retentionTime / 2) > l2) {
                return false;
            }
        }
        return (chunk2 = this.retainChunk) == null || chunk.version <= chunk2.version;
    }

    private long getTimeSinceCreation() {
        return Math.max(0L, this.getTimeAbsolute() - this.creationTime);
    }

    private long getTimeAbsolute() {
        long l2 = System.currentTimeMillis();
        if (this.lastTimeAbsolute != 0L && l2 < this.lastTimeAbsolute) {
            l2 = this.lastTimeAbsolute;
        } else {
            this.lastTimeAbsolute = l2;
        }
        return l2;
    }

    private void applyFreedSpace(long l2) {
        ArrayList<Chunk> arrayList;
        do {
            arrayList = New.arrayList();
            Iterator<Map.Entry<Long, HashMap<Integer, Chunk>>> iterator = this.freedPageSpace.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, HashMap<Integer, Chunk>> entry = iterator.next();
                long l3 = (Long)entry.getKey();
                if (l3 > l2) continue;
                HashMap hashMap = (HashMap)entry.getValue();
                for (Chunk chunk : hashMap.values()) {
                    Chunk chunk2 = this.chunks.get(chunk.id);
                    if (chunk2 == null) continue;
                    chunk2.maxLenLive += chunk.maxLenLive;
                    chunk2.pageCountLive += chunk.pageCountLive;
                    if (chunk2.pageCountLive < 0 && chunk2.pageCountLive > -10000000) {
                        chunk2.pageCountLive = 0;
                    }
                    if (chunk2.maxLenLive < 0L && chunk2.maxLenLive > -10000000L) {
                        chunk2.maxLenLive = 0L;
                    }
                    arrayList.add(chunk2);
                }
                iterator.remove();
            }
            for (Chunk chunk : arrayList) {
                this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
            }
        } while (arrayList.size() != 0);
    }

    private void shrinkFileIfPossible(int n2) {
        long l2;
        long l3 = this.getFileLengthInUse();
        if (l3 >= (l2 = this.fileStore.size())) {
            return;
        }
        if (n2 > 0 && l2 - l3 < 4096L) {
            return;
        }
        int n3 = (int)(100L - l3 * 100L / l2);
        if (n3 < n2) {
            return;
        }
        if (!this.closed) {
            this.sync();
        }
        this.fileStore.truncate(l3);
    }

    private long getFileLengthInUse() {
        long l2 = 8192L;
        for (Chunk chunk : this.chunks.values()) {
            if (chunk.len == Integer.MAX_VALUE) continue;
            long l3 = (chunk.block + (long)chunk.len) * 4096L;
            l2 = Math.max(l2, l3);
        }
        return l2;
    }

    public boolean hasUnsavedChanges() {
        this.checkOpen();
        if (this.metaChanged) {
            return true;
        }
        for (MVMap<?, ?> mVMap : this.maps.values()) {
            long l2;
            if (mVMap.isClosed() || (l2 = mVMap.getVersion()) < 0L || l2 <= this.lastStoredVersion) continue;
            return true;
        }
        return false;
    }

    private Chunk readChunkHeader(long l2) {
        long l3 = l2 * 4096L;
        ByteBuffer byteBuffer = this.fileStore.readFully(l3, 1024);
        return Chunk.readChunkHeader(byteBuffer, l3);
    }

    public synchronized boolean compactRewriteFully() {
        this.checkOpen();
        if (this.lastChunk == null) {
            return false;
        }
        Iterator<MVMap<?, ?>> iterator = this.maps.values().iterator();
        while (iterator.hasNext()) {
            MVMap<?, ?> mVMap;
            MVMap<?, ?> mVMap2 = mVMap = iterator.next();
            Cursor<Object, ?> cursor = mVMap2.cursor(null);
            Page page = null;
            while (cursor.hasNext()) {
                cursor.next();
                Page page2 = cursor.getPage();
                if (page2 == page) continue;
                Object object = page2.getKey(0);
                Object object2 = page2.getValue(0);
                mVMap2.put(object, object2);
                page = page2;
            }
        }
        this.commitAndSave();
        return true;
    }

    public synchronized boolean compactMoveChunks() {
        return this.compactMoveChunks(100, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean compactMoveChunks(int n2, long l2) {
        this.checkOpen();
        if (this.lastChunk == null || !this.reuseSpace) {
            return false;
        }
        int n3 = this.retentionTime;
        boolean bl2 = this.reuseSpace;
        try {
            this.retentionTime = -1;
            this.freeUnusedChunks();
            if (this.fileStore.getFillRate() > n2) {
                boolean bl3 = false;
                return bl3;
            }
            long l3 = this.fileStore.getFirstFree() / 4096L;
            ArrayList<Chunk> arrayList = this.compactGetMoveBlocks(l3, l2);
            this.compactMoveChunks(arrayList);
            this.freeUnusedChunks();
            this.storeNow();
        }
        finally {
            this.reuseSpace = bl2;
            this.retentionTime = n3;
        }
        return true;
    }

    private ArrayList<Chunk> compactGetMoveBlocks(long l2, long l3) {
        ArrayList<Chunk> arrayList = New.arrayList();
        for (Chunk chunk : this.chunks.values()) {
            if (chunk.block <= l2) continue;
            arrayList.add(chunk);
        }
        Collections.sort(arrayList, new Comparator<Chunk>(){

            @Override
            public int compare(Chunk chunk, Chunk chunk2) {
                return Long.signum(chunk.block - chunk2.block);
            }
        });
        int n2 = 0;
        long l4 = 0L;
        for (Chunk chunk : arrayList) {
            long l5 = (long)chunk.len * 4096L;
            if (l4 + l5 > l3) break;
            l4 += l5;
            ++n2;
        }
        while (arrayList.size() > n2 && arrayList.size() > 1) {
            arrayList.remove(1);
        }
        return arrayList;
    }

    private void compactMoveChunks(ArrayList<Chunk> arrayList) {
        long l2;
        int n2;
        ByteBuffer byteBuffer;
        int n3;
        long l3;
        WriteBuffer writeBuffer;
        for (Chunk chunk : arrayList) {
            writeBuffer = this.getWriteBuffer();
            l3 = chunk.block * 4096L;
            n3 = chunk.len * 4096;
            writeBuffer.limit(n3);
            byteBuffer = this.fileStore.readFully(l3, n3);
            Chunk.readChunkHeader(byteBuffer, l3);
            n2 = byteBuffer.position();
            writeBuffer.position(n2);
            writeBuffer.put(byteBuffer);
            l2 = this.getFileLengthInUse();
            this.fileStore.markUsed(l2, n3);
            this.fileStore.free(l3, n3);
            chunk.block = l2 / 4096L;
            chunk.next = 0L;
            writeBuffer.position(0);
            chunk.writeChunkHeader(writeBuffer, n2);
            writeBuffer.position(n3 - 128);
            writeBuffer.put(chunk.getFooterBytes());
            writeBuffer.position(0);
            this.write(l2, writeBuffer.getBuffer());
            this.releaseWriteBuffer(writeBuffer);
            this.markMetaChanged();
            this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
        }
        this.reuseSpace = false;
        this.commitAndSave();
        this.sync();
        this.reuseSpace = true;
        for (Chunk chunk : arrayList) {
            if (!this.chunks.containsKey(chunk.id)) continue;
            writeBuffer = this.getWriteBuffer();
            l3 = chunk.block * 4096L;
            n3 = chunk.len * 4096;
            writeBuffer.limit(n3);
            byteBuffer = this.fileStore.readFully(l3, n3);
            Chunk.readChunkHeader(byteBuffer, 0L);
            n2 = byteBuffer.position();
            writeBuffer.position(n2);
            writeBuffer.put(byteBuffer);
            l2 = this.fileStore.allocate(n3);
            this.fileStore.free(l3, n3);
            writeBuffer.position(0);
            chunk.block = l2 / 4096L;
            chunk.writeChunkHeader(writeBuffer, n2);
            writeBuffer.position(n3 - 128);
            writeBuffer.put(chunk.getFooterBytes());
            writeBuffer.position(0);
            this.write(l2, writeBuffer.getBuffer());
            this.releaseWriteBuffer(writeBuffer);
            this.markMetaChanged();
            this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
        }
        this.commitAndSave();
        this.sync();
        this.shrinkFileIfPossible(0);
    }

    public void sync() {
        this.checkOpen();
        FileStore fileStore = this.fileStore;
        if (fileStore != null) {
            fileStore.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compact(int n2, int n3) {
        if (!this.reuseSpace) {
            return false;
        }
        Object object = this.compactSync;
        synchronized (object) {
            ArrayList<Chunk> arrayList;
            this.checkOpen();
            MVStore mVStore = this;
            synchronized (mVStore) {
                arrayList = this.compactGetOldChunks(n2, n3);
            }
            if (arrayList == null || arrayList.size() == 0) {
                return false;
            }
            this.compactRewrite(arrayList);
            return true;
        }
    }

    private ArrayList<Chunk> compactGetOldChunks(int n2, int n3) {
        Object object3;
        int n4;
        if (this.lastChunk == null) {
            return null;
        }
        long l2 = 0L;
        long l3 = 0L;
        long l4 = this.getTimeSinceCreation();
        for (Chunk object22 : this.chunks.values()) {
            if (object22.time + (long)this.retentionTime > l4) continue;
            l2 += object22.maxLen;
            l3 += object22.maxLenLive;
        }
        if (l3 < 0L) {
            return null;
        }
        if (l2 <= 0L) {
            l2 = 1L;
        }
        if ((n4 = (int)(100L * l3 / l2)) >= n2) {
            return null;
        }
        ArrayList<Chunk> arrayList = New.arrayList();
        Chunk chunk = this.chunks.get(this.lastChunk.id);
        for (Chunk chunk2 : this.chunks.values()) {
            if (chunk2.time + (long)this.retentionTime > l4) continue;
            long n5 = chunk.version - chunk2.version + 1L;
            chunk2.collectPriority = (int)((long)(chunk2.getFillRate() * 1000) / n5);
            arrayList.add(chunk2);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Collections.sort(arrayList, new Comparator<Chunk>(){

            @Override
            public int compare(Chunk chunk, Chunk chunk2) {
                int n2 = new Integer(chunk.collectPriority).compareTo(chunk2.collectPriority);
                if (n2 == 0) {
                    n2 = new Long(chunk.maxLenLive).compareTo(chunk2.maxLenLive);
                }
                return n2;
            }
        });
        long l5 = 0L;
        int n5 = 0;
        Object object2 = null;
        for (Object object3 : arrayList) {
            if (object2 != null && ((Chunk)object3).collectPriority > 0 && l5 > (long)n3) break;
            l5 += ((Chunk)object3).maxLenLive;
            ++n5;
            object2 = object3;
        }
        if (n5 < 1) {
            return null;
        }
        boolean bl2 = false;
        object3 = arrayList.iterator();
        while (object3.hasNext()) {
            Chunk chunk3 = (Chunk)object3.next();
            if (object2 == chunk3) {
                bl2 = true;
                continue;
            }
            if (!bl2) continue;
            object3.remove();
        }
        return arrayList;
    }

    private void compactRewrite(ArrayList<Chunk> arrayList) {
        HashSet<Integer> hashSet = New.hashSet();
        for (Chunk object : arrayList) {
            hashSet.add(object.id);
        }
        for (MVMap mVMap : this.maps.values()) {
            MVMap mVMap2 = mVMap;
            if (mVMap2.rewrite(hashSet)) continue;
            return;
        }
        if (!this.meta.rewrite(hashSet)) {
            return;
        }
        this.freeUnusedChunks();
        this.commitAndSave();
    }

    Page readPage(MVMap<?, ?> mVMap, long l2) {
        Page page;
        if (l2 == 0L) {
            throw DataUtils.newIllegalStateException(6, "Position 0", new Object[0]);
        }
        Page page2 = page = this.cache == null ? null : this.cache.get(l2);
        if (page == null) {
            Chunk chunk = this.getChunk(l2);
            long l3 = chunk.block * 4096L;
            if ((l3 += (long)DataUtils.getPageOffset(l2)) < 0L) {
                throw DataUtils.newIllegalStateException(6, "Negative position {0}", l3);
            }
            long l4 = (chunk.block + (long)chunk.len) * 4096L;
            page = Page.read(this.fileStore, l2, mVMap, l3, l4);
            this.cachePage(l2, page, page.getMemory());
        }
        return page;
    }

    void removePage(MVMap<?, ?> mVMap, long l2, int n2) {
        if (l2 == 0L) {
            this.unsavedMemory = Math.max(0, this.unsavedMemory - n2);
            return;
        }
        if (this.cache != null && DataUtils.getPageType(l2) == 0) {
            this.cache.remove(l2);
        }
        Chunk chunk = this.getChunk(l2);
        long l3 = this.currentVersion;
        if (mVMap == this.meta && this.currentStoreVersion >= 0L && Thread.currentThread() == this.currentStoreThread) {
            l3 = this.currentStoreVersion;
        }
        this.registerFreePage(l3, chunk.id, DataUtils.getPageMaxLength(l2), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerFreePage(long l2, int n2, long l3, int n3) {
        HashMap<Integer, Chunk> hashMap;
        HashMap<Integer, Chunk> hashMap2 = this.freedPageSpace.get(l2);
        if (hashMap2 == null) {
            hashMap2 = New.hashMap();
            hashMap = this.freedPageSpace.putIfAbsent(l2, hashMap2);
            if (hashMap != null) {
                hashMap2 = hashMap;
            }
        }
        hashMap = hashMap2;
        synchronized (hashMap) {
            Chunk chunk = hashMap2.get(n2);
            if (chunk == null) {
                chunk = new Chunk(n2);
                hashMap2.put(n2, chunk);
            }
            chunk.maxLenLive -= l3;
            chunk.pageCountLive -= n3;
        }
    }

    Compressor getCompressorFast() {
        if (this.compressorFast == null) {
            this.compressorFast = new CompressLZF();
        }
        return this.compressorFast;
    }

    Compressor getCompressorHigh() {
        if (this.compressorHigh == null) {
            this.compressorHigh = new CompressDeflate();
        }
        return this.compressorHigh;
    }

    int getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getPageSplitSize() {
        return this.pageSplitSize;
    }

    public boolean getReuseSpace() {
        return this.reuseSpace;
    }

    public void setReuseSpace(boolean bl2) {
        this.reuseSpace = bl2;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(int n2) {
        this.retentionTime = n2;
    }

    public void setVersionsToKeep(int n2) {
        this.versionsToKeep = n2;
    }

    public long getVersionsToKeep() {
        return this.versionsToKeep;
    }

    long getOldestVersionToKeep() {
        long l2 = this.currentVersion;
        if (this.fileStore == null) {
            return l2 - (long)this.versionsToKeep;
        }
        long l3 = this.currentStoreVersion;
        if (l3 > -1L) {
            l2 = Math.min(l2, l3);
        }
        return l2;
    }

    private boolean isKnownVersion(long l2) {
        if (l2 > this.currentVersion || l2 < 0L) {
            return false;
        }
        if (l2 == this.currentVersion || this.chunks.size() == 0) {
            return true;
        }
        Chunk chunk = this.getChunkForVersion(l2);
        if (chunk == null) {
            return false;
        }
        MVMap<String, String> mVMap = this.getMetaMap(l2);
        if (mVMap == null) {
            return false;
        }
        try {
            String string;
            Iterator<String> iterator = mVMap.keyIterator("chunk.");
            while (iterator.hasNext() && (string = iterator.next()).startsWith("chunk.")) {
                if (this.meta.containsKey(string)) continue;
                String string2 = mVMap.get(string);
                Chunk chunk2 = Chunk.fromString(string2);
                Chunk chunk3 = this.readChunkHeaderAndFooter(chunk2.block);
                if (chunk3 == null || chunk3.id != chunk2.id) {
                    return false;
                }
                this.chunks.put(chunk2.id, chunk2);
            }
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        return true;
    }

    void registerUnsavedPage(int n2) {
        this.unsavedMemory += n2;
        int n3 = this.unsavedMemory;
        if (n3 > this.autoCommitMemory && this.autoCommitMemory > 0) {
            this.saveNeeded = true;
        }
    }

    void beforeWrite(MVMap<?, ?> mVMap) {
        if (this.saveNeeded) {
            if (mVMap == this.meta) {
                return;
            }
            this.saveNeeded = false;
            if (this.unsavedMemory > this.autoCommitMemory && this.autoCommitMemory > 0) {
                this.commitAndSave();
            }
        }
    }

    public int getStoreVersion() {
        this.checkOpen();
        String string = this.meta.get("setting.storeVersion");
        return string == null ? 0 : DataUtils.parseHexInt(string);
    }

    public synchronized void setStoreVersion(int n2) {
        this.checkOpen();
        this.markMetaChanged();
        this.meta.put("setting.storeVersion", Integer.toHexString(n2));
    }

    public void rollback() {
        this.rollbackTo(this.currentVersion);
    }

    public synchronized void rollbackTo(long l2) {
        this.checkOpen();
        if (l2 == 0L) {
            for (MVMap<?, ?> mVMap : this.maps.values()) {
                mVMap.close();
            }
            this.meta.clear();
            this.chunks.clear();
            if (this.fileStore != null) {
                this.fileStore.clear();
            }
            this.maps.clear();
            this.freedPageSpace.clear();
            this.currentVersion = l2;
            this.setWriteVersion(l2);
            this.metaChanged = false;
            return;
        }
        DataUtils.checkArgument(this.isKnownVersion(l2), "Unknown version {0}", l2);
        for (MVMap<?, ?> object2 : this.maps.values()) {
            object2.rollbackTo(l2);
        }
        for (long i2 = this.currentVersion; i2 >= l2 && this.freedPageSpace.size() != 0; --i2) {
            this.freedPageSpace.remove(i2);
        }
        this.meta.rollbackTo(l2);
        this.metaChanged = false;
        boolean bl2 = false;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Chunk chunk = null;
        for (Chunk n2 : this.chunks.values()) {
            if (n2.version > l2) {
                arrayList.add(n2.id);
                continue;
            }
            if (chunk != null && chunk.id >= n2.id) continue;
            chunk = n2;
        }
        if (arrayList.size() > 0) {
            Collections.sort(arrayList, Collections.reverseOrder());
            this.revertTemp(l2);
            bl2 = true;
            Iterator<Object> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                Chunk chunk2 = this.chunks.remove(n2);
                long l3 = chunk2.block * 4096L;
                int n3 = chunk2.len * 4096;
                this.fileStore.free(l3, n3);
                WriteBuffer writeBuffer = this.getWriteBuffer();
                writeBuffer.limit(n3);
                Arrays.fill(writeBuffer.getBuffer().array(), (byte)0);
                this.write(l3, writeBuffer.getBuffer());
                this.releaseWriteBuffer(writeBuffer);
                this.sync();
            }
            this.lastChunk = chunk;
            this.writeStoreHeader();
            this.readStoreHeader();
        }
        for (MVMap mVMap : New.arrayList(this.maps.values())) {
            int n4 = mVMap.getId();
            if (mVMap.getCreateVersion() >= l2) {
                mVMap.close();
                this.maps.remove(n4);
                continue;
            }
            if (!bl2) continue;
            mVMap.setRootPos(MVStore.getRootPos(this.meta, n4), -1L);
        }
        if (this.lastChunk != null) {
            for (Chunk chunk3 : this.chunks.values()) {
                this.meta.put(Chunk.getMetaKey(chunk3.id), chunk3.asString());
            }
        }
        this.currentVersion = l2;
        this.setWriteVersion(l2);
    }

    private static long getRootPos(MVMap<String, String> mVMap, int n2) {
        String string = mVMap.get(MVMap.getMapRootKey(n2));
        return string == null ? 0L : DataUtils.parseHexLong(string);
    }

    private void revertTemp(long l2) {
        Iterator<Object> iterator = this.freedPageSpace.keySet().iterator();
        while (iterator.hasNext()) {
            long l3 = (Long)iterator.next();
            if (l3 > l2) continue;
            iterator.remove();
        }
        for (MVMap mVMap : this.maps.values()) {
            mVMap.removeUnusedOldVersions();
        }
    }

    public long getCurrentVersion() {
        return this.currentVersion;
    }

    public FileStore getFileStore() {
        return this.fileStore;
    }

    public Map<String, Object> getStoreHeader() {
        return this.storeHeader;
    }

    private void checkOpen() {
        if (this.closed) {
            throw DataUtils.newIllegalStateException(4, "This store is closed", this.panicException);
        }
    }

    public synchronized void renameMap(MVMap<?, ?> mVMap, String string) {
        this.checkOpen();
        DataUtils.checkArgument(mVMap != this.meta, "Renaming the meta map is not allowed", new Object[0]);
        int n2 = mVMap.getId();
        String string2 = this.getMapName(n2);
        if (string2.equals(string)) {
            return;
        }
        DataUtils.checkArgument(!this.meta.containsKey("name." + string), "A map named {0} already exists", string);
        this.markMetaChanged();
        String string3 = Integer.toHexString(n2);
        this.meta.remove("name." + string2);
        this.meta.put(MVMap.getMapKey(n2), mVMap.asString(string));
        this.meta.put("name." + string, string3);
    }

    public synchronized void removeMap(MVMap<?, ?> mVMap) {
        this.checkOpen();
        DataUtils.checkArgument(mVMap != this.meta, "Removing the meta map is not allowed", new Object[0]);
        mVMap.clear();
        int n2 = mVMap.getId();
        String string = this.getMapName(n2);
        this.markMetaChanged();
        this.meta.remove(MVMap.getMapKey(n2));
        this.meta.remove("name." + string);
        this.meta.remove(MVMap.getMapRootKey(n2));
        this.maps.remove(n2);
    }

    public synchronized String getMapName(int n2) {
        this.checkOpen();
        String string = this.meta.get(MVMap.getMapKey(n2));
        return string == null ? null : DataUtils.parseMap(string).get("name");
    }

    void writeInBackground() {
        block9: {
            block8: {
                if (this.closed) {
                    return;
                }
                long l2 = this.getTimeSinceCreation();
                if (l2 <= this.lastCommitTime + (long)this.autoCommitDelay) {
                    return;
                }
                if (this.hasUnsavedChanges()) {
                    try {
                        this.commitAndSave();
                    }
                    catch (Exception exception) {
                        if (this.backgroundExceptionHandler == null) break block8;
                        this.backgroundExceptionHandler.uncaughtException(null, exception);
                        return;
                    }
                }
            }
            if (this.autoCompactFillRate > 0) {
                try {
                    long l3 = this.fileStore.getWriteCount() + this.fileStore.getReadCount();
                    boolean bl2 = this.autoCompactLastFileOpCount != l3;
                    int n2 = bl2 ? this.autoCompactFillRate / 3 : this.autoCompactFillRate;
                    this.compact(n2, this.autoCommitMemory);
                    this.autoCompactLastFileOpCount = this.fileStore.getWriteCount() + this.fileStore.getReadCount();
                }
                catch (Exception exception) {
                    if (this.backgroundExceptionHandler == null) break block9;
                    this.backgroundExceptionHandler.uncaughtException(null, exception);
                }
            }
        }
    }

    public void setCacheSize(int n2) {
        if (this.cache != null) {
            this.cache.setMaxMemory((long)n2 * 1024L * 1024L);
            this.cache.clear();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBackgroundThread() {
        BackgroundWriterThread backgroundWriterThread = this.backgroundWriterThread;
        if (backgroundWriterThread == null) {
            return;
        }
        this.backgroundWriterThread = null;
        if (Thread.currentThread() == backgroundWriterThread) {
            return;
        }
        Object object = backgroundWriterThread.sync;
        synchronized (object) {
            backgroundWriterThread.sync.notifyAll();
        }
        if (Thread.holdsLock(this)) {
            return;
        }
        try {
            backgroundWriterThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAutoCommitDelay(int n2) {
        if (this.autoCommitDelay == n2) {
            return;
        }
        this.autoCommitDelay = n2;
        if (this.fileStore == null || this.fileStore.isReadOnly()) {
            return;
        }
        this.stopBackgroundThread();
        if (n2 > 0) {
            int n3 = Math.max(1, n2 / 10);
            BackgroundWriterThread backgroundWriterThread = new BackgroundWriterThread(this, n3, this.fileStore.toString());
            backgroundWriterThread.start();
            this.backgroundWriterThread = backgroundWriterThread;
        }
    }

    public int getAutoCommitDelay() {
        return this.autoCommitDelay;
    }

    public int getAutoCommitMemory() {
        return this.autoCommitMemory;
    }

    public int getUnsavedMemory() {
        return this.unsavedMemory;
    }

    void cachePage(long l2, Page page, int n2) {
        if (this.cache != null) {
            this.cache.put(l2, page, n2);
        }
    }

    public int getCacheSizeUsed() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getUsedMemory() / 1024L / 1024L);
    }

    public int getCacheSize() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getMaxMemory() / 1024L / 1024L);
    }

    public CacheLongKeyLIRS<Page> getCache() {
        return this.cache;
    }

    public static class Builder {
        private final HashMap<String, Object> config = New.hashMap();

        private Builder set(String string, Object object) {
            this.config.put(string, object);
            return this;
        }

        public Builder autoCommitDisabled() {
            this.set("autoCommitBufferSize", 0);
            return this.set("autoCommitDelay", 0);
        }

        public Builder autoCommitBufferSize(int n2) {
            return this.set("autoCommitBufferSize", n2);
        }

        public Builder autoCompactFillRate(int n2) {
            return this.set("autoCompactFillRate", n2);
        }

        public Builder fileName(String string) {
            return this.set("fileName", string);
        }

        public Builder encryptionKey(char[] cArray) {
            return this.set("encryptionKey", cArray);
        }

        public Builder readOnly() {
            return this.set("readOnly", 1);
        }

        public Builder cacheSize(int n2) {
            return this.set("cacheSize", n2);
        }

        public Builder compress() {
            return this.set("compress", 1);
        }

        public Builder compressHigh() {
            return this.set("compress", 2);
        }

        public Builder pageSplitSize(int n2) {
            return this.set("pageSplitSize", n2);
        }

        public Builder backgroundExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            return this.set("backgroundExceptionHandler", uncaughtExceptionHandler);
        }

        public Builder fileStore(FileStore fileStore) {
            return this.set("fileStore", fileStore);
        }

        public MVStore open() {
            return new MVStore(this.config);
        }

        public String toString() {
            return DataUtils.appendMap(new StringBuilder(), this.config).toString();
        }

        public static Builder fromString(String string) {
            HashMap<String, String> hashMap = DataUtils.parseMap(string);
            Builder builder = new Builder();
            builder.config.putAll(hashMap);
            return builder;
        }
    }

    private static class BackgroundWriterThread
    extends Thread {
        public final Object sync = new Object();
        private final MVStore store;
        private final int sleep;

        BackgroundWriterThread(MVStore mVStore, int n2, String string) {
            super("MVStore background writer " + string);
            this.store = mVStore;
            this.sleep = n2;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BackgroundWriterThread backgroundWriterThread;
            while ((backgroundWriterThread = this.store.backgroundWriterThread) != null) {
                Object object = this.sync;
                synchronized (object) {
                    try {
                        this.sync.wait(this.sleep);
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                }
                this.store.writeInBackground();
            }
        }
    }
}

