/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.util.BitSet;
import org.h2.util.MathUtils;

public class FreeSpaceBitSet {
    private static final boolean DETAILED_INFO = false;
    private final int firstFreeBlock;
    private final int blockSize;
    private final BitSet set = new BitSet();

    public FreeSpaceBitSet(int n2, int n3) {
        this.firstFreeBlock = n2;
        this.blockSize = n3;
        this.clear();
    }

    public void clear() {
        this.set.clear();
        this.set.set(0, this.firstFreeBlock);
    }

    public boolean isUsed(long l2, int n2) {
        int n3 = this.getBlock(l2);
        int n4 = this.getBlockCount(n2);
        for (int i2 = n3; i2 < n3 + n4; ++i2) {
            if (this.set.get(i2)) continue;
            return false;
        }
        return true;
    }

    public boolean isFree(long l2, int n2) {
        int n3 = this.getBlock(l2);
        int n4 = this.getBlockCount(n2);
        for (int i2 = n3; i2 < n3 + n4; ++i2) {
            if (!this.set.get(i2)) continue;
            return false;
        }
        return true;
    }

    public long allocate(int n2) {
        int n3 = this.getBlockCount(n2);
        int n4 = 0;
        while (true) {
            int n5;
            int n6;
            if ((n6 = this.set.nextSetBit((n5 = this.set.nextClearBit(n4)) + 1)) < 0 || n6 - n5 >= n3) {
                this.set.set(n5, n5 + n3);
                return this.getPos(n5);
            }
            n4 = n6;
        }
    }

    public void markUsed(long l2, int n2) {
        int n3 = this.getBlock(l2);
        int n4 = this.getBlockCount(n2);
        this.set.set(n3, n3 + n4);
    }

    public void free(long l2, int n2) {
        int n3 = this.getBlock(l2);
        int n4 = this.getBlockCount(n2);
        this.set.clear(n3, n3 + n4);
    }

    private long getPos(int n2) {
        return (long)n2 * (long)this.blockSize;
    }

    private int getBlock(long l2) {
        return (int)(l2 / (long)this.blockSize);
    }

    private int getBlockCount(int n2) {
        return MathUtils.roundUpInt(n2, this.blockSize) / this.blockSize;
    }

    public int getFillRate() {
        int n2 = this.set.length();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.set.get(i2)) continue;
            ++n3;
        }
        if (n3 == 0) {
            return 0;
        }
        return Math.max(1, (int)(100L * (long)n3 / (long)n2));
    }

    public long getFirstFree() {
        return this.getPos(this.set.nextClearBit(0));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            int n3 = this.set.nextClearBit(n2);
            stringBuilder.append(Integer.toHexString(n3)).append('-');
            int n4 = this.set.nextSetBit(n3 + 1);
            if (n4 < 0) break;
            stringBuilder.append(Integer.toHexString(n4 - 1));
            n2 = n4 + 1;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

