/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FreeSpaceBitSet;
import org.h2.mvstore.cache.FilePathCache;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FilePathDisk;
import org.h2.store.fs.FilePathEncrypt;
import org.h2.store.fs.FilePathNio;

public class FileStore {
    protected long readCount;
    protected long readBytes;
    protected long writeCount;
    protected long writeBytes;
    protected final FreeSpaceBitSet freeSpace = new FreeSpaceBitSet(2, 4096);
    protected String fileName;
    protected boolean readOnly;
    protected long fileSize;
    protected FileChannel file;
    protected FileChannel encryptedFile;
    protected FileLock fileLock;

    public String toString() {
        return this.fileName;
    }

    public ByteBuffer readFully(long l2, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        DataUtils.readFully(this.file, l2, byteBuffer);
        ++this.readCount;
        this.readBytes += (long)n2;
        return byteBuffer;
    }

    public void writeFully(long l2, ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.fileSize = Math.max(this.fileSize, l2 + (long)n2);
        DataUtils.writeFully(this.file, l2, byteBuffer);
        ++this.writeCount;
        this.writeBytes += (long)n2;
    }

    public void open(String string, boolean bl2, char[] cArray) {
        FilePath filePath;
        if (this.file != null) {
            return;
        }
        if (string != null && (filePath = FilePath.get(string)) instanceof FilePathDisk && !string.startsWith(filePath.getScheme() + ":")) {
            FilePathNio.class.getName();
            string = "nio:" + string;
        }
        this.fileName = string;
        filePath = FilePath.get(string);
        FilePath filePath2 = filePath.getParent();
        if (filePath2 != null && !filePath2.exists()) {
            throw DataUtils.newIllegalArgumentException("Directory does not exist: {0}", filePath2);
        }
        if (filePath.exists() && !filePath.canWrite()) {
            bl2 = true;
        }
        this.readOnly = bl2;
        try {
            this.file = filePath.open(bl2 ? "r" : "rw");
            if (cArray != null) {
                byte[] byArray = FilePathEncrypt.getPasswordBytes(cArray);
                this.encryptedFile = this.file;
                this.file = new FilePathEncrypt.FileEncrypt(string, byArray, this.file);
            }
            this.file = FilePathCache.wrap(this.file);
            try {
                this.fileLock = bl2 ? this.file.tryLock(0L, Long.MAX_VALUE, true) : this.file.tryLock();
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                throw DataUtils.newIllegalStateException(7, "The file is locked: {0}", string, overlappingFileLockException);
            }
            if (this.fileLock == null) {
                throw DataUtils.newIllegalStateException(7, "The file is locked: {0}", string);
            }
            this.fileSize = this.file.size();
        }
        catch (IOException iOException) {
            throw DataUtils.newIllegalStateException(1, "Could not open file {0}", string, iOException);
        }
    }

    public void close() {
        try {
            if (this.fileLock != null) {
                this.fileLock.release();
                this.fileLock = null;
            }
            this.file.close();
            this.freeSpace.clear();
        }
        catch (Exception exception) {
            throw DataUtils.newIllegalStateException(2, "Closing failed for file {0}", this.fileName, exception);
        }
        finally {
            this.file = null;
        }
    }

    public void sync() {
        try {
            this.file.force(true);
        }
        catch (IOException iOException) {
            throw DataUtils.newIllegalStateException(2, "Could not sync file {0}", this.fileName, iOException);
        }
    }

    public long size() {
        return this.fileSize;
    }

    public void truncate(long l2) {
        try {
            ++this.writeCount;
            this.file.truncate(l2);
            this.fileSize = Math.min(this.fileSize, l2);
        }
        catch (IOException iOException) {
            throw DataUtils.newIllegalStateException(2, "Could not truncate file {0} to size {1}", this.fileName, l2, iOException);
        }
    }

    public FileChannel getFile() {
        return this.file;
    }

    public FileChannel getEncryptedFile() {
        return this.encryptedFile;
    }

    public long getWriteCount() {
        return this.writeCount;
    }

    public long getWriteBytes() {
        return this.writeBytes;
    }

    public long getReadCount() {
        return this.readCount;
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getDefaultRetentionTime() {
        return 45000;
    }

    public void markUsed(long l2, int n2) {
        this.freeSpace.markUsed(l2, n2);
    }

    public long allocate(int n2) {
        return this.freeSpace.allocate(n2);
    }

    public void free(long l2, int n2) {
        this.freeSpace.free(l2, n2);
    }

    public int getFillRate() {
        return this.freeSpace.getFillRate();
    }

    long getFirstFree() {
        return this.freeSpace.getFirstFree();
    }

    public void clear() {
        this.freeSpace.clear();
    }

    public String getFileName() {
        return this.fileName;
    }
}

