/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import org.h2.util.New;

public class DataUtils {
    public static final int ERROR_READING_FAILED = 1;
    public static final int ERROR_WRITING_FAILED = 2;
    public static final int ERROR_INTERNAL = 3;
    public static final int ERROR_CLOSED = 4;
    public static final int ERROR_UNSUPPORTED_FORMAT = 5;
    public static final int ERROR_FILE_CORRUPT = 6;
    public static final int ERROR_FILE_LOCKED = 7;
    public static final int ERROR_SERIALIZATION = 8;
    public static final int ERROR_CHUNK_NOT_FOUND = 9;
    public static final int ERROR_BLOCK_NOT_FOUND = 50;
    public static final int ERROR_TRANSACTION_CORRUPT = 100;
    public static final int ERROR_TRANSACTION_LOCKED = 101;
    public static final int ERROR_TOO_MANY_OPEN_TRANSACTIONS = 102;
    public static final int ERROR_TRANSACTION_ILLEGAL_STATE = 103;
    public static final int PAGE_TYPE_LEAF = 0;
    public static final int PAGE_TYPE_NODE = 1;
    public static final int PAGE_COMPRESSED = 2;
    public static final int PAGE_COMPRESSED_HIGH = 6;
    public static final int MAX_VAR_INT_LEN = 5;
    public static final int MAX_VAR_LONG_LEN = 10;
    public static final int COMPRESSED_VAR_INT_MAX = 0x1FFFFF;
    public static final long COMPRESSED_VAR_LONG_MAX = 0x1FFFFFFFFFFFFL;
    public static final int PAGE_MEMORY = 128;
    public static final int PAGE_MEMORY_CHILD = 16;
    public static final int PAGE_LARGE = 0x200000;
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final Charset LATIN = Charset.forName("ISO-8859-1");
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int MAX_GROW = 0x1000000;

    public static int getVarIntLen(int n2) {
        if ((n2 & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n2 & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n2 & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n2 & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int getVarLongLen(long l2) {
        int n2 = 1;
        while ((l2 >>>= 7) != 0L) {
            ++n2;
        }
        return n2;
    }

    public static int readVarInt(ByteBuffer byteBuffer) {
        byte by2 = byteBuffer.get();
        if (by2 >= 0) {
            return by2;
        }
        return DataUtils.readVarIntRest(byteBuffer, by2);
    }

    private static int readVarIntRest(ByteBuffer byteBuffer, int n2) {
        int n3 = n2 & 0x7F;
        n2 = byteBuffer.get();
        if (n2 >= 0) {
            return n3 | n2 << 7;
        }
        n3 |= (n2 & 0x7F) << 7;
        n2 = byteBuffer.get();
        if (n2 >= 0) {
            return n3 | n2 << 14;
        }
        n3 |= (n2 & 0x7F) << 14;
        n2 = byteBuffer.get();
        if (n2 >= 0) {
            return n3 | n2 << 21;
        }
        return n3 |= (n2 & 0x7F) << 21 | byteBuffer.get() << 28;
    }

    public static long readVarLong(ByteBuffer byteBuffer) {
        long l2 = byteBuffer.get();
        if (l2 >= 0L) {
            return l2;
        }
        l2 &= 0x7FL;
        for (int i2 = 7; i2 < 64; i2 += 7) {
            long l3 = byteBuffer.get();
            l2 |= (l3 & 0x7FL) << i2;
            if (l3 >= 0L) break;
        }
        return l2;
    }

    public static void writeVarInt(OutputStream outputStream, int n2) throws IOException {
        while ((n2 & 0xFFFFFF80) != 0) {
            outputStream.write((byte)(0x80 | n2 & 0x7F));
            n2 >>>= 7;
        }
        outputStream.write((byte)n2);
    }

    public static void writeVarInt(ByteBuffer byteBuffer, int n2) {
        while ((n2 & 0xFFFFFF80) != 0) {
            byteBuffer.put((byte)(0x80 | n2 & 0x7F));
            n2 >>>= 7;
        }
        byteBuffer.put((byte)n2);
    }

    public static ByteBuffer writeStringData(ByteBuffer byteBuffer, String string, int n2) {
        byteBuffer = DataUtils.ensureCapacity(byteBuffer, 3 * n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '\u0080') {
                byteBuffer.put((byte)c2);
                continue;
            }
            if (c2 >= '\u0800') {
                byteBuffer.put((byte)(0xE0 | c2 >> 12));
                byteBuffer.put((byte)(c2 >> 6 & 0x3F));
                byteBuffer.put((byte)(c2 & 0x3F));
                continue;
            }
            byteBuffer.put((byte)(0xC0 | c2 >> 6));
            byteBuffer.put((byte)(c2 & 0x3F));
        }
        return byteBuffer;
    }

    public static String readString(ByteBuffer byteBuffer, int n2) {
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byteBuffer.get() & 0xFF;
            cArray[i2] = n3 < 128 ? (char)n3 : (n3 >= 224 ? (char)(((n3 & 0xF) << 12) + ((byteBuffer.get() & 0x3F) << 6) + (byteBuffer.get() & 0x3F)) : (char)(((n3 & 0x1F) << 6) + (byteBuffer.get() & 0x3F)));
        }
        return new String(cArray);
    }

    public static void writeVarLong(ByteBuffer byteBuffer, long l2) {
        while ((l2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            byteBuffer.put((byte)(0x80L | l2 & 0x7FL));
            l2 >>>= 7;
        }
        byteBuffer.put((byte)l2);
    }

    public static void writeVarLong(OutputStream outputStream, long l2) throws IOException {
        while ((l2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            outputStream.write((byte)(0x80L | l2 & 0x7FL));
            l2 >>>= 7;
        }
        outputStream.write((byte)l2);
    }

    public static void copyWithGap(Object object, Object object2, int n2, int n3) {
        if (n3 > 0) {
            System.arraycopy(object, 0, object2, 0, n3);
        }
        if (n3 < n2) {
            System.arraycopy(object, n3, object2, n3 + 1, n2 - n3);
        }
    }

    public static void copyExcept(Object object, Object object2, int n2, int n3) {
        if (n3 > 0 && n2 > 0) {
            System.arraycopy(object, 0, object2, 0, n3);
        }
        if (n3 < n2) {
            System.arraycopy(object, n3 + 1, object2, n3, n2 - n3 - 1);
        }
    }

    public static void readFully(FileChannel fileChannel, long l2, ByteBuffer byteBuffer) {
        try {
            do {
                int n2;
                if ((n2 = fileChannel.read(byteBuffer, l2)) < 0) {
                    throw new EOFException();
                }
                l2 += (long)n2;
            } while (byteBuffer.remaining() > 0);
            byteBuffer.rewind();
        }
        catch (IOException iOException) {
            long l3;
            try {
                l3 = fileChannel.size();
            }
            catch (IOException iOException2) {
                l3 = -1L;
            }
            throw DataUtils.newIllegalStateException(1, "Reading from {0} failed; file length {1} read length {2} at {3}", fileChannel, l3, byteBuffer.remaining(), l2, iOException);
        }
    }

    public static void writeFully(FileChannel fileChannel, long l2, ByteBuffer byteBuffer) {
        try {
            int n2 = 0;
            do {
                int n3 = fileChannel.write(byteBuffer, l2 + (long)n2);
                n2 += n3;
            } while (byteBuffer.remaining() > 0);
        }
        catch (IOException iOException) {
            throw DataUtils.newIllegalStateException(2, "Writing to {0} failed; length {1} at {2}", fileChannel, byteBuffer.remaining(), l2, iOException);
        }
    }

    public static int encodeLength(int n2) {
        if (n2 <= 32) {
            return 0;
        }
        int n3 = Integer.numberOfLeadingZeros(n2);
        int n4 = n2 << n3 + 1;
        n3 += n3;
        if ((n4 & Integer.MIN_VALUE) != 0) {
            --n3;
        }
        if (n4 << 1 != 0) {
            --n3;
        }
        n3 = Math.min(31, 52 - n3);
        return n3;
    }

    public static int getPageChunkId(long l2) {
        return (int)(l2 >>> 38);
    }

    public static int getPageMaxLength(long l2) {
        int n2 = (int)(l2 >> 1 & 0x1FL);
        if (n2 == 31) {
            return 0x200000;
        }
        return 2 + (n2 & 1) << (n2 >> 1) + 4;
    }

    public static int getPageOffset(long l2) {
        return (int)(l2 >> 6);
    }

    public static int getPageType(long l2) {
        return (int)l2 & 1;
    }

    public static long getPagePos(int n2, int n3, int n4, int n5) {
        long l2 = (long)n2 << 38;
        l2 |= (long)n3 << 6;
        l2 |= (long)(DataUtils.encodeLength(n4) << 1);
        return l2 |= (long)n5;
    }

    public static short getCheckValue(int n2) {
        return (short)(n2 >> 16 ^ n2);
    }

    public static StringBuilder appendMap(StringBuilder stringBuilder, HashMap<String, ?> hashMap) {
        ArrayList<String> arrayList = New.arrayList(hashMap.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            DataUtils.appendMap(stringBuilder, string, hashMap.get(string));
        }
        return stringBuilder;
    }

    public static void appendMap(StringBuilder stringBuilder, String string, Object object) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append(',');
        }
        stringBuilder.append(string).append(':');
        String string2 = object instanceof Long ? Long.toHexString((Long)object) : (object instanceof Integer ? Integer.toHexString((Integer)object) : object.toString());
        if (string2.indexOf(44) < 0 && string2.indexOf(34) < 0) {
            stringBuilder.append(string2);
        } else {
            stringBuilder.append('\"');
            int n2 = string2.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string2.charAt(i2);
                if (c2 == '\"') {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c2);
            }
            stringBuilder.append('\"');
        }
    }

    public static HashMap<String, String> parseMap(String string) {
        HashMap<String, String> hashMap = New.hashMap();
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c2;
            int n4 = n2;
            if ((n2 = string.indexOf(58, n2)) < 0) {
                throw DataUtils.newIllegalStateException(6, "Not a map: {0}", string);
            }
            String string2 = string.substring(n4, n2++);
            StringBuilder stringBuilder = new StringBuilder();
            block1: while (n2 < n3 && (c2 = string.charAt(n2++)) != ',') {
                if (c2 == '\"') {
                    while (n2 < n3) {
                        if ((c2 = string.charAt(n2++)) == '\\') {
                            if (n2 == n3) {
                                throw DataUtils.newIllegalStateException(6, "Not a map: {0}", string);
                            }
                            c2 = string.charAt(n2++);
                        } else if (c2 == '\"') continue block1;
                        stringBuilder.append(c2);
                    }
                    continue;
                }
                stringBuilder.append(c2);
            }
            hashMap.put(string2, stringBuilder.toString());
        }
        return hashMap;
    }

    public static int getFletcher32(byte[] byArray, int n2) {
        int n3;
        int n4 = 65535;
        int n5 = 65535;
        int n6 = 0;
        int n7 = n2 / 2 * 2;
        while (n6 < n7) {
            n3 = Math.min(n6 + 720, n7);
            while (n6 < n3) {
                int n8 = (byArray[n6++] & 0xFF) << 8 | byArray[n6++] & 0xFF;
                n5 += (n4 += n8);
            }
            n4 = (n4 & 0xFFFF) + (n4 >>> 16);
            n5 = (n5 & 0xFFFF) + (n5 >>> 16);
        }
        if (n6 < n2) {
            n3 = (byArray[n6] & 0xFF) << 8;
            n5 += (n4 += n3);
        }
        n4 = (n4 & 0xFFFF) + (n4 >>> 16);
        n5 = (n5 & 0xFFFF) + (n5 >>> 16);
        return n5 << 16 | n4;
    }

    public static void checkArgument(boolean bl2, String string, Object ... objectArray) {
        if (!bl2) {
            throw DataUtils.newIllegalArgumentException(string, objectArray);
        }
    }

    public static IllegalArgumentException newIllegalArgumentException(String string, Object ... objectArray) {
        return DataUtils.initCause(new IllegalArgumentException(DataUtils.formatMessage(0, string, objectArray)), objectArray);
    }

    public static UnsupportedOperationException newUnsupportedOperationException(String string) {
        return new UnsupportedOperationException(DataUtils.formatMessage(0, string, new Object[0]));
    }

    public static ConcurrentModificationException newConcurrentModificationException(String string) {
        return new ConcurrentModificationException(DataUtils.formatMessage(0, string, new Object[0]));
    }

    public static IllegalStateException newIllegalStateException(int n2, String string, Object ... objectArray) {
        return DataUtils.initCause(new IllegalStateException(DataUtils.formatMessage(n2, string, objectArray)), objectArray);
    }

    private static <T extends Exception> T initCause(T t2, Object ... objectArray) {
        Object object;
        int n2 = objectArray.length;
        if (n2 > 0 && (object = objectArray[n2 - 1]) instanceof Exception) {
            t2.initCause((Exception)object);
        }
        return t2;
    }

    public static String formatMessage(int n2, String string, Object ... objectArray) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            String string2;
            Object object = objectArray[i2];
            if (object instanceof Exception) continue;
            String string3 = string2 = object == null ? "null" : object.toString();
            if (string2.length() > 1000) {
                string2 = string2.substring(0, 1000) + "...";
            }
            objectArray[i2] = string2;
        }
        return MessageFormat.format(string, objectArray) + " [" + 1 + "." + 4 + "." + 192 + "/" + n2 + "]";
    }

    public static int getErrorCode(String string) {
        int n2;
        if (string != null && string.endsWith("]") && (n2 = string.lastIndexOf(47)) >= 0) {
            String string2 = string.substring(n2 + 1, string.length() - 1);
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static byte[] newBytes(int n2) {
        if (n2 == 0) {
            return EMPTY_BYTES;
        }
        try {
            return new byte[n2];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            OutOfMemoryError outOfMemoryError2 = new OutOfMemoryError("Requested memory: " + n2);
            outOfMemoryError2.initCause(outOfMemoryError);
            throw outOfMemoryError2;
        }
    }

    public static ByteBuffer ensureCapacity(ByteBuffer byteBuffer, int n2) {
        if (byteBuffer.remaining() > (n2 += 1024)) {
            return byteBuffer;
        }
        return DataUtils.grow(byteBuffer, n2);
    }

    private static ByteBuffer grow(ByteBuffer byteBuffer, int n2) {
        n2 = byteBuffer.remaining() + n2;
        int n3 = byteBuffer.capacity();
        n2 = Math.max(n2, Math.min(n3 + 0x1000000, n3 * 2));
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2);
        byteBuffer.flip();
        byteBuffer2.put(byteBuffer);
        return byteBuffer2;
    }

    public static long readHexLong(Map<String, ? extends Object> map, String string, long l2) {
        Object object = map.get(string);
        if (object == null) {
            return l2;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        try {
            return DataUtils.parseHexLong((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            throw DataUtils.newIllegalStateException(6, "Error parsing the value {0}", object, numberFormatException);
        }
    }

    public static long parseHexLong(String string) {
        try {
            if (string.length() == 16) {
                return Long.parseLong(string.substring(0, 8), 16) << 32 | Long.parseLong(string.substring(8, 16), 16);
            }
            return Long.parseLong(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw DataUtils.newIllegalStateException(6, "Error parsing the value {0}", string, numberFormatException);
        }
    }

    public static int parseHexInt(String string) {
        try {
            return (int)Long.parseLong(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw DataUtils.newIllegalStateException(6, "Error parsing the value {0}", string, numberFormatException);
        }
    }

    public static int readHexInt(HashMap<String, ? extends Object> hashMap, String string, int n2) {
        Object object = hashMap.get(string);
        if (object == null) {
            return n2;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        try {
            return (int)Long.parseLong((String)object, 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw DataUtils.newIllegalStateException(6, "Error parsing the value {0}", object, numberFormatException);
        }
    }

    public static class MapEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public MapEntry(K k2, V v2) {
            this.key = k2;
            this.value = v2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v2) {
            throw DataUtils.newUnsupportedOperationException("Updating the value is not supported");
        }
    }
}

