/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.util.Iterator;
import org.h2.mvstore.CursorPos;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.Page;

public class Cursor<K, V>
implements Iterator<K> {
    private final MVMap<K, ?> map;
    private final K from;
    private CursorPos pos;
    private K current;
    private K last;
    private V currentValue;
    private V lastValue;
    private Page lastPage;
    private final Page root;
    private boolean initialized;

    Cursor(MVMap<K, ?> mVMap, Page page, K k2) {
        this.map = mVMap;
        this.root = page;
        this.from = k2;
    }

    @Override
    public boolean hasNext() {
        if (!this.initialized) {
            this.min(this.root, this.from);
            this.initialized = true;
            this.fetchNext();
        }
        return this.current != null;
    }

    @Override
    public K next() {
        this.hasNext();
        K k2 = this.current;
        this.last = this.current;
        this.lastValue = this.currentValue;
        this.lastPage = this.pos == null ? null : this.pos.page;
        this.fetchNext();
        return k2;
    }

    public K getKey() {
        return this.last;
    }

    public V getValue() {
        return this.lastValue;
    }

    Page getPage() {
        return this.lastPage;
    }

    public void skip(long l2) {
        if (!this.hasNext()) {
            return;
        }
        if (l2 < 10L) {
            while (l2-- > 0L) {
                this.fetchNext();
            }
            return;
        }
        long l3 = this.map.getKeyIndex(this.current);
        K k2 = this.map.getKey(l3 + l2);
        this.pos = null;
        this.min(this.root, k2);
        this.fetchNext();
    }

    @Override
    public void remove() {
        throw DataUtils.newUnsupportedOperationException("Removing is not supported");
    }

    private void min(Page page, K k2) {
        int n2;
        while (true) {
            if (page.isLeaf()) {
                int n3 = n2 = k2 == null ? 0 : page.binarySearch(k2);
                if (n2 < 0) {
                    n2 = -n2 - 1;
                }
                break;
            }
            int n4 = n2 = k2 == null ? -1 : page.binarySearch(k2);
            n2 = n2 < 0 ? -n2 - 1 : ++n2;
            this.pos = new CursorPos(page, n2 + 1, this.pos);
            page = page.getChildPage(n2);
        }
        this.pos = new CursorPos(page, n2, this.pos);
    }

    private void fetchNext() {
        while (this.pos != null) {
            if (this.pos.index < this.pos.page.getKeyCount()) {
                int n2 = this.pos.index++;
                this.current = this.pos.page.getKey(n2);
                this.currentValue = this.pos.page.getValue(n2);
                return;
            }
            this.pos = this.pos.parent;
            if (this.pos == null) break;
            if (this.pos.index >= this.map.getChildPageCount(this.pos.page)) continue;
            this.min(this.pos.page.getChildPage(this.pos.index++), null);
        }
        this.current = null;
    }
}

