/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.util.Arrays;
import java.util.Iterator;
import org.h2.mvstore.DataUtils;

public class ConcurrentArrayList<K> {
    K[] array = new Object[0];

    public K peekFirst() {
        K[] KArray = this.array;
        return KArray.length == 0 ? null : (K)KArray[0];
    }

    public K peekLast() {
        K[] KArray = this.array;
        int n2 = KArray.length;
        return n2 == 0 ? null : (K)KArray[n2 - 1];
    }

    public synchronized void add(K k2) {
        int n2 = this.array.length;
        this.array = Arrays.copyOf(this.array, n2 + 1);
        this.array[n2] = k2;
    }

    public synchronized boolean removeFirst(K k2) {
        if (this.peekFirst() != k2) {
            return false;
        }
        int n2 = this.array.length;
        Object[] objectArray = new Object[n2 - 1];
        System.arraycopy(this.array, 1, objectArray, 0, n2 - 1);
        this.array = objectArray;
        return true;
    }

    public synchronized boolean removeLast(K k2) {
        if (this.peekLast() != k2) {
            return false;
        }
        this.array = Arrays.copyOf(this.array, this.array.length - 1);
        return true;
    }

    public Iterator<K> iterator() {
        return new Iterator<K>(){
            K[] a;
            int index;
            {
                this.a = ConcurrentArrayList.this.array;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.a.length;
            }

            @Override
            public K next() {
                return this.a[this.index++];
            }

            @Override
            public void remove() {
                throw DataUtils.newUnsupportedOperationException("remove");
            }
        };
    }
}

