/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.h2.engine.SysProperties;
import org.h2.expression.ParameterInterface;
import org.h2.message.TraceWriter;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;

public class Trace {
    public static final int COMMAND = 0;
    public static final int CONSTRAINT = 1;
    public static final int DATABASE = 2;
    public static final int FUNCTION = 3;
    public static final int FILE_LOCK = 4;
    public static final int INDEX = 5;
    public static final int JDBC = 6;
    public static final int LOCK = 7;
    public static final int SCHEMA = 8;
    public static final int SEQUENCE = 9;
    public static final int SETTING = 10;
    public static final int TABLE = 11;
    public static final int TRIGGER = 12;
    public static final int USER = 13;
    public static final int PAGE_STORE = 14;
    public static final int JDBCX = 15;
    public static final String[] MODULE_NAMES = new String[]{"command", "constraint", "database", "function", "fileLock", "index", "jdbc", "lock", "schema", "sequence", "setting", "table", "trigger", "user", "pageStore", "JDBCX"};
    private final TraceWriter traceWriter;
    private final String module;
    private final String lineSeparator;
    private int traceLevel = -1;

    Trace(TraceWriter traceWriter, int n2) {
        this(traceWriter, MODULE_NAMES[n2]);
    }

    Trace(TraceWriter traceWriter, String string) {
        this.traceWriter = traceWriter;
        this.module = string;
        this.lineSeparator = SysProperties.LINE_SEPARATOR;
    }

    public void setLevel(int n2) {
        this.traceLevel = n2;
    }

    private boolean isEnabled(int n2) {
        if (this.traceLevel == -1) {
            return this.traceWriter.isEnabled(n2);
        }
        return n2 <= this.traceLevel;
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(2);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(3);
    }

    public void error(Throwable throwable, String string) {
        if (this.isEnabled(1)) {
            this.traceWriter.write(1, this.module, string, throwable);
        }
    }

    public void error(Throwable throwable, String string, Object ... objectArray) {
        if (this.isEnabled(1)) {
            string = MessageFormat.format(string, objectArray);
            this.traceWriter.write(1, this.module, string, throwable);
        }
    }

    public void info(String string) {
        if (this.isEnabled(2)) {
            this.traceWriter.write(2, this.module, string, null);
        }
    }

    public void info(String string, Object ... objectArray) {
        if (this.isEnabled(2)) {
            string = MessageFormat.format(string, objectArray);
            this.traceWriter.write(2, this.module, string, null);
        }
    }

    void info(Throwable throwable, String string) {
        if (this.isEnabled(2)) {
            this.traceWriter.write(2, this.module, string, throwable);
        }
    }

    public static String formatParams(ArrayList<? extends ParameterInterface> arrayList) {
        if (arrayList.size() == 0) {
            return "";
        }
        StatementBuilder statementBuilder = new StatementBuilder();
        int n2 = 0;
        boolean bl2 = false;
        for (ParameterInterface parameterInterface : arrayList) {
            if (!parameterInterface.isValueSet()) continue;
            if (!bl2) {
                statementBuilder.append(" {");
                bl2 = true;
            }
            statementBuilder.appendExceptFirst(", ");
            Value value = parameterInterface.getParamValue();
            statementBuilder.append(++n2).append(": ").append(value.getTraceSQL());
        }
        if (bl2) {
            statementBuilder.append('}');
        }
        return statementBuilder.toString();
    }

    public void infoSQL(String string, String string2, int n2, long l2) {
        if (!this.isEnabled(2)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + 20);
        stringBuilder.append(this.lineSeparator).append("/*SQL");
        boolean bl2 = false;
        if (string2.length() > 0) {
            bl2 = true;
            stringBuilder.append(" l:").append(string.length());
        }
        if (n2 > 0) {
            bl2 = true;
            stringBuilder.append(" #:").append(n2);
        }
        if (l2 > 0L) {
            bl2 = true;
            stringBuilder.append(" t:").append(l2);
        }
        if (!bl2) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("*/").append(StringUtils.javaEncode(string)).append(StringUtils.javaEncode(string2)).append(';');
        string = stringBuilder.toString();
        this.traceWriter.write(2, this.module, string, null);
    }

    public void debug(String string, Object ... objectArray) {
        if (this.isEnabled(3)) {
            string = MessageFormat.format(string, objectArray);
            this.traceWriter.write(3, this.module, string, null);
        }
    }

    public void debug(String string) {
        if (this.isEnabled(3)) {
            this.traceWriter.write(3, this.module, string, null);
        }
    }

    public void debug(Throwable throwable, String string) {
        if (this.isEnabled(3)) {
            this.traceWriter.write(3, this.module, string, throwable);
        }
    }

    public void infoCode(String string) {
        if (this.isEnabled(2)) {
            this.traceWriter.write(2, this.module, this.lineSeparator + "/**/" + string, null);
        }
    }

    void debugCode(String string) {
        if (this.isEnabled(3)) {
            this.traceWriter.write(3, this.module, this.lineSeparator + "/**/" + string, null);
        }
    }
}

