/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcResultSet;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.util.MathUtils;
import org.h2.value.DataType;

public class JdbcResultSetMetaData
extends TraceObject
implements ResultSetMetaData {
    private final String catalog;
    private final JdbcResultSet rs;
    private final JdbcPreparedStatement prep;
    private final ResultInterface result;
    private final int columnCount;

    JdbcResultSetMetaData(JdbcResultSet jdbcResultSet, JdbcPreparedStatement jdbcPreparedStatement, ResultInterface resultInterface, String string, Trace trace, int n2) {
        this.setTrace(trace, 5, n2);
        this.catalog = string;
        this.rs = jdbcResultSet;
        this.prep = jdbcPreparedStatement;
        this.result = resultInterface;
        this.columnCount = resultInterface.getVisibleColumnCount();
    }

    @Override
    public int getColumnCount() throws SQLException {
        try {
            this.debugCodeCall("getColumnCount");
            this.checkClosed();
            return this.columnCount;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getColumnLabel(int n2) throws SQLException {
        try {
            this.debugCodeCall("getColumnLabel", n2);
            this.checkColumnIndex(n2);
            return this.result.getAlias(--n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getColumnName(int n2) throws SQLException {
        try {
            this.debugCodeCall("getColumnName", n2);
            this.checkColumnIndex(n2);
            return this.result.getColumnName(--n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getColumnType(int n2) throws SQLException {
        try {
            this.debugCodeCall("getColumnType", n2);
            this.checkColumnIndex(n2);
            int n3 = this.result.getColumnType(--n2);
            return DataType.convertTypeToSQLType(n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getColumnTypeName(int n2) throws SQLException {
        try {
            this.debugCodeCall("getColumnTypeName", n2);
            this.checkColumnIndex(n2);
            int n3 = this.result.getColumnType(--n2);
            return DataType.getDataType((int)n3).name;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getSchemaName(int n2) throws SQLException {
        try {
            this.debugCodeCall("getSchemaName", n2);
            this.checkColumnIndex(n2);
            String string = this.result.getSchemaName(--n2);
            return string == null ? "" : string;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getTableName(int n2) throws SQLException {
        try {
            this.debugCodeCall("getTableName", n2);
            this.checkColumnIndex(n2);
            String string = this.result.getTableName(--n2);
            return string == null ? "" : string;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getCatalogName(int n2) throws SQLException {
        try {
            this.debugCodeCall("getCatalogName", n2);
            this.checkColumnIndex(n2);
            return this.catalog == null ? "" : this.catalog;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isAutoIncrement(int n2) throws SQLException {
        try {
            this.debugCodeCall("isAutoIncrement", n2);
            this.checkColumnIndex(n2);
            return this.result.isAutoIncrement(--n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isCaseSensitive(int n2) throws SQLException {
        try {
            this.debugCodeCall("isCaseSensitive", n2);
            this.checkColumnIndex(n2);
            return true;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isSearchable(int n2) throws SQLException {
        try {
            this.debugCodeCall("isSearchable", n2);
            this.checkColumnIndex(n2);
            return true;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isCurrency(int n2) throws SQLException {
        try {
            this.debugCodeCall("isCurrency", n2);
            this.checkColumnIndex(n2);
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int isNullable(int n2) throws SQLException {
        try {
            this.debugCodeCall("isNullable", n2);
            this.checkColumnIndex(n2);
            return this.result.getNullable(--n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isSigned(int n2) throws SQLException {
        try {
            this.debugCodeCall("isSigned", n2);
            this.checkColumnIndex(n2);
            return true;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isReadOnly(int n2) throws SQLException {
        try {
            this.debugCodeCall("isReadOnly", n2);
            this.checkColumnIndex(n2);
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isWritable(int n2) throws SQLException {
        try {
            this.debugCodeCall("isWritable", n2);
            this.checkColumnIndex(n2);
            return true;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isDefinitelyWritable(int n2) throws SQLException {
        try {
            this.debugCodeCall("isDefinitelyWritable", n2);
            this.checkColumnIndex(n2);
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getColumnClassName(int n2) throws SQLException {
        try {
            this.debugCodeCall("getColumnClassName", n2);
            this.checkColumnIndex(n2);
            int n3 = this.result.getColumnType(--n2);
            return DataType.getTypeClassName(n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getPrecision(int n2) throws SQLException {
        try {
            this.debugCodeCall("getPrecision", n2);
            this.checkColumnIndex(n2);
            long l2 = this.result.getColumnPrecision(--n2);
            return MathUtils.convertLongToInt(l2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getScale(int n2) throws SQLException {
        try {
            this.debugCodeCall("getScale", n2);
            this.checkColumnIndex(n2);
            return this.result.getColumnScale(--n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getColumnDisplaySize(int n2) throws SQLException {
        try {
            this.debugCodeCall("getColumnDisplaySize", n2);
            this.checkColumnIndex(n2);
            return this.result.getDisplaySize(--n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private void checkClosed() {
        if (this.rs != null) {
            this.rs.checkClosed();
        }
        if (this.prep != null) {
            this.prep.checkClosed();
        }
    }

    private void checkColumnIndex(int n2) {
        this.checkClosed();
        if (n2 < 1 || n2 > this.columnCount) {
            throw DbException.getInvalidValueException("columnIndex", n2);
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw DbException.getInvalidValueException("iface", clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    public String toString() {
        return this.getTraceObjectName() + ": columns=" + this.columnCount;
    }
}

