/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcArray;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcClob;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcResultSetMetaData;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.result.UpdatableRow;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class JdbcResultSet
extends TraceObject
implements ResultSet {
    private final boolean closeStatement;
    private final boolean scrollable;
    private final boolean updatable;
    private ResultInterface result;
    private JdbcConnection conn;
    private JdbcStatement stat;
    private int columnCount;
    private boolean wasNull;
    private Value[] insertRow;
    private Value[] updateRow;
    private HashMap<String, Integer> columnLabelMap;
    private HashMap<Integer, Value[]> patchedRows;
    private JdbcPreparedStatement preparedStatement;

    JdbcResultSet(JdbcConnection jdbcConnection, JdbcStatement jdbcStatement, ResultInterface resultInterface, int n2, boolean bl2, boolean bl3, boolean bl4) {
        this.setTrace(jdbcConnection.getSession().getTrace(), 4, n2);
        this.conn = jdbcConnection;
        this.stat = jdbcStatement;
        this.result = resultInterface;
        this.columnCount = resultInterface.getVisibleColumnCount();
        this.closeStatement = bl2;
        this.scrollable = bl3;
        this.updatable = bl4;
    }

    JdbcResultSet(JdbcConnection jdbcConnection, JdbcPreparedStatement jdbcPreparedStatement, ResultInterface resultInterface, int n2, boolean bl2, boolean bl3, boolean bl4, HashMap<String, Integer> hashMap) {
        this(jdbcConnection, jdbcPreparedStatement, resultInterface, n2, bl2, bl3, bl4);
        this.columnLabelMap = hashMap;
        this.preparedStatement = jdbcPreparedStatement;
    }

    @Override
    public boolean next() throws SQLException {
        try {
            this.debugCodeCall("next");
            this.checkClosed();
            return this.nextRow();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            int n2 = JdbcResultSet.getNextId(5);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSetMetaData", 5, n2, "getMetaData()");
            }
            this.checkClosed();
            String string = this.conn.getCatalog();
            JdbcResultSetMetaData jdbcResultSetMetaData = new JdbcResultSetMetaData(this, null, this.result, string, this.conn.getSession().getTrace(), n2);
            return jdbcResultSetMetaData;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            this.debugCodeCall("wasNull");
            this.checkClosed();
            return this.wasNull;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        try {
            this.debugCodeCall("findColumn", string);
            return this.getColumnIndex(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            this.closeInternal();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeInternal() throws SQLException {
        if (this.result != null) {
            try {
                this.result.close();
                if (this.closeStatement && this.stat != null) {
                    this.stat.close();
                }
            }
            finally {
                this.columnCount = 0;
                this.result = null;
                this.stat = null;
                this.conn = null;
                this.insertRow = null;
                this.updateRow = null;
            }
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        try {
            this.debugCodeCall("getStatement");
            this.checkClosed();
            if (this.closeStatement) {
                return null;
            }
            return this.stat;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getString(int n2) throws SQLException {
        try {
            this.debugCodeCall("getString", n2);
            return this.get(n2).getString();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getString(String string) throws SQLException {
        try {
            this.debugCodeCall("getString", string);
            return this.get(string).getString();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getInt(int n2) throws SQLException {
        try {
            this.debugCodeCall("getInt", n2);
            return this.get(n2).getInt();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getInt(String string) throws SQLException {
        try {
            this.debugCodeCall("getInt", string);
            return this.get(string).getInt();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        try {
            this.debugCodeCall("getBigDecimal", n2);
            return this.get(n2).getBigDecimal();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        try {
            this.debugCodeCall("getDate", n2);
            return this.get(n2).getDate();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        try {
            this.debugCodeCall("getTime", n2);
            return this.get(n2).getTime();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        try {
            this.debugCodeCall("getTimestamp", n2);
            return this.get(n2).getTimestamp();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        try {
            this.debugCodeCall("getBigDecimal", string);
            return this.get(string).getBigDecimal();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Date getDate(String string) throws SQLException {
        try {
            this.debugCodeCall("getDate", string);
            return this.get(string).getDate();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Time getTime(String string) throws SQLException {
        try {
            this.debugCodeCall("getTime", string);
            return this.get(string).getTime();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        try {
            this.debugCodeCall("getTimestamp", string);
            return this.get(string).getTimestamp();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Object getObject(int n2) throws SQLException {
        try {
            this.debugCodeCall("getObject", n2);
            Value value = this.get(n2);
            return this.conn.convertToDefaultObject(value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Object getObject(String string) throws SQLException {
        try {
            this.debugCodeCall("getObject", string);
            Value value = this.get(string);
            return this.conn.convertToDefaultObject(value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean getBoolean(int n2) throws SQLException {
        try {
            this.debugCodeCall("getBoolean", n2);
            Boolean bl2 = this.get(n2).getBoolean();
            return bl2 == null ? false : bl2;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        try {
            this.debugCodeCall("getBoolean", string);
            Boolean bl2 = this.get(string).getBoolean();
            return bl2 == null ? false : bl2;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public byte getByte(int n2) throws SQLException {
        try {
            this.debugCodeCall("getByte", n2);
            return this.get(n2).getByte();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public byte getByte(String string) throws SQLException {
        try {
            this.debugCodeCall("getByte", string);
            return this.get(string).getByte();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public short getShort(int n2) throws SQLException {
        try {
            this.debugCodeCall("getShort", n2);
            return this.get(n2).getShort();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public short getShort(String string) throws SQLException {
        try {
            this.debugCodeCall("getShort", string);
            return this.get(string).getShort();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long getLong(int n2) throws SQLException {
        try {
            this.debugCodeCall("getLong", n2);
            return this.get(n2).getLong();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long getLong(String string) throws SQLException {
        try {
            this.debugCodeCall("getLong", string);
            return this.get(string).getLong();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        try {
            this.debugCodeCall("getFloat", n2);
            return this.get(n2).getFloat();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public float getFloat(String string) throws SQLException {
        try {
            this.debugCodeCall("getFloat", string);
            return this.get(string).getFloat();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        try {
            this.debugCodeCall("getDouble", n2);
            return this.get(n2).getDouble();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public double getDouble(String string) throws SQLException {
        try {
            this.debugCodeCall("getDouble", string);
            return this.get(string).getDouble();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getBigDecimal(" + StringUtils.quoteJavaString(string) + ", " + n2 + ");");
            }
            if (n2 < 0) {
                throw DbException.getInvalidValueException("scale", n2);
            }
            BigDecimal bigDecimal = this.get(string).getBigDecimal();
            return bigDecimal == null ? null : ValueDecimal.setScale(bigDecimal, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getBigDecimal(" + n2 + ", " + n3 + ");");
            }
            if (n3 < 0) {
                throw DbException.getInvalidValueException("scale", n3);
            }
            BigDecimal bigDecimal = this.get(n2).getBigDecimal();
            return bigDecimal == null ? null : ValueDecimal.setScale(bigDecimal, n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int n2) throws SQLException {
        throw this.unsupported("unicodeStream");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String string) throws SQLException {
        throw this.unsupported("unicodeStream");
    }

    @Override
    public Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        throw this.unsupported("map");
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        throw this.unsupported("map");
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getDate(" + n2 + ", calendar)");
            }
            return DateTimeUtils.convertDate(this.get(n2), calendar);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getDate(" + StringUtils.quoteJavaString(string) + ", calendar)");
            }
            return DateTimeUtils.convertDate(this.get(string), calendar);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTime(" + n2 + ", calendar)");
            }
            return DateTimeUtils.convertTime(this.get(n2), calendar);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTime(" + StringUtils.quoteJavaString(string) + ", calendar)");
            }
            return DateTimeUtils.convertTime(this.get(string), calendar);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTimestamp(" + n2 + ", calendar)");
            }
            Value value = this.get(n2);
            return DateTimeUtils.convertTimestamp(value, calendar);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTimestamp(" + StringUtils.quoteJavaString(string) + ", calendar)");
            }
            Value value = this.get(string);
            return DateTimeUtils.convertTimestamp(value, calendar);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        try {
            int n3 = JdbcResultSet.getNextId(9);
            this.debugCodeAssign("Blob", 9, n3, "getBlob(" + n2 + ")");
            Value value = this.get(n2);
            return value == ValueNull.INSTANCE ? null : new JdbcBlob(this.conn, value, n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        try {
            int n2 = JdbcResultSet.getNextId(9);
            this.debugCodeAssign("Blob", 9, n2, "getBlob(" + JdbcResultSet.quote(string) + ")");
            Value value = this.get(string);
            return value == ValueNull.INSTANCE ? null : new JdbcBlob(this.conn, value, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        try {
            this.debugCodeCall("getBytes", n2);
            return this.get(n2).getBytes();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        try {
            this.debugCodeCall("getBytes", string);
            return this.get(string).getBytes();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream", n2);
            return this.get(n2).getInputStream();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream", string);
            return this.get(string).getInputStream();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        try {
            int n3 = JdbcResultSet.getNextId(10);
            this.debugCodeAssign("Clob", 10, n3, "getClob(" + n2 + ")");
            Value value = this.get(n2);
            return value == ValueNull.INSTANCE ? null : new JdbcClob(this.conn, value, n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        try {
            int n2 = JdbcResultSet.getNextId(10);
            this.debugCodeAssign("Clob", 10, n2, "getClob(" + JdbcResultSet.quote(string) + ")");
            Value value = this.get(string);
            return value == ValueNull.INSTANCE ? null : new JdbcClob(this.conn, value, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        try {
            int n3 = JdbcResultSet.getNextId(16);
            this.debugCodeAssign("Clob", 16, n3, "getArray(" + n2 + ")");
            Value value = this.get(n2);
            return value == ValueNull.INSTANCE ? null : new JdbcArray(this.conn, value, n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Array getArray(String string) throws SQLException {
        try {
            int n2 = JdbcResultSet.getNextId(16);
            this.debugCodeAssign("Clob", 16, n2, "getArray(" + JdbcResultSet.quote(string) + ")");
            Value value = this.get(string);
            return value == ValueNull.INSTANCE ? null : new JdbcArray(this.conn, value, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream", n2);
            String string = this.get(n2).getString();
            return string == null ? null : IOUtils.getInputStreamFromString(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream", string);
            String string2 = this.get(string).getString();
            return IOUtils.getInputStreamFromString(string2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream", n2);
            return this.get(n2).getReader();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream", string);
            return this.get(string).getReader();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public void updateNull(int n2) throws SQLException {
        try {
            this.debugCodeCall("updateNull", n2);
            this.update(n2, (Value)ValueNull.INSTANCE);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateNull(String string) throws SQLException {
        try {
            this.debugCodeCall("updateNull", string);
            this.update(string, (Value)ValueNull.INSTANCE);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBoolean(int n2, boolean bl2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBoolean(" + n2 + ", " + bl2 + ");");
            }
            this.update(n2, (Value)ValueBoolean.get(bl2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBoolean(String string, boolean bl2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBoolean(" + JdbcResultSet.quote(string) + ", " + bl2 + ");");
            }
            this.update(string, (Value)ValueBoolean.get(bl2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateByte(int n2, byte by2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateByte(" + n2 + ", " + by2 + ");");
            }
            this.update(n2, (Value)ValueByte.get(by2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateByte(String string, byte by2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateByte(" + string + ", " + by2 + ");");
            }
            this.update(string, (Value)ValueByte.get(by2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBytes(" + n2 + ", x);");
            }
            this.update(n2, byArray == null ? ValueNull.INSTANCE : ValueBytes.get(byArray));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBytes(" + JdbcResultSet.quote(string) + ", x);");
            }
            this.update(string, byArray == null ? ValueNull.INSTANCE : ValueBytes.get(byArray));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateShort(int n2, short s2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateShort(" + n2 + ", (short) " + s2 + ");");
            }
            this.update(n2, (Value)ValueShort.get(s2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateShort(String string, short s2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateShort(" + JdbcResultSet.quote(string) + ", (short) " + s2 + ");");
            }
            this.update(string, (Value)ValueShort.get(s2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateInt(int n2, int n3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateInt(" + n2 + ", " + n3 + ");");
            }
            this.update(n2, (Value)ValueInt.get(n3));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateInt(String string, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateInt(" + JdbcResultSet.quote(string) + ", " + n2 + ");");
            }
            this.update(string, (Value)ValueInt.get(n2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateLong(int n2, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateLong(" + n2 + ", " + l2 + "L);");
            }
            this.update(n2, (Value)ValueLong.get(l2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateLong(String string, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateLong(" + JdbcResultSet.quote(string) + ", " + l2 + "L);");
            }
            this.update(string, (Value)ValueLong.get(l2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateFloat(int n2, float f2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateFloat(" + n2 + ", " + f2 + "f);");
            }
            this.update(n2, (Value)ValueFloat.get(f2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateFloat(String string, float f2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateFloat(" + JdbcResultSet.quote(string) + ", " + f2 + "f);");
            }
            this.update(string, (Value)ValueFloat.get(f2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateDouble(int n2, double d2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDouble(" + n2 + ", " + d2 + "d);");
            }
            this.update(n2, (Value)ValueDouble.get(d2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateDouble(String string, double d2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDouble(" + JdbcResultSet.quote(string) + ", " + d2 + "d);");
            }
            this.update(string, (Value)ValueDouble.get(d2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBigDecimal(" + n2 + ", " + JdbcResultSet.quoteBigDecimal(bigDecimal) + ");");
            }
            this.update(n2, bigDecimal == null ? ValueNull.INSTANCE : ValueDecimal.get(bigDecimal));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBigDecimal(" + JdbcResultSet.quote(string) + ", " + JdbcResultSet.quoteBigDecimal(bigDecimal) + ");");
            }
            this.update(string, bigDecimal == null ? ValueNull.INSTANCE : ValueDecimal.get(bigDecimal));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateString(int n2, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateString(" + n2 + ", " + JdbcResultSet.quote(string) + ");");
            }
            this.update(n2, string == null ? ValueNull.INSTANCE : ValueString.get(string));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateString(" + JdbcResultSet.quote(string) + ", " + JdbcResultSet.quote(string2) + ");");
            }
            this.update(string, string2 == null ? ValueNull.INSTANCE : ValueString.get(string2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateDate(int n2, Date date) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDate(" + n2 + ", x);");
            }
            this.update(n2, date == null ? ValueNull.INSTANCE : ValueDate.get(date));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDate(" + JdbcResultSet.quote(string) + ", x);");
            }
            this.update(string, date == null ? ValueNull.INSTANCE : ValueDate.get(date));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateTime(int n2, Time time) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTime(" + n2 + ", x);");
            }
            this.update(n2, time == null ? ValueNull.INSTANCE : ValueTime.get(time));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTime(" + JdbcResultSet.quote(string) + ", x);");
            }
            this.update(string, time == null ? ValueNull.INSTANCE : ValueTime.get(time));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTimestamp(" + n2 + ", x);");
            }
            this.update(n2, timestamp == null ? ValueNull.INSTANCE : ValueTimestamp.get(timestamp));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTimestamp(" + JdbcResultSet.quote(string) + ", x);");
            }
            this.update(string, timestamp == null ? ValueNull.INSTANCE : ValueTimestamp.get(timestamp));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.updateAsciiStream(n2, inputStream, (long)n3);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(n2, inputStream, -1);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateAsciiStream(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(IOUtils.getAsciiReader(inputStream), l2);
            this.update(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(string, inputStream, (long)n2);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(string, inputStream, -1);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateAsciiStream(" + JdbcResultSet.quote(string) + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(IOUtils.getAsciiReader(inputStream), l2);
            this.update(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.updateBinaryStream(n2, inputStream, (long)n3);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n2, inputStream, -1);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBinaryStream(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createBlob(inputStream, l2);
            this.update(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(string, inputStream, -1);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(string, inputStream, (long)n2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBinaryStream(" + JdbcResultSet.quote(string) + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createBlob(inputStream, l2);
            this.update(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateCharacterStream(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(reader, l2);
            this.update(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.updateCharacterStream(n2, reader, (long)n3);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader) throws SQLException {
        this.updateCharacterStream(n2, reader, -1);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(string, reader, (long)n2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(string, reader, -1);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateCharacterStream(" + JdbcResultSet.quote(string) + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(reader, l2);
            this.update(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + n2 + ", x, " + n3 + ");");
            }
            this.update(n2, this.convertToUnknownValue(object));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateObject(String string, Object object, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + JdbcResultSet.quote(string) + ", x, " + n2 + ");");
            }
            this.update(string, this.convertToUnknownValue(object));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateObject(int n2, Object object) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + n2 + ", x);");
            }
            this.update(n2, this.convertToUnknownValue(object));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + JdbcResultSet.quote(string) + ", x);");
            }
            this.update(string, this.convertToUnknownValue(object));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateRef(int n2, Ref ref) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream) throws SQLException {
        this.updateBlob(n2, inputStream, -1L);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createBlob(inputStream, l2);
            this.update(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBlob(int n2, Blob blob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + n2 + ", x);");
            }
            this.checkClosed();
            Value value = blob == null ? ValueNull.INSTANCE : this.conn.createBlob(blob.getBinaryStream(), -1L);
            this.update(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + JdbcResultSet.quote(string) + ", x);");
            }
            this.checkClosed();
            Value value = blob == null ? ValueNull.INSTANCE : this.conn.createBlob(blob.getBinaryStream(), -1L);
            this.update(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.updateBlob(string, inputStream, -1L);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + JdbcResultSet.quote(string) + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createBlob(inputStream, -1L);
            this.update(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateClob(int n2, Clob clob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + n2 + ", x);");
            }
            this.checkClosed();
            Value value = clob == null ? ValueNull.INSTANCE : this.conn.createClob(clob.getCharacterStream(), -1L);
            this.update(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateClob(int n2, Reader reader) throws SQLException {
        this.updateClob(n2, reader, -1L);
    }

    @Override
    public void updateClob(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(reader, l2);
            this.update(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + JdbcResultSet.quote(string) + ", x);");
            }
            this.checkClosed();
            Value value = clob == null ? ValueNull.INSTANCE : this.conn.createClob(clob.getCharacterStream(), -1L);
            this.update(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.updateClob(string, reader, -1L);
    }

    @Override
    public void updateClob(String string, Reader reader, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + JdbcResultSet.quote(string) + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(reader, l2);
            this.update(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateArray(int n2, Array array) throws SQLException {
        throw this.unsupported("setArray");
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw this.unsupported("setArray");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw this.unsupported("cursorName");
    }

    @Override
    public int getRow() throws SQLException {
        try {
            this.debugCodeCall("getRow");
            this.checkClosed();
            int n2 = this.result.getRowId();
            if (n2 >= this.result.getRowCount()) {
                return 0;
            }
            return n2 + 1;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            this.debugCodeCall("getConcurrency");
            this.checkClosed();
            if (!this.updatable) {
                return 1007;
            }
            UpdatableRow updatableRow = new UpdatableRow(this.conn, this.result);
            return updatableRow.isUpdatable() ? 1008 : 1007;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            this.debugCodeCall("getFetchDirection");
            this.checkClosed();
            return 1000;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            this.debugCodeCall("getFetchSize");
            this.checkClosed();
            return this.result.getFetchSize();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setFetchSize(int n2) throws SQLException {
        try {
            this.debugCodeCall("setFetchSize", n2);
            this.checkClosed();
            if (n2 < 0) {
                throw DbException.getInvalidValueException("rows", n2);
            }
            if (n2 > 0) {
                int n3;
                if (this.stat != null && (n3 = this.stat.getMaxRows()) > 0 && n2 > n3) {
                    throw DbException.getInvalidValueException("rows", n2);
                }
            } else {
                n2 = SysProperties.SERVER_RESULT_SET_FETCH_SIZE;
            }
            this.result.setFetchSize(n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setFetchDirection(int n2) throws SQLException {
        this.debugCodeCall("setFetchDirection", n2);
        if (n2 != 1000) {
            throw this.unsupported("setFetchDirection");
        }
    }

    @Override
    public int getType() throws SQLException {
        try {
            this.debugCodeCall("getType");
            this.checkClosed();
            return this.stat == null ? 1003 : this.stat.resultSetType;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            this.debugCodeCall("isBeforeFirst");
            this.checkClosed();
            int n2 = this.result.getRowId();
            int n3 = this.result.getRowCount();
            return n3 > 0 && n2 < 0;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            this.debugCodeCall("isAfterLast");
            this.checkClosed();
            int n2 = this.result.getRowId();
            int n3 = this.result.getRowCount();
            return n3 > 0 && n2 >= n3;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            this.debugCodeCall("isFirst");
            this.checkClosed();
            int n2 = this.result.getRowId();
            return n2 == 0 && n2 < this.result.getRowCount();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try {
            this.debugCodeCall("isLast");
            this.checkClosed();
            int n2 = this.result.getRowId();
            return n2 >= 0 && n2 == this.result.getRowCount() - 1;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try {
            this.debugCodeCall("beforeFirst");
            this.checkClosed();
            if (this.result.getRowId() >= 0) {
                this.resetResult();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try {
            this.debugCodeCall("afterLast");
            this.checkClosed();
            while (this.nextRow()) {
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean first() throws SQLException {
        try {
            this.debugCodeCall("first");
            this.checkClosed();
            if (this.result.getRowId() < 0) {
                return this.nextRow();
            }
            this.resetResult();
            return this.nextRow();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean last() throws SQLException {
        try {
            this.debugCodeCall("last");
            this.checkClosed();
            return this.absolute(-1);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        try {
            this.debugCodeCall("absolute", n2);
            this.checkClosed();
            if (n2 < 0) {
                n2 = this.result.getRowCount() + n2 + 1;
            } else if (n2 > this.result.getRowCount() + 1) {
                n2 = this.result.getRowCount() + 1;
            }
            if (n2 <= this.result.getRowId()) {
                this.resetResult();
            }
            while (this.result.getRowId() + 1 < n2) {
                this.nextRow();
            }
            int n3 = this.result.getRowId();
            return n3 >= 0 && n3 < this.result.getRowCount();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean relative(int n2) throws SQLException {
        try {
            this.debugCodeCall("relative", n2);
            this.checkClosed();
            int n3 = this.result.getRowId() + 1 + n2;
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > this.result.getRowCount()) {
                n3 = this.result.getRowCount() + 1;
            }
            return this.absolute(n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try {
            this.debugCodeCall("previous");
            this.checkClosed();
            return this.relative(-1);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            this.debugCodeCall("moveToInsertRow");
            this.checkUpdatable();
            this.insertRow = new Value[this.columnCount];
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            this.debugCodeCall("moveToCurrentRow");
            this.checkUpdatable();
            this.insertRow = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            this.debugCodeCall("rowUpdated");
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try {
            this.debugCodeCall("rowInserted");
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            this.debugCodeCall("rowDeleted");
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void insertRow() throws SQLException {
        try {
            this.debugCodeCall("insertRow");
            this.checkUpdatable();
            if (this.insertRow == null) {
                throw DbException.get(90029);
            }
            this.getUpdatableRow().insertRow(this.insertRow);
            this.insertRow = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateRow() throws SQLException {
        try {
            this.debugCodeCall("updateRow");
            this.checkUpdatable();
            if (this.insertRow != null) {
                throw DbException.get(90029);
            }
            this.checkOnValidRow();
            if (this.updateRow != null) {
                int n2;
                UpdatableRow updatableRow = this.getUpdatableRow();
                Value[] valueArray = new Value[this.columnCount];
                for (n2 = 0; n2 < this.updateRow.length; ++n2) {
                    valueArray[n2] = this.get(n2 + 1);
                }
                updatableRow.updateRow(valueArray, this.updateRow);
                for (n2 = 0; n2 < this.updateRow.length; ++n2) {
                    if (this.updateRow[n2] != null) continue;
                    this.updateRow[n2] = valueArray[n2];
                }
                Value[] valueArray2 = updatableRow.readRow(this.updateRow);
                this.patchCurrentRow(valueArray2);
                this.updateRow = null;
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        try {
            this.debugCodeCall("deleteRow");
            this.checkUpdatable();
            if (this.insertRow != null) {
                throw DbException.get(90029);
            }
            this.checkOnValidRow();
            this.getUpdatableRow().deleteRow(this.result.currentRow());
            this.updateRow = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try {
            this.debugCodeCall("refreshRow");
            this.checkClosed();
            if (this.insertRow != null) {
                throw DbException.get(2000);
            }
            this.checkOnValidRow();
            this.patchCurrentRow(this.getUpdatableRow().readRow(this.result.currentRow()));
            this.updateRow = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        try {
            this.debugCodeCall("cancelRowUpdates");
            this.checkClosed();
            if (this.insertRow != null) {
                throw DbException.get(2000);
            }
            this.updateRow = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private UpdatableRow getUpdatableRow() throws SQLException {
        UpdatableRow updatableRow = new UpdatableRow(this.conn, this.result);
        if (!updatableRow.isUpdatable()) {
            throw DbException.get(90127);
        }
        return updatableRow;
    }

    private int getColumnIndex(String string) {
        int n2;
        this.checkClosed();
        if (string == null) {
            throw DbException.getInvalidValueException("columnLabel", null);
        }
        if (this.columnCount >= 3) {
            Serializable serializable;
            if (this.columnLabelMap == null) {
                String string2;
                int n3;
                serializable = New.hashMap(this.columnCount);
                for (n3 = 0; n3 < this.columnCount; ++n3) {
                    string2 = StringUtils.toUpperEnglish(this.result.getAlias(n3));
                    JdbcResultSet.mapColumn((HashMap<String, Integer>)serializable, string2, n3);
                }
                for (n3 = 0; n3 < this.columnCount; ++n3) {
                    string2 = this.result.getColumnName(n3);
                    if (string2 == null) continue;
                    string2 = StringUtils.toUpperEnglish(string2);
                    JdbcResultSet.mapColumn((HashMap<String, Integer>)serializable, string2, n3);
                    String string3 = this.result.getTableName(n3);
                    if (string3 == null) continue;
                    string2 = StringUtils.toUpperEnglish(string3) + "." + string2;
                    JdbcResultSet.mapColumn((HashMap<String, Integer>)serializable, string2, n3);
                }
                this.columnLabelMap = serializable;
                if (this.preparedStatement != null) {
                    this.preparedStatement.setCachedColumnLabelMap(this.columnLabelMap);
                }
            }
            if ((serializable = this.columnLabelMap.get(StringUtils.toUpperEnglish(string))) == null) {
                throw DbException.get(42122, string);
            }
            return (Integer)serializable + 1;
        }
        for (n2 = 0; n2 < this.columnCount; ++n2) {
            if (!string.equalsIgnoreCase(this.result.getAlias(n2))) continue;
            return n2 + 1;
        }
        n2 = string.indexOf(46);
        if (n2 > 0) {
            String string4 = string.substring(0, n2);
            String string5 = string.substring(n2 + 1);
            for (int i2 = 0; i2 < this.columnCount; ++i2) {
                if (!string4.equalsIgnoreCase(this.result.getTableName(i2)) || !string5.equalsIgnoreCase(this.result.getColumnName(i2))) continue;
                return i2 + 1;
            }
        } else {
            for (int i3 = 0; i3 < this.columnCount; ++i3) {
                if (!string.equalsIgnoreCase(this.result.getColumnName(i3))) continue;
                return i3 + 1;
            }
        }
        throw DbException.get(42122, string);
    }

    private static void mapColumn(HashMap<String, Integer> hashMap, String string, int n2) {
        Integer n3 = hashMap.put(string, n2);
        if (n3 != null) {
            hashMap.put(string, n3);
        }
    }

    private void checkColumnIndex(int n2) {
        this.checkClosed();
        if (n2 < 1 || n2 > this.columnCount) {
            throw DbException.getInvalidValueException("columnIndex", n2);
        }
    }

    void checkClosed() {
        if (this.result == null) {
            throw DbException.get(90007);
        }
        if (this.stat != null) {
            this.stat.checkClosed();
        }
        if (this.conn != null) {
            this.conn.checkClosed();
        }
    }

    private void checkOnValidRow() {
        if (this.result.getRowId() < 0 || this.result.getRowId() >= this.result.getRowCount()) {
            throw DbException.get(2000);
        }
    }

    private Value get(int n2) {
        Value[] valueArray;
        this.checkColumnIndex(n2);
        this.checkOnValidRow();
        if (this.patchedRows == null) {
            valueArray = this.result.currentRow();
        } else {
            valueArray = this.patchedRows.get(this.result.getRowId());
            if (valueArray == null) {
                valueArray = this.result.currentRow();
            }
        }
        Value value = valueArray[n2 - 1];
        this.wasNull = value == ValueNull.INSTANCE;
        return value;
    }

    private Value get(String string) {
        int n2 = this.getColumnIndex(string);
        return this.get(n2);
    }

    private void update(String string, Value value) {
        int n2 = this.getColumnIndex(string);
        this.update(n2, value);
    }

    private void update(int n2, Value value) {
        this.checkUpdatable();
        this.checkColumnIndex(n2);
        if (this.insertRow != null) {
            this.insertRow[n2 - 1] = value;
        } else {
            if (this.updateRow == null) {
                this.updateRow = new Value[this.columnCount];
            }
            this.updateRow[n2 - 1] = value;
        }
    }

    private boolean nextRow() {
        boolean bl2 = this.result.next();
        if (!bl2 && !this.scrollable) {
            this.result.close();
        }
        return bl2;
    }

    private void resetResult() {
        if (!this.scrollable) {
            throw DbException.get(90128);
        }
        this.result.reset();
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public void updateRowId(int n2, RowId rowId) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            this.debugCodeCall("getHoldability");
            this.checkClosed();
            return this.conn.getHoldability();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.result == null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateNString(int n2, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNString(" + n2 + ", " + JdbcResultSet.quote(string) + ");");
            }
            this.update(n2, string == null ? ValueNull.INSTANCE : ValueString.get(string));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNString(" + JdbcResultSet.quote(string) + ", " + JdbcResultSet.quote(string2) + ");");
            }
            this.update(string, string2 == null ? ValueNull.INSTANCE : ValueString.get(string2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateNClob(int n2, NClob nClob) throws SQLException {
        throw this.unsupported("NClob");
    }

    @Override
    public void updateNClob(int n2, Reader reader) throws SQLException {
        this.updateClob(n2, reader, -1L);
    }

    @Override
    public void updateNClob(int n2, Reader reader, long l2) throws SQLException {
        this.updateClob(n2, reader, l2);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        this.updateClob(string, reader, -1L);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l2) throws SQLException {
        this.updateClob(string, reader, l2);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw this.unsupported("NClob");
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        try {
            int n3 = JdbcResultSet.getNextId(10);
            this.debugCodeAssign("NClob", 10, n3, "getNClob(" + n2 + ")");
            Value value = this.get(n2);
            return value == ValueNull.INSTANCE ? null : new JdbcClob(this.conn, value, n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        try {
            int n2 = JdbcResultSet.getNextId(10);
            this.debugCodeAssign("NClob", 10, n2, "getNClob(" + string + ")");
            Value value = this.get(string);
            return value == ValueNull.INSTANCE ? null : new JdbcClob(this.conn, value, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public String getNString(int n2) throws SQLException {
        try {
            this.debugCodeCall("getNString", n2);
            return this.get(n2).getString();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getNString(String string) throws SQLException {
        try {
            this.debugCodeCall("getNString", string);
            return this.get(string).getString();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        try {
            this.debugCodeCall("getNCharacterStream", n2);
            return this.get(n2).getReader();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        try {
            this.debugCodeCall("getNCharacterStream", string);
            return this.get(string).getReader();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader) throws SQLException {
        this.updateNCharacterStream(n2, reader, -1L);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNCharacterStream(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(reader, l2);
            this.update(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.updateNCharacterStream(string, reader, -1L);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNCharacterStream(" + JdbcResultSet.quote(string) + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(reader, l2);
            this.update(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw DbException.getInvalidValueException("iface", clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T getObject(int n2, Class<T> clazz) {
        return null;
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) {
        return null;
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.result;
    }

    private void patchCurrentRow(Value[] valueArray) {
        boolean bl2 = false;
        Value[] valueArray2 = this.result.currentRow();
        CompareMode compareMode = this.conn.getCompareMode();
        for (int i2 = 0; i2 < valueArray.length; ++i2) {
            if (valueArray[i2].compareTo(valueArray2[i2], compareMode) == 0) continue;
            bl2 = true;
            break;
        }
        if (this.patchedRows == null) {
            this.patchedRows = New.hashMap();
        }
        Integer n2 = this.result.getRowId();
        if (!bl2) {
            this.patchedRows.remove(n2);
        } else {
            this.patchedRows.put(n2, valueArray);
        }
    }

    private Value convertToUnknownValue(Object object) {
        this.checkClosed();
        return DataType.convertToValue(this.conn.getSession(), object, -1);
    }

    private void checkUpdatable() {
        this.checkClosed();
        if (!this.updatable) {
            throw DbException.get(90140);
        }
    }
}

