/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.h2.command.CommandInterface;
import org.h2.engine.SessionInterface;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcBatchUpdateException;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcParameterMetaData;
import org.h2.jdbc.JdbcResultSet;
import org.h2.jdbc.JdbcResultSetMetaData;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.tools.SimpleResultSet;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.New;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class JdbcPreparedStatement
extends JdbcStatement
implements PreparedStatement {
    protected CommandInterface command;
    private final String sqlStatement;
    private ArrayList<Value[]> batchParameters;
    private ArrayList<Object> batchIdentities;
    private HashMap<String, Integer> cachedColumnLabelMap;

    JdbcPreparedStatement(JdbcConnection jdbcConnection, String string, int n2, int n3, int n4, boolean bl2) {
        super(jdbcConnection, n2, n3, n4, bl2);
        this.setTrace(this.session.getTrace(), 3, n2);
        this.sqlStatement = string;
        this.command = jdbcConnection.prepareCommand(string, this.fetchSize);
    }

    void setCachedColumnLabelMap(HashMap<String, Integer> hashMap) {
        this.cachedColumnLabelMap = hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            int n2 = JdbcPreparedStatement.getNextId(4);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSet", 4, n2, "executeQuery()");
            }
            this.batchIdentities = null;
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                ResultInterface resultInterface;
                this.checkClosed();
                this.closeOldResultSet();
                boolean bl2 = this.resultSetType != 1003;
                boolean bl3 = this.resultSetConcurrency == 1008;
                try {
                    this.setExecutingStatement(this.command);
                    resultInterface = this.command.executeQuery(this.maxRows, bl2);
                }
                finally {
                    this.setExecutingStatement(null);
                }
                this.resultSet = new JdbcResultSet(this.conn, this, resultInterface, n2, this.closedByResultSet, bl2, bl3, this.cachedColumnLabelMap);
            }
            return this.resultSet;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        int n2;
        this.debugCodeCall("executeUpdate");
        this.checkClosedForWrite();
        this.batchIdentities = null;
        try {
            n2 = this.executeUpdateInternal();
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
        this.afterWriting();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdateInternal() throws SQLException {
        this.closeOldResultSet();
        SessionInterface sessionInterface = this.session;
        synchronized (sessionInterface) {
            try {
                this.setExecutingStatement(this.command);
                this.updateCount = this.command.executeUpdate();
            }
            finally {
                this.setExecutingStatement(null);
            }
        }
        return this.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        boolean bl2;
        int n2 = JdbcPreparedStatement.getNextId(4);
        if (this.isDebugEnabled()) {
            this.debugCodeCall("execute");
        }
        this.checkClosedForWrite();
        try {
            boolean bl3;
            SessionInterface sessionInterface = this.conn.getSession();
            synchronized (sessionInterface) {
                this.closeOldResultSet();
                try {
                    this.setExecutingStatement(this.command);
                    if (this.command.isQuery()) {
                        bl3 = true;
                        boolean bl4 = this.resultSetType != 1003;
                        boolean bl5 = this.resultSetConcurrency == 1008;
                        ResultInterface resultInterface = this.command.executeQuery(this.maxRows, bl4);
                        this.resultSet = new JdbcResultSet(this.conn, this, resultInterface, n2, this.closedByResultSet, bl4, bl5);
                    } else {
                        bl3 = false;
                        this.updateCount = this.command.executeUpdate();
                    }
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            bl2 = bl3;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
        this.afterWriting();
        return bl2;
    }

    @Override
    public void clearParameters() throws SQLException {
        try {
            this.debugCodeCall("clearParameters");
            this.checkClosed();
            ArrayList<? extends ParameterInterface> arrayList = this.command.getParameters();
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ParameterInterface parameterInterface = arrayList.get(i2);
                parameterInterface.setValue(null, this.batchParameters == null);
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        try {
            this.debugCodeCall("executeQuery", string);
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void addBatch(String string) throws SQLException {
        try {
            this.debugCodeCall("addBatch", string);
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        try {
            this.debugCodeCall("executeUpdate", string);
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        try {
            this.debugCodeCall("execute", string);
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setNull(int n2, int n3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNull(" + n2 + ", " + n3 + ");");
            }
            this.setParameter(n2, ValueNull.INSTANCE);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setInt(int n2, int n3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setInt(" + n2 + ", " + n3 + ");");
            }
            this.setParameter(n2, ValueInt.get(n3));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setString(int n2, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setString(" + n2 + ", " + JdbcPreparedStatement.quote(string) + ");");
            }
            Value value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
            this.setParameter(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBigDecimal(" + n2 + ", " + JdbcPreparedStatement.quoteBigDecimal(bigDecimal) + ");");
            }
            Value value = bigDecimal == null ? ValueNull.INSTANCE : ValueDecimal.get(bigDecimal);
            this.setParameter(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setDate(int n2, Date date) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDate(" + n2 + ", " + JdbcPreparedStatement.quoteDate(date) + ");");
            }
            Value value = date == null ? ValueNull.INSTANCE : ValueDate.get(date);
            this.setParameter(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTime(int n2, Time time) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTime(" + n2 + ", " + JdbcPreparedStatement.quoteTime(time) + ");");
            }
            Value value = time == null ? ValueNull.INSTANCE : ValueTime.get(time);
            this.setParameter(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTimestamp(" + n2 + ", " + JdbcPreparedStatement.quoteTimestamp(timestamp) + ");");
            }
            Value value = timestamp == null ? ValueNull.INSTANCE : ValueTimestamp.get(timestamp);
            this.setParameter(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setObject(int n2, Object object) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + n2 + ", x);");
            }
            if (object == null) {
                this.setParameter(n2, ValueNull.INSTANCE);
            } else {
                this.setParameter(n2, DataType.convertToValue(this.session, object, -1));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setObject(int n2, Object object, int n3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + n2 + ", x, " + n3 + ");");
            }
            int n4 = DataType.convertSQLTypeToValueType(n3);
            if (object == null) {
                this.setParameter(n2, ValueNull.INSTANCE);
            } else {
                Value value = DataType.convertToValue(this.conn.getSession(), object, n4);
                this.setParameter(n2, value.convertTo(n4));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + n2 + ", x, " + n3 + ", " + n4 + ");");
            }
            this.setObject(n2, object, n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setBoolean(int n2, boolean bl2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBoolean(" + n2 + ", " + bl2 + ");");
            }
            this.setParameter(n2, ValueBoolean.get(bl2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setByte(int n2, byte by2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setByte(" + n2 + ", " + by2 + ");");
            }
            this.setParameter(n2, ValueByte.get(by2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setShort(int n2, short s2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setShort(" + n2 + ", (short) " + s2 + ");");
            }
            this.setParameter(n2, ValueShort.get(s2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setLong(int n2, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setLong(" + n2 + ", " + l2 + "L);");
            }
            this.setParameter(n2, ValueLong.get(l2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setFloat(int n2, float f2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setFloat(" + n2 + ", " + f2 + "f);");
            }
            this.setParameter(n2, ValueFloat.get(f2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setDouble(int n2, double d2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDouble(" + n2 + ", " + d2 + "d);");
            }
            this.setParameter(n2, ValueDouble.get(d2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setRef(int n2, Ref ref) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDate(" + n2 + ", " + JdbcPreparedStatement.quoteDate(date) + ", calendar);");
            }
            if (date == null) {
                this.setParameter(n2, ValueNull.INSTANCE);
            } else {
                this.setParameter(n2, DateTimeUtils.convertDate(date, calendar));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTime(" + n2 + ", " + JdbcPreparedStatement.quoteTime(time) + ", calendar);");
            }
            if (time == null) {
                this.setParameter(n2, ValueNull.INSTANCE);
            } else {
                this.setParameter(n2, DateTimeUtils.convertTime(time, calendar));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTimestamp(" + n2 + ", " + JdbcPreparedStatement.quoteTimestamp(timestamp) + ", calendar);");
            }
            if (timestamp == null) {
                this.setParameter(n2, ValueNull.INSTANCE);
            } else {
                this.setParameter(n2, DateTimeUtils.convertTimestamp(timestamp, calendar));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        throw this.unsupported("unicodeStream");
    }

    @Override
    public void setNull(int n2, int n3, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNull(" + n2 + ", " + n3 + ", " + JdbcPreparedStatement.quote(string) + ");");
            }
            this.setNull(n2, n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int n2, Blob blob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + n2 + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = blob == null ? ValueNull.INSTANCE : this.conn.createBlob(blob.getBinaryStream(), -1L);
                this.setParameter(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int n2, InputStream inputStream) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + n2 + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createBlob(inputStream, -1L);
                this.setParameter(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int n2, Clob clob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + n2 + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = clob == null ? ValueNull.INSTANCE : this.conn.createClob(clob.getCharacterStream(), -1L);
                this.setParameter(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int n2, Reader reader) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + n2 + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = reader == null ? ValueNull.INSTANCE : this.conn.createClob(reader, -1L);
                this.setParameter(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setArray(int n2, Array array) throws SQLException {
        throw this.unsupported("setArray");
    }

    @Override
    public void setBytes(int n2, byte[] byArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBytes(" + n2 + ", " + JdbcPreparedStatement.quoteBytes(byArray) + ");");
            }
            Value value = byArray == null ? ValueNull.INSTANCE : ValueBytes.get(byArray);
            this.setParameter(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBinaryStream(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createBlob(inputStream, l2);
                this.setParameter(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.setBinaryStream(n2, inputStream, (long)n3);
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.setBinaryStream(n2, inputStream, -1);
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.setAsciiStream(n2, inputStream, (long)n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setAsciiStream(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(IOUtils.getAsciiReader(inputStream), l2);
                this.setParameter(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.setAsciiStream(n2, inputStream, -1);
    }

    @Override
    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.setCharacterStream(n2, reader, (long)n3);
    }

    @Override
    public void setCharacterStream(int n2, Reader reader) throws SQLException {
        this.setCharacterStream(n2, reader, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setCharacterStream(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(reader, l2);
                this.setParameter(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setURL(int n2, URL uRL) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            this.debugCodeCall("getMetaData");
            this.checkClosed();
            ResultInterface resultInterface = this.command.getMetaData();
            if (resultInterface == null) {
                return null;
            }
            int n2 = JdbcPreparedStatement.getNextId(5);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSetMetaData", 5, n2, "getMetaData()");
            }
            String string = this.conn.getCatalog();
            JdbcResultSetMetaData jdbcResultSetMetaData = new JdbcResultSetMetaData(null, this, resultInterface, string, this.session.getTrace(), n2);
            return jdbcResultSetMetaData;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.debugCodeCall("clearBatch");
            this.checkClosed();
            this.batchParameters = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            super.close();
            this.batchParameters = null;
            if (this.command != null) {
                this.command.close();
                this.command = null;
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        int n2 = JdbcPreparedStatement.getNextId(3);
        this.debugCodeCall("executeBatch");
        if (this.batchParameters == null) {
            this.batchParameters = New.arrayList();
        }
        this.batchIdentities = New.arrayList();
        int n3 = this.batchParameters.size();
        int[] nArray2 = new int[n3];
        boolean bl2 = false;
        Object object = null;
        this.checkClosedForWrite();
        try {
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object2;
                Value[] valueArray = this.batchParameters.get(i2);
                ArrayList<? extends ParameterInterface> arrayList = this.command.getParameters();
                for (int i3 = 0; i3 < valueArray.length; ++i3) {
                    object2 = valueArray[i3];
                    ParameterInterface parameterInterface = arrayList.get(i3);
                    parameterInterface.setValue((Value)object2, false);
                }
                try {
                    nArray2[i2] = this.executeUpdateInternal();
                    ResultSet resultSet = this.conn.getGeneratedKeys(this, n2);
                    while (resultSet.next()) {
                        this.batchIdentities.add(resultSet.getObject(1));
                    }
                    continue;
                }
                catch (Exception exception) {
                    object2 = this.logAndConvert(exception);
                    if (object == null) {
                        object = object2;
                    } else {
                        ((SQLException)object2).setNextException((SQLException)object);
                        object = object2;
                    }
                    nArray2[i2] = -3;
                    bl2 = true;
                }
            }
            this.batchParameters = null;
            if (bl2) {
                JdbcBatchUpdateException jdbcBatchUpdateException = new JdbcBatchUpdateException((SQLException)object, nArray2);
                throw jdbcBatchUpdateException;
            }
            nArray = nArray2;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
        this.afterWriting();
        return nArray;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.batchIdentities != null && !this.batchIdentities.isEmpty()) {
            SimpleResultSet simpleResultSet = new SimpleResultSet();
            simpleResultSet.addColumn("identity", 4, 10, 0);
            for (Object object : this.batchIdentities) {
                simpleResultSet.addRow(object);
            }
            return simpleResultSet;
        }
        return super.getGeneratedKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        try {
            this.debugCodeCall("addBatch");
            this.checkClosedForWrite();
            try {
                ArrayList<? extends ParameterInterface> arrayList = this.command.getParameters();
                int n2 = arrayList.size();
                Value[] valueArray = new Value[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    Value value;
                    ParameterInterface parameterInterface = arrayList.get(i2);
                    valueArray[i2] = value = parameterInterface.getParamValue();
                }
                if (this.batchParameters == null) {
                    this.batchParameters = New.arrayList();
                }
                this.batchParameters.add(valueArray);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int executeUpdate(String string, int n2) throws SQLException {
        try {
            this.debugCode("executeUpdate(" + JdbcPreparedStatement.quote(string) + ", " + n2 + ");");
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            this.debugCode("executeUpdate(" + JdbcPreparedStatement.quote(string) + ", " + JdbcPreparedStatement.quoteIntArray(nArray) + ");");
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            this.debugCode("executeUpdate(" + JdbcPreparedStatement.quote(string) + ", " + JdbcPreparedStatement.quoteArray(stringArray) + ");");
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean execute(String string, int n2) throws SQLException {
        try {
            this.debugCode("execute(" + JdbcPreparedStatement.quote(string) + ", " + n2 + ");");
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        try {
            this.debugCode("execute(" + JdbcPreparedStatement.quote(string) + ", " + JdbcPreparedStatement.quoteIntArray(nArray) + ");");
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            this.debugCode("execute(" + JdbcPreparedStatement.quote(string) + ", " + JdbcPreparedStatement.quoteArray(stringArray) + ");");
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            int n2 = JdbcPreparedStatement.getNextId(11);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ParameterMetaData", 11, n2, "getParameterMetaData()");
            }
            this.checkClosed();
            JdbcParameterMetaData jdbcParameterMetaData = new JdbcParameterMetaData(this.session.getTrace(), this, this.command, n2);
            return jdbcParameterMetaData;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private void setParameter(int n2, Value value) {
        this.checkClosed();
        ArrayList<? extends ParameterInterface> arrayList = this.command.getParameters();
        if (--n2 < 0 || n2 >= arrayList.size()) {
            throw DbException.getInvalidValueException("parameterIndex", n2 + 1);
        }
        ParameterInterface parameterInterface = arrayList.get(n2);
        parameterInterface.setValue(value, this.batchParameters == null);
    }

    @Override
    public void setRowId(int n2, RowId rowId) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public void setNString(int n2, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNString(" + n2 + ", " + JdbcPreparedStatement.quote(string) + ");");
            }
            Value value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
            this.setParameter(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNCharacterStream(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(reader, l2);
                this.setParameter(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader) throws SQLException {
        this.setNCharacterStream(n2, reader, -1L);
    }

    @Override
    public void setNClob(int n2, NClob nClob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNClob(" + n2 + ", x);");
            }
            this.checkClosedForWrite();
            Value value = nClob == null ? ValueNull.INSTANCE : this.conn.createClob(nClob.getCharacterStream(), -1L);
            this.setParameter(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int n2, Reader reader) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNClob(" + n2 + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(reader, -1L);
                this.setParameter(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(reader, l2);
                this.setParameter(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createBlob(inputStream, l2);
                this.setParameter(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNClob(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(reader, l2);
                this.setParameter(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public String toString() {
        return this.getTraceObjectName() + ": " + this.command;
    }

    @Override
    protected boolean checkClosed(boolean bl2) {
        if (super.checkClosed(bl2)) {
            ArrayList<? extends ParameterInterface> arrayList = this.command.getParameters();
            this.command = this.conn.prepareCommand(this.sqlStatement, this.fetchSize);
            ArrayList<? extends ParameterInterface> arrayList2 = this.command.getParameters();
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ParameterInterface parameterInterface = arrayList.get(i2);
                Value value = parameterInterface.getParamValue();
                if (value == null) continue;
                ParameterInterface parameterInterface2 = arrayList2.get(i2);
                parameterInterface2.setValue(value, false);
            }
            return true;
        }
        return false;
    }
}

