/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.command.CommandInterface;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.util.MathUtils;
import org.h2.value.DataType;

public class JdbcParameterMetaData
extends TraceObject
implements ParameterMetaData {
    private final JdbcPreparedStatement prep;
    private final int paramCount;
    private final ArrayList<? extends ParameterInterface> parameters;

    JdbcParameterMetaData(Trace trace, JdbcPreparedStatement jdbcPreparedStatement, CommandInterface commandInterface, int n2) {
        this.setTrace(trace, 11, n2);
        this.prep = jdbcPreparedStatement;
        this.parameters = commandInterface.getParameters();
        this.paramCount = this.parameters.size();
    }

    @Override
    public int getParameterCount() throws SQLException {
        try {
            this.debugCodeCall("getParameterCount");
            this.checkClosed();
            return this.paramCount;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getParameterMode(int n2) throws SQLException {
        try {
            this.debugCodeCall("getParameterMode", n2);
            this.getParameter(n2);
            return 1;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getParameterType(int n2) throws SQLException {
        try {
            this.debugCodeCall("getParameterType", n2);
            ParameterInterface parameterInterface = this.getParameter(n2);
            int n3 = parameterInterface.getType();
            if (n3 == -1) {
                n3 = 13;
            }
            return DataType.getDataType((int)n3).sqlType;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getPrecision(int n2) throws SQLException {
        try {
            this.debugCodeCall("getPrecision", n2);
            ParameterInterface parameterInterface = this.getParameter(n2);
            return MathUtils.convertLongToInt(parameterInterface.getPrecision());
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getScale(int n2) throws SQLException {
        try {
            this.debugCodeCall("getScale", n2);
            ParameterInterface parameterInterface = this.getParameter(n2);
            return parameterInterface.getScale();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int isNullable(int n2) throws SQLException {
        try {
            this.debugCodeCall("isNullable", n2);
            return this.getParameter(n2).getNullable();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isSigned(int n2) throws SQLException {
        try {
            this.debugCodeCall("isSigned", n2);
            this.getParameter(n2);
            return true;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getParameterClassName(int n2) throws SQLException {
        try {
            this.debugCodeCall("getParameterClassName", n2);
            ParameterInterface parameterInterface = this.getParameter(n2);
            int n3 = parameterInterface.getType();
            if (n3 == -1) {
                n3 = 13;
            }
            return DataType.getTypeClassName(n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getParameterTypeName(int n2) throws SQLException {
        try {
            this.debugCodeCall("getParameterTypeName", n2);
            ParameterInterface parameterInterface = this.getParameter(n2);
            int n3 = parameterInterface.getType();
            if (n3 == -1) {
                n3 = 13;
            }
            return DataType.getDataType((int)n3).name;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private ParameterInterface getParameter(int n2) {
        this.checkClosed();
        if (n2 < 1 || n2 > this.paramCount) {
            throw DbException.getInvalidValueException("param", n2);
        }
        return this.parameters.get(n2 - 1);
    }

    private void checkClosed() {
        this.prep.checkClosed();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw DbException.getInvalidValueException("iface", clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    public String toString() {
        return this.getTraceObjectName() + ": parameterCount=" + this.paramCount;
    }
}

