/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.util.IOUtils;
import org.h2.util.Task;
import org.h2.value.Value;

public class JdbcClob
extends TraceObject
implements NClob {
    Value value;
    private final JdbcConnection conn;

    public JdbcClob(JdbcConnection jdbcConnection, Value value, int n2) {
        this.setTrace(jdbcConnection.getSession().getTrace(), 10, n2);
        this.conn = jdbcConnection;
        this.value = value;
    }

    @Override
    public long length() throws SQLException {
        try {
            long l2;
            this.debugCodeCall("length");
            this.checkClosed();
            if (this.value.getType() == 16 && (l2 = this.value.getPrecision()) > 0L) {
                return l2;
            }
            return IOUtils.copyAndCloseInput(this.value.getReader(), null, Long.MAX_VALUE);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void truncate(long l2) throws SQLException {
        throw this.unsupported("LOB update");
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream");
            this.checkClosed();
            String string = this.value.getString();
            return IOUtils.getInputStreamFromString(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public OutputStream setAsciiStream(long l2) throws SQLException {
        throw this.unsupported("LOB update");
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream");
            this.checkClosed();
            return this.value.getReader();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Writer setCharacterStream(long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("setCharacterStream(" + l2 + ");");
            }
            this.checkClosed();
            if (l2 != 1L) {
                throw DbException.getInvalidValueException("pos", l2);
            }
            if (this.value.getPrecision() != 0L) {
                throw DbException.getInvalidValueException("length", this.value.getPrecision());
            }
            final JdbcConnection jdbcConnection = this.conn;
            final PipedInputStream pipedInputStream = new PipedInputStream();
            final Task task = new Task(){

                @Override
                public void call() {
                    JdbcClob.this.value = jdbcConnection.createClob(IOUtils.getReader(pipedInputStream), -1L);
                }
            };
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream){

                @Override
                public void close() throws IOException {
                    super.close();
                    try {
                        task.get();
                    }
                    catch (Exception exception) {
                        throw DbException.convertToIOException(exception);
                    }
                }
            };
            task.execute();
            return IOUtils.getBufferedWriter(pipedOutputStream);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubString(long l2, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getSubString(" + l2 + ", " + n2 + ");");
            }
            this.checkClosed();
            if (l2 < 1L) {
                throw DbException.getInvalidValueException("pos", l2);
            }
            if (n2 < 0) {
                throw DbException.getInvalidValueException("length", n2);
            }
            StringWriter stringWriter = new StringWriter(Math.min(4096, n2));
            try (Reader reader = this.value.getReader();){
                IOUtils.skipFully(reader, l2 - 1L);
                IOUtils.copyAndCloseInput(reader, stringWriter, n2);
            }
            return stringWriter.toString();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int setString(long l2, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setString(" + l2 + ", " + JdbcClob.quote(string) + ");");
            }
            this.checkClosed();
            if (l2 != 1L) {
                throw DbException.getInvalidValueException("pos", l2);
            }
            if (string == null) {
                throw DbException.getInvalidValueException("str", string);
            }
            this.value = this.conn.createClob(new StringReader(string), -1L);
            return string.length();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        throw this.unsupported("LOB update");
    }

    @Override
    public long position(String string, long l2) throws SQLException {
        throw this.unsupported("LOB search");
    }

    @Override
    public long position(Clob clob, long l2) throws SQLException {
        throw this.unsupported("LOB search");
    }

    @Override
    public void free() {
        this.debugCodeCall("free");
        this.value = null;
    }

    @Override
    public Reader getCharacterStream(long l2, long l3) throws SQLException {
        throw this.unsupported("LOB subset");
    }

    private void checkClosed() {
        this.conn.checkClosed();
        if (this.value == null) {
            throw DbException.get(90007);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + (this.value == null ? "null" : this.value.getTraceSQL());
    }
}

