/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcResultSet;
import org.h2.message.DbException;
import org.h2.util.BitField;
import org.h2.util.New;
import org.h2.value.ValueNull;

public class JdbcCallableStatement
extends JdbcPreparedStatement
implements CallableStatement {
    private BitField outParameters;
    private int maxOutParameters;
    private HashMap<String, Integer> namedParameters;

    JdbcCallableStatement(JdbcConnection jdbcConnection, String string, int n2, int n3, int n4) {
        super(jdbcConnection, string, n2, n3, n4, false);
        this.setTrace(this.session.getTrace(), 0, n2);
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            this.checkClosed();
            if (this.command.isQuery()) {
                super.executeQuery();
                return 0;
            }
            return super.executeUpdate();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void registerOutParameter(int n2, int n3) throws SQLException {
        this.registerOutParameter(n2);
    }

    @Override
    public void registerOutParameter(int n2, int n3, String string) throws SQLException {
        this.registerOutParameter(n2);
    }

    @Override
    public void registerOutParameter(int n2, int n3, int n4) throws SQLException {
        this.registerOutParameter(n2);
    }

    @Override
    public void registerOutParameter(String string, int n2, String string2) throws SQLException {
        this.registerOutParameter(this.getIndexForName(string), n2, string2);
    }

    @Override
    public void registerOutParameter(String string, int n2, int n3) throws SQLException {
        this.registerOutParameter(this.getIndexForName(string), n2, n3);
    }

    @Override
    public void registerOutParameter(String string, int n2) throws SQLException {
        this.registerOutParameter(this.getIndexForName(string), n2);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.getOpenResultSet().wasNull();
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public String getString(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getString(n2);
    }

    @Override
    public boolean getBoolean(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getBoolean(n2);
    }

    @Override
    public byte getByte(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getByte(n2);
    }

    @Override
    public short getShort(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getShort(n2);
    }

    @Override
    public int getInt(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getInt(n2);
    }

    @Override
    public long getLong(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getLong(n2);
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getFloat(n2);
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getDouble(n2);
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getBigDecimal(n2, n3);
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getBytes(n2);
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getDate(n2);
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getTime(n2);
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getTimestamp(n2);
    }

    @Override
    public Object getObject(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getObject(n2);
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getBigDecimal(n2);
    }

    @Override
    public Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        throw this.unsupported("map");
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getBlob(n2);
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getClob(n2);
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getArray(n2);
    }

    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getDate(n2, calendar);
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getTime(n2, calendar);
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getTimestamp(n2, calendar);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.getIndexForName(string), calendar);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.getIndexForName(string), calendar);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.getIndexForName(string), calendar);
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.getIndexForName(string));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.getIndexForName(string));
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.getIndexForName(string));
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        throw this.unsupported("map");
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.getIndexForName(string));
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.getIndexForName(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.getIndexForName(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.getIndexForName(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.getIndexForName(string));
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.getIndexForName(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.getIndexForName(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.getIndexForName(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.getIndexForName(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.getIndexForName(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.getIndexForName(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.getIndexForName(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.getIndexForName(string));
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.getIndexForName(string));
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getNClob(n2);
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.getIndexForName(string));
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public String getNString(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getNString(n2);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getNString(this.getIndexForName(string));
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getNCharacterStream(n2);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.getIndexForName(string));
    }

    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        this.checkRegistered(n2);
        return this.getOpenResultSet().getCharacterStream(n2);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.getIndexForName(string));
    }

    @Override
    public void setNull(String string, int n2, String string2) throws SQLException {
        this.setNull(this.getIndexForName(string), n2, string2);
    }

    @Override
    public void setNull(String string, int n2) throws SQLException {
        this.setNull(this.getIndexForName(string), n2);
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(this.getIndexForName(string), timestamp, calendar);
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.setTime(this.getIndexForName(string), time, calendar);
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.setDate(this.getIndexForName(string), date, calendar);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.setCharacterStream(this.getIndexForName(string), reader, n2);
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        this.setObject(this.getIndexForName(string), object);
    }

    @Override
    public void setObject(String string, Object object, int n2) throws SQLException {
        this.setObject(this.getIndexForName(string), object, n2);
    }

    @Override
    public void setObject(String string, Object object, int n2, int n3) throws SQLException {
        this.setObject(this.getIndexForName(string), object, n2, n3);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStream(this.getIndexForName(string), inputStream, n2);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        this.setAsciiStream(this.getIndexForName(string), inputStream, l2);
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.setTimestamp(this.getIndexForName(string), timestamp);
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        this.setTime(this.getIndexForName(string), time);
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        this.setDate(this.getIndexForName(string), date);
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.setBytes(this.getIndexForName(string), byArray);
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        this.setString(this.getIndexForName(string), string2);
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimal(this.getIndexForName(string), bigDecimal);
    }

    @Override
    public void setDouble(String string, double d2) throws SQLException {
        this.setDouble(this.getIndexForName(string), d2);
    }

    @Override
    public void setFloat(String string, float f2) throws SQLException {
        this.setFloat(this.getIndexForName(string), f2);
    }

    @Override
    public void setLong(String string, long l2) throws SQLException {
        this.setLong(this.getIndexForName(string), l2);
    }

    @Override
    public void setInt(String string, int n2) throws SQLException {
        this.setInt(this.getIndexForName(string), n2);
    }

    @Override
    public void setShort(String string, short s2) throws SQLException {
        this.setShort(this.getIndexForName(string), s2);
    }

    @Override
    public void setByte(String string, byte by2) throws SQLException {
        this.setByte(this.getIndexForName(string), by2);
    }

    @Override
    public void setBoolean(String string, boolean bl2) throws SQLException {
        this.setBoolean(this.getIndexForName(string), bl2);
    }

    @Override
    public void setURL(String string, URL uRL) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        this.setNString(this.getIndexForName(string), string2);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        this.setNCharacterStream(this.getIndexForName(string), reader, l2);
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        this.setNClob(this.getIndexForName(string), nClob);
    }

    @Override
    public void setClob(String string, Reader reader, long l2) throws SQLException {
        this.setClob(this.getIndexForName(string), reader, l2);
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l2) throws SQLException {
        this.setBlob(this.getIndexForName(string), inputStream, l2);
    }

    @Override
    public void setNClob(String string, Reader reader, long l2) throws SQLException {
        this.setNClob(this.getIndexForName(string), reader, l2);
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        this.setBlob(this.getIndexForName(string), blob);
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        this.setClob(this.getIndexForName(string), clob);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.setAsciiStream(this.getIndexForName(string), inputStream);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.setAsciiStream(this.getIndexForName(string), inputStream, n2);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.setBinaryStream(this.getIndexForName(string), inputStream);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        this.setBinaryStream(this.getIndexForName(string), inputStream, l2);
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        this.setBlob(this.getIndexForName(string), inputStream);
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        this.setCharacterStream(this.getIndexForName(string), reader);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, long l2) throws SQLException {
        this.setCharacterStream(this.getIndexForName(string), reader, l2);
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        this.setClob(this.getIndexForName(string), reader);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        this.setNCharacterStream(this.getIndexForName(string), reader);
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        this.setNClob(this.getIndexForName(string), reader);
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public <T> T getObject(int n2, Class<T> clazz) {
        return null;
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) {
        return null;
    }

    private ResultSetMetaData getCheckedMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        if (resultSetMetaData == null) {
            throw DbException.getUnsupportedException("Supported only for calling stored procedures");
        }
        return resultSetMetaData;
    }

    private void checkIndexBounds(int n2) {
        this.checkClosed();
        if (n2 < 1 || n2 > this.maxOutParameters) {
            throw DbException.getInvalidValueException("parameterIndex", n2);
        }
    }

    private void registerOutParameter(int n2) throws SQLException {
        try {
            this.checkClosed();
            if (this.outParameters == null) {
                this.maxOutParameters = Math.min(this.getParameterMetaData().getParameterCount(), this.getCheckedMetaData().getColumnCount());
                this.outParameters = new BitField();
            }
            this.checkIndexBounds(n2);
            ParameterInterface parameterInterface = this.command.getParameters().get(--n2);
            if (!parameterInterface.isValueSet()) {
                parameterInterface.setValue(ValueNull.INSTANCE, false);
            }
            this.outParameters.set(n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private void checkRegistered(int n2) throws SQLException {
        try {
            this.checkIndexBounds(n2);
            if (!this.outParameters.get(n2 - 1)) {
                throw DbException.getInvalidValueException("parameterIndex", n2);
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private int getIndexForName(String string) throws SQLException {
        try {
            Object object;
            this.checkClosed();
            if (this.namedParameters == null) {
                object = this.getCheckedMetaData();
                int n2 = object.getColumnCount();
                HashMap<String, Integer> hashMap = New.hashMap(n2);
                for (int i2 = 1; i2 <= n2; ++i2) {
                    hashMap.put(object.getColumnLabel(i2), i2);
                }
                this.namedParameters = hashMap;
            }
            if ((object = this.namedParameters.get(string)) == null) {
                throw DbException.getInvalidValueException("parameterName", string);
            }
            return (Integer)object;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private JdbcResultSet getOpenResultSet() throws SQLException {
        try {
            this.checkClosed();
            if (this.resultSet == null) {
                throw DbException.get(2000);
            }
            if (this.resultSet.isBeforeFirst()) {
                this.resultSet.next();
            }
            return this.resultSet;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }
}

