/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.util.IOUtils;
import org.h2.util.Task;
import org.h2.value.Value;

public class JdbcBlob
extends TraceObject
implements Blob {
    Value value;
    private final JdbcConnection conn;

    public JdbcBlob(JdbcConnection jdbcConnection, Value value, int n2) {
        this.setTrace(jdbcConnection.getSession().getTrace(), 9, n2);
        this.conn = jdbcConnection;
        this.value = value;
    }

    @Override
    public long length() throws SQLException {
        try {
            long l2;
            this.debugCodeCall("length");
            this.checkClosed();
            if (this.value.getType() == 15 && (l2 = this.value.getPrecision()) > 0L) {
                return l2;
            }
            return IOUtils.copyAndCloseInput(this.value.getInputStream(), null);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void truncate(long l2) throws SQLException {
        throw this.unsupported("LOB update");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(long l2, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getBytes(" + l2 + ", " + n2 + ");");
            }
            this.checkClosed();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (InputStream inputStream = this.value.getInputStream();){
                IOUtils.skipFully(inputStream, l2 - 1L);
                IOUtils.copy(inputStream, byteArrayOutputStream, n2);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int setBytes(long l2, byte[] byArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBytes(" + l2 + ", " + JdbcBlob.quoteBytes(byArray) + ");");
            }
            this.checkClosed();
            if (l2 != 1L) {
                throw DbException.getInvalidValueException("pos", l2);
            }
            this.value = this.conn.createBlob(new ByteArrayInputStream(byArray), -1L);
            return byArray.length;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        throw this.unsupported("LOB update");
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream");
            this.checkClosed();
            return this.value.getInputStream();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public OutputStream setBinaryStream(long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBinaryStream(" + l2 + ");");
            }
            this.checkClosed();
            if (l2 != 1L) {
                throw DbException.getInvalidValueException("pos", l2);
            }
            if (this.value.getPrecision() != 0L) {
                throw DbException.getInvalidValueException("length", this.value.getPrecision());
            }
            final JdbcConnection jdbcConnection = this.conn;
            final PipedInputStream pipedInputStream = new PipedInputStream();
            final Task task = new Task(){

                @Override
                public void call() {
                    JdbcBlob.this.value = jdbcConnection.createBlob(pipedInputStream, -1L);
                }
            };
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream){

                @Override
                public void close() throws IOException {
                    super.close();
                    try {
                        task.get();
                    }
                    catch (Exception exception) {
                        throw DbException.convertToIOException(exception);
                    }
                }
            };
            task.execute();
            return new BufferedOutputStream(pipedOutputStream);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long position(byte[] byArray, long l2) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("position(" + JdbcBlob.quoteBytes(byArray) + ", " + l2 + ");");
        }
        throw this.unsupported("LOB search");
    }

    @Override
    public long position(Blob blob, long l2) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("position(blobPattern, " + l2 + ");");
        }
        throw this.unsupported("LOB subset");
    }

    @Override
    public void free() {
        this.debugCodeCall("free");
        this.value = null;
    }

    @Override
    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        throw this.unsupported("LOB update");
    }

    private void checkClosed() {
        this.conn.checkClosed();
        if (this.value == null) {
            throw DbException.get(90007);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + (this.value == null ? "null" : this.value.getTraceSQL());
    }
}

