/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.tools.SimpleResultSet;
import org.h2.value.Value;

public class JdbcArray
extends TraceObject
implements Array {
    private Value value;
    private final JdbcConnection conn;

    JdbcArray(JdbcConnection jdbcConnection, Value value, int n2) {
        this.setTrace(jdbcConnection.getSession().getTrace(), 16, n2);
        this.conn = jdbcConnection;
        this.value = value;
    }

    @Override
    public Object getArray() throws SQLException {
        try {
            this.debugCodeCall("getArray");
            this.checkClosed();
            return this.get();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        try {
            this.debugCode("getArray(" + JdbcArray.quoteMap(map) + ");");
            JdbcConnection.checkMap(map);
            this.checkClosed();
            return this.get();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Object getArray(long l2, int n2) throws SQLException {
        try {
            this.debugCode("getArray(" + l2 + ", " + n2 + ");");
            this.checkClosed();
            return this.get(l2, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Object getArray(long l2, int n2, Map<String, Class<?>> map) throws SQLException {
        try {
            this.debugCode("getArray(" + l2 + ", " + n2 + ", " + JdbcArray.quoteMap(map) + ");");
            this.checkClosed();
            JdbcConnection.checkMap(map);
            return this.get(l2, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getBaseType() throws SQLException {
        try {
            this.debugCodeCall("getBaseType");
            this.checkClosed();
            return 0;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        try {
            this.debugCodeCall("getBaseTypeName");
            this.checkClosed();
            return "NULL";
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            this.debugCodeCall("getResultSet");
            this.checkClosed();
            return JdbcArray.getResultSet(this.get(), 0L);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        try {
            this.debugCode("getResultSet(" + JdbcArray.quoteMap(map) + ");");
            this.checkClosed();
            JdbcConnection.checkMap(map);
            return JdbcArray.getResultSet(this.get(), 0L);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getResultSet(long l2, int n2) throws SQLException {
        try {
            this.debugCode("getResultSet(" + l2 + ", " + n2 + ");");
            this.checkClosed();
            return JdbcArray.getResultSet(this.get(l2, n2), l2 - 1L);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getResultSet(long l2, int n2, Map<String, Class<?>> map) throws SQLException {
        try {
            this.debugCode("getResultSet(" + l2 + ", " + n2 + ", " + JdbcArray.quoteMap(map) + ");");
            this.checkClosed();
            JdbcConnection.checkMap(map);
            return JdbcArray.getResultSet(this.get(l2, n2), l2 - 1L);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void free() {
        this.debugCodeCall("free");
        this.value = null;
    }

    private static ResultSet getResultSet(Object[] objectArray, long l2) {
        SimpleResultSet simpleResultSet = new SimpleResultSet();
        simpleResultSet.addColumn("INDEX", -5, 0, 0);
        simpleResultSet.addColumn("VALUE", 0, 0, 0);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            simpleResultSet.addRow(l2 + (long)i2 + 1L, objectArray[i2]);
        }
        return simpleResultSet;
    }

    private void checkClosed() {
        this.conn.checkClosed();
        if (this.value == null) {
            throw DbException.get(90007);
        }
    }

    private Object[] get() {
        return (Object[])this.value.convertTo(17).getObject();
    }

    private Object[] get(long l2, int n2) {
        Object[] objectArray = this.get();
        if (n2 < 0 || n2 > objectArray.length) {
            throw DbException.getInvalidValueException("count (1.." + objectArray.length + ")", n2);
        }
        if (l2 < 1L || l2 > (long)objectArray.length) {
            throw DbException.getInvalidValueException("index (1.." + objectArray.length + ")", l2);
        }
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, (int)(l2 - 1L), objectArray2, 0, n2);
        return objectArray2;
    }

    public String toString() {
        return this.value == null ? "null" : this.getTraceObjectName() + ": " + this.value.getTraceSQL();
    }
}

