/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.ScanCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.table.TableFilter;
import org.h2.util.New;

public class ScanIndex
extends BaseIndex {
    private long firstFree = -1L;
    private ArrayList<Row> rows = New.arrayList();
    private final RegularTable tableData;
    private int rowCountDiff;
    private final HashMap<Integer, Integer> sessionRowCount;
    private HashSet<Row> delta;
    private long rowCount;

    public ScanIndex(RegularTable regularTable, int n2, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initBaseIndex(regularTable, n2, regularTable.getName() + "_DATA", indexColumnArray, indexType);
        this.sessionRowCount = this.database.isMultiVersion() ? New.hashMap() : null;
        this.tableData = regularTable;
    }

    @Override
    public void remove(Session session) {
        this.truncate(session);
    }

    @Override
    public void truncate(Session session) {
        this.rows = New.arrayList();
        this.firstFree = -1L;
        if (this.tableData.getContainsLargeObject() && this.tableData.isPersistData()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        this.tableData.setRowCount(0L);
        this.rowCount = 0L;
        this.rowCountDiff = 0;
        if (this.database.isMultiVersion()) {
            this.sessionRowCount.clear();
        }
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public Row getRow(Session session, long l2) {
        return this.rows.get((int)l2);
    }

    @Override
    public void add(Session session, Row row) {
        int n2;
        if (this.firstFree == -1L) {
            n2 = this.rows.size();
            row.setKey(n2);
            this.rows.add(row);
        } else {
            long l2 = this.firstFree;
            Row row2 = this.rows.get((int)l2);
            this.firstFree = row2.getKey();
            row.setKey(l2);
            this.rows.set((int)l2, row);
        }
        row.setDeleted(false);
        if (this.database.isMultiVersion()) {
            if (this.delta == null) {
                this.delta = New.hashSet();
            }
            if ((n2 = (int)(this.delta.remove(row) ? 1 : 0)) == 0) {
                this.delta.add(row);
            }
            this.incrementRowCount(session.getId(), 1);
        }
        ++this.rowCount;
    }

    @Override
    public void commit(int n2, Row row) {
        if (this.database.isMultiVersion()) {
            if (this.delta != null) {
                this.delta.remove(row);
            }
            this.incrementRowCount(row.getSessionId(), n2 == 1 ? 1 : -1);
        }
    }

    private void incrementRowCount(int n2, int n3) {
        if (this.database.isMultiVersion()) {
            Integer n4 = n2;
            Integer n5 = this.sessionRowCount.get(n4);
            int n6 = n5 == null ? 0 : n5;
            this.sessionRowCount.put(n4, n6 + n3);
            this.rowCountDiff += n3;
        }
    }

    @Override
    public void remove(Session session, Row row) {
        if (!this.database.isMultiVersion() && this.rowCount == 1L) {
            this.rows = New.arrayList();
            this.firstFree = -1L;
        } else {
            Row row2 = session.createRow(null, 1);
            row2.setKey(this.firstFree);
            long l2 = row.getKey();
            if ((long)this.rows.size() <= l2) {
                throw DbException.get(90112, this.rows.size() + ": " + l2);
            }
            this.rows.set((int)l2, row2);
            this.firstFree = l2;
        }
        if (this.database.isMultiVersion()) {
            boolean bl2;
            row.setDeleted(true);
            if (this.delta == null) {
                this.delta = New.hashSet();
            }
            if (!(bl2 = this.delta.remove(row))) {
                this.delta.add(row);
            }
            this.incrementRowCount(session.getId(), -1);
        }
        --this.rowCount;
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return new ScanCursor(session, this, this.database.isMultiVersion());
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n2, SortOrder sortOrder, HashSet<Column> hashSet) {
        return this.tableData.getRowCountApproximation() + 1000L;
    }

    @Override
    public long getRowCount(Session session) {
        if (this.database.isMultiVersion()) {
            Integer n2 = this.sessionRowCount.get(session.getId());
            long l2 = n2 == null ? 0L : (long)n2.intValue();
            l2 += this.rowCount;
            return l2 -= (long)this.rowCountDiff;
        }
        return this.rowCount;
    }

    Row getNextRow(Row row) {
        long l2 = row == null ? -1L : row.getKey();
        do {
            if (++l2 < (long)this.rows.size()) continue;
            return null;
        } while ((row = this.rows.get((int)l2)).isEmpty());
        return row;
    }

    @Override
    public int getColumnIndex(Column column) {
        return -1;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("SCAN");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl2) {
        throw DbException.getUnsupportedException("SCAN");
    }

    Iterator<Row> getDelta() {
        if (this.delta == null) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.delta.iterator();
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public String getPlanSQL() {
        return this.table.getSQL() + ".tableScan";
    }
}

