/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.HashSet;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.RangeCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RangeTable;
import org.h2.table.TableFilter;

public class RangeIndex
extends BaseIndex {
    private final RangeTable rangeTable;

    public RangeIndex(RangeTable rangeTable, IndexColumn[] indexColumnArray) {
        this.initBaseIndex(rangeTable, 0, "RANGE_INDEX", indexColumnArray, IndexType.createNonUnique(true));
        this.rangeTable = rangeTable;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public void remove(Session session, Row row) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        long l2;
        long l3;
        long l4 = l3 = this.rangeTable.getMin(session);
        long l5 = l2 = this.rangeTable.getMax(session);
        long l6 = this.rangeTable.getStep(session);
        try {
            l4 = Math.max(l3, searchRow == null ? l3 : searchRow.getValue(0).getLong());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            l5 = Math.min(l2, searchRow2 == null ? l2 : searchRow2.getValue(0).getLong());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new RangeCursor(session, l4, l5, l6);
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n2, SortOrder sortOrder, HashSet<Column> hashSet) {
        return 1.0;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public void remove(Session session) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl2) {
        long l2 = bl2 ? this.rangeTable.getMin(session) : this.rangeTable.getMax(session);
        return new RangeCursor(session, l2, l2);
    }

    @Override
    public long getRowCount(Session session) {
        return this.rangeTable.getRowCountApproximation();
    }

    @Override
    public long getRowCountApproximation() {
        return this.rangeTable.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }
}

