/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.PageDataLeaf;
import org.h2.message.DbException;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;

public class PageDataOverflow
extends Page {
    static final int START_LAST = 9;
    static final int START_MORE = 11;
    private static final int START_NEXT_OVERFLOW = 7;
    private final PageStore store;
    private int type;
    private int parentPageId;
    private int nextPage;
    private final Data data;
    private int start;
    private int size;

    private PageDataOverflow(PageStore pageStore, int n2, Data data) {
        this.store = pageStore;
        this.setPos(n2);
        this.data = data;
    }

    public static Page read(PageStore pageStore, Data data, int n2) {
        PageDataOverflow pageDataOverflow = new PageDataOverflow(pageStore, n2, data);
        pageDataOverflow.read();
        return pageDataOverflow;
    }

    static PageDataOverflow create(PageStore pageStore, int n2, int n3, int n4, int n5, Data data, int n6, int n7) {
        Data data2 = pageStore.createData();
        PageDataOverflow pageDataOverflow = new PageDataOverflow(pageStore, n2, data2);
        pageStore.logUndo(pageDataOverflow, null);
        data2.writeByte((byte)n3);
        data2.writeShortInt(0);
        data2.writeInt(n4);
        if (n3 == 3) {
            data2.writeInt(n5);
        } else {
            data2.writeShortInt(n7);
        }
        pageDataOverflow.start = data2.length();
        data2.write(data.getBytes(), n6, n7);
        pageDataOverflow.type = n3;
        pageDataOverflow.parentPageId = n4;
        pageDataOverflow.nextPage = n5;
        pageDataOverflow.size = n7;
        return pageDataOverflow;
    }

    private void read() {
        this.data.reset();
        this.type = this.data.readByte();
        this.data.readShortInt();
        this.parentPageId = this.data.readInt();
        if (this.type == 19) {
            this.size = this.data.readShortInt();
            this.nextPage = 0;
        } else if (this.type == 3) {
            this.nextPage = this.data.readInt();
            this.size = this.store.getPageSize() - this.data.length();
        } else {
            throw DbException.get(90030, "page:" + this.getPos() + " type:" + this.type);
        }
        this.start = this.data.length();
    }

    int readInto(Data data) {
        data.checkCapacity(this.size);
        if (this.type == 19) {
            data.write(this.data.getBytes(), 9, this.size);
            return 0;
        }
        data.write(this.data.getBytes(), 11, this.size);
        return this.nextPage;
    }

    int getNextOverflow() {
        return this.nextPage;
    }

    private void writeHead() {
        this.data.writeByte((byte)this.type);
        this.data.writeShortInt(0);
        this.data.writeInt(this.parentPageId);
    }

    @Override
    public void write() {
        this.writeData();
        this.store.writePage(this.getPos(), this.data);
    }

    private void writeData() {
        this.data.reset();
        this.writeHead();
        if (this.type == 3) {
            this.data.writeInt(this.nextPage);
        } else {
            this.data.writeShortInt(this.size);
        }
    }

    public String toString() {
        return "page[" + this.getPos() + "] data leaf overflow parent:" + this.parentPageId + " next:" + this.nextPage;
    }

    @Override
    public int getMemory() {
        return 120 + this.store.getPageSize() >> 2;
    }

    void setParentPageId(int n2) {
        this.store.logUndo(this, this.data);
        this.parentPageId = n2;
    }

    @Override
    public void moveTo(Session session, int n2) {
        Page page = this.store.getPage(this.parentPageId);
        if (page == null) {
            throw DbException.throwInternalError();
        }
        PageDataOverflow pageDataOverflow = null;
        if (this.nextPage != 0) {
            pageDataOverflow = (PageDataOverflow)this.store.getPage(this.nextPage);
        }
        this.store.logUndo(this, this.data);
        PageDataOverflow pageDataOverflow2 = PageDataOverflow.create(this.store, n2, this.type, this.parentPageId, this.nextPage, this.data, this.start, this.size);
        this.store.update(pageDataOverflow2);
        if (pageDataOverflow != null) {
            pageDataOverflow.setParentPageId(n2);
            this.store.update(pageDataOverflow);
        }
        if (page instanceof PageDataOverflow) {
            PageDataOverflow pageDataOverflow3 = (PageDataOverflow)page;
            pageDataOverflow3.setNext(this.getPos(), n2);
        } else {
            PageDataLeaf pageDataLeaf = (PageDataLeaf)page;
            pageDataLeaf.setOverflow(this.getPos(), n2);
        }
        this.store.update(page);
        this.store.free(this.getPos());
    }

    private void setNext(int n2, int n3) {
        if (SysProperties.CHECK && n2 != this.nextPage) {
            DbException.throwInternalError("move " + this + " " + n3);
        }
        this.store.logUndo(this, this.data);
        this.nextPage = n3;
        this.data.setInt(7, n3);
    }

    void free() {
        this.store.logUndo(this, this.data);
        this.store.free(this.getPos());
    }

    @Override
    public boolean canRemove() {
        return true;
    }

    @Override
    public boolean isStream() {
        return true;
    }
}

