/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.Arrays;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.Cursor;
import org.h2.index.PageData;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDataLeaf;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;
import org.h2.util.Utils;

public class PageDataNode
extends PageData {
    private int[] childPageIds;
    private int rowCountStored = -1;
    private int rowCount = -1;
    private int length;

    private PageDataNode(PageDataIndex pageDataIndex, int n2, Data data) {
        super(pageDataIndex, n2, data);
    }

    static PageDataNode create(PageDataIndex pageDataIndex, int n2, int n3) {
        PageDataNode pageDataNode = new PageDataNode(pageDataIndex, n2, pageDataIndex.getPageStore().createData());
        pageDataIndex.getPageStore().logUndo(pageDataNode, null);
        pageDataNode.parentPageId = n3;
        pageDataNode.writeHead();
        pageDataNode.length = pageDataNode.data.length() + 4;
        return pageDataNode;
    }

    public static Page read(PageDataIndex pageDataIndex, Data data, int n2) {
        PageDataNode pageDataNode = new PageDataNode(pageDataIndex, n2, data);
        pageDataNode.read();
        return pageDataNode;
    }

    private void read() {
        this.data.reset();
        this.data.readByte();
        this.data.readShortInt();
        this.parentPageId = this.data.readInt();
        int n2 = this.data.readVarInt();
        if (n2 != this.index.getId()) {
            throw DbException.get(90030, "page:" + this.getPos() + " expected index:" + this.index.getId() + "got:" + n2);
        }
        this.rowCount = this.rowCountStored = this.data.readInt();
        this.entryCount = this.data.readShortInt();
        this.childPageIds = new int[this.entryCount + 1];
        this.childPageIds[this.entryCount] = this.data.readInt();
        this.keys = Utils.newLongArray(this.entryCount);
        for (int i2 = 0; i2 < this.entryCount; ++i2) {
            this.childPageIds[i2] = this.data.readInt();
            this.keys[i2] = this.data.readVarLong();
        }
        this.length = this.data.length();
        this.check();
        this.written = true;
    }

    private void addChild(int n2, int n3, long l2) {
        this.index.getPageStore().logUndo(this, this.data);
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        this.childPageIds = PageDataNode.insert(this.childPageIds, this.entryCount + 1, n2 + 1, n3);
        this.keys = PageDataNode.insert(this.keys, this.entryCount, n2, l2);
        ++this.entryCount;
        this.length += 4 + Data.getVarLongLen(l2);
    }

    @Override
    int addRowTry(Row row) {
        int n2;
        PageData pageData;
        int n3;
        this.index.getPageStore().logUndo(this, this.data);
        int n4 = 4 + Data.getVarLongLen(row.getKey());
        while ((n3 = (pageData = this.index.getPage(this.childPageIds[n2 = this.find(row.getKey())], this.getPos())).addRowTry(row)) != -1) {
            if (this.length + n4 > this.index.getPageStore().getPageSize()) {
                return this.entryCount / 2;
            }
            long l2 = n3 == 0 ? row.getKey() : pageData.getKey(n3 - 1);
            PageData pageData2 = pageData.split(n3);
            this.index.getPageStore().update(pageData);
            this.index.getPageStore().update(pageData2);
            this.addChild(n2, pageData2.getPos(), l2);
            this.index.getPageStore().update(this);
        }
        this.updateRowCount(1);
        return -1;
    }

    private void updateRowCount(int n2) {
        if (this.rowCount != -1) {
            this.rowCount += n2;
        }
        if (this.rowCountStored != -1) {
            this.rowCountStored = -1;
            this.index.getPageStore().logUndo(this, this.data);
            if (this.written) {
                this.writeHead();
            }
            this.index.getPageStore().update(this);
        }
    }

    @Override
    Cursor find(Session session, long l2, long l3, boolean bl2) {
        int n2 = this.find(l2);
        int n3 = this.childPageIds[n2];
        return this.index.getPage(n3, this.getPos()).find(session, l2, l3, bl2);
    }

    @Override
    PageData split(int n2) {
        int n3 = this.index.getPageStore().allocatePage();
        PageDataNode pageDataNode = PageDataNode.create(this.index, n3, this.parentPageId);
        int n4 = this.childPageIds[n2];
        int n5 = n2;
        while (n5 < this.entryCount) {
            pageDataNode.addChild(pageDataNode.entryCount, this.childPageIds[n2 + 1], this.keys[n2]);
            this.removeChild(n2);
        }
        n5 = this.childPageIds[n2 - 1];
        this.removeChild(n2 - 1);
        this.childPageIds[n2 - 1] = n5;
        pageDataNode.childPageIds[0] = n4;
        pageDataNode.remapChildren(this.getPos());
        return pageDataNode;
    }

    @Override
    protected void remapChildren(int n2) {
        for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
            int n3 = this.childPageIds[i2];
            PageData pageData = this.index.getPage(n3, n2);
            pageData.setParentPageId(this.getPos());
            this.index.getPageStore().update(pageData);
        }
    }

    void init(PageData pageData, long l2, PageData pageData2) {
        this.entryCount = 1;
        this.childPageIds = new int[]{pageData.getPos(), pageData2.getPos()};
        this.keys = new long[]{l2};
        this.length += 4 + Data.getVarLongLen(l2);
        this.check();
    }

    @Override
    long getLastKey() {
        return this.index.getPage(this.childPageIds[this.entryCount], this.getPos()).getLastKey();
    }

    PageDataLeaf getNextPage(long l2) {
        int n2 = this.find(l2) + 1;
        if (n2 > this.entryCount) {
            if (this.parentPageId == 0) {
                return null;
            }
            PageDataNode pageDataNode = (PageDataNode)this.index.getPage(this.parentPageId, -1);
            return pageDataNode.getNextPage(l2);
        }
        PageData pageData = this.index.getPage(this.childPageIds[n2], this.getPos());
        return pageData.getFirstLeaf();
    }

    @Override
    PageDataLeaf getFirstLeaf() {
        int n2 = this.childPageIds[0];
        return this.index.getPage(n2, this.getPos()).getFirstLeaf();
    }

    @Override
    boolean remove(long l2) {
        int n2 = this.find(l2);
        PageData pageData = this.index.getPage(this.childPageIds[n2], this.getPos());
        boolean bl2 = pageData.remove(l2);
        this.index.getPageStore().logUndo(this, this.data);
        this.updateRowCount(-1);
        if (!bl2) {
            return false;
        }
        this.index.getPageStore().free(pageData.getPos());
        if (this.entryCount < 1) {
            return true;
        }
        this.removeChild(n2);
        this.index.getPageStore().update(this);
        return false;
    }

    @Override
    void freeRecursive() {
        this.index.getPageStore().logUndo(this, this.data);
        this.index.getPageStore().free(this.getPos());
        for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
            int n2 = this.childPageIds[i2];
            this.index.getPage(n2, this.getPos()).freeRecursive();
        }
    }

    @Override
    Row getRowWithKey(long l2) {
        int n2 = this.find(l2);
        PageData pageData = this.index.getPage(this.childPageIds[n2], this.getPos());
        return pageData.getRowWithKey(l2);
    }

    @Override
    int getRowCount() {
        if (this.rowCount == -1) {
            int n2 = 0;
            for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
                int n3 = this.childPageIds[i2];
                PageData pageData = this.index.getPage(n3, this.getPos());
                if (this.getPos() == pageData.getPos()) {
                    throw DbException.throwInternalError("Page is its own child: " + this.getPos());
                }
                this.index.getDatabase().setProgress(0, this.index.getTable() + "." + this.index.getName(), n2 += pageData.getRowCount(), Integer.MAX_VALUE);
            }
            this.rowCount = n2;
        }
        return this.rowCount;
    }

    @Override
    long getDiskSpaceUsed() {
        long l2 = 0L;
        for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
            int n2 = this.childPageIds[i2];
            PageData pageData = this.index.getPage(n2, this.getPos());
            if (this.getPos() == pageData.getPos()) {
                throw DbException.throwInternalError("Page is its own child: " + this.getPos());
            }
            this.index.getDatabase().setProgress(0, this.index.getTable() + "." + this.index.getName(), (int)((l2 += pageData.getDiskSpaceUsed()) >> 16), Integer.MAX_VALUE);
        }
        return l2;
    }

    @Override
    void setRowCountStored(int n2) {
        this.rowCount = n2;
        if (this.rowCountStored != n2) {
            this.rowCountStored = n2;
            this.index.getPageStore().logUndo(this, this.data);
            if (this.written) {
                this.changeCount = this.index.getPageStore().getChangeCount();
                this.writeHead();
            }
            this.index.getPageStore().update(this);
        }
    }

    private void check() {
        if (SysProperties.CHECK) {
            for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
                int n2 = this.childPageIds[i2];
                if (n2 != 0) continue;
                DbException.throwInternalError();
            }
        }
    }

    @Override
    public void write() {
        this.writeData();
        this.index.getPageStore().writePage(this.getPos(), this.data);
    }

    private void writeHead() {
        this.data.reset();
        this.data.writeByte((byte)2);
        this.data.writeShortInt(0);
        if (SysProperties.CHECK2 && this.data.length() != 3) {
            DbException.throwInternalError();
        }
        this.data.writeInt(this.parentPageId);
        this.data.writeVarInt(this.index.getId());
        this.data.writeInt(this.rowCountStored);
        this.data.writeShortInt(this.entryCount);
    }

    private void writeData() {
        if (this.written) {
            return;
        }
        this.check();
        this.writeHead();
        this.data.writeInt(this.childPageIds[this.entryCount]);
        for (int i2 = 0; i2 < this.entryCount; ++i2) {
            this.data.writeInt(this.childPageIds[i2]);
            this.data.writeVarLong(this.keys[i2]);
        }
        if (this.length != this.data.length()) {
            DbException.throwInternalError("expected pos: " + this.length + " got: " + this.data.length());
        }
        this.written = true;
    }

    private void removeChild(int n2) {
        this.index.getPageStore().logUndo(this, this.data);
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        int n3 = n2 < this.entryCount ? n2 : n2 - 1;
        --this.entryCount;
        this.length -= 4 + Data.getVarLongLen(this.keys[n3]);
        if (this.entryCount < 0) {
            DbException.throwInternalError();
        }
        this.keys = PageDataNode.remove(this.keys, this.entryCount + 1, n3);
        this.childPageIds = PageDataNode.remove(this.childPageIds, this.entryCount + 2, n2);
    }

    public String toString() {
        return "page[" + this.getPos() + "] data node table:" + this.index.getId() + " entries:" + this.entryCount + " " + Arrays.toString(this.childPageIds);
    }

    @Override
    public void moveTo(Session session, int n2) {
        PageStore pageStore = this.index.getPageStore();
        for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
            int n3 = this.childPageIds[i2];
            pageStore.getPage(n3);
        }
        if (this.parentPageId != 0) {
            pageStore.getPage(this.parentPageId);
        }
        pageStore.logUndo(this, this.data);
        PageDataNode pageDataNode = PageDataNode.create(this.index, n2, this.parentPageId);
        pageDataNode.rowCountStored = this.rowCountStored;
        pageDataNode.rowCount = this.rowCount;
        pageDataNode.childPageIds = this.childPageIds;
        pageDataNode.keys = this.keys;
        pageDataNode.entryCount = this.entryCount;
        pageDataNode.length = this.length;
        pageStore.update(pageDataNode);
        if (this.parentPageId == 0) {
            this.index.setRootPageId(session, n2);
        } else {
            PageDataNode pageDataNode2 = (PageDataNode)pageStore.getPage(this.parentPageId);
            pageDataNode2.moveChild(this.getPos(), n2);
        }
        for (int i3 = 0; i3 < this.entryCount + 1; ++i3) {
            int n4 = this.childPageIds[i3];
            PageData pageData = (PageData)pageStore.getPage(n4);
            pageData.setParentPageId(n2);
            pageStore.update(pageData);
        }
        pageStore.free(this.getPos());
    }

    void moveChild(int n2, int n3) {
        for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
            if (this.childPageIds[i2] != n2) continue;
            this.index.getPageStore().logUndo(this, this.data);
            this.written = false;
            this.changeCount = this.index.getPageStore().getChangeCount();
            this.childPageIds[i2] = n3;
            this.index.getPageStore().update(this);
            return;
        }
        throw DbException.throwInternalError();
    }
}

