/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.Cursor;
import org.h2.index.PageData;
import org.h2.index.PageDataCursor;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDataNode;
import org.h2.index.PageDataOverflow;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;
import org.h2.value.Value;

public class PageDataLeaf
extends PageData {
    private final boolean optimizeUpdate;
    private int[] offsets;
    private Row[] rows;
    private SoftReference<Row> rowRef;
    private int firstOverflowPageId;
    private int start;
    private int overflowRowSize;
    private int columnCount;
    private int memoryData;
    private boolean writtenData;

    private PageDataLeaf(PageDataIndex pageDataIndex, int n2, Data data) {
        super(pageDataIndex, n2, data);
        this.optimizeUpdate = pageDataIndex.getDatabase().getSettings().optimizeUpdate;
    }

    static PageDataLeaf create(PageDataIndex pageDataIndex, int n2, int n3) {
        PageDataLeaf pageDataLeaf = new PageDataLeaf(pageDataIndex, n2, pageDataIndex.getPageStore().createData());
        pageDataIndex.getPageStore().logUndo(pageDataLeaf, null);
        pageDataLeaf.rows = Row.EMPTY_ARRAY;
        pageDataLeaf.parentPageId = n3;
        pageDataLeaf.columnCount = pageDataIndex.getTable().getColumns().length;
        pageDataLeaf.writeHead();
        pageDataLeaf.start = pageDataLeaf.data.length();
        return pageDataLeaf;
    }

    public static Page read(PageDataIndex pageDataIndex, Data data, int n2) {
        PageDataLeaf pageDataLeaf = new PageDataLeaf(pageDataIndex, n2, data);
        pageDataLeaf.read();
        return pageDataLeaf;
    }

    private void read() {
        this.data.reset();
        byte by2 = this.data.readByte();
        this.data.readShortInt();
        this.parentPageId = this.data.readInt();
        int n2 = this.data.readVarInt();
        if (n2 != this.index.getId()) {
            throw DbException.get(90030, "page:" + this.getPos() + " expected table:" + this.index.getId() + " got:" + n2 + " type:" + by2);
        }
        this.columnCount = this.data.readVarInt();
        this.entryCount = this.data.readShortInt();
        this.offsets = new int[this.entryCount];
        this.keys = new long[this.entryCount];
        this.rows = new Row[this.entryCount];
        if (by2 == 1) {
            if (this.entryCount != 1) {
                DbException.throwInternalError("entries: " + this.entryCount);
            }
            this.firstOverflowPageId = this.data.readInt();
        }
        for (int i2 = 0; i2 < this.entryCount; ++i2) {
            this.keys[i2] = this.data.readVarLong();
            this.offsets[i2] = this.data.readShortInt();
        }
        this.start = this.data.length();
        this.written = true;
        this.writtenData = true;
    }

    private int getRowLength(Row row) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            n2 += this.data.getValueLen(row.getValue(i2));
        }
        return n2;
    }

    private int findInsertionPoint(long l2) {
        int n2 = this.find(l2);
        if (n2 < this.entryCount && this.keys[n2] == l2) {
            throw this.index.getDuplicateKeyException("" + l2);
        }
        return n2;
    }

    @Override
    int addRowTry(Row row) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.index.getPageStore().logUndo(this, this.data);
        int n6 = this.getRowLength(row);
        int n7 = this.index.getPageStore().getPageSize();
        int n8 = this.entryCount == 0 ? n7 : this.offsets[this.entryCount - 1];
        int n9 = 2 + Data.getVarLongLen(row.getKey());
        if (this.entryCount > 0 && n8 - n6 < this.start + n9) {
            int n10 = this.findInsertionPoint(row.getKey());
            if (this.entryCount > 1) {
                if (this.entryCount < 5) {
                    return this.entryCount / 2;
                }
                if (this.index.isSortedInsertMode()) {
                    return n10 < 2 ? 1 : (n10 > this.entryCount - 1 ? this.entryCount - 1 : n10);
                }
                int n11 = this.entryCount / 3;
                return n10 < n11 ? n11 : (n10 >= 2 * n11 ? 2 * n11 : n10);
            }
            return n10;
        }
        this.index.getPageStore().logUndo(this, this.data);
        if (this.entryCount == 0) {
            n5 = 0;
        } else {
            if (!this.optimizeUpdate) {
                this.readAllRows();
            }
            n5 = this.findInsertionPoint(row.getKey());
        }
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        n8 = n5 == 0 ? n7 : this.offsets[n5 - 1];
        int n12 = n8 - n6;
        this.start += n9;
        this.offsets = PageDataLeaf.insert(this.offsets, this.entryCount, n5, n12);
        PageDataLeaf.add(this.offsets, n5 + 1, this.entryCount + 1, -n6);
        this.keys = PageDataLeaf.insert(this.keys, this.entryCount, n5, row.getKey());
        this.rows = PageDataLeaf.insert(this.rows, this.entryCount, n5, row);
        ++this.entryCount;
        this.index.getPageStore().update(this);
        if (this.optimizeUpdate && this.writtenData && n12 >= this.start) {
            byte[] byArray = this.data.getBytes();
            n4 = this.offsets[this.entryCount - 1] + n6;
            n3 = this.offsets[n5];
            System.arraycopy(byArray, n4, byArray, n4 - n6, n3 - n4 + n6);
            this.data.setPos(n3);
            for (n2 = 0; n2 < this.columnCount; ++n2) {
                this.data.writeValue(row.getValue(n2));
            }
        }
        if (n12 < this.start) {
            int n13;
            this.writtenData = false;
            if (this.entryCount > 1) {
                DbException.throwInternalError();
            }
            this.start += 4;
            int n14 = n6 - (n7 - this.start);
            this.offsets[n5] = n12 = this.start;
            n4 = this.getPos();
            n3 = n7;
            this.firstOverflowPageId = n2 = this.index.getPageStore().allocatePage();
            this.overflowRowSize = n7 + n6;
            this.writeData();
            Row row2 = this.rows[0];
            this.rowRef = new SoftReference<Row>(row2);
            this.rows[0] = null;
            Data data = this.index.getPageStore().createData();
            data.checkCapacity(this.data.length());
            data.write(this.data.getBytes(), 0, this.data.length());
            this.data.truncate(this.index.getPageStore().getPageSize());
            do {
                int n15;
                int n16;
                if (n14 <= n7 - 9) {
                    n16 = 19;
                    n13 = n14;
                    n15 = 0;
                } else {
                    n16 = 3;
                    n13 = n7 - 11;
                    n15 = this.index.getPageStore().allocatePage();
                }
                PageDataOverflow pageDataOverflow = PageDataOverflow.create(this.index.getPageStore(), n2, n16, n4, n15, data, n3, n13);
                this.index.getPageStore().update(pageDataOverflow);
                n3 += n13;
                n4 = n2;
                n2 = n15;
            } while ((n14 -= n13) > 0);
        }
        if (this.rowRef == null) {
            this.memoryChange(true, row);
        } else {
            this.memoryChange(true, null);
        }
        return -1;
    }

    private void removeRow(int n2) {
        Row row;
        this.index.getPageStore().logUndo(this, this.data);
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        if (!this.optimizeUpdate) {
            this.readAllRows();
        }
        if ((row = this.getRowAt(n2)) != null) {
            this.memoryChange(false, row);
        }
        --this.entryCount;
        if (this.entryCount < 0) {
            DbException.throwInternalError();
        }
        if (this.firstOverflowPageId != 0) {
            this.start -= 4;
            this.freeOverflow();
            this.firstOverflowPageId = 0;
            this.overflowRowSize = 0;
            this.rowRef = null;
        }
        int n3 = 2 + Data.getVarLongLen(this.keys[n2]);
        int n4 = n2 > 0 ? this.offsets[n2 - 1] : this.index.getPageStore().getPageSize();
        int n5 = n4 - this.offsets[n2];
        if (this.optimizeUpdate) {
            if (this.writtenData) {
                byte[] byArray = this.data.getBytes();
                int n6 = this.offsets[this.entryCount];
                System.arraycopy(byArray, n6, byArray, n6 + n5, this.offsets[n2] - n6);
                Arrays.fill(byArray, n6, n6 + n5, (byte)0);
            }
        } else {
            int n7 = this.offsets[this.entryCount];
            Arrays.fill(this.data.getBytes(), n7, n7 + n5, (byte)0);
        }
        this.start -= n3;
        this.offsets = PageDataLeaf.remove(this.offsets, this.entryCount + 1, n2);
        PageDataLeaf.add(this.offsets, n2, this.entryCount, n5);
        this.keys = PageDataLeaf.remove(this.keys, this.entryCount + 1, n2);
        this.rows = PageDataLeaf.remove(this.rows, this.entryCount + 1, n2);
    }

    @Override
    Cursor find(Session session, long l2, long l3, boolean bl2) {
        int n2 = this.find(l2);
        return new PageDataCursor(session, this, n2, l3, bl2);
    }

    Row getRowAt(int n2) {
        Row row = this.rows[n2];
        if (row == null) {
            if (this.firstOverflowPageId == 0) {
                row = this.readRow(this.data, this.offsets[n2], this.columnCount);
            } else {
                PageDataOverflow pageDataOverflow;
                if (this.rowRef != null && (row = this.rowRef.get()) != null) {
                    return row;
                }
                PageStore pageStore = this.index.getPageStore();
                Data data = pageStore.createData();
                int n3 = pageStore.getPageSize();
                int n4 = this.offsets[n2];
                data.write(this.data.getBytes(), n4, n3 - n4);
                int n5 = this.firstOverflowPageId;
                while ((n5 = (pageDataOverflow = this.index.getPageOverflow(n5)).readInto(data)) != 0) {
                }
                this.overflowRowSize = n3 + data.length();
                row = this.readRow(data, 0, this.columnCount);
            }
            row.setKey(this.keys[n2]);
            if (this.firstOverflowPageId != 0) {
                this.rowRef = new SoftReference<Row>(row);
            } else {
                this.rows[n2] = row;
                this.memoryChange(true, row);
            }
        }
        return row;
    }

    int getEntryCount() {
        return this.entryCount;
    }

    @Override
    PageData split(int n2) {
        int n3 = this.index.getPageStore().allocatePage();
        PageDataLeaf pageDataLeaf = PageDataLeaf.create(this.index, n3, this.parentPageId);
        int n4 = n2;
        while (n4 < this.entryCount) {
            int n5 = pageDataLeaf.addRowTry(this.getRowAt(n2));
            if (n5 != -1) {
                DbException.throwInternalError("split " + n5);
            }
            this.removeRow(n2);
        }
        return pageDataLeaf;
    }

    @Override
    long getLastKey() {
        if (this.entryCount == 0) {
            return 0L;
        }
        return this.getRowAt(this.entryCount - 1).getKey();
    }

    PageDataLeaf getNextPage() {
        if (this.parentPageId == 0) {
            return null;
        }
        PageDataNode pageDataNode = (PageDataNode)this.index.getPage(this.parentPageId, -1);
        return pageDataNode.getNextPage(this.keys[this.entryCount - 1]);
    }

    @Override
    PageDataLeaf getFirstLeaf() {
        return this;
    }

    @Override
    protected void remapChildren(int n2) {
        if (this.firstOverflowPageId == 0) {
            return;
        }
        PageDataOverflow pageDataOverflow = this.index.getPageOverflow(this.firstOverflowPageId);
        pageDataOverflow.setParentPageId(this.getPos());
        this.index.getPageStore().update(pageDataOverflow);
    }

    @Override
    boolean remove(long l2) {
        int n2 = this.find(l2);
        if (this.keys == null || this.keys[n2] != l2) {
            throw DbException.get(90112, this.index.getSQL() + ": " + l2 + " " + (this.keys == null ? -1L : this.keys[n2]));
        }
        this.index.getPageStore().logUndo(this, this.data);
        if (this.entryCount == 1) {
            this.freeRecursive();
            return true;
        }
        this.removeRow(n2);
        this.index.getPageStore().update(this);
        return false;
    }

    @Override
    void freeRecursive() {
        this.index.getPageStore().logUndo(this, this.data);
        this.index.getPageStore().free(this.getPos());
        this.freeOverflow();
    }

    private void freeOverflow() {
        if (this.firstOverflowPageId != 0) {
            PageDataOverflow pageDataOverflow;
            int n2 = this.firstOverflowPageId;
            do {
                pageDataOverflow = this.index.getPageOverflow(n2);
                pageDataOverflow.free();
            } while ((n2 = pageDataOverflow.getNextOverflow()) != 0);
        }
    }

    @Override
    Row getRowWithKey(long l2) {
        int n2 = this.find(l2);
        return this.getRowAt(n2);
    }

    @Override
    int getRowCount() {
        return this.entryCount;
    }

    @Override
    void setRowCountStored(int n2) {
    }

    @Override
    long getDiskSpaceUsed() {
        return this.index.getPageStore().getPageSize();
    }

    @Override
    public void write() {
        this.writeData();
        this.index.getPageStore().writePage(this.getPos(), this.data);
        this.data.truncate(this.index.getPageStore().getPageSize());
    }

    private void readAllRows() {
        for (int i2 = 0; i2 < this.entryCount; ++i2) {
            this.getRowAt(i2);
        }
    }

    private void writeHead() {
        this.data.reset();
        int n2 = this.firstOverflowPageId == 0 ? 17 : 1;
        this.data.writeByte((byte)n2);
        this.data.writeShortInt(0);
        if (SysProperties.CHECK2 && this.data.length() != 3) {
            DbException.throwInternalError();
        }
        this.data.writeInt(this.parentPageId);
        this.data.writeVarInt(this.index.getId());
        this.data.writeVarInt(this.columnCount);
        this.data.writeShortInt(this.entryCount);
    }

    private void writeData() {
        int n2;
        if (this.written) {
            return;
        }
        if (!this.optimizeUpdate) {
            this.readAllRows();
        }
        this.writeHead();
        if (this.firstOverflowPageId != 0) {
            this.data.writeInt(this.firstOverflowPageId);
            this.data.checkCapacity(this.overflowRowSize);
        }
        for (n2 = 0; n2 < this.entryCount; ++n2) {
            this.data.writeVarLong(this.keys[n2]);
            this.data.writeShortInt(this.offsets[n2]);
        }
        if (!this.writtenData || !this.optimizeUpdate) {
            for (n2 = 0; n2 < this.entryCount; ++n2) {
                this.data.setPos(this.offsets[n2]);
                Row row = this.getRowAt(n2);
                for (int i2 = 0; i2 < this.columnCount; ++i2) {
                    this.data.writeValue(row.getValue(i2));
                }
            }
            this.writtenData = true;
        }
        this.written = true;
    }

    public String toString() {
        return "page[" + this.getPos() + "] data leaf table:" + this.index.getId() + " " + this.index.getTable().getName() + " entries:" + this.entryCount + " parent:" + this.parentPageId + (this.firstOverflowPageId == 0 ? "" : " overflow:" + this.firstOverflowPageId) + " keys:" + Arrays.toString(this.keys) + " offsets:" + Arrays.toString(this.offsets);
    }

    @Override
    public void moveTo(Session session, int n2) {
        PageStore pageStore = this.index.getPageStore();
        if (this.parentPageId != 0) {
            pageStore.getPage(this.parentPageId);
        }
        pageStore.logUndo(this, this.data);
        PageDataLeaf pageDataLeaf = PageDataLeaf.create(this.index, n2, this.parentPageId);
        this.readAllRows();
        pageDataLeaf.keys = this.keys;
        pageDataLeaf.overflowRowSize = this.overflowRowSize;
        pageDataLeaf.firstOverflowPageId = this.firstOverflowPageId;
        pageDataLeaf.rowRef = this.rowRef;
        pageDataLeaf.rows = this.rows;
        if (this.firstOverflowPageId != 0) {
            pageDataLeaf.rows[0] = this.getRowAt(0);
        }
        pageDataLeaf.entryCount = this.entryCount;
        pageDataLeaf.offsets = this.offsets;
        pageDataLeaf.start = this.start;
        pageDataLeaf.remapChildren(this.getPos());
        pageDataLeaf.writeData();
        pageDataLeaf.data.truncate(this.index.getPageStore().getPageSize());
        pageStore.update(pageDataLeaf);
        if (this.parentPageId == 0) {
            this.index.setRootPageId(session, n2);
        } else {
            PageDataNode pageDataNode = (PageDataNode)pageStore.getPage(this.parentPageId);
            pageDataNode.moveChild(this.getPos(), n2);
        }
        pageStore.free(this.getPos());
    }

    void setOverflow(int n2, int n3) {
        if (SysProperties.CHECK && n2 != this.firstOverflowPageId) {
            DbException.throwInternalError("move " + this + " " + this.firstOverflowPageId);
        }
        this.index.getPageStore().logUndo(this, this.data);
        this.firstOverflowPageId = n3;
        if (this.written) {
            this.changeCount = this.index.getPageStore().getChangeCount();
            this.writeHead();
            this.data.writeInt(this.firstOverflowPageId);
        }
        this.index.getPageStore().update(this);
    }

    private void memoryChange(boolean bl2, Row row) {
        int n2 = row == null ? 0 : 20 + row.getMemory();
        this.memoryData += bl2 ? n2 : -n2;
        this.index.memoryChange(240 + this.memoryData + this.index.getPageStore().getPageSize() >> 2);
    }

    @Override
    public boolean isStream() {
        return this.firstOverflowPageId > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Row readRow(Data data, int n2, int n3) {
        Value[] valueArray = new Value[n3];
        Data data2 = data;
        synchronized (data2) {
            data.setPos(n2);
            for (int i2 = 0; i2 < n3; ++i2) {
                valueArray[i2] = data.readValue();
            }
        }
        return this.index.getDatabase().createRow(valueArray, -1);
    }
}

