/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.PageBtree;
import org.h2.index.PageBtreeCursor;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageBtreeLeaf;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;
import org.h2.util.Utils;

public class PageBtreeNode
extends PageBtree {
    private static final int CHILD_OFFSET_PAIR_LENGTH = 6;
    private static final int MAX_KEY_LENGTH = 10;
    private final boolean pageStoreInternalCount;
    private int[] childPageIds;
    private int rowCountStored = -1;
    private int rowCount = -1;

    private PageBtreeNode(PageBtreeIndex pageBtreeIndex, int n2, Data data) {
        super(pageBtreeIndex, n2, data);
        this.pageStoreInternalCount = pageBtreeIndex.getDatabase().getSettings().pageStoreInternalCount;
    }

    public static Page read(PageBtreeIndex pageBtreeIndex, Data data, int n2) {
        PageBtreeNode pageBtreeNode = new PageBtreeNode(pageBtreeIndex, n2, data);
        pageBtreeNode.read();
        return pageBtreeNode;
    }

    static PageBtreeNode create(PageBtreeIndex pageBtreeIndex, int n2, int n3) {
        PageBtreeNode pageBtreeNode = new PageBtreeNode(pageBtreeIndex, n2, pageBtreeIndex.getPageStore().createData());
        pageBtreeIndex.getPageStore().logUndo(pageBtreeNode, null);
        pageBtreeNode.parentPageId = n3;
        pageBtreeNode.writeHead();
        pageBtreeNode.start = pageBtreeNode.data.length() + 4;
        pageBtreeNode.rows = SearchRow.EMPTY_ARRAY;
        if (pageBtreeNode.pageStoreInternalCount) {
            pageBtreeNode.rowCount = 0;
        }
        return pageBtreeNode;
    }

    private void read() {
        this.data.reset();
        byte by2 = this.data.readByte();
        this.data.readShortInt();
        this.parentPageId = this.data.readInt();
        this.onlyPosition = (by2 & 0x10) == 0;
        int n2 = this.data.readVarInt();
        if (n2 != this.index.getId()) {
            throw DbException.get(90030, "page:" + this.getPos() + " expected index:" + this.index.getId() + "got:" + n2);
        }
        this.rowCount = this.rowCountStored = this.data.readInt();
        this.entryCount = this.data.readShortInt();
        this.childPageIds = new int[this.entryCount + 1];
        this.childPageIds[this.entryCount] = this.data.readInt();
        this.rows = this.entryCount == 0 ? SearchRow.EMPTY_ARRAY : new SearchRow[this.entryCount];
        this.offsets = Utils.newIntArray(this.entryCount);
        for (int i2 = 0; i2 < this.entryCount; ++i2) {
            this.childPageIds[i2] = this.data.readInt();
            this.offsets[i2] = this.data.readShortInt();
        }
        this.check();
        this.start = this.data.length();
        this.written = true;
    }

    private int addChildTry(SearchRow searchRow) {
        int n2;
        if (this.entryCount < 4) {
            return -1;
        }
        if (this.onlyPosition) {
            n2 = this.entryCount + 10;
        } else {
            int n3 = this.index.getRowSize(this.data, searchRow, this.onlyPosition);
            int n4 = this.index.getPageStore().getPageSize();
            int n5 = this.entryCount == 0 ? n4 : this.offsets[this.entryCount - 1];
            n2 = n5 - n3;
        }
        if (n2 < this.start + 6) {
            return this.entryCount / 2;
        }
        return -1;
    }

    private void addChild(int n2, int n3, SearchRow searchRow) {
        int n4;
        int n5;
        int n6 = this.index.getRowSize(this.data, searchRow, this.onlyPosition);
        int n7 = this.index.getPageStore().getPageSize();
        int n8 = n5 = this.entryCount == 0 ? n7 : this.offsets[this.entryCount - 1];
        if (n5 - n6 < this.start + 6) {
            this.readAllRows();
            this.onlyPosition = true;
            n4 = n7;
            for (int i2 = 0; i2 < this.entryCount; ++i2) {
                this.offsets[i2] = n4 -= this.index.getRowSize(this.data, this.getRow(i2), true);
            }
            n5 = this.entryCount == 0 ? n7 : this.offsets[this.entryCount - 1];
            n6 = this.index.getRowSize(this.data, searchRow, true);
            if (SysProperties.CHECK && n5 - n6 < this.start + 6) {
                throw DbException.throwInternalError();
            }
        }
        n4 = n5 - n6;
        if (this.entryCount > 0 && n2 < this.entryCount) {
            n4 = (n2 == 0 ? n7 : this.offsets[n2 - 1]) - n6;
        }
        this.rows = PageBtreeNode.insert(this.rows, this.entryCount, n2, searchRow);
        this.offsets = PageBtreeNode.insert(this.offsets, this.entryCount, n2, n4);
        PageBtreeNode.add(this.offsets, n2 + 1, this.entryCount + 1, -n6);
        this.childPageIds = PageBtreeNode.insert(this.childPageIds, this.entryCount + 1, n2 + 1, n3);
        this.start += 6;
        if (this.pageStoreInternalCount && this.rowCount != -1) {
            this.rowCount += n4;
        }
        ++this.entryCount;
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
    }

    @Override
    int addRowTry(SearchRow searchRow) {
        int n2;
        PageBtree pageBtree;
        int n3;
        while ((n3 = (pageBtree = this.index.getPage(this.childPageIds[n2 = this.find(searchRow, false, true, true)])).addRowTry(searchRow)) != -1) {
            SearchRow searchRow2 = pageBtree.getRow(n3 - 1);
            this.index.getPageStore().logUndo(this, this.data);
            int n4 = this.addChildTry(searchRow2);
            if (n4 != -1) {
                return n4;
            }
            PageBtree pageBtree2 = pageBtree.split(n3);
            this.readAllRows();
            this.addChild(n2, pageBtree2.getPos(), searchRow2);
            this.index.getPageStore().update(pageBtree);
            this.index.getPageStore().update(pageBtree2);
            this.index.getPageStore().update(this);
        }
        this.updateRowCount(1);
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        return -1;
    }

    private void updateRowCount(int n2) {
        if (this.rowCount != -1) {
            this.rowCount += n2;
        }
        if (this.rowCountStored != -1) {
            this.rowCountStored = -1;
            this.index.getPageStore().logUndo(this, this.data);
            if (this.written) {
                this.writeHead();
            }
            this.index.getPageStore().update(this);
        }
    }

    @Override
    PageBtree split(int n2) {
        int n3 = this.index.getPageStore().allocatePage();
        PageBtreeNode pageBtreeNode = PageBtreeNode.create(this.index, n3, this.parentPageId);
        this.index.getPageStore().logUndo(this, this.data);
        if (this.onlyPosition) {
            pageBtreeNode.onlyPosition = true;
        }
        int n4 = this.childPageIds[n2];
        this.readAllRows();
        int n5 = n2;
        while (n5 < this.entryCount) {
            pageBtreeNode.addChild(pageBtreeNode.entryCount, this.childPageIds[n2 + 1], this.getRow(n2));
            this.removeChild(n2);
        }
        n5 = this.childPageIds[n2 - 1];
        this.removeChild(n2 - 1);
        this.childPageIds[n2 - 1] = n5;
        if (pageBtreeNode.childPageIds == null) {
            pageBtreeNode.childPageIds = new int[1];
        }
        pageBtreeNode.childPageIds[0] = n4;
        pageBtreeNode.remapChildren();
        return pageBtreeNode;
    }

    @Override
    protected void remapChildren() {
        for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
            int n2 = this.childPageIds[i2];
            PageBtree pageBtree = this.index.getPage(n2);
            pageBtree.setParentPageId(this.getPos());
            this.index.getPageStore().update(pageBtree);
        }
    }

    void init(PageBtree pageBtree, SearchRow searchRow, PageBtree pageBtree2) {
        this.entryCount = 0;
        this.childPageIds = new int[]{pageBtree.getPos()};
        this.rows = SearchRow.EMPTY_ARRAY;
        this.offsets = Utils.EMPTY_INT_ARRAY;
        this.addChild(0, pageBtree2.getPos(), searchRow);
        if (this.pageStoreInternalCount) {
            this.rowCount = pageBtree.getRowCount() + pageBtree2.getRowCount();
        }
        this.check();
    }

    @Override
    void find(PageBtreeCursor pageBtreeCursor, SearchRow searchRow, boolean bl2) {
        int n2 = this.find(searchRow, bl2, false, false);
        if (n2 > this.entryCount) {
            if (this.parentPageId == 0) {
                return;
            }
            PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
            pageBtreeNode.find(pageBtreeCursor, searchRow, bl2);
            return;
        }
        PageBtree pageBtree = this.index.getPage(this.childPageIds[n2]);
        pageBtree.find(pageBtreeCursor, searchRow, bl2);
    }

    @Override
    void last(PageBtreeCursor pageBtreeCursor) {
        int n2 = this.childPageIds[this.entryCount];
        this.index.getPage(n2).last(pageBtreeCursor);
    }

    @Override
    PageBtreeLeaf getFirstLeaf() {
        int n2 = this.childPageIds[0];
        return this.index.getPage(n2).getFirstLeaf();
    }

    @Override
    PageBtreeLeaf getLastLeaf() {
        int n2 = this.childPageIds[this.entryCount];
        return this.index.getPage(n2).getLastLeaf();
    }

    @Override
    SearchRow remove(SearchRow searchRow) {
        int n2 = this.find(searchRow, false, false, true);
        PageBtree pageBtree = this.index.getPage(this.childPageIds[n2]);
        SearchRow searchRow2 = pageBtree.remove(searchRow);
        this.index.getPageStore().logUndo(this, this.data);
        this.updateRowCount(-1);
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        if (searchRow2 == null) {
            return null;
        }
        if (searchRow2 == searchRow) {
            this.index.getPageStore().free(pageBtree.getPos());
            if (this.entryCount < 1) {
                return searchRow;
            }
            searchRow2 = n2 == this.entryCount ? this.getRow(n2 - 1) : null;
            this.removeChild(n2);
            this.index.getPageStore().update(this);
            return searchRow2;
        }
        if (n2 == this.entryCount) {
            return searchRow2;
        }
        int n3 = this.childPageIds[n2];
        this.removeChild(n2);
        this.addChild(n2, n3, searchRow2);
        int n4 = this.childPageIds[n2];
        this.childPageIds[n2] = this.childPageIds[n2 + 1];
        this.childPageIds[n2 + 1] = n4;
        this.index.getPageStore().update(this);
        return null;
    }

    @Override
    int getRowCount() {
        if (this.rowCount == -1) {
            int n2 = 0;
            for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
                int n3 = this.childPageIds[i2];
                PageBtree pageBtree = this.index.getPage(n3);
                this.index.getDatabase().setProgress(0, this.index.getName(), n2 += pageBtree.getRowCount(), Integer.MAX_VALUE);
            }
            this.rowCount = n2;
        }
        return this.rowCount;
    }

    @Override
    void setRowCountStored(int n2) {
        if (n2 < 0 && this.pageStoreInternalCount) {
            return;
        }
        this.rowCount = n2;
        if (this.rowCountStored != n2) {
            this.rowCountStored = n2;
            this.index.getPageStore().logUndo(this, this.data);
            if (this.written) {
                this.changeCount = this.index.getPageStore().getChangeCount();
                this.writeHead();
            }
            this.index.getPageStore().update(this);
        }
    }

    private void check() {
        if (SysProperties.CHECK) {
            for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
                int n2 = this.childPageIds[i2];
                if (n2 != 0) continue;
                DbException.throwInternalError();
            }
        }
    }

    @Override
    public void write() {
        this.check();
        this.writeData();
        this.index.getPageStore().writePage(this.getPos(), this.data);
    }

    private void writeHead() {
        this.data.reset();
        this.data.writeByte((byte)(5 | (this.onlyPosition ? 0 : 16)));
        this.data.writeShortInt(0);
        this.data.writeInt(this.parentPageId);
        this.data.writeVarInt(this.index.getId());
        this.data.writeInt(this.rowCountStored);
        this.data.writeShortInt(this.entryCount);
    }

    private void writeData() {
        int n2;
        if (this.written) {
            return;
        }
        this.readAllRows();
        this.writeHead();
        this.data.writeInt(this.childPageIds[this.entryCount]);
        for (n2 = 0; n2 < this.entryCount; ++n2) {
            this.data.writeInt(this.childPageIds[n2]);
            this.data.writeShortInt(this.offsets[n2]);
        }
        for (n2 = 0; n2 < this.entryCount; ++n2) {
            this.index.writeRow(this.data, this.offsets[n2], this.rows[n2], this.onlyPosition);
        }
        this.written = true;
    }

    @Override
    void freeRecursive() {
        this.index.getPageStore().logUndo(this, this.data);
        this.index.getPageStore().free(this.getPos());
        for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
            int n2 = this.childPageIds[i2];
            this.index.getPage(n2).freeRecursive();
        }
    }

    private void removeChild(int n2) {
        this.readAllRows();
        --this.entryCount;
        if (this.pageStoreInternalCount) {
            this.updateRowCount(-this.index.getPage(this.childPageIds[n2]).getRowCount());
        }
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        if (this.entryCount < 0) {
            DbException.throwInternalError();
        }
        if (this.entryCount > n2) {
            int n3 = n2 > 0 ? this.offsets[n2 - 1] : this.index.getPageStore().getPageSize();
            int n4 = n3 - this.offsets[n2];
            PageBtreeNode.add(this.offsets, n2, this.entryCount + 1, n4);
        }
        this.rows = PageBtreeNode.remove(this.rows, this.entryCount + 1, n2);
        this.offsets = PageBtreeNode.remove(this.offsets, this.entryCount + 1, n2);
        this.childPageIds = PageBtreeNode.remove(this.childPageIds, this.entryCount + 2, n2);
        this.start -= 6;
    }

    void nextPage(PageBtreeCursor pageBtreeCursor, int n2) {
        int n3;
        for (n3 = 0; n3 < this.entryCount + 1; ++n3) {
            if (this.childPageIds[n3] != n2) continue;
            ++n3;
            break;
        }
        if (n3 > this.entryCount) {
            if (this.parentPageId == 0) {
                pageBtreeCursor.setCurrent(null, 0);
                return;
            }
            PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
            pageBtreeNode.nextPage(pageBtreeCursor, this.getPos());
            return;
        }
        PageBtree pageBtree = this.index.getPage(this.childPageIds[n3]);
        PageBtreeLeaf pageBtreeLeaf = pageBtree.getFirstLeaf();
        pageBtreeCursor.setCurrent(pageBtreeLeaf, 0);
    }

    void previousPage(PageBtreeCursor pageBtreeCursor, int n2) {
        int n3;
        for (n3 = this.entryCount; n3 >= 0; --n3) {
            if (this.childPageIds[n3] != n2) continue;
            --n3;
            break;
        }
        if (n3 < 0) {
            if (this.parentPageId == 0) {
                pageBtreeCursor.setCurrent(null, 0);
                return;
            }
            PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
            pageBtreeNode.previousPage(pageBtreeCursor, this.getPos());
            return;
        }
        PageBtree pageBtree = this.index.getPage(this.childPageIds[n3]);
        PageBtreeLeaf pageBtreeLeaf = pageBtree.getLastLeaf();
        pageBtreeCursor.setCurrent(pageBtreeLeaf, pageBtreeLeaf.entryCount - 1);
    }

    public String toString() {
        return "page[" + this.getPos() + "] b-tree node table:" + this.index.getId() + " entries:" + this.entryCount;
    }

    @Override
    public void moveTo(Session session, int n2) {
        PageStore pageStore = this.index.getPageStore();
        pageStore.logUndo(this, this.data);
        PageBtreeNode pageBtreeNode = PageBtreeNode.create(this.index, n2, this.parentPageId);
        this.readAllRows();
        pageBtreeNode.rowCountStored = this.rowCountStored;
        pageBtreeNode.rowCount = this.rowCount;
        pageBtreeNode.childPageIds = this.childPageIds;
        pageBtreeNode.rows = this.rows;
        pageBtreeNode.entryCount = this.entryCount;
        pageBtreeNode.offsets = this.offsets;
        pageBtreeNode.onlyPosition = this.onlyPosition;
        pageBtreeNode.parentPageId = this.parentPageId;
        pageBtreeNode.start = this.start;
        pageStore.update(pageBtreeNode);
        if (this.parentPageId == 0) {
            this.index.setRootPageId(session, n2);
        } else {
            Page page = pageStore.getPage(this.parentPageId);
            if (!(page instanceof PageBtreeNode)) {
                throw DbException.throwInternalError();
            }
            PageBtreeNode pageBtreeNode2 = (PageBtreeNode)page;
            pageBtreeNode2.moveChild(this.getPos(), n2);
        }
        for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
            int n3 = this.childPageIds[i2];
            PageBtree pageBtree = this.index.getPage(n3);
            pageBtree.setParentPageId(n2);
            pageStore.update(pageBtree);
        }
        pageStore.free(this.getPos());
    }

    void moveChild(int n2, int n3) {
        for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
            if (this.childPageIds[i2] != n2) continue;
            this.index.getPageStore().logUndo(this, this.data);
            this.written = false;
            this.changeCount = this.index.getPageStore().getChangeCount();
            this.childPageIds[i2] = n3;
            this.index.getPageStore().update(this);
            return;
        }
        throw DbException.throwInternalError();
    }
}

