/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.HashSet;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexLookupBatch;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.MathUtils;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public abstract class BaseIndex
extends SchemaObjectBase
implements Index {
    protected IndexColumn[] indexColumns;
    protected Column[] columns;
    protected int[] columnIds;
    protected Table table;
    protected IndexType indexType;
    protected boolean isMultiVersion;

    protected void initBaseIndex(Table table, int n2, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initSchemaObjectBase(table.getSchema(), n2, string, 5);
        this.indexType = indexType;
        this.table = table;
        if (indexColumnArray != null) {
            this.indexColumns = indexColumnArray;
            this.columns = new Column[indexColumnArray.length];
            int n3 = this.columns.length;
            this.columnIds = new int[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                Column column;
                this.columns[i2] = column = indexColumnArray[i2].column;
                this.columnIds[i2] = column.getColumnId();
            }
        }
    }

    protected static void checkIndexColumnTypes(IndexColumn[] indexColumnArray) {
        for (IndexColumn indexColumn : indexColumnArray) {
            int n2 = indexColumn.column.getType();
            if (n2 != 16 && n2 != 15) continue;
            throw DbException.getUnsupportedException("Index on BLOB or CLOB column: " + indexColumn.column.getCreateSQL());
        }
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    protected DbException getDuplicateKeyException(String string) {
        String string2 = this.getName() + " ON " + this.table.getSQL() + "(" + this.getColumnListSQL() + ")";
        if (string != null) {
            string2 = string2 + " VALUES " + string;
        }
        DbException dbException = DbException.get(23505, string2);
        dbException.setSource(this);
        return dbException;
    }

    @Override
    public String getPlanSQL() {
        return this.getSQL();
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.table.removeIndex(this);
        this.remove(session);
        this.database.removeMeta(session, this.getId());
    }

    @Override
    public boolean canFindNext() {
        return false;
    }

    @Override
    public Cursor find(TableFilter tableFilter, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(tableFilter.getSession(), searchRow, searchRow2);
    }

    @Override
    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) {
        throw DbException.throwInternalError();
    }

    protected final long getCostRangeIndex(int[] nArray, long l2, TableFilter[] tableFilterArray, int n2, SortOrder sortOrder, boolean bl2, HashSet<Column> hashSet) {
        int n3;
        int n4;
        int n5 = 0;
        long l3 = l2 += 1000L;
        if (nArray != null) {
            int n6 = this.columns.length;
            for (int i2 = 0; i2 < n6; ++i2) {
                long l4;
                Column column = this.columns[i2];
                n4 = column.getColumnId();
                int n7 = nArray[n4];
                if ((n7 & 1) == 1) {
                    if (i2 == this.columns.length - 1 && this.getIndexType().isUnique()) {
                        l3 = 3L;
                        break;
                    }
                    l4 = l2 * (long)(n5 = 100 - (100 - n5) * (100 - column.getSelectivity()) / 100) / 100L;
                    if (l4 <= 0L) {
                        l4 = 1L;
                    }
                } else {
                    if ((n7 & 6) == 6) {
                        l3 = 2L + l2 / 4L;
                        break;
                    }
                    if ((n7 & 2) == 2) {
                        l3 = 2L + l2 / 3L;
                        break;
                    }
                    if ((n7 & 4) != 4) break;
                    l3 = l2 / 3L;
                    break;
                }
                l3 = 2L + Math.max(l2 / l4, 1L);
            }
        }
        long l5 = 0L;
        if (sortOrder != null) {
            l5 = 100L + l2 / 10L;
        }
        if (sortOrder != null && !bl2) {
            boolean bl3 = true;
            n4 = 0;
            int[] nArray2 = sortOrder.getSortTypes();
            TableFilter tableFilter = tableFilterArray == null ? null : tableFilterArray[n2];
            int n8 = nArray2.length;
            for (n3 = 0; n3 < n8 && n3 < this.indexColumns.length; ++n3) {
                Column column = sortOrder.getColumn(n3, tableFilter);
                if (column == null) {
                    bl3 = false;
                    break;
                }
                IndexColumn indexColumn = this.indexColumns[n3];
                if (!column.equals(indexColumn.column)) {
                    bl3 = false;
                    break;
                }
                int n9 = nArray2[n3];
                if (n9 != indexColumn.sortType) {
                    bl3 = false;
                    break;
                }
                ++n4;
            }
            if (bl3) {
                l5 = 100 - n4;
            }
        }
        boolean bl4 = true;
        if (!bl2 && hashSet != null && !hashSet.isEmpty()) {
            n4 = 1;
            for (Column column : hashSet) {
                if (column.getTable() != this.getTable()) continue;
                n3 = 0;
                for (Column column2 : this.columns) {
                    if (column != column2) continue;
                    n3 = 1;
                    break;
                }
                if (n3 != 0) continue;
                n4 = 0;
                break;
            }
            if (n4 != 0) {
                bl4 = false;
            }
        }
        long l6 = bl2 ? l3 + l5 + 20L : (bl4 ? l3 + l3 + l5 + 20L : l3 + l5 + (long)(20 - this.columns.length));
        return l6;
    }

    @Override
    public int compareRows(SearchRow searchRow, SearchRow searchRow2) {
        if (searchRow == searchRow2) {
            return 0;
        }
        int n2 = this.indexColumns.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.columnIds[i2];
            Value value = searchRow.getValue(n3);
            Value value2 = searchRow2.getValue(n3);
            if (value == null || value2 == null) {
                return 0;
            }
            int n4 = this.compareValues(value, value2, this.indexColumns[i2].sortType);
            if (n4 == 0) continue;
            return n4;
        }
        return 0;
    }

    protected boolean containsNullAndAllowMultipleNull(SearchRow searchRow) {
        Mode mode = this.database.getMode();
        if (mode.uniqueIndexSingleNull) {
            return false;
        }
        if (mode.uniqueIndexSingleNullExceptAllColumnsAreNull) {
            for (int n2 : this.columnIds) {
                Value value = searchRow.getValue(n2);
                if (value == ValueNull.INSTANCE) continue;
                return false;
            }
            return true;
        }
        for (int n3 : this.columnIds) {
            Value value = searchRow.getValue(n3);
            if (value != ValueNull.INSTANCE) continue;
            return true;
        }
        return false;
    }

    int compareKeys(SearchRow searchRow, SearchRow searchRow2) {
        long l2;
        long l3 = searchRow.getKey();
        if (l3 == (l2 = searchRow2.getKey())) {
            if (this.isMultiVersion) {
                int n2 = searchRow.getVersion();
                int n3 = searchRow2.getVersion();
                return MathUtils.compareInt(n3, n2);
            }
            return 0;
        }
        return l3 > l2 ? 1 : -1;
    }

    private int compareValues(Value value, Value value2, int n2) {
        if (value == value2) {
            return 0;
        }
        int n3 = this.table.compareTypeSafe(value, value2);
        if ((n2 & 1) != 0) {
            n3 = -n3;
        }
        return n3;
    }

    @Override
    public int getColumnIndex(Column column) {
        int n2 = this.columns.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.columns[i2].equals(column)) continue;
            return i2;
        }
        return -1;
    }

    private String getColumnListSQL() {
        StatementBuilder statementBuilder = new StatementBuilder();
        for (IndexColumn indexColumn : this.indexColumns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        return statementBuilder.toString();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        StringBuilder stringBuilder = new StringBuilder("CREATE ");
        stringBuilder.append(this.indexType.getSQL());
        stringBuilder.append(' ');
        if (this.table.isHidden()) {
            stringBuilder.append("IF NOT EXISTS ");
        }
        stringBuilder.append(string);
        stringBuilder.append(" ON ").append(table.getSQL());
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        stringBuilder.append('(').append(this.getColumnListSQL()).append(')');
        return stringBuilder.toString();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    @Override
    public IndexColumn[] getIndexColumns() {
        return this.indexColumns;
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public IndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public void commit(int n2, Row row) {
    }

    void setMultiVersion(boolean bl2) {
        this.isMultiVersion = bl2;
    }

    @Override
    public Row getRow(Session session, long l2) {
        throw DbException.getUnsupportedException(this.toString());
    }

    @Override
    public boolean isHidden() {
        return this.table.isHidden();
    }

    @Override
    public boolean isRowIdIndex() {
        return false;
    }

    @Override
    public boolean canScan() {
        return true;
    }

    @Override
    public void setSortedInsertMode(boolean bl2) {
    }

    @Override
    public IndexLookupBatch createLookupBatch(TableFilter tableFilter) {
        return null;
    }
}

