/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.Function;
import org.h2.expression.FunctionInfo;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.tools.SimpleResultSet;
import org.h2.util.MathUtils;
import org.h2.util.StatementBuilder;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;

public class TableFunction
extends Function {
    private final boolean distinct;
    private final long rowCount;
    private Column[] columnList;

    TableFunction(Database database, FunctionInfo functionInfo, long l2) {
        super(database, functionInfo);
        this.distinct = functionInfo.type == 224;
        this.rowCount = l2;
    }

    @Override
    public Value getValue(Session session) {
        return this.getTable(session, this.args, false, this.distinct);
    }

    @Override
    protected void checkParameterCount(int n2) {
        if (n2 < 1) {
            throw DbException.get(7001, this.getName(), ">0");
        }
    }

    @Override
    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder(this.getName());
        statementBuilder.append('(');
        int n2 = 0;
        for (Expression expression : this.args) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(this.columnList[n2++].getCreateSQL()).append('=').append(expression.getSQL());
        }
        return statementBuilder.append(')').toString();
    }

    @Override
    public String getName() {
        return this.distinct ? "TABLE_DISTINCT" : "TABLE";
    }

    @Override
    public ValueResultSet getValueForColumnList(Session session, Expression[] expressionArray) {
        return this.getTable(session, this.args, true, false);
    }

    public void setColumns(ArrayList<Column> arrayList) {
        this.columnList = new Column[arrayList.size()];
        arrayList.toArray(this.columnList);
    }

    private ValueResultSet getTable(Session session, Expression[] expressionArray, boolean bl2, boolean bl3) {
        Object object;
        int n2 = this.columnList.length;
        Expression[] expressionArray2 = new Expression[n2];
        Database database = session.getDatabase();
        for (int i2 = 0; i2 < n2; ++i2) {
            object = this.columnList[i2];
            ExpressionColumn expressionColumn = new ExpressionColumn(database, (Column)object);
            expressionArray2[i2] = expressionColumn;
        }
        LocalResult localResult = new LocalResult(session, expressionArray2, n2);
        if (bl3) {
            localResult.setDistinct();
        }
        if (!bl2) {
            Value[] valueArray;
            Value[] valueArray2;
            int n3;
            object = new Value[n2][];
            int n4 = 0;
            for (n3 = 0; n3 < n2; ++n3) {
                valueArray2 = expressionArray[n3].getValue(session);
                if (valueArray2 == ValueNull.INSTANCE) {
                    object[n3] = new Value[0];
                    continue;
                }
                ValueArray valueArray3 = (ValueArray)valueArray2.convertTo(17);
                valueArray = valueArray3.getList();
                object[n3] = valueArray;
                n4 = Math.max(n4, valueArray.length);
            }
            for (n3 = 0; n3 < n4; ++n3) {
                valueArray2 = new Value[n2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    Value value;
                    valueArray = object[i3];
                    if (valueArray.length <= n3) {
                        value = ValueNull.INSTANCE;
                    } else {
                        Column column = this.columnList[i3];
                        value = valueArray[n3];
                        value = column.convert(value);
                        value = value.convertPrecision(column.getPrecision(), false);
                        value = value.convertScale(true, column.getScale());
                    }
                    valueArray2[i3] = value;
                }
                localResult.addRow(valueArray2);
            }
        }
        localResult.done();
        object = ValueResultSet.get(TableFunction.getSimpleResultSet(localResult, Integer.MAX_VALUE));
        return object;
    }

    private static SimpleResultSet getSimpleResultSet(ResultInterface resultInterface, int n2) {
        int n3;
        Object[] objectArray;
        int n4;
        int n5 = resultInterface.getVisibleColumnCount();
        SimpleResultSet simpleResultSet = new SimpleResultSet();
        simpleResultSet.setAutoClose(false);
        for (n4 = 0; n4 < n5; ++n4) {
            objectArray = resultInterface.getColumnName(n4);
            n3 = DataType.convertTypeToSQLType(resultInterface.getColumnType(n4));
            int n6 = MathUtils.convertLongToInt(resultInterface.getColumnPrecision(n4));
            int n7 = resultInterface.getColumnScale(n4);
            simpleResultSet.addColumn((String)objectArray, n3, n6, n7);
        }
        resultInterface.reset();
        for (n4 = 0; n4 < n2 && resultInterface.next(); ++n4) {
            objectArray = new Object[n5];
            for (n3 = 0; n3 < n5; ++n3) {
                objectArray[n3] = resultInterface.currentRow()[n3].getObject();
            }
            simpleResultSet.addRow(objectArray);
        }
        return simpleResultSet;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        return TableFunction.getExpressionColumns(session, this.getTable(session, this.getArgs(), true, false).getResultSet());
    }
}

