/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.PatternSyntaxException;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.FunctionCall;
import org.h2.expression.FunctionInfo;
import org.h2.expression.SequenceValue;
import org.h2.expression.TableFunction;
import org.h2.expression.ValueExpression;
import org.h2.expression.Variable;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.security.BlockCipher;
import org.h2.security.CipherFactory;
import org.h2.security.SHA256;
import org.h2.store.fs.FileUtils;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.LinkSchema;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.tools.CompressTool;
import org.h2.tools.Csv;
import org.h2.util.AutoCloseInputStream;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.ToChar;
import org.h2.util.ToDateParser;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public class Function
extends Expression
implements FunctionCall {
    public static final int ABS = 0;
    public static final int ACOS = 1;
    public static final int ASIN = 2;
    public static final int ATAN = 3;
    public static final int ATAN2 = 4;
    public static final int BITAND = 5;
    public static final int BITOR = 6;
    public static final int BITXOR = 7;
    public static final int CEILING = 8;
    public static final int COS = 9;
    public static final int COT = 10;
    public static final int DEGREES = 11;
    public static final int EXP = 12;
    public static final int FLOOR = 13;
    public static final int LOG = 14;
    public static final int LOG10 = 15;
    public static final int MOD = 16;
    public static final int PI = 17;
    public static final int POWER = 18;
    public static final int RADIANS = 19;
    public static final int RAND = 20;
    public static final int ROUND = 21;
    public static final int ROUNDMAGIC = 22;
    public static final int SIGN = 23;
    public static final int SIN = 24;
    public static final int SQRT = 25;
    public static final int TAN = 26;
    public static final int TRUNCATE = 27;
    public static final int SECURE_RAND = 28;
    public static final int HASH = 29;
    public static final int ENCRYPT = 30;
    public static final int DECRYPT = 31;
    public static final int COMPRESS = 32;
    public static final int EXPAND = 33;
    public static final int ZERO = 34;
    public static final int RANDOM_UUID = 35;
    public static final int COSH = 36;
    public static final int SINH = 37;
    public static final int TANH = 38;
    public static final int LN = 39;
    public static final int ASCII = 50;
    public static final int BIT_LENGTH = 51;
    public static final int CHAR = 52;
    public static final int CHAR_LENGTH = 53;
    public static final int CONCAT = 54;
    public static final int DIFFERENCE = 55;
    public static final int HEXTORAW = 56;
    public static final int INSERT = 57;
    public static final int INSTR = 58;
    public static final int LCASE = 59;
    public static final int LEFT = 60;
    public static final int LENGTH = 61;
    public static final int LOCATE = 62;
    public static final int LTRIM = 63;
    public static final int OCTET_LENGTH = 64;
    public static final int RAWTOHEX = 65;
    public static final int REPEAT = 66;
    public static final int REPLACE = 67;
    public static final int RIGHT = 68;
    public static final int RTRIM = 69;
    public static final int SOUNDEX = 70;
    public static final int SPACE = 71;
    public static final int SUBSTR = 72;
    public static final int SUBSTRING = 73;
    public static final int UCASE = 74;
    public static final int LOWER = 75;
    public static final int UPPER = 76;
    public static final int POSITION = 77;
    public static final int TRIM = 78;
    public static final int STRINGENCODE = 79;
    public static final int STRINGDECODE = 80;
    public static final int STRINGTOUTF8 = 81;
    public static final int UTF8TOSTRING = 82;
    public static final int XMLATTR = 83;
    public static final int XMLNODE = 84;
    public static final int XMLCOMMENT = 85;
    public static final int XMLCDATA = 86;
    public static final int XMLSTARTDOC = 87;
    public static final int XMLTEXT = 88;
    public static final int REGEXP_REPLACE = 89;
    public static final int RPAD = 90;
    public static final int LPAD = 91;
    public static final int CONCAT_WS = 92;
    public static final int TO_CHAR = 93;
    public static final int TRANSLATE = 94;
    public static final int ORA_HASH = 95;
    public static final int TO_DATE = 96;
    public static final int TO_TIMESTAMP = 97;
    public static final int ADD_MONTHS = 98;
    public static final int CURDATE = 100;
    public static final int CURTIME = 101;
    public static final int DATE_ADD = 102;
    public static final int DATE_DIFF = 103;
    public static final int DAY_NAME = 104;
    public static final int DAY_OF_MONTH = 105;
    public static final int DAY_OF_WEEK = 106;
    public static final int DAY_OF_YEAR = 107;
    public static final int HOUR = 108;
    public static final int MINUTE = 109;
    public static final int MONTH = 110;
    public static final int MONTH_NAME = 111;
    public static final int NOW = 112;
    public static final int QUARTER = 113;
    public static final int SECOND = 114;
    public static final int WEEK = 115;
    public static final int YEAR = 116;
    public static final int CURRENT_DATE = 117;
    public static final int CURRENT_TIME = 118;
    public static final int CURRENT_TIMESTAMP = 119;
    public static final int EXTRACT = 120;
    public static final int FORMATDATETIME = 121;
    public static final int PARSEDATETIME = 122;
    public static final int ISO_YEAR = 123;
    public static final int ISO_WEEK = 124;
    public static final int ISO_DAY_OF_WEEK = 125;
    public static final int DATABASE = 150;
    public static final int USER = 151;
    public static final int CURRENT_USER = 152;
    public static final int IDENTITY = 153;
    public static final int SCOPE_IDENTITY = 154;
    public static final int AUTOCOMMIT = 155;
    public static final int READONLY = 156;
    public static final int DATABASE_PATH = 157;
    public static final int LOCK_TIMEOUT = 158;
    public static final int DISK_SPACE_USED = 159;
    public static final int IFNULL = 200;
    public static final int CASEWHEN = 201;
    public static final int CONVERT = 202;
    public static final int CAST = 203;
    public static final int COALESCE = 204;
    public static final int NULLIF = 205;
    public static final int CASE = 206;
    public static final int NEXTVAL = 207;
    public static final int CURRVAL = 208;
    public static final int ARRAY_GET = 209;
    public static final int CSVREAD = 210;
    public static final int CSVWRITE = 211;
    public static final int MEMORY_FREE = 212;
    public static final int MEMORY_USED = 213;
    public static final int LOCK_MODE = 214;
    public static final int SCHEMA = 215;
    public static final int SESSION_ID = 216;
    public static final int ARRAY_LENGTH = 217;
    public static final int LINK_SCHEMA = 218;
    public static final int GREATEST = 219;
    public static final int LEAST = 220;
    public static final int CANCEL_SESSION = 221;
    public static final int SET = 222;
    public static final int TABLE = 223;
    public static final int TABLE_DISTINCT = 224;
    public static final int FILE_READ = 225;
    public static final int TRANSACTION_ID = 226;
    public static final int TRUNCATE_VALUE = 227;
    public static final int NVL2 = 228;
    public static final int DECODE = 229;
    public static final int ARRAY_CONTAINS = 230;
    public static final int FILE_WRITE = 232;
    public static final int VALUES = 250;
    public static final int H2VERSION = 231;
    public static final int ROW_NUMBER = 300;
    private static final int VAR_ARGS = -1;
    private static final long PRECISION_UNKNOWN = -1L;
    private static final HashMap<String, FunctionInfo> FUNCTIONS = New.hashMap();
    private static final HashMap<String, Integer> DATE_PART = New.hashMap();
    private static final char[] SOUNDEX_INDEX = new char[128];
    protected Expression[] args;
    private final FunctionInfo info;
    private ArrayList<Expression> varArgs;
    private int dataType;
    private int scale;
    private long precision = -1L;
    private int displaySize;
    private final Database database;

    protected Function(Database database, FunctionInfo functionInfo) {
        this.database = database;
        this.info = functionInfo;
        if (functionInfo.parameterCount == -1) {
            this.varArgs = New.arrayList();
        } else {
            this.args = new Expression[functionInfo.parameterCount];
        }
    }

    private static void addFunction(String string, int n2, int n3, int n4, boolean bl2, boolean bl3, boolean bl4) {
        FunctionInfo functionInfo = new FunctionInfo();
        functionInfo.name = string;
        functionInfo.type = n2;
        functionInfo.parameterCount = n3;
        functionInfo.dataType = n4;
        functionInfo.nullIfParameterIsNull = bl2;
        functionInfo.deterministic = bl3;
        functionInfo.bufferResultSetToLocalTemp = bl4;
        FUNCTIONS.put(string, functionInfo);
    }

    private static void addFunctionNotDeterministic(String string, int n2, int n3, int n4) {
        Function.addFunction(string, n2, n3, n4, true, false, true);
    }

    private static void addFunction(String string, int n2, int n3, int n4) {
        Function.addFunction(string, n2, n3, n4, true, true, true);
    }

    private static void addFunctionWithNull(String string, int n2, int n3, int n4) {
        Function.addFunction(string, n2, n3, n4, false, true, true);
    }

    private static FunctionInfo getFunctionInfo(String string) {
        return FUNCTIONS.get(string);
    }

    public static Function getFunction(Database database, String string) {
        FunctionInfo functionInfo;
        if (!database.getSettings().databaseToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        if ((functionInfo = Function.getFunctionInfo(string)) == null) {
            return null;
        }
        switch (functionInfo.type) {
            case 223: 
            case 224: {
                return new TableFunction(database, functionInfo, Long.MAX_VALUE);
            }
        }
        return new Function(database, functionInfo);
    }

    public void setParameter(int n2, Expression expression) {
        if (this.varArgs != null) {
            this.varArgs.add(expression);
        } else {
            if (n2 >= this.args.length) {
                throw DbException.get(7001, this.info.name, "" + this.args.length);
            }
            this.args[n2] = expression;
        }
    }

    private static strictfp double log10(double d2) {
        return Function.roundMagic(StrictMath.log(d2) / StrictMath.log(10.0));
    }

    @Override
    public Value getValue(Session session) {
        return this.getValueWithArgs(session, this.args);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Value getSimpleValue(Session session, Value value, Expression[] expressionArray, Value[] valueArray) {
        Expression expression;
        block121: {
            int n2;
            int n3;
            switch (this.info.type) {
                case 0: {
                    return value.getSignum() >= 0 ? value : value.negate();
                }
                case 1: {
                    return ValueDouble.get(Math.acos(value.getDouble()));
                }
                case 2: {
                    return ValueDouble.get(Math.asin(value.getDouble()));
                }
                case 3: {
                    return ValueDouble.get(Math.atan(value.getDouble()));
                }
                case 8: {
                    return ValueDouble.get(Math.ceil(value.getDouble()));
                }
                case 9: {
                    return ValueDouble.get(Math.cos(value.getDouble()));
                }
                case 36: {
                    return ValueDouble.get(Math.cosh(value.getDouble()));
                }
                case 10: {
                    double d2 = Math.tan(value.getDouble());
                    if (d2 != 0.0) return ValueDouble.get(1.0 / d2);
                    throw DbException.get(22012, this.getSQL());
                }
                case 11: {
                    return ValueDouble.get(Math.toDegrees(value.getDouble()));
                }
                case 12: {
                    return ValueDouble.get(Math.exp(value.getDouble()));
                }
                case 13: {
                    return ValueDouble.get(Math.floor(value.getDouble()));
                }
                case 39: {
                    return ValueDouble.get(Math.log(value.getDouble()));
                }
                case 14: {
                    if (!this.database.getMode().logIsLogBase10) return ValueDouble.get(Math.log(value.getDouble()));
                    return ValueDouble.get(Math.log10(value.getDouble()));
                }
                case 15: {
                    return ValueDouble.get(Function.log10(value.getDouble()));
                }
                case 17: {
                    return ValueDouble.get(Math.PI);
                }
                case 19: {
                    return ValueDouble.get(Math.toRadians(value.getDouble()));
                }
                case 20: {
                    if (value == null) return ValueDouble.get(session.getRandom().nextDouble());
                    session.getRandom().setSeed(value.getInt());
                    return ValueDouble.get(session.getRandom().nextDouble());
                }
                case 22: {
                    return ValueDouble.get(Function.roundMagic(value.getDouble()));
                }
                case 23: {
                    return ValueInt.get(value.getSignum());
                }
                case 24: {
                    return ValueDouble.get(Math.sin(value.getDouble()));
                }
                case 37: {
                    return ValueDouble.get(Math.sinh(value.getDouble()));
                }
                case 25: {
                    return ValueDouble.get(Math.sqrt(value.getDouble()));
                }
                case 26: {
                    return ValueDouble.get(Math.tan(value.getDouble()));
                }
                case 38: {
                    return ValueDouble.get(Math.tanh(value.getDouble()));
                }
                case 28: {
                    return ValueBytes.getNoCopy(MathUtils.secureRandomBytes(value.getInt()));
                }
                case 33: {
                    return ValueBytes.getNoCopy(CompressTool.getInstance().expand(value.getBytesNoCopy()));
                }
                case 34: {
                    return ValueInt.get(0);
                }
                case 35: {
                    return ValueUuid.getNewRandom();
                }
                case 50: {
                    String string = value.getString();
                    if (string.length() != 0) return ValueInt.get(string.charAt(0));
                    return ValueNull.INSTANCE;
                }
                case 51: {
                    return ValueLong.get(16L * Function.length(value));
                }
                case 52: {
                    return ValueString.get(String.valueOf((char)value.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 53: 
                case 61: {
                    return ValueLong.get(Function.length(value));
                }
                case 64: {
                    return ValueLong.get(2L * Function.length(value));
                }
                case 54: 
                case 92: {
                    Value value2 = ValueNull.INSTANCE;
                    int n4 = 0;
                    String string = "";
                    if (this.info.type == 92) {
                        n4 = 1;
                        string = Function.getNullOrValue(session, expressionArray, valueArray, 0).getString();
                    }
                    int n5 = n4;
                    while (true) {
                        if (n5 >= expressionArray.length) {
                            if (this.info.type != 92) return value2;
                            if (string == null) return value2;
                            if (value2 != ValueNull.INSTANCE) return value2;
                            return ValueString.get("", this.database.getMode().treatEmptyStringsAsNull);
                        }
                        Value value3 = Function.getNullOrValue(session, expressionArray, valueArray, n5);
                        if (value3 != ValueNull.INSTANCE) {
                            if (value2 == ValueNull.INSTANCE) {
                                value2 = value3;
                            } else {
                                String string2 = value3.getString();
                                if (!StringUtils.isNullOrEmpty(string) && !StringUtils.isNullOrEmpty(string2)) {
                                    string2 = string.concat(string2);
                                }
                                value2 = ValueString.get(value2.getString().concat(string2), this.database.getMode().treatEmptyStringsAsNull);
                            }
                        }
                        ++n5;
                    }
                }
                case 56: {
                    return ValueString.get(Function.hexToRaw(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 59: 
                case 75: {
                    return ValueString.get(value.getString().toLowerCase(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 65: {
                    return ValueString.get(Function.rawToHex(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 70: {
                    return ValueString.get(Function.getSoundex(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 71: {
                    int n6 = Math.max(0, value.getInt());
                    char[] cArray = new char[n6];
                    int n7 = n6 - 1;
                    while (true) {
                        if (n7 < 0) {
                            return ValueString.get(new String(cArray), this.database.getMode().treatEmptyStringsAsNull);
                        }
                        cArray[n7] = 32;
                        --n7;
                    }
                }
                case 74: 
                case 76: {
                    return ValueString.get(value.getString().toUpperCase(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 79: {
                    return ValueString.get(StringUtils.javaEncode(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 80: {
                    return ValueString.get(StringUtils.javaDecode(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 81: {
                    return ValueBytes.getNoCopy(value.getString().getBytes(Constants.UTF8));
                }
                case 82: {
                    return ValueString.get(new String(value.getBytesNoCopy(), Constants.UTF8), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 85: {
                    return ValueString.get(StringUtils.xmlComment(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 86: {
                    return ValueString.get(StringUtils.xmlCData(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 87: {
                    return ValueString.get(StringUtils.xmlStartDoc(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 104: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE", Locale.ENGLISH);
                    return ValueString.get(simpleDateFormat.format(value.getDate()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 105: {
                    return ValueInt.get(DateTimeUtils.getDatePart(value.getDate(), 5));
                }
                case 106: {
                    return ValueInt.get(DateTimeUtils.getDatePart(value.getDate(), 7));
                }
                case 107: {
                    return ValueInt.get(DateTimeUtils.getDatePart(value.getDate(), 6));
                }
                case 108: {
                    return ValueInt.get(DateTimeUtils.getDatePart(value.getTimestamp(), 11));
                }
                case 109: {
                    return ValueInt.get(DateTimeUtils.getDatePart(value.getTimestamp(), 12));
                }
                case 110: {
                    return ValueInt.get(DateTimeUtils.getDatePart(value.getDate(), 2));
                }
                case 111: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM", Locale.ENGLISH);
                    return ValueString.get(simpleDateFormat.format(value.getDate()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 113: {
                    return ValueInt.get((DateTimeUtils.getDatePart(value.getDate(), 2) - 1) / 3 + 1);
                }
                case 114: {
                    return ValueInt.get(DateTimeUtils.getDatePart(value.getTimestamp(), 13));
                }
                case 115: {
                    return ValueInt.get(DateTimeUtils.getDatePart(value.getDate(), 3));
                }
                case 116: {
                    return ValueInt.get(DateTimeUtils.getDatePart(value.getDate(), 1));
                }
                case 123: {
                    return ValueInt.get(DateTimeUtils.getIsoYear(value.getDate()));
                }
                case 124: {
                    return ValueInt.get(DateTimeUtils.getIsoWeek(value.getDate()));
                }
                case 125: {
                    return ValueInt.get(DateTimeUtils.getIsoDayOfWeek(value.getDate()));
                }
                case 100: 
                case 117: {
                    long l2 = session.getTransactionStart();
                    return ValueDate.fromMillis(l2);
                }
                case 101: 
                case 118: {
                    long l3 = session.getTransactionStart();
                    return ValueTime.fromMillis(l3);
                }
                case 112: 
                case 119: {
                    long l4 = session.getTransactionStart();
                    ValueTimestamp valueTimestamp = ValueTimestamp.fromMillis(l4);
                    if (value == null) return valueTimestamp;
                    Mode mode = this.database.getMode();
                    valueTimestamp = (ValueTimestamp)valueTimestamp.convertScale(mode.convertOnlyToSmallerScale, value.getInt());
                    return valueTimestamp;
                }
                case 150: {
                    return ValueString.get(this.database.getShortName(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 151: 
                case 152: {
                    return ValueString.get(session.getUser().getName(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 153: {
                    return session.getLastIdentity();
                }
                case 154: {
                    return session.getLastScopeIdentity();
                }
                case 155: {
                    return ValueBoolean.get(session.getAutoCommit());
                }
                case 156: {
                    return ValueBoolean.get(this.database.isReadOnly());
                }
                case 157: {
                    String string = this.database.getDatabasePath();
                    return string == null ? ValueNull.INSTANCE : ValueString.get(string, this.database.getMode().treatEmptyStringsAsNull);
                }
                case 158: {
                    return ValueInt.get(session.getLockTimeout());
                }
                case 159: {
                    return ValueLong.get(Function.getDiskSpaceUsed(session, value));
                }
                case 202: 
                case 203: {
                    value = value.convertTo(this.dataType);
                    Mode mode = this.database.getMode();
                    value = value.convertScale(mode.convertOnlyToSmallerScale, this.scale);
                    return value = value.convertPrecision(this.getPrecision(), false);
                }
                case 212: {
                    session.getUser().checkAdmin();
                    return ValueInt.get(Utils.getMemoryFree());
                }
                case 213: {
                    session.getUser().checkAdmin();
                    return ValueInt.get(Utils.getMemoryUsed());
                }
                case 214: {
                    return ValueInt.get(this.database.getLockMode());
                }
                case 215: {
                    return ValueString.get(session.getCurrentSchemaName(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 216: {
                    return ValueInt.get(session.getId());
                }
                case 200: {
                    Value value2 = value;
                    if (value != ValueNull.INSTANCE) return this.convertResult(value2);
                    value2 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    return this.convertResult(value2);
                }
                case 201: {
                    Value value4 = value == ValueNull.INSTANCE || value.getBoolean() == false ? Function.getNullOrValue(session, expressionArray, valueArray, 2) : Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    return value4.convertTo(this.dataType);
                }
                case 229: {
                    int n8 = -1;
                    int n9 = expressionArray.length - 1;
                    for (int i2 = 1; i2 < n9; i2 += 2) {
                        if (!this.database.areEqual(value, Function.getNullOrValue(session, expressionArray, valueArray, i2))) continue;
                        n8 = i2 + 1;
                        break;
                    }
                    if (n8 < 0 && expressionArray.length % 2 == 0) {
                        n8 = expressionArray.length - 1;
                    }
                    ValueNull valueNull = n8 < 0 ? ValueNull.INSTANCE : Function.getNullOrValue(session, expressionArray, valueArray, n8);
                    return ((Value)valueNull).convertTo(this.dataType);
                }
                case 228: {
                    Value value5 = value == ValueNull.INSTANCE ? Function.getNullOrValue(session, expressionArray, valueArray, 2) : Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    return value5.convertTo(this.dataType);
                }
                case 204: {
                    Value value2 = value;
                    int n10 = 0;
                    while (n10 < expressionArray.length) {
                        Value value6 = Function.getNullOrValue(session, expressionArray, valueArray, n10);
                        if (value6 != ValueNull.INSTANCE) {
                            return value6.convertTo(this.dataType);
                        }
                        ++n10;
                    }
                    return value2;
                }
                case 219: 
                case 220: {
                    Value value2 = ValueNull.INSTANCE;
                    int n11 = 0;
                    while (n11 < expressionArray.length) {
                        Value value7 = Function.getNullOrValue(session, expressionArray, valueArray, n11);
                        if (value7 != ValueNull.INSTANCE) {
                            value7 = value7.convertTo(this.dataType);
                            if (value2 == ValueNull.INSTANCE) {
                                value2 = value7;
                            } else {
                                int n12 = this.database.compareTypeSafe(value2, value7);
                                if (this.info.type == 219 && n12 < 0) {
                                    value2 = value7;
                                } else if (this.info.type == 220 && n12 > 0) {
                                    value2 = value7;
                                }
                            }
                        }
                        ++n11;
                    }
                    return value2;
                }
                case 206: {
                    expression = null;
                    if (value == null) {
                        n3 = expressionArray.length - 1;
                        break;
                    }
                    if (value == ValueNull.INSTANCE) break block121;
                    int n13 = expressionArray.length - 1;
                    for (n2 = 1; n2 < n13; n2 += 2) {
                        Value value8 = expressionArray[n2].getValue(session);
                        if (!this.database.areEqual(value, value8)) continue;
                        expression = expressionArray[n2 + 1];
                        break block121;
                    }
                    break block121;
                }
                case 209: {
                    if (value.getType() != 17) {
                        return ValueNull.INSTANCE;
                    }
                    Value value9 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    int n14 = value9.getInt();
                    Value[] valueArray2 = ((ValueArray)value).getList();
                    if (n14 < 1) return ValueNull.INSTANCE;
                    if (n14 > valueArray2.length) return ValueNull.INSTANCE;
                    return valueArray2[n14 - 1];
                }
                case 217: {
                    if (value.getType() != 17) return ValueNull.INSTANCE;
                    Value[] valueArray3 = ((ValueArray)value).getList();
                    return ValueInt.get(valueArray3.length);
                }
                case 230: {
                    Value[] valueArray4;
                    Value value2 = ValueBoolean.get(false);
                    if (value.getType() != 17) return value2;
                    Value value10 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    Value[] valueArray5 = valueArray4 = ((ValueArray)value).getList();
                    int n15 = valueArray5.length;
                    int n16 = 0;
                    while (n16 < n15) {
                        Value value11 = valueArray5[n16];
                        if (value11.equals(value10)) {
                            return ValueBoolean.get(true);
                        }
                        ++n16;
                    }
                    return value2;
                }
                case 221: {
                    return ValueBoolean.get(Function.cancelStatement(session, value.getInt()));
                }
                case 226: {
                    return session.getTransactionId();
                }
                default: {
                    return null;
                }
            }
            for (n2 = 1; n2 < n3; n2 += 2) {
                Value value12 = expressionArray[n2].getValue(session);
                if (value12 == ValueNull.INSTANCE || !value12.getBoolean().booleanValue()) continue;
                expression = expressionArray[n2 + 1];
                break;
            }
        }
        if (expression == null && expressionArray.length % 2 == 0) {
            expression = expressionArray[expressionArray.length - 1];
        }
        ValueNull valueNull = expression == null ? ValueNull.INSTANCE : expression.getValue(session);
        return ((Value)valueNull).convertTo(this.dataType);
    }

    private Value convertResult(Value value) {
        return value.convertTo(this.dataType);
    }

    private static boolean cancelStatement(Session session, int n2) {
        Session[] sessionArray;
        session.getUser().checkAdmin();
        for (Session session2 : sessionArray = session.getDatabase().getSessions(false)) {
            if (session2.getId() != n2) continue;
            Command command = session2.getCurrentCommand();
            if (command == null) {
                return false;
            }
            command.cancel();
            return true;
        }
        return false;
    }

    private static long getDiskSpaceUsed(Session session, Value value) {
        Parser parser = new Parser(session);
        String string = value.getString();
        Table table = parser.parseTableName(string);
        return table.getDiskSpaceUsed();
    }

    private static Value getNullOrValue(Session session, Expression[] expressionArray, Value[] valueArray, int n2) {
        if (n2 >= expressionArray.length) {
            return null;
        }
        Value value = valueArray[n2];
        if (value == null) {
            Expression expression = expressionArray[n2];
            if (expression == null) {
                return null;
            }
            value = valueArray[n2] = expression.getValue(session);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value getValueWithArgs(Session session, Expression[] expressionArray) {
        Object object;
        Value value;
        Value value2;
        Object object2;
        Value[] valueArray = new Value[expressionArray.length];
        if (this.info.nullIfParameterIsNull) {
            for (int i2 = 0; i2 < expressionArray.length; ++i2) {
                object2 = expressionArray[i2];
                value2 = ((Expression)object2).getValue(session);
                if (value2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                valueArray[i2] = value2;
            }
        }
        if ((object2 = this.getSimpleValue(session, value = Function.getNullOrValue(session, expressionArray, valueArray, 0), expressionArray, valueArray)) != null) {
            return object2;
        }
        value2 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
        Value value3 = Function.getNullOrValue(session, expressionArray, valueArray, 2);
        Value value4 = Function.getNullOrValue(session, expressionArray, valueArray, 3);
        Value value5 = Function.getNullOrValue(session, expressionArray, valueArray, 4);
        Value value6 = Function.getNullOrValue(session, expressionArray, valueArray, 5);
        block6 : switch (this.info.type) {
            case 4: {
                object = ValueDouble.get(Math.atan2(value.getDouble(), value2.getDouble()));
                break;
            }
            case 5: {
                object = ValueLong.get(value.getLong() & value2.getLong());
                break;
            }
            case 6: {
                object = ValueLong.get(value.getLong() | value2.getLong());
                break;
            }
            case 7: {
                object = ValueLong.get(value.getLong() ^ value2.getLong());
                break;
            }
            case 16: {
                long l2 = value2.getLong();
                if (l2 == 0L) {
                    throw DbException.get(22012, this.getSQL());
                }
                object = ValueLong.get(value.getLong() % l2);
                break;
            }
            case 18: {
                object = ValueDouble.get(Math.pow(value.getDouble(), value2.getDouble()));
                break;
            }
            case 21: {
                double d2 = value2 == null ? 1.0 : Math.pow(10.0, value2.getDouble());
                object = ValueDouble.get((double)Math.round(value.getDouble() * d2) / d2);
                break;
            }
            case 27: {
                if (value.getType() == 11) {
                    Timestamp timestamp = value.getTimestamp();
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(timestamp);
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    object = ValueTimestamp.fromMillis(calendar.getTimeInMillis());
                    break;
                }
                if (value.getType() == 10) {
                    ValueDate valueDate = (ValueDate)value;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(valueDate.getDate());
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    object = ValueTimestamp.fromMillis(calendar.getTimeInMillis());
                    break;
                }
                if (value.getType() == 13) {
                    ValueString valueString = (ValueString)value;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(ValueTimestamp.parse(valueString.getString()).getDate());
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    object = ValueTimestamp.fromMillis(calendar.getTimeInMillis());
                    break;
                }
                double d3 = value.getDouble();
                int n2 = value2 == null ? 0 : value2.getInt();
                double d4 = Math.pow(10.0, n2);
                double d5 = d3 * d4;
                object = ValueDouble.get((d3 < 0.0 ? Math.ceil(d5) : Math.floor(d5)) / d4);
                break;
            }
            case 29: {
                object = ValueBytes.getNoCopy(Function.getHash(value.getString(), value2.getBytesNoCopy(), value3.getInt()));
                break;
            }
            case 30: {
                object = ValueBytes.getNoCopy(Function.encrypt(value.getString(), value2.getBytesNoCopy(), value3.getBytesNoCopy()));
                break;
            }
            case 31: {
                object = ValueBytes.getNoCopy(Function.decrypt(value.getString(), value2.getBytesNoCopy(), value3.getBytesNoCopy()));
                break;
            }
            case 32: {
                String string = null;
                if (value2 != null) {
                    string = value2.getString();
                }
                object = ValueBytes.getNoCopy(CompressTool.getInstance().compress(value.getBytesNoCopy(), string));
                break;
            }
            case 55: {
                object = ValueInt.get(Function.getDifference(value.getString(), value2.getString()));
                break;
            }
            case 57: {
                if (value2 == ValueNull.INSTANCE || value3 == ValueNull.INSTANCE) {
                    object = value2;
                    break;
                }
                object = ValueString.get(Function.insert(value.getString(), value2.getInt(), value3.getInt(), value4.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 60: {
                object = ValueString.get(Function.left(value.getString(), value2.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 62: {
                int n3 = value3 == null ? 0 : value3.getInt();
                object = ValueInt.get(Function.locate(value.getString(), value2.getString(), n3));
                break;
            }
            case 58: {
                int n4 = value3 == null ? 0 : value3.getInt();
                object = ValueInt.get(Function.locate(value2.getString(), value.getString(), n4));
                break;
            }
            case 66: {
                int n5 = Math.max(0, value2.getInt());
                object = ValueString.get(Function.repeat(value.getString(), n5), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 67: {
                String string = value.getString();
                String string2 = value2.getString();
                String string3 = value3 == null ? "" : value3.getString();
                object = ValueString.get(Function.replace(string, string2, string3), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 68: {
                object = ValueString.get(Function.right(value.getString(), value2.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 63: {
                object = ValueString.get(StringUtils.trim(value.getString(), true, false, value2 == null ? " " : value2.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 78: {
                object = ValueString.get(StringUtils.trim(value.getString(), true, true, value2 == null ? " " : value2.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 69: {
                object = ValueString.get(StringUtils.trim(value.getString(), false, true, value2 == null ? " " : value2.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 72: 
            case 73: {
                String string = value.getString();
                int n6 = value2.getInt();
                if (n6 < 0) {
                    n6 = string.length() + n6 + 1;
                }
                int n7 = value3 == null ? string.length() : value3.getInt();
                object = ValueString.get(Function.substring(string, n6, n7), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 77: {
                object = ValueInt.get(Function.locate(value.getString(), value2.getString(), 0));
                break;
            }
            case 83: {
                object = ValueString.get(StringUtils.xmlAttr(value.getString(), value2.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 84: {
                String string;
                String string4 = value2 == null ? null : (string = value2 == ValueNull.INSTANCE ? null : value2.getString());
                String string5 = value3 == null ? null : (value3 == ValueNull.INSTANCE ? null : value3.getString());
                boolean bl2 = value4 == null ? true : value4.getBoolean();
                object = ValueString.get(StringUtils.xmlNode(value.getString(), string, string5, bl2), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 89: {
                String string = value2.getString();
                String string6 = value3.getString();
                try {
                    object = ValueString.get(value.getString().replaceAll(string, string6), this.database.getMode().treatEmptyStringsAsNull);
                    break;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    throw DbException.get(22025, stringIndexOutOfBoundsException, string6);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DbException.get(22025, patternSyntaxException, string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DbException.get(22025, illegalArgumentException, string6);
                }
            }
            case 90: {
                object = ValueString.get(StringUtils.pad(value.getString(), value2.getInt(), value3 == null ? null : value3.getString(), true), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 91: {
                object = ValueString.get(StringUtils.pad(value.getString(), value2.getInt(), value3 == null ? null : value3.getString(), false), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 95: {
                object = ValueLong.get(Function.oraHash(value.getString(), value2 == null ? null : Integer.valueOf(value2.getInt()), value3 == null ? null : Integer.valueOf(value3.getInt())).intValue());
                break;
            }
            case 93: {
                switch (value.getType()) {
                    case 9: 
                    case 10: 
                    case 11: {
                        object = ValueString.get(ToChar.toChar(value.getTimestamp(), value2 == null ? null : value2.getString(), value3 == null ? null : value3.getString()), this.database.getMode().treatEmptyStringsAsNull);
                        break block6;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        object = ValueString.get(ToChar.toChar(value.getBigDecimal(), value2 == null ? null : value2.getString(), value3 == null ? null : value3.getString()), this.database.getMode().treatEmptyStringsAsNull);
                        break block6;
                    }
                }
                object = ValueString.get(value.getString(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 96: {
                object = ValueTimestamp.get(ToDateParser.toDate(value.getString(), value2 == null ? null : value2.getString()));
                break;
            }
            case 97: {
                object = ValueTimestamp.get(ToDateParser.toTimestamp(value.getString(), value2 == null ? null : value2.getString()));
                break;
            }
            case 98: {
                object = ValueTimestamp.get(DateTimeUtils.addMonths(value.getTimestamp(), value2.getInt()));
                break;
            }
            case 94: {
                String string = value2.getString();
                String string7 = value3.getString();
                object = ValueString.get(Function.translate(value.getString(), string, string7), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 231: {
                object = ValueString.get(Constants.getVersion(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 102: {
                object = ValueTimestamp.get(Function.dateadd(value.getString(), value2.getLong(), value3.getTimestamp()));
                break;
            }
            case 103: {
                object = ValueLong.get(Function.datediff(value.getString(), value2.getTimestamp(), value3.getTimestamp()));
                break;
            }
            case 120: {
                int n8 = Function.getDatePart(value.getString());
                object = ValueInt.get(DateTimeUtils.getDatePart(value2.getTimestamp(), n8));
                break;
            }
            case 121: {
                String string;
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    object = ValueNull.INSTANCE;
                    break;
                }
                String string8 = value3 == null ? null : (string = value3 == ValueNull.INSTANCE ? null : value3.getString());
                String string9 = value4 == null ? null : (value4 == ValueNull.INSTANCE ? null : value4.getString());
                object = ValueString.get(DateTimeUtils.formatDateTime(value.getTimestamp(), value2.getString(), string, string9), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 122: {
                String string;
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    object = ValueNull.INSTANCE;
                    break;
                }
                String string10 = value3 == null ? null : (string = value3 == ValueNull.INSTANCE ? null : value3.getString());
                String string11 = value4 == null ? null : (value4 == ValueNull.INSTANCE ? null : value4.getString());
                Date date = DateTimeUtils.parseDateTime(value.getString(), value2.getString(), string, string11);
                object = ValueTimestamp.fromMillis(date.getTime());
                break;
            }
            case 205: {
                object = this.database.areEqual(value, value2) ? ValueNull.INSTANCE : value;
                break;
            }
            case 207: {
                Sequence sequence = this.getSequence(session, value, value2);
                SequenceValue sequenceValue = new SequenceValue(sequence);
                object = sequenceValue.getValue(session);
                break;
            }
            case 208: {
                Sequence sequence = this.getSequence(session, value, value2);
                object = ValueLong.get(sequence.getCurrentValue());
                break;
            }
            case 210: {
                Object object3;
                String[] stringArray;
                String string = value.getString();
                String string12 = value2 == null ? null : value2.getString();
                Csv csv = new Csv();
                String string13 = value3 == null ? null : value3.getString();
                String string14 = null;
                if (string13 != null && string13.indexOf(61) >= 0) {
                    string14 = csv.setOptions(string13);
                } else {
                    string14 = string13;
                    String string15 = value4 == null ? null : value4.getString();
                    stringArray = value5 == null ? null : value5.getString();
                    object3 = value6 == null ? null : value6.getString();
                    Value value7 = Function.getNullOrValue(session, expressionArray, valueArray, 6);
                    String string16 = value7 == null ? null : value7.getString();
                    Function.setCsvDelimiterEscape(csv, string15, (String)stringArray, (String)object3);
                    csv.setNullString(string16);
                }
                char c2 = csv.getFieldSeparatorRead();
                stringArray = StringUtils.arraySplit(string12, c2, true);
                try {
                    object = object3 = ValueResultSet.get(csv.read(string, stringArray, string14));
                    break;
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
            }
            case 218: {
                session.getUser().checkAdmin();
                JdbcConnection jdbcConnection = session.createConnection(false);
                ResultSet resultSet = LinkSchema.linkSchema(jdbcConnection, value.getString(), value2.getString(), value3.getString(), value4.getString(), value5.getString(), value6.getString());
                object = ValueResultSet.get(resultSet);
                break;
            }
            case 211: {
                session.getUser().checkAdmin();
                JdbcConnection jdbcConnection = session.createConnection(false);
                Csv csv = new Csv();
                String string = value3 == null ? null : value3.getString();
                String string17 = null;
                if (string != null && string.indexOf(61) >= 0) {
                    string17 = csv.setOptions(string);
                } else {
                    string17 = string;
                    String string18 = value4 == null ? null : value4.getString();
                    String string19 = value5 == null ? null : value5.getString();
                    String string20 = value6 == null ? null : value6.getString();
                    Value value8 = Function.getNullOrValue(session, expressionArray, valueArray, 6);
                    String string21 = value8 == null ? null : value8.getString();
                    Value value9 = Function.getNullOrValue(session, expressionArray, valueArray, 7);
                    String string22 = value9 == null ? null : value9.getString();
                    Function.setCsvDelimiterEscape(csv, string18, string19, string20);
                    csv.setNullString(string21);
                    if (string22 != null) {
                        csv.setLineSeparator(string22);
                    }
                }
                try {
                    int n9 = csv.write(jdbcConnection, value.getString(), value2.getString(), string17);
                    object = ValueInt.get(n9);
                    break;
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
            }
            case 222: {
                Variable variable = (Variable)expressionArray[0];
                session.setVariable(variable.getName(), value2);
                object = value2;
                break;
            }
            case 225: {
                session.getUser().checkAdmin();
                String string = value.getString();
                boolean bl3 = expressionArray.length == 1;
                try {
                    AutoCloseInputStream autoCloseInputStream = new AutoCloseInputStream(FileUtils.newInputStream(string));
                    if (bl3) {
                        object = this.database.getLobStorage().createBlob(autoCloseInputStream, -1L);
                    } else {
                        InputStreamReader inputStreamReader = value2 == ValueNull.INSTANCE ? new InputStreamReader(autoCloseInputStream) : new InputStreamReader((InputStream)autoCloseInputStream, value2.getString());
                        object = this.database.getLobStorage().createClob(inputStreamReader, -1L);
                    }
                    session.addTemporaryLob((Value)object);
                    break;
                }
                catch (IOException iOException) {
                    throw DbException.convertIOException(iOException, string);
                }
            }
            case 232: {
                session.getUser().checkAdmin();
                object = ValueNull.INSTANCE;
                String string = value2.getString();
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                    try (InputStream inputStream = value.getInputStream();){
                        object = ValueLong.get(IOUtils.copyAndClose(inputStream, fileOutputStream));
                        break;
                    }
                }
                catch (IOException iOException) {
                    throw DbException.convertIOException(iOException, string);
                }
            }
            case 227: {
                object = value.convertPrecision(value2.getLong(), value3.getBoolean());
                break;
            }
            case 88: {
                if (value2 == null) {
                    object = ValueString.get(StringUtils.xmlText(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                    break;
                }
                object = ValueString.get(StringUtils.xmlText(value.getString(), value2.getBoolean()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 250: {
                object = session.getVariable(expressionArray[0].getSchemaName() + "." + expressionArray[0].getTableName() + "." + expressionArray[0].getColumnName());
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.info.type);
            }
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Sequence getSequence(Session session, Value value, Value value2) {
        Object object;
        String string;
        Object object2;
        Object object3;
        if (value2 == null) {
            object3 = new Parser(session);
            object2 = value.getString();
            Expression expression = ((Parser)object3).parseExpression((String)object2);
            if (!(expression instanceof ExpressionColumn)) throw DbException.getSyntaxError((String)object2, 1);
            ExpressionColumn expressionColumn = (ExpressionColumn)expression;
            string = expressionColumn.getOriginalTableAliasName();
            if (string == null) {
                string = session.getCurrentSchemaName();
                object = object2;
            } else {
                object = expressionColumn.getColumnName();
            }
        } else {
            string = value.getString();
            object = value2.getString();
        }
        if ((object3 = this.database.findSchema(string)) == null) {
            string = StringUtils.toUpperEnglish(string);
            object3 = this.database.getSchema(string);
        }
        if ((object2 = ((Schema)object3).findSequence((String)object)) != null) return object2;
        object = StringUtils.toUpperEnglish((String)object);
        return ((Schema)object3).getSequence((String)object);
    }

    private static long length(Value value) {
        switch (value.getType()) {
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                return value.getPrecision();
            }
        }
        return value.getString().length();
    }

    private static byte[] getPaddedArrayCopy(byte[] byArray, int n2) {
        int n3 = MathUtils.roundUpInt(byArray.length, n2);
        byte[] byArray2 = DataUtils.newBytes(n3);
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    private static byte[] decrypt(String string, byte[] byArray, byte[] byArray2) {
        BlockCipher blockCipher = CipherFactory.getBlockCipher(string);
        byte[] byArray3 = Function.getPaddedArrayCopy(byArray, blockCipher.getKeyLength());
        blockCipher.setKey(byArray3);
        byte[] byArray4 = Function.getPaddedArrayCopy(byArray2, 16);
        blockCipher.decrypt(byArray4, 0, byArray4.length);
        return byArray4;
    }

    private static byte[] encrypt(String string, byte[] byArray, byte[] byArray2) {
        BlockCipher blockCipher = CipherFactory.getBlockCipher(string);
        byte[] byArray3 = Function.getPaddedArrayCopy(byArray, blockCipher.getKeyLength());
        blockCipher.setKey(byArray3);
        byte[] byArray4 = Function.getPaddedArrayCopy(byArray2, 16);
        blockCipher.encrypt(byArray4, 0, byArray4.length);
        return byArray4;
    }

    private static byte[] getHash(String string, byte[] byArray, int n2) {
        if (!"SHA256".equalsIgnoreCase(string)) {
            throw DbException.getInvalidValueException("algorithm", string);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray = SHA256.getHash(byArray, false);
        }
        return byArray;
    }

    public static boolean isDatePart(String string) {
        Integer n2 = DATE_PART.get(StringUtils.toUpperEnglish(string));
        return n2 != null;
    }

    private static int getDatePart(String string) {
        Integer n2 = DATE_PART.get(StringUtils.toUpperEnglish(string));
        if (n2 == null) {
            throw DbException.getInvalidValueException("date part", string);
        }
        return n2;
    }

    private static Timestamp dateadd(String string, long l2, Timestamp timestamp) {
        int n2 = Function.getDatePart(string);
        if (n2 == 14) {
            Timestamp timestamp2 = new Timestamp(timestamp.getTime() + l2);
            timestamp2.setNanos(timestamp2.getNanos() + timestamp.getNanos() % 1000000);
            return timestamp2;
        }
        if (l2 > Integer.MAX_VALUE) {
            throw DbException.getInvalidValueException("DATEADD count", l2);
        }
        Calendar calendar = Calendar.getInstance();
        int n3 = timestamp.getNanos() % 1000000;
        calendar.setTime(timestamp);
        calendar.add(n2, (int)l2);
        long l3 = calendar.getTime().getTime();
        Timestamp timestamp3 = new Timestamp(l3);
        timestamp3.setNanos(timestamp3.getNanos() + n3);
        return timestamp3;
    }

    private static long datediff(String string, Timestamp timestamp, Timestamp timestamp2) {
        int n2 = Function.getDatePart(string);
        Calendar calendar = Calendar.getInstance();
        long l2 = timestamp.getTime();
        long l3 = timestamp2.getTime();
        TimeZone timeZone = calendar.getTimeZone();
        calendar.setTime(timestamp);
        l2 += (long)timeZone.getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14));
        calendar.setTime(timestamp2);
        l3 += (long)timeZone.getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14));
        switch (n2) {
            case 14: {
                return l3 - l2;
            }
            case 3: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                long l4 = 3600000L;
                long l5 = Math.min(l2 / l4 * l4, l3 / l4 * l4);
                l2 -= l5;
                l3 -= l5;
                switch (n2) {
                    case 13: {
                        return l3 / 1000L - l2 / 1000L;
                    }
                    case 12: {
                        return l3 / 60000L - l2 / 60000L;
                    }
                    case 11: {
                        return l3 / l4 - l2 / l4;
                    }
                    case 6: {
                        return l3 / (l4 * 24L) - l2 / (l4 * 24L);
                    }
                    case 3: {
                        return l3 / (l4 * 24L * 7L) - l2 / (l4 * 24L * 7L);
                    }
                }
                throw DbException.throwInternalError("field:" + n2);
            }
            case 5: {
                return l3 / 86400000L - l2 / 86400000L;
            }
        }
        calendar.setTimeInMillis(l2);
        int n3 = calendar.get(1);
        int n4 = calendar.get(2);
        calendar.setTimeInMillis(l3);
        int n5 = calendar.get(1);
        int n6 = calendar.get(2);
        int n7 = n5 - n3;
        if (n2 == 2) {
            return 12 * n7 + (n6 - n4);
        }
        if (n2 == 1) {
            return n7;
        }
        throw DbException.getUnsupportedException("DATEDIFF " + string);
    }

    private static String substring(String string, int n2, int n3) {
        int n4 = string.length();
        if (--n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        int n5 = n2 = n2 > n4 ? n4 : n2;
        if (n2 + n3 > n4) {
            n3 = n4 - n2;
        }
        return string.substring(n2, n2 + n3);
    }

    private static String replace(String string, String string2, String string3) {
        int n2;
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n3 = 0;
        int n4 = string2.length();
        while ((n2 = string.indexOf(string2, n3)) != -1) {
            stringBuilder.append(string.substring(n3, n2)).append(string3);
            n3 = n2 + n4;
        }
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    private static String repeat(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * n2);
        while (n2-- > 0) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String rawToHex(String string) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(4 * n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = Integer.toHexString(string.charAt(i2) & 0xFFFF);
            for (int i3 = string2.length(); i3 < 4; ++i3) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static int locate(String string, String string2, int n2) {
        if (n2 < 0) {
            int n3 = string2.length() + n2;
            return string2.lastIndexOf(string, n3) + 1;
        }
        int n4 = n2 == 0 ? 0 : n2 - 1;
        return string2.indexOf(string, n4) + 1;
    }

    private static String right(String string, int n2) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > string.length()) {
            n2 = string.length();
        }
        return string.substring(string.length() - n2);
    }

    private static String left(String string, int n2) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > string.length()) {
            n2 = string.length();
        }
        return string.substring(0, n2);
    }

    private static String insert(String string, int n2, int n3, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n4 = string.length();
        int n5 = string2.length();
        if (--n2 < 0 || n3 <= 0 || n5 == 0 || n2 > n4) {
            return string;
        }
        if (n2 + n3 > n4) {
            n3 = n4 - n2;
        }
        return string.substring(0, n2) + string2 + string.substring(n2 + n3);
    }

    private static String hexToRaw(String string) {
        int n2 = string.length();
        if (n2 % 4 != 0) {
            throw DbException.get(22018, string);
        }
        StringBuilder stringBuilder = new StringBuilder(n2 / 4);
        for (int i2 = 0; i2 < n2; i2 += 4) {
            try {
                char c2 = (char)Integer.parseInt(string.substring(i2, i2 + 4), 16);
                stringBuilder.append(c2);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw DbException.get(22018, string);
            }
        }
        return stringBuilder.toString();
    }

    private static int getDifference(String string, String string2) {
        string = Function.getSoundex(string);
        string2 = Function.getSoundex(string2);
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            if (string.charAt(i2) != string2.charAt(i2)) continue;
            ++n2;
        }
        return n2;
    }

    private static String translate(String string, String string2, String string3) {
        if (StringUtils.isNullOrEmpty(string) || StringUtils.isNullOrEmpty(string2)) {
            return string;
        }
        StringBuilder stringBuilder = null;
        int n2 = string3 == null ? 0 : string3.length();
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            int n4 = string2.indexOf(c2);
            if (n4 >= 0) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(n3);
                    if (i2 > 0) {
                        stringBuilder.append(string.substring(0, i2));
                    }
                }
                if (n4 < n2) {
                    c2 = string3.charAt(n4);
                }
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    private static double roundMagic(double d2) {
        if (d2 < 1.0E-13 && d2 > -1.0E-13) {
            return 0.0;
        }
        if (d2 > 1.0E12 || d2 < -1.0E12) {
            return d2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(d2);
        if (stringBuilder.toString().indexOf(69) >= 0) {
            return d2;
        }
        int n2 = stringBuilder.length();
        if (n2 < 16) {
            return d2;
        }
        if (stringBuilder.toString().indexOf(46) > n2 - 3) {
            return d2;
        }
        stringBuilder.delete(n2 - 2, n2);
        char c2 = stringBuilder.charAt((n2 -= 2) - 2);
        char c3 = stringBuilder.charAt(n2 - 3);
        char c4 = stringBuilder.charAt(n2 - 4);
        if (c2 == '0' && c3 == '0' && c4 == '0') {
            stringBuilder.setCharAt(n2 - 1, '0');
        } else if (c2 == '9' && c3 == '9' && c4 == '9') {
            stringBuilder.setCharAt(n2 - 1, '9');
            stringBuilder.append('9');
            stringBuilder.append('9');
            stringBuilder.append('9');
        }
        return Double.parseDouble(stringBuilder.toString());
    }

    private static String getSoundex(String string) {
        int n2 = string.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        char c2 = '0';
        int n3 = 0;
        for (int i2 = 0; i2 < n2 && n3 < 4; ++i2) {
            char c3;
            char c4 = string.charAt(i2);
            char c5 = c3 = c4 > SOUNDEX_INDEX.length ? (char)'\u0000' : SOUNDEX_INDEX[c4];
            if (c3 == '\u0000') continue;
            if (n3 == 0) {
                cArray[n3++] = c4;
                c2 = c3;
                continue;
            }
            if (c3 <= '6') {
                if (c3 == c2) continue;
                cArray[n3++] = c3;
                c2 = c3;
                continue;
            }
            if (c3 != '7') continue;
            c2 = c3;
        }
        return new String(cArray);
    }

    private static Integer oraHash(String string, Integer n2, Integer n3) {
        int n4 = string.hashCode();
        if (n3 != null && n3 != 0) {
            n4 *= n3 * 17;
        }
        if (n2 != null && n2 > 0) {
            n4 %= n2.intValue();
        }
        return n4;
    }

    @Override
    public int getType() {
        return this.dataType;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n2) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.mapColumns(columnResolver, n2);
        }
    }

    protected void checkParameterCount(int n2) {
        boolean bl2;
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        switch (this.info.type) {
            case 204: 
            case 210: 
            case 219: 
            case 220: {
                n3 = 1;
                break;
            }
            case 20: 
            case 112: 
            case 119: {
                n4 = 1;
                break;
            }
            case 21: 
            case 27: 
            case 32: 
            case 63: 
            case 69: 
            case 78: 
            case 88: 
            case 97: 
            case 225: {
                n3 = 1;
                n4 = 2;
                break;
            }
            case 93: 
            case 96: {
                n3 = 1;
                n4 = 3;
                break;
            }
            case 95: {
                n3 = 1;
                n4 = 3;
                break;
            }
            case 58: 
            case 62: 
            case 67: 
            case 72: 
            case 73: 
            case 90: 
            case 91: {
                n3 = 2;
                n4 = 3;
                break;
            }
            case 54: 
            case 92: 
            case 211: {
                n3 = 2;
                break;
            }
            case 84: {
                n3 = 1;
                n4 = 4;
                break;
            }
            case 121: 
            case 122: {
                n3 = 2;
                n4 = 4;
                break;
            }
            case 207: 
            case 208: {
                n3 = 1;
                n4 = 2;
                break;
            }
            case 206: 
            case 229: {
                n3 = 3;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.info.type);
            }
        }
        boolean bl3 = bl2 = n2 >= n3 && n2 <= n4;
        if (!bl2) {
            throw DbException.get(7001, this.info.name, n3 + ".." + n4);
        }
    }

    public void doneWithParameters() {
        if (this.info.parameterCount == -1) {
            int n2 = this.varArgs.size();
            this.checkParameterCount(n2);
            this.args = new Expression[n2];
            this.varArgs.toArray(this.args);
            this.varArgs = null;
        } else {
            int n3 = this.args.length;
            if (n3 > 0 && this.args[n3 - 1] == null) {
                throw DbException.get(7001, this.info.name, "" + n3);
            }
        }
    }

    public void setDataType(Column column) {
        this.dataType = column.getType();
        this.precision = column.getPrecision();
        this.displaySize = column.getDisplaySize();
        this.scale = column.getScale();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Expression optimize(Session session) {
        int n2;
        long l2;
        int n3;
        int n4;
        boolean bl2 = this.info.deterministic;
        for (n4 = 0; n4 < this.args.length; ++n4) {
            Expression expression = this.args[n4];
            if (expression == null) continue;
            this.args[n4] = expression = expression.optimize(session);
            if (expression.isConstant()) continue;
            bl2 = false;
        }
        Expression expression = this.args.length < 1 ? null : this.args[0];
        switch (this.info.type) {
            case 200: 
            case 204: 
            case 205: 
            case 219: 
            case 220: {
                n4 = -1;
                n3 = 0;
                l2 = 0L;
                n2 = 0;
                for (Expression expression2 : this.args) {
                    int n5;
                    if (expression2 == ValueExpression.getNull() || (n5 = expression2.getType()) == -1 || n5 == 0) continue;
                    n4 = Value.getHigherOrder(n4, n5);
                    n3 = Math.max(n3, expression2.getScale());
                    l2 = Math.max(l2, expression2.getPrecision());
                    n2 = Math.max(n2, expression2.getDisplaySize());
                }
                if (n4 != -1) break;
                n4 = 13;
                n3 = 0;
                l2 = Integer.MAX_VALUE;
                n2 = Integer.MAX_VALUE;
                break;
            }
            case 206: 
            case 229: {
                Expression expression5;
                void expression3;
                n4 = -1;
                n3 = 0;
                l2 = 0L;
                n2 = 0;
                int i2 = 2;
                int n6 = this.args.length;
                while (expression3 < n6) {
                    int n7;
                    Expression expression4 = this.args[expression3];
                    if (expression4 != ValueExpression.getNull() && (n7 = expression4.getType()) != -1 && n7 != 0) {
                        n4 = Value.getHigherOrder(n4, n7);
                        n3 = Math.max(n3, expression4.getScale());
                        l2 = Math.max(l2, expression4.getPrecision());
                        n2 = Math.max(n2, expression4.getDisplaySize());
                    }
                    expression3 += 2;
                }
                if (this.args.length % 2 == 0 && (expression5 = this.args[this.args.length - 1]) != ValueExpression.getNull() && (n6 = expression5.getType()) != -1 && n6 != 0) {
                    n4 = Value.getHigherOrder(n4, n6);
                    n3 = Math.max(n3, expression5.getScale());
                    l2 = Math.max(l2, expression5.getPrecision());
                    n2 = Math.max(n2, expression5.getDisplaySize());
                }
                if (n4 != -1) break;
                n4 = 13;
                n3 = 0;
                l2 = Integer.MAX_VALUE;
                n2 = Integer.MAX_VALUE;
                break;
            }
            case 201: {
                n4 = Value.getHigherOrder(this.args[1].getType(), this.args[2].getType());
                l2 = Math.max(this.args[1].getPrecision(), this.args[2].getPrecision());
                n2 = Math.max(this.args[1].getDisplaySize(), this.args[2].getDisplaySize());
                n3 = Math.max(this.args[1].getScale(), this.args[2].getScale());
                break;
            }
            case 228: {
                switch (this.args[1].getType()) {
                    case 13: 
                    case 14: 
                    case 16: 
                    case 21: {
                        n4 = this.args[1].getType();
                        break;
                    }
                    default: {
                        n4 = Value.getHigherOrder(this.args[1].getType(), this.args[2].getType());
                    }
                }
                l2 = Math.max(this.args[1].getPrecision(), this.args[2].getPrecision());
                n2 = Math.max(this.args[1].getDisplaySize(), this.args[2].getDisplaySize());
                n3 = Math.max(this.args[1].getScale(), this.args[2].getScale());
                break;
            }
            case 202: 
            case 203: 
            case 227: {
                n4 = this.dataType;
                l2 = this.precision;
                n3 = this.scale;
                n2 = this.displaySize;
                break;
            }
            case 27: {
                n4 = expression.getType();
                n3 = expression.getScale();
                l2 = expression.getPrecision();
                n2 = expression.getDisplaySize();
                if (n4 == 0) {
                    n4 = 4;
                    l2 = 10L;
                    n2 = 11;
                    n3 = 0;
                    break;
                }
                if (n4 != 11) break;
                n4 = 10;
                l2 = 8L;
                n3 = 0;
                n2 = 10;
                break;
            }
            case 0: 
            case 13: 
            case 21: {
                n4 = expression.getType();
                n3 = expression.getScale();
                l2 = expression.getPrecision();
                n2 = expression.getDisplaySize();
                if (n4 != 0) break;
                n4 = 4;
                l2 = 10L;
                n2 = 11;
                n3 = 0;
                break;
            }
            case 222: {
                Expression dataType = this.args[1];
                n4 = dataType.getType();
                l2 = dataType.getPrecision();
                n3 = dataType.getScale();
                n2 = dataType.getDisplaySize();
                if (expression instanceof Variable) break;
                throw DbException.get(90137, expression.getSQL());
            }
            case 225: {
                n4 = this.args.length == 1 ? 15 : 16;
                l2 = Integer.MAX_VALUE;
                n3 = 0;
                n2 = Integer.MAX_VALUE;
                break;
            }
            case 72: 
            case 73: {
                n4 = this.info.dataType;
                l2 = this.args[0].getPrecision();
                n3 = 0;
                if (this.args[1].isConstant()) {
                    l2 -= this.args[1].getValue(session).getLong() - 1L;
                }
                if (this.args.length == 3 && this.args[2].isConstant()) {
                    l2 = Math.min(l2, this.args[2].getValue(session).getLong());
                }
                l2 = Math.max(0L, l2);
                n2 = MathUtils.convertLongToInt(l2);
                break;
            }
            default: {
                n4 = this.info.dataType;
                DataType dataType = DataType.getDataType(n4);
                l2 = -1L;
                n2 = 0;
                n3 = dataType.defaultScale;
            }
        }
        this.dataType = n4;
        this.precision = l2;
        this.scale = n3;
        this.displaySize = n2;
        if (bl2) {
            Value value = this.getValue(session);
            if (value == ValueNull.INSTANCE && (this.info.type == 203 || this.info.type == 202)) {
                return this;
            }
            return ValueExpression.get(value);
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl2) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.setEvaluatable(tableFilter, bl2);
        }
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public long getPrecision() {
        if (this.precision == -1L) {
            this.calculatePrecisionAndDisplaySize();
        }
        return this.precision;
    }

    @Override
    public int getDisplaySize() {
        if (this.precision == -1L) {
            this.calculatePrecisionAndDisplaySize();
        }
        return this.displaySize;
    }

    private void calculatePrecisionAndDisplaySize() {
        switch (this.info.type) {
            case 30: 
            case 31: {
                this.precision = this.args[2].getPrecision();
                this.displaySize = this.args[2].getDisplaySize();
                break;
            }
            case 32: {
                this.precision = this.args[0].getPrecision();
                this.displaySize = this.args[0].getDisplaySize();
                break;
            }
            case 52: {
                this.precision = 1L;
                this.displaySize = 1;
                break;
            }
            case 54: {
                this.precision = 0L;
                this.displaySize = 0;
                for (Expression expression : this.args) {
                    this.precision += expression.getPrecision();
                    this.displaySize = MathUtils.convertLongToInt((long)this.displaySize + (long)expression.getDisplaySize());
                    if (this.precision >= 0L) continue;
                    this.precision = Long.MAX_VALUE;
                }
                break;
            }
            case 56: {
                this.precision = (this.args[0].getPrecision() + 3L) / 4L;
                this.displaySize = MathUtils.convertLongToInt(this.precision);
                break;
            }
            case 27: 
            case 59: 
            case 63: 
            case 68: 
            case 69: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: {
                this.precision = this.args[0].getPrecision();
                this.displaySize = this.args[0].getDisplaySize();
                break;
            }
            case 65: {
                this.precision = this.args[0].getPrecision() * 4L;
                this.displaySize = MathUtils.convertLongToInt(this.precision);
                break;
            }
            case 70: {
                this.precision = 4L;
                this.displaySize = (int)this.precision;
                break;
            }
            case 104: 
            case 111: {
                this.precision = 20L;
                this.displaySize = (int)this.precision;
                break;
            }
            default: {
                DataType dataType = DataType.getDataType(this.dataType);
                this.precision = dataType.defaultPrecision;
                this.displaySize = dataType.defaultDisplaySize;
            }
        }
    }

    @Override
    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder(this.info.name);
        if (this.info.type == 206) {
            if (this.args[0] != null) {
                statementBuilder.append(" ").append(this.args[0].getSQL());
            }
            int n2 = this.args.length - 1;
            for (int i2 = 1; i2 < n2; i2 += 2) {
                statementBuilder.append(" WHEN ").append(this.args[i2].getSQL());
                statementBuilder.append(" THEN ").append(this.args[i2 + 1].getSQL());
            }
            if (this.args.length % 2 == 0) {
                statementBuilder.append(" ELSE ").append(this.args[this.args.length - 1].getSQL());
            }
            return statementBuilder.append(" END").toString();
        }
        statementBuilder.append('(');
        switch (this.info.type) {
            case 203: {
                statementBuilder.append(this.args[0].getSQL()).append(" AS ").append(new Column(null, this.dataType, this.precision, this.scale, this.displaySize).getCreateSQL());
                break;
            }
            case 202: {
                if (this.database.getMode().swapConvertFunctionParameters) {
                    statementBuilder.append(new Column(null, this.dataType, this.precision, this.scale, this.displaySize).getCreateSQL()).append(',').append(this.args[0].getSQL());
                    break;
                }
                statementBuilder.append(this.args[0].getSQL()).append(',').append(new Column(null, this.dataType, this.precision, this.scale, this.displaySize).getCreateSQL());
                break;
            }
            case 120: {
                ValueString valueString = (ValueString)((ValueExpression)this.args[0]).getValue(null);
                statementBuilder.append(valueString.getString()).append(" FROM ").append(this.args[1].getSQL());
                break;
            }
            default: {
                for (Expression expression : this.args) {
                    statementBuilder.appendExceptFirst(", ");
                    statementBuilder.append(expression.getSQL());
                }
            }
        }
        return statementBuilder.append(')').toString();
    }

    @Override
    public void updateAggregate(Session session) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.updateAggregate(session);
        }
    }

    public int getFunctionType() {
        return this.info.type;
    }

    @Override
    public String getName() {
        return this.info.name;
    }

    @Override
    public ValueResultSet getValueForColumnList(Session session, Expression[] expressionArray) {
        switch (this.info.type) {
            case 210: {
                ValueResultSet valueResultSet;
                ResultSet resultSet;
                String[] stringArray;
                String string = expressionArray[0].getValue(session).getString();
                if (string == null) {
                    throw DbException.get(90012, "fileName");
                }
                String string2 = expressionArray.length < 2 ? null : expressionArray[1].getValue(session).getString();
                Csv csv = new Csv();
                String string3 = expressionArray.length < 3 ? null : expressionArray[2].getValue(session).getString();
                String string4 = null;
                if (string3 != null && string3.indexOf(61) >= 0) {
                    string4 = csv.setOptions(string3);
                } else {
                    string4 = string3;
                    String string5 = expressionArray.length < 4 ? null : expressionArray[3].getValue(session).getString();
                    stringArray = expressionArray.length < 5 ? null : expressionArray[4].getValue(session).getString();
                    resultSet = expressionArray.length < 6 ? null : expressionArray[5].getValue(session).getString();
                    Function.setCsvDelimiterEscape(csv, string5, (String)stringArray, (String)((Object)resultSet));
                }
                char c2 = csv.getFieldSeparatorRead();
                stringArray = StringUtils.arraySplit(string2, c2, true);
                resultSet = null;
                try {
                    resultSet = csv.read(string, stringArray, string4);
                    valueResultSet = ValueResultSet.getCopy(resultSet, 0);
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
                finally {
                    csv.close();
                    JdbcUtils.closeSilently(resultSet);
                }
                return valueResultSet;
            }
        }
        return (ValueResultSet)this.getValueWithArgs(session, expressionArray);
    }

    private static void setCsvDelimiterEscape(Csv csv, String string, String string2, String string3) {
        char c2;
        if (string != null) {
            csv.setFieldSeparatorWrite(string);
            if (string.length() > 0) {
                c2 = string.charAt(0);
                csv.setFieldSeparatorRead(c2);
            }
        }
        if (string2 != null) {
            c2 = string2.length() == 0 ? (char)'\u0000' : string2.charAt(0);
            csv.setFieldDelimiter(c2);
        }
        if (string3 != null) {
            c2 = string3.length() == 0 ? (char)'\u0000' : string3.charAt(0);
            csv.setEscapeCharacter(c2);
        }
    }

    @Override
    public Expression[] getArgs() {
        return this.args;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        for (Expression expression : this.args) {
            if (expression == null || expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        switch (expressionVisitor.getType()) {
            case 2: 
            case 5: 
            case 8: {
                return this.info.deterministic;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        int n2 = 3;
        for (Expression expression : this.args) {
            if (expression == null) continue;
            n2 += expression.getCost();
        }
        return n2;
    }

    @Override
    public boolean isDeterministic() {
        return this.info.deterministic;
    }

    @Override
    public boolean isBufferResultSetToLocalTemp() {
        return this.info.bufferResultSetToLocalTemp;
    }

    static {
        DATE_PART.put("SQL_TSI_YEAR", 1);
        DATE_PART.put("YEAR", 1);
        DATE_PART.put("YYYY", 1);
        DATE_PART.put("YY", 1);
        DATE_PART.put("SQL_TSI_MONTH", 2);
        DATE_PART.put("MONTH", 2);
        DATE_PART.put("MM", 2);
        DATE_PART.put("M", 2);
        DATE_PART.put("SQL_TSI_WEEK", 3);
        DATE_PART.put("WW", 3);
        DATE_PART.put("WK", 3);
        DATE_PART.put("WEEK", 3);
        DATE_PART.put("DAY", 5);
        DATE_PART.put("DD", 5);
        DATE_PART.put("D", 5);
        DATE_PART.put("SQL_TSI_DAY", 5);
        DATE_PART.put("DAYOFYEAR", 6);
        DATE_PART.put("DAY_OF_YEAR", 6);
        DATE_PART.put("DY", 6);
        DATE_PART.put("DOY", 6);
        DATE_PART.put("SQL_TSI_HOUR", 11);
        DATE_PART.put("HOUR", 11);
        DATE_PART.put("HH", 11);
        DATE_PART.put("SQL_TSI_MINUTE", 12);
        DATE_PART.put("MINUTE", 12);
        DATE_PART.put("MI", 12);
        DATE_PART.put("N", 12);
        DATE_PART.put("SQL_TSI_SECOND", 13);
        DATE_PART.put("SECOND", 13);
        DATE_PART.put("SS", 13);
        DATE_PART.put("S", 13);
        DATE_PART.put("MILLISECOND", 14);
        DATE_PART.put("MS", 14);
        String string = "7AEIOUY8HW1BFPV2CGJKQSXZ3DT4L5MN6R";
        char c2 = '\u0000';
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = string.charAt(i2);
            if (c3 < '9') {
                c2 = c3;
                continue;
            }
            Function.SOUNDEX_INDEX[c3] = c2;
            Function.SOUNDEX_INDEX[Character.toLowerCase((char)c3)] = c2;
        }
        Function.addFunction("ABS", 0, 1, 0);
        Function.addFunction("ACOS", 1, 1, 7);
        Function.addFunction("ASIN", 2, 1, 7);
        Function.addFunction("ATAN", 3, 1, 7);
        Function.addFunction("ATAN2", 4, 2, 7);
        Function.addFunction("BITAND", 5, 2, 5);
        Function.addFunction("BITOR", 6, 2, 5);
        Function.addFunction("BITXOR", 7, 2, 5);
        Function.addFunction("CEILING", 8, 1, 7);
        Function.addFunction("CEIL", 8, 1, 7);
        Function.addFunction("COS", 9, 1, 7);
        Function.addFunction("COSH", 36, 1, 7);
        Function.addFunction("COT", 10, 1, 7);
        Function.addFunction("DEGREES", 11, 1, 7);
        Function.addFunction("EXP", 12, 1, 7);
        Function.addFunction("FLOOR", 13, 1, 7);
        Function.addFunction("LOG", 14, 1, 7);
        Function.addFunction("LN", 39, 1, 7);
        Function.addFunction("LOG10", 15, 1, 7);
        Function.addFunction("MOD", 16, 2, 5);
        Function.addFunction("PI", 17, 0, 7);
        Function.addFunction("POWER", 18, 2, 7);
        Function.addFunction("RADIANS", 19, 1, 7);
        Function.addFunctionNotDeterministic("RAND", 20, -1, 7);
        Function.addFunctionNotDeterministic("RANDOM", 20, -1, 7);
        Function.addFunction("ROUND", 21, -1, 7);
        Function.addFunction("ROUNDMAGIC", 22, 1, 7);
        Function.addFunction("SIGN", 23, 1, 4);
        Function.addFunction("SIN", 24, 1, 7);
        Function.addFunction("SINH", 37, 1, 7);
        Function.addFunction("SQRT", 25, 1, 7);
        Function.addFunction("TAN", 26, 1, 7);
        Function.addFunction("TANH", 38, 1, 7);
        Function.addFunction("TRUNCATE", 27, -1, 0);
        Function.addFunction("TRUNC", 27, -1, 0);
        Function.addFunction("HASH", 29, 3, 12);
        Function.addFunction("ENCRYPT", 30, 3, 12);
        Function.addFunction("DECRYPT", 31, 3, 12);
        Function.addFunctionNotDeterministic("SECURE_RAND", 28, 1, 12);
        Function.addFunction("COMPRESS", 32, -1, 12);
        Function.addFunction("EXPAND", 33, 1, 12);
        Function.addFunction("ZERO", 34, 0, 4);
        Function.addFunctionNotDeterministic("RANDOM_UUID", 35, 0, 20);
        Function.addFunctionNotDeterministic("SYS_GUID", 35, 0, 20);
        Function.addFunction("ASCII", 50, 1, 4);
        Function.addFunction("BIT_LENGTH", 51, 1, 5);
        Function.addFunction("CHAR", 52, 1, 13);
        Function.addFunction("CHR", 52, 1, 13);
        Function.addFunction("CHAR_LENGTH", 53, 1, 4);
        Function.addFunction("CHARACTER_LENGTH", 53, 1, 4);
        Function.addFunctionWithNull("CONCAT", 54, -1, 13);
        Function.addFunctionWithNull("CONCAT_WS", 92, -1, 13);
        Function.addFunction("DIFFERENCE", 55, 2, 4);
        Function.addFunction("HEXTORAW", 56, 1, 13);
        Function.addFunctionWithNull("INSERT", 57, 4, 13);
        Function.addFunction("LCASE", 59, 1, 13);
        Function.addFunction("LEFT", 60, 2, 13);
        Function.addFunction("LENGTH", 61, 1, 5);
        Function.addFunction("LOCATE", 62, -1, 4);
        Function.addFunction("CHARINDEX", 62, -1, 4);
        Function.addFunction("POSITION", 62, 2, 4);
        Function.addFunction("INSTR", 58, -1, 4);
        Function.addFunction("LTRIM", 63, -1, 13);
        Function.addFunction("OCTET_LENGTH", 64, 1, 5);
        Function.addFunction("RAWTOHEX", 65, 1, 13);
        Function.addFunction("REPEAT", 66, 2, 13);
        Function.addFunction("REPLACE", 67, -1, 13);
        Function.addFunction("RIGHT", 68, 2, 13);
        Function.addFunction("RTRIM", 69, -1, 13);
        Function.addFunction("SOUNDEX", 70, 1, 13);
        Function.addFunction("SPACE", 71, 1, 13);
        Function.addFunction("SUBSTR", 72, -1, 13);
        Function.addFunction("SUBSTRING", 73, -1, 13);
        Function.addFunction("UCASE", 74, 1, 13);
        Function.addFunction("LOWER", 75, 1, 13);
        Function.addFunction("UPPER", 76, 1, 13);
        Function.addFunction("POSITION", 77, 2, 4);
        Function.addFunction("TRIM", 78, -1, 13);
        Function.addFunction("STRINGENCODE", 79, 1, 13);
        Function.addFunction("STRINGDECODE", 80, 1, 13);
        Function.addFunction("STRINGTOUTF8", 81, 1, 12);
        Function.addFunction("UTF8TOSTRING", 82, 1, 13);
        Function.addFunction("XMLATTR", 83, 2, 13);
        Function.addFunctionWithNull("XMLNODE", 84, -1, 13);
        Function.addFunction("XMLCOMMENT", 85, 1, 13);
        Function.addFunction("XMLCDATA", 86, 1, 13);
        Function.addFunction("XMLSTARTDOC", 87, 0, 13);
        Function.addFunction("XMLTEXT", 88, -1, 13);
        Function.addFunction("REGEXP_REPLACE", 89, 3, 13);
        Function.addFunction("RPAD", 90, -1, 13);
        Function.addFunction("LPAD", 91, -1, 13);
        Function.addFunction("TO_CHAR", 93, -1, 13);
        Function.addFunction("ORA_HASH", 95, -1, 4);
        Function.addFunction("TRANSLATE", 94, 3, 13);
        Function.addFunctionNotDeterministic("CURRENT_DATE", 117, 0, 10);
        Function.addFunctionNotDeterministic("CURDATE", 100, 0, 10);
        Function.addFunction("TO_DATE", 96, -1, 13);
        Function.addFunction("TO_TIMESTAMP", 97, -1, 13);
        Function.addFunction("ADD_MONTHS", 98, 2, 11);
        Function.addFunctionNotDeterministic("GETDATE", 100, 0, 10);
        Function.addFunctionNotDeterministic("CURRENT_TIME", 118, 0, 9);
        Function.addFunctionNotDeterministic("CURTIME", 101, 0, 9);
        Function.addFunctionNotDeterministic("CURRENT_TIMESTAMP", 119, -1, 11);
        Function.addFunctionNotDeterministic("NOW", 112, -1, 11);
        Function.addFunction("DATEADD", 102, 3, 11);
        Function.addFunction("TIMESTAMPADD", 102, 3, 5);
        Function.addFunction("DATEDIFF", 103, 3, 5);
        Function.addFunction("TIMESTAMPDIFF", 103, 3, 5);
        Function.addFunction("DAYNAME", 104, 1, 13);
        Function.addFunction("DAYNAME", 104, 1, 13);
        Function.addFunction("DAY", 105, 1, 4);
        Function.addFunction("DAY_OF_MONTH", 105, 1, 4);
        Function.addFunction("DAY_OF_WEEK", 106, 1, 4);
        Function.addFunction("DAY_OF_YEAR", 107, 1, 4);
        Function.addFunction("DAYOFMONTH", 105, 1, 4);
        Function.addFunction("DAYOFWEEK", 106, 1, 4);
        Function.addFunction("DAYOFYEAR", 107, 1, 4);
        Function.addFunction("HOUR", 108, 1, 4);
        Function.addFunction("MINUTE", 109, 1, 4);
        Function.addFunction("MONTH", 110, 1, 4);
        Function.addFunction("MONTHNAME", 111, 1, 13);
        Function.addFunction("QUARTER", 113, 1, 4);
        Function.addFunction("SECOND", 114, 1, 4);
        Function.addFunction("WEEK", 115, 1, 4);
        Function.addFunction("YEAR", 116, 1, 4);
        Function.addFunction("EXTRACT", 120, 2, 4);
        Function.addFunctionWithNull("FORMATDATETIME", 121, -1, 13);
        Function.addFunctionWithNull("PARSEDATETIME", 122, -1, 11);
        Function.addFunction("ISO_YEAR", 123, 1, 4);
        Function.addFunction("ISO_WEEK", 124, 1, 4);
        Function.addFunction("ISO_DAY_OF_WEEK", 125, 1, 4);
        Function.addFunctionNotDeterministic("DATABASE", 150, 0, 13);
        Function.addFunctionNotDeterministic("USER", 151, 0, 13);
        Function.addFunctionNotDeterministic("CURRENT_USER", 152, 0, 13);
        Function.addFunctionNotDeterministic("IDENTITY", 153, 0, 5);
        Function.addFunctionNotDeterministic("SCOPE_IDENTITY", 154, 0, 5);
        Function.addFunctionNotDeterministic("IDENTITY_VAL_LOCAL", 153, 0, 5);
        Function.addFunctionNotDeterministic("LAST_INSERT_ID", 153, 0, 5);
        Function.addFunctionNotDeterministic("LASTVAL", 153, 0, 5);
        Function.addFunctionNotDeterministic("AUTOCOMMIT", 155, 0, 1);
        Function.addFunctionNotDeterministic("READONLY", 156, 0, 1);
        Function.addFunction("DATABASE_PATH", 157, 0, 13);
        Function.addFunctionNotDeterministic("LOCK_TIMEOUT", 158, 0, 4);
        Function.addFunctionWithNull("IFNULL", 200, 2, 0);
        Function.addFunctionWithNull("ISNULL", 200, 2, 0);
        Function.addFunctionWithNull("CASEWHEN", 201, 3, 0);
        Function.addFunctionWithNull("CONVERT", 202, 1, 0);
        Function.addFunctionWithNull("CAST", 203, 1, 0);
        Function.addFunctionWithNull("TRUNCATE_VALUE", 227, 3, 0);
        Function.addFunctionWithNull("COALESCE", 204, -1, 0);
        Function.addFunctionWithNull("NVL", 204, -1, 0);
        Function.addFunctionWithNull("NVL2", 228, 3, 0);
        Function.addFunctionWithNull("NULLIF", 205, 2, 0);
        Function.addFunctionWithNull("CASE", 206, -1, 0);
        Function.addFunctionNotDeterministic("NEXTVAL", 207, -1, 5);
        Function.addFunctionNotDeterministic("CURRVAL", 208, -1, 5);
        Function.addFunction("ARRAY_GET", 209, 2, 13);
        Function.addFunction("ARRAY_CONTAINS", 230, 2, 1, false, true, true);
        Function.addFunction("CSVREAD", 210, -1, 18, false, false, false);
        Function.addFunction("CSVWRITE", 211, -1, 4, false, false, true);
        Function.addFunctionNotDeterministic("MEMORY_FREE", 212, 0, 4);
        Function.addFunctionNotDeterministic("MEMORY_USED", 213, 0, 4);
        Function.addFunctionNotDeterministic("LOCK_MODE", 214, 0, 4);
        Function.addFunctionNotDeterministic("SCHEMA", 215, 0, 13);
        Function.addFunctionNotDeterministic("SESSION_ID", 216, 0, 4);
        Function.addFunction("ARRAY_LENGTH", 217, 1, 4);
        Function.addFunctionNotDeterministic("LINK_SCHEMA", 218, 6, 18);
        Function.addFunctionWithNull("LEAST", 220, -1, 0);
        Function.addFunctionWithNull("GREATEST", 219, -1, 0);
        Function.addFunctionNotDeterministic("CANCEL_SESSION", 221, 1, 1);
        Function.addFunction("SET", 222, 2, 0, false, false, true);
        Function.addFunction("FILE_READ", 225, -1, 0, false, false, true);
        Function.addFunction("FILE_WRITE", 232, 2, 5, false, false, true);
        Function.addFunctionNotDeterministic("TRANSACTION_ID", 226, 0, 13);
        Function.addFunctionWithNull("DECODE", 229, -1, 0);
        Function.addFunctionNotDeterministic("DISK_SPACE_USED", 159, 1, 5);
        Function.addFunction("H2VERSION", 231, 0, 13);
        Function.addFunctionWithNull("TABLE", 223, -1, 18);
        Function.addFunctionWithNull("TABLE_DISTINCT", 224, -1, 18);
        Function.addFunctionWithNull("ROW_NUMBER", 300, 0, 5);
        Function.addFunction("VALUES", 250, 1, 0, false, true, false);
    }
}

