/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;
import org.h2.value.ValueArray;

public class ExpressionList
extends Expression {
    private final Expression[] list;

    public ExpressionList(Expression[] expressionArray) {
        this.list = expressionArray;
    }

    @Override
    public Value getValue(Session session) {
        Value[] valueArray = new Value[this.list.length];
        for (int i2 = 0; i2 < this.list.length; ++i2) {
            valueArray[i2] = this.list[i2].getValue(session);
        }
        return ValueArray.get(valueArray);
    }

    @Override
    public int getType() {
        return 17;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n2) {
        for (Expression expression : this.list) {
            expression.mapColumns(columnResolver, n2);
        }
    }

    @Override
    public Expression optimize(Session session) {
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.list.length; ++i2) {
            Expression expression = this.list[i2].optimize(session);
            if (!expression.isConstant()) {
                bl2 = false;
            }
            this.list[i2] = expression;
        }
        if (bl2) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl2) {
        for (Expression expression : this.list) {
            expression.setEvaluatable(tableFilter, bl2);
        }
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public long getPrecision() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getDisplaySize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        for (Expression expression : this.list) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expression.getSQL());
        }
        if (this.list.length == 1) {
            statementBuilder.append(',');
        }
        return statementBuilder.append(')').toString();
    }

    @Override
    public void updateAggregate(Session session) {
        for (Expression expression : this.list) {
            expression.updateAggregate(session);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        for (Expression expression : this.list) {
            if (expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        int n2 = 1;
        for (Expression expression : this.list) {
            n2 += expression.getCost();
        }
        return n2;
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        Expression[] expressionArray = new ExpressionColumn[this.list.length];
        for (int i2 = 0; i2 < this.list.length; ++i2) {
            Expression expression = this.list[i2];
            Column column = new Column("C" + (i2 + 1), expression.getType(), expression.getPrecision(), expression.getScale(), expression.getDisplaySize());
            expressionArray[i2] = new ExpressionColumn(session.getDatabase(), column);
        }
        return expressionArray;
    }
}

