/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionInSelect
extends Condition {
    private final Database database;
    private Expression left;
    private final Query query;
    private final boolean all;
    private final int compareType;
    private int queryLevel;

    public ConditionInSelect(Database database, Expression expression, Query query, boolean bl2, int n2) {
        this.database = database;
        this.left = expression;
        this.query = query;
        this.all = bl2;
        this.compareType = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value getValue(Session session) {
        this.query.setSession(session);
        if (!this.query.hasOrder()) {
            this.query.setDistinct(true);
        }
        try (LocalResult localResult = this.query.query(0);){
            Value value = this.left.getValue(session);
            if (localResult.getRowCount() == 0) {
                ValueBoolean valueBoolean = ValueBoolean.get(this.all);
                return valueBoolean;
            }
            if (value == ValueNull.INSTANCE) {
                Value value2 = value;
                return value2;
            }
            if (!session.getDatabase().getSettings().optimizeInSelect) {
                Value value3 = this.getValueSlow(localResult, value);
                return value3;
            }
            if (this.all || this.compareType != 0 && this.compareType != 16) {
                Value value4 = this.getValueSlow(localResult, value);
                return value4;
            }
            int n2 = localResult.getColumnType(0);
            if (n2 == 0) {
                ValueBoolean valueBoolean = ValueBoolean.get(false);
                return valueBoolean;
            }
            if (localResult.containsDistinct(new Value[]{value = value.convertTo(n2)})) {
                ValueBoolean valueBoolean = ValueBoolean.get(true);
                return valueBoolean;
            }
            if (localResult.containsDistinct(new Value[]{ValueNull.INSTANCE})) {
                ValueNull valueNull = ValueNull.INSTANCE;
                return valueNull;
            }
            ValueBoolean valueBoolean = ValueBoolean.get(false);
            return valueBoolean;
        }
    }

    private Value getValueSlow(LocalResult localResult, Value value) {
        boolean bl2 = false;
        boolean bl3 = this.all;
        while (localResult.next()) {
            boolean bl4;
            Value value2 = localResult.currentRow()[0];
            if (value2 == ValueNull.INSTANCE) {
                bl4 = false;
                bl2 = true;
            } else {
                bl4 = Comparison.compareNotNull(this.database, value, value2, this.compareType);
            }
            if (!bl4 && this.all) {
                bl3 = false;
                break;
            }
            if (!bl4 || this.all) continue;
            bl3 = true;
            break;
        }
        if (!bl3 && bl2) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(bl3);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n2) {
        this.left.mapColumns(columnResolver, n2);
        this.query.mapColumns(columnResolver, n2 + 1);
        this.queryLevel = Math.max(n2, this.queryLevel);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        this.query.setRandomAccessResult(true);
        session.optimizeQueryExpression(this.query);
        if (this.query.getColumnCount() != 1) {
            throw DbException.get(90052);
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl2) {
        this.left.setEvaluatable(tableFilter, bl2);
        this.query.setEvaluatable(tableFilter, bl2);
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(').append(this.left.getSQL()).append(' ');
        if (this.all) {
            stringBuilder.append(Comparison.getCompareOperator(this.compareType)).append(" ALL");
        } else if (this.compareType == 0) {
            stringBuilder.append("IN");
        } else {
            stringBuilder.append(Comparison.getCompareOperator(this.compareType)).append(" ANY");
        }
        stringBuilder.append("(\n").append(StringUtils.indent(this.query.getPlanSQL(), 4, false)).append("))");
        return stringBuilder.toString();
    }

    @Override
    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
        this.query.updateAggregate(session);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.query.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.query.getCostAsExpression();
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (!session.getDatabase().getSettings().optimizeInList) {
            return;
        }
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getNotFromResolverVisitor(tableFilter);
        if (!this.query.isEverything(expressionVisitor)) {
            return;
        }
        tableFilter.addIndexCondition(IndexCondition.getInQuery(expressionColumn, this.query));
    }
}

