/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class CompareLike
extends Condition {
    private static final int MATCH = 0;
    private static final int ONE = 1;
    private static final int ANY = 2;
    private final CompareMode compareMode;
    private final String defaultEscape;
    private Expression left;
    private Expression right;
    private Expression escape;
    private boolean isInit;
    private char[] patternChars;
    private String patternString;
    private int[] patternTypes;
    private int patternLength;
    private final boolean regexp;
    private Pattern patternRegexp;
    private boolean ignoreCase;
    private boolean fastCompare;
    private boolean invalidPattern;
    private boolean shortcutToStartsWith;

    public CompareLike(Database database, Expression expression, Expression expression2, Expression expression3, boolean bl2) {
        this(database.getCompareMode(), database.getSettings().defaultEscape, expression, expression2, expression3, bl2);
    }

    public CompareLike(CompareMode compareMode, String string, Expression expression, Expression expression2, Expression expression3, boolean bl2) {
        this.compareMode = compareMode;
        this.defaultEscape = string;
        this.regexp = bl2;
        this.left = expression;
        this.right = expression2;
        this.escape = expression3;
    }

    private static Character getEscapeChar(String string) {
        return string == null || string.length() == 0 ? null : Character.valueOf(string.charAt(0));
    }

    @Override
    public String getSQL() {
        String string;
        if (this.regexp) {
            string = this.left.getSQL() + " REGEXP " + this.right.getSQL();
        } else {
            string = this.left.getSQL() + " LIKE " + this.right.getSQL();
            if (this.escape != null) {
                string = string + " ESCAPE " + this.escape.getSQL();
            }
        }
        return "(" + string + ")";
    }

    @Override
    public Expression optimize(Session session) {
        Value value;
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        if (this.left.getType() == 14) {
            this.ignoreCase = true;
        }
        if (this.left.isValueSet() && (value = this.left.getValue(session)) == ValueNull.INSTANCE) {
            return ValueExpression.getNull();
        }
        if (this.escape != null) {
            this.escape = this.escape.optimize(session);
        }
        if (this.right.isValueSet() && (this.escape == null || this.escape.isValueSet())) {
            Value value2;
            if (this.left.isValueSet()) {
                return ValueExpression.get(this.getValue(session));
            }
            value = this.right.getValue(session);
            if (value == ValueNull.INSTANCE) {
                return ValueExpression.getNull();
            }
            Value value3 = value2 = this.escape == null ? null : this.escape.getValue(session);
            if (value2 == ValueNull.INSTANCE) {
                return ValueExpression.getNull();
            }
            String string = value.getString();
            this.initPattern(string, this.getEscapeChar(value2));
            if (this.invalidPattern) {
                return ValueExpression.getNull();
            }
            if ("%".equals(string)) {
                return new Comparison(session, 7, this.left, null).optimize(session);
            }
            if (this.isFullMatch()) {
                Value value4 = ValueString.get(this.patternString);
                ValueExpression valueExpression = ValueExpression.get(value4);
                return new Comparison(session, 0, this.left, valueExpression).optimize(session);
            }
            this.isInit = true;
        }
        return this;
    }

    private Character getEscapeChar(Value value) {
        Character c2;
        if (value == null) {
            return CompareLike.getEscapeChar(this.defaultEscape);
        }
        String string = value.getString();
        if (string == null) {
            c2 = CompareLike.getEscapeChar(this.defaultEscape);
        } else if (string.length() == 0) {
            c2 = null;
        } else {
            if (string.length() > 1) {
                throw DbException.get(22025, string);
            }
            c2 = Character.valueOf(string.charAt(0));
        }
        return c2;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        Value value;
        if (this.regexp) {
            return;
        }
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        if (!this.right.isEverything(ExpressionVisitor.INDEPENDENT_VISITOR)) {
            return;
        }
        if (this.escape != null && !this.escape.isEverything(ExpressionVisitor.INDEPENDENT_VISITOR)) {
            return;
        }
        String string = this.right.getValue(session).getString();
        Value value2 = value = this.escape == null ? null : this.escape.getValue(session);
        if (value == ValueNull.INSTANCE) {
            DbException.throwInternalError();
        }
        this.initPattern(string, this.getEscapeChar(value));
        if (this.invalidPattern) {
            return;
        }
        if (this.patternLength <= 0 || this.patternTypes[0] != 0) {
            return;
        }
        int n2 = expressionColumn.getColumn().getType();
        if (n2 != 13 && n2 != 14 && n2 != 21) {
            return;
        }
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (n3 < this.patternLength && this.patternTypes[n3] == 0) {
            stringBuilder.append(this.patternChars[n3++]);
        }
        String string2 = stringBuilder.toString();
        if (n3 == this.patternLength) {
            tableFilter.addIndexCondition(IndexCondition.get(0, expressionColumn, ValueExpression.get(ValueString.get(string2))));
        } else if (string2.length() > 0) {
            tableFilter.addIndexCondition(IndexCondition.get(1, expressionColumn, ValueExpression.get(ValueString.get(string2))));
            char c2 = string2.charAt(string2.length() - 1);
            for (int i2 = 1; i2 < 2000; ++i2) {
                String string3 = string2.substring(0, string2.length() - 1) + (char)(c2 + i2);
                if (this.compareMode.compareString(string2, string3, this.ignoreCase) != -1) continue;
                tableFilter.addIndexCondition(IndexCondition.get(4, expressionColumn, ValueExpression.get(ValueString.get(string3))));
                break;
            }
        }
    }

    @Override
    public Value getValue(Session session) {
        Object object;
        Value value = this.left.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        if (!this.isInit) {
            Value value2;
            object = this.right.getValue(session);
            if (object == ValueNull.INSTANCE) {
                return object;
            }
            String string = ((Value)object).getString();
            Value value3 = value2 = this.escape == null ? null : this.escape.getValue(session);
            if (value2 == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
            this.initPattern(string, this.getEscapeChar(value2));
        }
        if (this.invalidPattern) {
            return ValueNull.INSTANCE;
        }
        object = value.getString();
        boolean bl2 = this.regexp ? this.patternRegexp.matcher((CharSequence)object).find() : (this.shortcutToStartsWith ? ((String)object).regionMatches(this.ignoreCase, 0, this.patternString, 0, this.patternLength - 1) : this.compareAt((String)object, 0, 0, ((String)object).length(), this.patternChars, this.patternTypes));
        return ValueBoolean.get(bl2);
    }

    private boolean compareAt(String string, int n2, int n3, int n4, char[] cArray, int[] nArray) {
        while (n2 < this.patternLength) {
            switch (nArray[n2]) {
                case 0: {
                    if (n3 < n4 && this.compare(cArray, string, n2, n3++)) break;
                    return false;
                }
                case 1: {
                    if (n3++ < n4) break;
                    return false;
                }
                case 2: {
                    if (++n2 >= this.patternLength) {
                        return true;
                    }
                    while (n3 < n4) {
                        if (this.compare(cArray, string, n2, n3) && this.compareAt(string, n2, n3, n4, cArray, nArray)) {
                            return true;
                        }
                        ++n3;
                    }
                    return false;
                }
                default: {
                    DbException.throwInternalError();
                }
            }
            ++n2;
        }
        return n3 == n4;
    }

    private boolean compare(char[] cArray, String string, int n2, int n3) {
        return cArray[n2] == string.charAt(n3) || !this.fastCompare && this.compareMode.equalsChars(this.patternString, n2, string, n3, this.ignoreCase);
    }

    public boolean test(String string, String string2, char c2) {
        this.initPattern(string, Character.valueOf(c2));
        if (this.invalidPattern) {
            return false;
        }
        return this.compareAt(string2, 0, 0, string2.length(), this.patternChars, this.patternTypes);
    }

    private void initPattern(String string, Character c2) {
        int n2;
        if (this.compareMode.getName().equals("OFF") && !this.ignoreCase) {
            this.fastCompare = true;
        }
        if (this.regexp) {
            this.patternString = string;
            try {
                this.patternRegexp = this.ignoreCase ? Pattern.compile(string, 2) : Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DbException.get(22025, patternSyntaxException, string);
            }
            return;
        }
        this.patternLength = 0;
        if (string == null) {
            this.patternTypes = null;
            this.patternChars = null;
            return;
        }
        int n3 = string.length();
        this.patternChars = new char[n3];
        this.patternTypes = new int[n3];
        boolean bl2 = false;
        for (n2 = 0; n2 < n3; ++n2) {
            int n4;
            char c3 = string.charAt(n2);
            if (c2 != null && c2.charValue() == c3) {
                if (n2 >= n3 - 1) {
                    this.invalidPattern = true;
                    return;
                }
                c3 = string.charAt(++n2);
                n4 = 0;
                bl2 = false;
            } else if (c3 == '%') {
                if (bl2) continue;
                n4 = 2;
                bl2 = true;
            } else if (c3 == '_') {
                n4 = 1;
            } else {
                n4 = 0;
                bl2 = false;
            }
            this.patternTypes[this.patternLength] = n4;
            this.patternChars[this.patternLength++] = c3;
        }
        for (n2 = 0; n2 < this.patternLength - 1; ++n2) {
            if (this.patternTypes[n2] != 2 || this.patternTypes[n2 + 1] != 1) continue;
            this.patternTypes[n2] = 1;
            this.patternTypes[n2 + 1] = 2;
        }
        this.patternString = new String(this.patternChars, 0, this.patternLength);
        if (this.compareMode.getName().equals("OFF") && this.patternLength > 1) {
            for (n2 = 0; n2 < this.patternLength && this.patternTypes[n2] == 0; ++n2) {
            }
            if (n2 == this.patternLength - 1 && this.patternTypes[this.patternLength - 1] == 2) {
                this.shortcutToStartsWith = true;
            }
        }
    }

    private boolean isFullMatch() {
        if (this.patternTypes == null) {
            return false;
        }
        for (int n2 : this.patternTypes) {
            if (n2 == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n2) {
        this.left.mapColumns(columnResolver, n2);
        this.right.mapColumns(columnResolver, n2);
        if (this.escape != null) {
            this.escape.mapColumns(columnResolver, n2);
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl2) {
        this.left.setEvaluatable(tableFilter, bl2);
        this.right.setEvaluatable(tableFilter, bl2);
        if (this.escape != null) {
            this.escape.setEvaluatable(tableFilter, bl2);
        }
    }

    @Override
    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
        this.right.updateAggregate(session);
        if (this.escape != null) {
            this.escape.updateAggregate(session);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor) && (this.escape == null || this.escape.isEverything(expressionVisitor));
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.right.getCost() + 3;
    }
}

