/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Database;
import org.h2.expression.AggregateData;
import org.h2.message.DbException;
import org.h2.util.ValueHashMap;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;

class AggregateDataDefault
extends AggregateData {
    private final int aggregateType;
    private long count;
    private ValueHashMap<AggregateDataDefault> distinctValues;
    private Value value;
    private double m2;
    private double mean;

    AggregateDataDefault(int n2) {
        this.aggregateType = n2;
    }

    @Override
    void add(Database database, int n2, boolean bl2, Value value) {
        if (value == ValueNull.INSTANCE) {
            return;
        }
        ++this.count;
        if (bl2) {
            if (this.distinctValues == null) {
                this.distinctValues = ValueHashMap.newInstance();
            }
            this.distinctValues.put(value, this);
            return;
        }
        switch (this.aggregateType) {
            case 3: {
                if (this.value == null) {
                    this.value = value.convertTo(n2);
                    break;
                }
                value = value.convertTo(this.value.getType());
                this.value = this.value.add(value);
                break;
            }
            case 6: {
                if (this.value == null) {
                    this.value = value.convertTo(DataType.getAddProofType(n2));
                    break;
                }
                value = value.convertTo(this.value.getType());
                this.value = this.value.add(value);
                break;
            }
            case 4: {
                if (this.value != null && database.compare(value, this.value) >= 0) break;
                this.value = value;
                break;
            }
            case 5: {
                if (this.value != null && database.compare(value, this.value) <= 0) break;
                this.value = value;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                double d2 = value.getDouble();
                if (this.count == 1L) {
                    this.mean = d2;
                    this.m2 = 0.0;
                    break;
                }
                double d3 = d2 - this.mean;
                this.mean += d3 / (double)this.count;
                this.m2 += d3 * (d2 - this.mean);
                break;
            }
            case 12: {
                value = value.convertTo(1);
                if (this.value == null) {
                    this.value = value;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() != false && value.getBoolean() != false);
                break;
            }
            case 11: {
                value = value.convertTo(1);
                if (this.value == null) {
                    this.value = value;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() != false || value.getBoolean() != false);
                break;
            }
            case 14: {
                if (this.value == null) {
                    this.value = value.convertTo(n2);
                    break;
                }
                this.value = ValueLong.get(this.value.getLong() & value.getLong()).convertTo(n2);
                break;
            }
            case 13: {
                if (this.value == null) {
                    this.value = value.convertTo(n2);
                    break;
                }
                this.value = ValueLong.get(this.value.getLong() | value.getLong()).convertTo(n2);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.aggregateType);
            }
        }
    }

    @Override
    Value getValue(Database database, int n2, boolean bl2) {
        if (bl2) {
            this.count = 0L;
            this.groupDistinct(database, n2);
        }
        Value value = null;
        switch (this.aggregateType) {
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                value = this.value;
                break;
            }
            case 6: {
                if (this.value == null) break;
                value = AggregateDataDefault.divide(this.value, this.count);
                break;
            }
            case 7: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                value = ValueDouble.get(Math.sqrt(this.m2 / (double)this.count));
                break;
            }
            case 8: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                value = ValueDouble.get(Math.sqrt(this.m2 / (double)(this.count - 1L)));
                break;
            }
            case 9: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                value = ValueDouble.get(this.m2 / (double)this.count);
                break;
            }
            case 10: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                value = ValueDouble.get(this.m2 / (double)(this.count - 1L));
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.aggregateType);
            }
        }
        return value == null ? ValueNull.INSTANCE : value.convertTo(n2);
    }

    private static Value divide(Value value, long l2) {
        if (l2 == 0L) {
            return ValueNull.INSTANCE;
        }
        int n2 = Value.getHigherOrder(value.getType(), 5);
        Value value2 = ValueLong.get(l2).convertTo(n2);
        value = value.convertTo(n2).divide(value2);
        return value;
    }

    private void groupDistinct(Database database, int n2) {
        if (this.distinctValues == null) {
            return;
        }
        this.count = 0L;
        for (Value value : this.distinctValues.keys()) {
            this.add(database, n2, false, value);
        }
    }
}

