/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.engine.UndoLog;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.FileStore;
import org.h2.table.Table;
import org.h2.value.Value;

public class UndoLogRecord {
    public static final short INSERT = 0;
    public static final short DELETE = 1;
    private static final int IN_MEMORY = 0;
    private static final int STORED = 1;
    private static final int IN_MEMORY_INVALID = 2;
    private Table table;
    private Row row;
    private short operation;
    private short state;
    private int filePos;

    UndoLogRecord(Table table, short s2, Row row) {
        this.table = table;
        this.row = row;
        this.operation = s2;
        this.state = 0;
    }

    boolean isStored() {
        return this.state == 1;
    }

    boolean canStore() {
        return this.table.getUniqueIndex() != null;
    }

    void undo(Session session) {
        Database database = session.getDatabase();
        switch (this.operation) {
            case 0: {
                if (this.state == 2) {
                    this.state = 0;
                }
                if (database.getLockMode() == 0 && this.row.isDeleted()) {
                    return;
                }
                try {
                    this.row.setDeleted(false);
                    this.table.removeRow(session, this.row);
                    this.table.fireAfterRow(session, this.row, null, true);
                    break;
                }
                catch (DbException dbException) {
                    if (session.getDatabase().getLockMode() == 0 && dbException.getErrorCode() == 90112) break;
                    throw dbException;
                }
            }
            case 1: {
                try {
                    this.table.addRow(session, this.row);
                    this.table.fireAfterRow(session, null, this.row, true);
                    this.row.commit();
                    break;
                }
                catch (DbException dbException) {
                    if (session.getDatabase().getLockMode() == 0 && dbException.getSQLException().getErrorCode() == 23505) break;
                    throw dbException;
                }
            }
            default: {
                DbException.throwInternalError("op=" + this.operation);
            }
        }
    }

    void append(Data data, UndoLog undoLog) {
        int n2 = data.length();
        data.writeInt(0);
        data.writeInt(this.operation);
        data.writeByte(this.row.isDeleted() ? (byte)1 : 0);
        data.writeInt(undoLog.getTableId(this.table));
        data.writeLong(this.row.getKey());
        data.writeInt(this.row.getSessionId());
        int n3 = this.row.getColumnCount();
        data.writeInt(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            Value value = this.row.getValue(i2);
            data.checkCapacity(data.getValueLen(value));
            data.writeValue(value);
        }
        data.fillAligned();
        data.setInt(n2, (data.length() - n2) / 16);
    }

    void save(Data data, FileStore fileStore, UndoLog undoLog) {
        data.reset();
        this.append(data, undoLog);
        this.filePos = (int)(fileStore.getFilePointer() / 16L);
        fileStore.write(data.getBytes(), 0, data.length());
        this.row = null;
        this.state = 1;
    }

    static UndoLogRecord loadFromBuffer(Data data, UndoLog undoLog) {
        UndoLogRecord undoLogRecord = new UndoLogRecord(null, 0, null);
        int n2 = data.length();
        int n3 = data.readInt() * 16;
        undoLogRecord.load(data, undoLog);
        data.setPos(n2 + n3);
        return undoLogRecord;
    }

    void load(Data data, FileStore fileStore, UndoLog undoLog) {
        int n2 = 16;
        undoLog.seek(this.filePos);
        data.reset();
        fileStore.readFully(data.getBytes(), 0, n2);
        int n3 = data.readInt() * 16;
        data.checkCapacity(n3);
        if (n3 - n2 > 0) {
            fileStore.readFully(data.getBytes(), n2, n3 - n2);
        }
        short s2 = this.operation;
        this.load(data, undoLog);
        if (SysProperties.CHECK && this.operation != s2) {
            DbException.throwInternalError("operation=" + this.operation + " op=" + s2);
        }
    }

    private void load(Data data, UndoLog undoLog) {
        this.operation = (short)data.readInt();
        boolean bl2 = data.readByte() == 1;
        this.table = undoLog.getTable(data.readInt());
        long l2 = data.readLong();
        int n2 = data.readInt();
        int n3 = data.readInt();
        Value[] valueArray = new Value[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            valueArray[i2] = data.readValue();
        }
        this.row = this.getTable().getDatabase().createRow(valueArray, -1);
        this.row.setKey(l2);
        this.row.setDeleted(bl2);
        this.row.setSessionId(n2);
        this.state = (short)2;
    }

    public Table getTable() {
        return this.table;
    }

    public long getFilePos() {
        return this.filePos;
    }

    void commit() {
        this.table.commit(this.operation, this.row);
    }

    public Row getRow() {
        return this.row;
    }

    void invalidatePos() {
        if (this.state == 0) {
            this.state = (short)2;
        }
    }
}

