/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.ArrayList;
import java.util.HashMap;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.engine.UndoLogRecord;
import org.h2.message.DbException;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.table.Table;
import org.h2.util.New;

public class UndoLog {
    private final Database database;
    private final ArrayList<Long> storedEntriesPos = New.arrayList();
    private final ArrayList<UndoLogRecord> records = New.arrayList();
    private FileStore file;
    private Data rowBuff;
    private int memoryUndo;
    private int storedEntries;
    private HashMap<Integer, Table> tables;
    private final boolean largeTransactions;

    UndoLog(Session session) {
        this.database = session.getDatabase();
        this.largeTransactions = this.database.getSettings().largeTransactions;
    }

    int size() {
        if (this.largeTransactions) {
            return this.storedEntries + this.records.size();
        }
        if (SysProperties.CHECK && this.memoryUndo > this.records.size()) {
            DbException.throwInternalError();
        }
        return this.records.size();
    }

    void clear() {
        this.records.clear();
        this.storedEntries = 0;
        this.storedEntriesPos.clear();
        this.memoryUndo = 0;
        if (this.file != null) {
            this.file.closeAndDeleteSilently();
            this.file = null;
            this.rowBuff = null;
        }
    }

    public UndoLogRecord getLast() {
        UndoLogRecord undoLogRecord;
        int n2 = this.records.size() - 1;
        if (this.largeTransactions) {
            if (n2 < 0 && this.storedEntries > 0) {
                int n3 = this.storedEntriesPos.size() - 1;
                long l2 = this.storedEntriesPos.get(n3);
                this.storedEntriesPos.remove(n3);
                long l3 = this.file.length();
                int n4 = (int)(l3 - l2);
                Data data = Data.create((DataHandler)this.database, n4);
                this.file.seek(l2);
                this.file.readFully(data.getBytes(), 0, n4);
                while (data.length() < n4) {
                    UndoLogRecord undoLogRecord2 = UndoLogRecord.loadFromBuffer(data, this);
                    this.records.add(undoLogRecord2);
                    ++this.memoryUndo;
                }
                this.storedEntries -= this.records.size();
                this.file.setLength(l2);
                this.file.seek(l2);
            }
            n2 = this.records.size() - 1;
        }
        if ((undoLogRecord = this.records.get(n2)).isStored()) {
            UndoLogRecord undoLogRecord3;
            int n5;
            int n6 = Math.max(0, n2 - this.database.getMaxMemoryUndo() / 2);
            UndoLogRecord undoLogRecord4 = null;
            for (n5 = n6; n5 <= n2; ++n5) {
                undoLogRecord3 = this.records.get(n5);
                if (!undoLogRecord3.isStored()) continue;
                undoLogRecord3.load(this.rowBuff, this.file, this);
                ++this.memoryUndo;
                if (undoLogRecord4 != null) continue;
                undoLogRecord4 = undoLogRecord3;
            }
            for (n5 = 0; n5 < n2; ++n5) {
                undoLogRecord3 = this.records.get(n5);
                undoLogRecord3.invalidatePos();
            }
            this.seek(undoLogRecord4.getFilePos());
        }
        return undoLogRecord;
    }

    void seek(long l2) {
        this.file.seek(l2 * 16L);
    }

    void removeLast(boolean bl2) {
        int n2 = this.records.size() - 1;
        UndoLogRecord undoLogRecord = this.records.remove(n2);
        if (!undoLogRecord.isStored()) {
            --this.memoryUndo;
        }
        if (bl2 && n2 > 1024 && (n2 & 0x3FF) == 0) {
            this.records.trimToSize();
        }
    }

    void add(UndoLogRecord undoLogRecord) {
        this.records.add(undoLogRecord);
        if (this.largeTransactions) {
            ++this.memoryUndo;
            if (this.memoryUndo > this.database.getMaxMemoryUndo() && this.database.isPersistent() && !this.database.isMultiVersion()) {
                Object object;
                if (this.file == null) {
                    object = this.database.createTempFile();
                    this.file = this.database.openFile((String)object, "rw", false);
                    this.file.setCheckedWriting(false);
                    this.file.setLength(48L);
                }
                object = Data.create((DataHandler)this.database, 4096);
                for (int i2 = 0; i2 < this.records.size(); ++i2) {
                    UndoLogRecord undoLogRecord2 = this.records.get(i2);
                    ((Data)object).checkCapacity(4096);
                    undoLogRecord2.append((Data)object, this);
                    if (i2 != this.records.size() - 1 && ((Data)object).length() <= 0x100000) continue;
                    this.storedEntriesPos.add(this.file.getFilePointer());
                    this.file.write(((Data)object).getBytes(), 0, ((Data)object).length());
                    ((Data)object).reset();
                }
                this.storedEntries += this.records.size();
                this.memoryUndo = 0;
                this.records.clear();
                this.file.autoDelete();
                return;
            }
        } else {
            if (!undoLogRecord.isStored()) {
                ++this.memoryUndo;
            }
            if (this.memoryUndo > this.database.getMaxMemoryUndo() && this.database.isPersistent() && !this.database.isMultiVersion()) {
                if (this.file == null) {
                    String string = this.database.createTempFile();
                    this.file = this.database.openFile(string, "rw", false);
                    this.file.setCheckedWriting(false);
                    this.file.seek(48L);
                    Data data = this.rowBuff = Data.create((DataHandler)this.database, 4096);
                    for (int i3 = 0; i3 < this.records.size(); ++i3) {
                        UndoLogRecord undoLogRecord3 = this.records.get(i3);
                        this.saveIfPossible(undoLogRecord3, data);
                    }
                } else {
                    this.saveIfPossible(undoLogRecord, this.rowBuff);
                }
                this.file.autoDelete();
            }
        }
    }

    private void saveIfPossible(UndoLogRecord undoLogRecord, Data data) {
        if (!undoLogRecord.isStored() && undoLogRecord.canStore()) {
            undoLogRecord.save(data, this.file, this);
            --this.memoryUndo;
        }
    }

    int getTableId(Table table) {
        int n2 = table.getId();
        if (this.tables == null) {
            this.tables = New.hashMap();
        }
        this.tables.put(n2, table);
        return n2;
    }

    Table getTable(int n2) {
        return this.tables.get(n2);
    }
}

