/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.HashMap;
import org.h2.message.DbException;
import org.h2.util.Utils;

public class SettingsBase {
    private final HashMap<String, String> settings;

    protected SettingsBase(HashMap<String, String> hashMap) {
        this.settings = hashMap;
    }

    protected boolean get(String string, boolean bl2) {
        String string2 = this.get(string, "" + bl2);
        try {
            return Boolean.parseBoolean(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw DbException.get(22018, numberFormatException, "key:" + string + " value:" + string2);
        }
    }

    protected int get(String string, int n2) {
        String string2 = this.get(string, "" + n2);
        try {
            return Integer.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw DbException.get(22018, numberFormatException, "key:" + string + " value:" + string2);
        }
    }

    protected String get(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("h2.");
        boolean bl2 = false;
        for (char c2 : string.toCharArray()) {
            if (c2 == '_') {
                bl2 = true;
                continue;
            }
            stringBuilder.append(bl2 ? Character.toUpperCase(c2) : Character.toLowerCase(c2));
            bl2 = false;
        }
        String string3 = stringBuilder.toString();
        String string4 = this.settings.get(string);
        if (string4 == null) {
            string4 = Utils.getProperty(string3, string2);
            this.settings.put(string, string4);
        }
        return string4;
    }

    protected boolean containsKey(String string) {
        return this.settings.containsKey(string);
    }

    public HashMap<String, String> getSettings() {
        return this.settings;
    }
}

