/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QueryStatisticsData {
    private static final Comparator<QueryEntry> QUERY_ENTRY_COMPARATOR = new Comparator<QueryEntry>(){

        @Override
        public int compare(QueryEntry queryEntry, QueryEntry queryEntry2) {
            return (int)Math.signum(queryEntry.lastUpdateTime - queryEntry2.lastUpdateTime);
        }
    };
    private final HashMap<String, QueryEntry> map = new HashMap();
    private int maxQueryEntries;

    public QueryStatisticsData(int n2) {
        this.maxQueryEntries = n2;
    }

    public synchronized void setMaxQueryEntries(int n2) {
        this.maxQueryEntries = n2;
    }

    public synchronized List<QueryEntry> getQueries() {
        ArrayList<QueryEntry> arrayList = new ArrayList<QueryEntry>();
        arrayList.addAll(this.map.values());
        Collections.sort(arrayList, QUERY_ENTRY_COMPARATOR);
        return arrayList.subList(0, Math.min(arrayList.size(), this.maxQueryEntries));
    }

    public synchronized void update(String string, long l2, int n2) {
        QueryEntry queryEntry = this.map.get(string);
        if (queryEntry == null) {
            queryEntry = new QueryEntry();
            queryEntry.sqlStatement = string;
            this.map.put(string, queryEntry);
        }
        queryEntry.update(l2, n2);
        if ((float)this.map.size() > (float)this.maxQueryEntries * 1.5f) {
            ArrayList<QueryEntry> arrayList = new ArrayList<QueryEntry>();
            arrayList.addAll(this.map.values());
            Collections.sort(arrayList, QUERY_ENTRY_COMPARATOR);
            HashSet hashSet = new HashSet(arrayList.subList(0, arrayList.size() / 3));
            Iterator<Map.Entry<String, QueryEntry>> iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, QueryEntry> entry = iterator.next();
                if (!hashSet.contains(entry.getValue())) continue;
                iterator.remove();
            }
        }
    }

    public static final class QueryEntry {
        public String sqlStatement;
        public int count;
        public long lastUpdateTime;
        public long executionTimeMin;
        public long executionTimeMax;
        public long executionTimeCumulative;
        public int rowCountMin;
        public int rowCountMax;
        public long rowCountCumulative;
        public double executionTimeMean;
        public double rowCountMean;
        private double executionTimeM2;
        private double rowCountM2;

        void update(long l2, int n2) {
            ++this.count;
            this.executionTimeMin = Math.min(l2, this.executionTimeMin);
            this.executionTimeMax = Math.max(l2, this.executionTimeMax);
            this.rowCountMin = Math.min(n2, this.rowCountMin);
            this.rowCountMax = Math.max(n2, this.rowCountMax);
            double d2 = (double)n2 - this.rowCountMean;
            this.rowCountMean += d2 / (double)this.count;
            this.rowCountM2 += d2 * ((double)n2 - this.rowCountMean);
            d2 = (double)l2 - this.executionTimeMean;
            this.executionTimeMean += d2 / (double)this.count;
            this.executionTimeM2 += d2 * ((double)l2 - this.executionTimeMean);
            this.executionTimeCumulative += l2;
            this.rowCountCumulative += (long)n2;
            this.lastUpdateTime = System.currentTimeMillis();
        }

        public double getExecutionTimeStandardDeviation() {
            return Math.sqrt(this.executionTimeM2 / (double)this.count);
        }

        public double getRowCountStandardDeviation() {
            return Math.sqrt(this.rowCountM2 / (double)this.count);
        }
    }
}

