/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.lang.ref.WeakReference;
import org.h2.engine.Database;
import org.h2.message.Trace;

class DatabaseCloser
extends Thread {
    private final boolean shutdownHook;
    private final Trace trace;
    private volatile WeakReference<Database> databaseRef;
    private int delayInMillis;

    DatabaseCloser(Database database, int n2, boolean bl2) {
        this.databaseRef = new WeakReference<Database>(database);
        this.delayInMillis = n2;
        this.shutdownHook = bl2;
        this.trace = database.getTrace(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        DatabaseCloser databaseCloser = this;
        synchronized (databaseCloser) {
            this.databaseRef = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.delayInMillis > 0) {
            try {
                int n2 = 100;
                Thread.sleep(n2);
                this.delayInMillis -= n2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.databaseRef != null) continue;
            return;
        }
        Database database = null;
        DatabaseCloser databaseCloser = this;
        synchronized (databaseCloser) {
            if (this.databaseRef != null) {
                database = (Database)this.databaseRef.get();
            }
        }
        if (database != null) {
            try {
                database.close(this.shutdownHook);
            }
            catch (RuntimeException runtimeException) {
                try {
                    this.trace.error(runtimeException, "could not close the database");
                }
                catch (RuntimeException runtimeException2) {
                    throw runtimeException;
                }
            }
        }
    }
}

