/*
 * Decompiled with CFR 0.152.
 */
package org.h2.compress;

import java.io.IOException;
import java.io.OutputStream;
import org.h2.compress.CompressLZF;

public class LZFOutputStream
extends OutputStream {
    static final int MAGIC = 1211255123;
    private final OutputStream out;
    private final CompressLZF compress = new CompressLZF();
    private final byte[] buffer;
    private int pos;
    private byte[] outBuffer;

    public LZFOutputStream(OutputStream outputStream) throws IOException {
        this.out = outputStream;
        int n2 = 131072;
        this.buffer = new byte[n2];
        this.ensureOutput(n2);
        this.writeInt(1211255123);
    }

    private void ensureOutput(int n2) {
        int n3 = (n2 < 100 ? n2 + 100 : n2) * 2;
        if (this.outBuffer == null || this.outBuffer.length < n3) {
            this.outBuffer = new byte[n3];
        }
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.pos >= this.buffer.length) {
            this.flush();
        }
        this.buffer[this.pos++] = (byte)n2;
    }

    private void compressAndWrite(byte[] byArray, int n2) throws IOException {
        if (n2 > 0) {
            this.ensureOutput(n2);
            int n3 = this.compress.compress(byArray, n2, this.outBuffer, 0);
            if (n3 > n2) {
                this.writeInt(-n2);
                this.out.write(byArray, 0, n2);
            } else {
                this.writeInt(n3);
                this.writeInt(n2);
                this.out.write(this.outBuffer, 0, n3);
            }
        }
    }

    private void writeInt(int n2) throws IOException {
        this.out.write((byte)(n2 >> 24));
        this.out.write((byte)(n2 >> 16));
        this.out.write((byte)(n2 >> 8));
        this.out.write((byte)n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            int n4 = Math.min(this.buffer.length - this.pos, n3);
            System.arraycopy(byArray, n2, this.buffer, this.pos, n4);
            this.pos += n4;
            if (this.pos >= this.buffer.length) {
                this.flush();
            }
            n2 += n4;
            n3 -= n4;
        }
    }

    @Override
    public void flush() throws IOException {
        this.compressAndWrite(this.buffer, this.pos);
        this.pos = 0;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }
}

