/*
 * Decompiled with CFR 0.152.
 */
package org.h2.compress;

import java.io.IOException;
import java.io.InputStream;
import org.h2.compress.CompressLZF;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;

public class LZFInputStream
extends InputStream {
    private final InputStream in;
    private CompressLZF decompress = new CompressLZF();
    private int pos;
    private int bufferLength;
    private byte[] inBuffer;
    private byte[] buffer;

    public LZFInputStream(InputStream inputStream) throws IOException {
        this.in = inputStream;
        if (this.readInt() != 1211255123) {
            throw new IOException("Not an LZFInputStream");
        }
    }

    private static byte[] ensureSize(byte[] byArray, int n2) {
        return byArray == null || byArray.length < n2 ? DataUtils.newBytes(n2) : byArray;
    }

    private void fillBuffer() throws IOException {
        if (this.buffer != null && this.pos < this.bufferLength) {
            return;
        }
        int n2 = this.readInt();
        if (this.decompress == null) {
            this.bufferLength = 0;
        } else if (n2 < 0) {
            n2 = -n2;
            this.buffer = LZFInputStream.ensureSize(this.buffer, n2);
            this.readFully(this.buffer, n2);
            this.bufferLength = n2;
        } else {
            this.inBuffer = LZFInputStream.ensureSize(this.inBuffer, n2);
            int n3 = this.readInt();
            this.readFully(this.inBuffer, n2);
            this.buffer = LZFInputStream.ensureSize(this.buffer, n3);
            try {
                this.decompress.expand(this.inBuffer, 0, n2, this.buffer, 0, n3);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                DbException.convertToIOException(arrayIndexOutOfBoundsException);
            }
            this.bufferLength = n3;
        }
        this.pos = 0;
    }

    private void readFully(byte[] byArray, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.in.read(byArray, n3, n2);
            n2 -= n4;
            n3 += n4;
        }
    }

    private int readInt() throws IOException {
        int n2 = this.in.read();
        if (n2 < 0) {
            this.decompress = null;
            return 0;
        }
        n2 = (n2 << 24) + (this.in.read() << 16) + (this.in.read() << 8) + this.in.read();
        return n2;
    }

    @Override
    public int read() throws IOException {
        this.fillBuffer();
        if (this.pos >= this.bufferLength) {
            return -1;
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (n3 == 0) {
            return 0;
        }
        int n5 = 0;
        while (n3 > 0 && (n4 = this.readBlock(byArray, n2, n3)) >= 0) {
            n5 += n4;
            n2 += n4;
            n3 -= n4;
        }
        return n5 == 0 ? -1 : n5;
    }

    private int readBlock(byte[] byArray, int n2, int n3) throws IOException {
        this.fillBuffer();
        if (this.pos >= this.bufferLength) {
            return -1;
        }
        int n4 = Math.min(n3, this.bufferLength - this.pos);
        n4 = Math.min(n4, byArray.length - n2);
        System.arraycopy(this.buffer, this.pos, byArray, n2, n4);
        this.pos += n4;
        return n4;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

