/*
 * Decompiled with CFR 0.152.
 */
package org.h2.compress;

import java.nio.ByteBuffer;
import org.h2.compress.Compressor;

public final class CompressLZF
implements Compressor {
    private static final int HASH_SIZE = 16384;
    private static final int MAX_LITERAL = 32;
    private static final int MAX_OFF = 8192;
    private static final int MAX_REF = 264;
    private int[] cachedHashTable;

    @Override
    public void setOptions(String string) {
    }

    private static int first(byte[] byArray, int n2) {
        return byArray[n2] << 8 | byArray[n2 + 1] & 0xFF;
    }

    private static int first(ByteBuffer byteBuffer, int n2) {
        return byteBuffer.get(n2) << 8 | byteBuffer.get(n2 + 1) & 0xFF;
    }

    private static int next(int n2, byte[] byArray, int n3) {
        return n2 << 8 | byArray[n3 + 2] & 0xFF;
    }

    private static int next(int n2, ByteBuffer byteBuffer, int n3) {
        return n2 << 8 | byteBuffer.get(n3 + 2) & 0xFF;
    }

    private static int hash(int n2) {
        return n2 * 2777 >> 9 & 0x3FFF;
    }

    @Override
    public int compress(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = 0;
        if (this.cachedHashTable == null) {
            this.cachedHashTable = new int[16384];
        }
        int[] nArray = this.cachedHashTable;
        int n5 = 0;
        ++n3;
        int n6 = CompressLZF.first(byArray, 0);
        while (n4 < n2 - 4) {
            byte by2 = byArray[n4 + 2];
            n6 = (n6 << 8) + (by2 & 0xFF);
            int n7 = CompressLZF.hash(n6);
            int n8 = nArray[n7];
            nArray[n7] = n4;
            if (n8 < n4 && n8 > 0 && (n7 = n4 - n8 - 1) < 8192 && byArray[n8 + 2] == by2 && byArray[n8 + 1] == (byte)(n6 >> 8) && byArray[n8] == (byte)(n6 >> 16)) {
                int n9;
                int n10 = n2 - n4 - 2;
                if (n10 > 264) {
                    n10 = 264;
                }
                if (n5 == 0) {
                    --n3;
                } else {
                    byArray2[n3 - n5 - 1] = (byte)(n5 - 1);
                    n5 = 0;
                }
                for (n9 = 3; n9 < n10 && byArray[n8 + n9] == byArray[n4 + n9]; ++n9) {
                }
                if ((n9 -= 2) < 7) {
                    byArray2[n3++] = (byte)((n7 >> 8) + (n9 << 5));
                } else {
                    byArray2[n3++] = (byte)((n7 >> 8) + 224);
                    byArray2[n3++] = (byte)(n9 - 7);
                }
                byArray2[n3++] = (byte)n7;
                ++n3;
                n6 = CompressLZF.first(byArray, n4 += n9);
                n6 = CompressLZF.next(n6, byArray, n4);
                nArray[CompressLZF.hash((int)n6)] = n4++;
                n6 = CompressLZF.next(n6, byArray, n4);
                nArray[CompressLZF.hash((int)n6)] = n4++;
                continue;
            }
            byArray2[n3++] = byArray[n4++];
            if (++n5 != 32) continue;
            byArray2[n3 - n5 - 1] = (byte)(n5 - 1);
            n5 = 0;
            ++n3;
        }
        while (n4 < n2) {
            byArray2[n3++] = byArray[n4++];
            if (++n5 != 32) continue;
            byArray2[n3 - n5 - 1] = (byte)(n5 - 1);
            n5 = 0;
            ++n3;
        }
        byArray2[n3 - n5 - 1] = (byte)(n5 - 1);
        if (n5 == 0) {
            --n3;
        }
        return n3;
    }

    public int compress(ByteBuffer byteBuffer, int n2, byte[] byArray, int n3) {
        int n4 = byteBuffer.capacity() - n2;
        if (this.cachedHashTable == null) {
            this.cachedHashTable = new int[16384];
        }
        int[] nArray = this.cachedHashTable;
        int n5 = 0;
        ++n3;
        int n6 = CompressLZF.first(byteBuffer, 0);
        while (n2 < n4 - 4) {
            byte by2 = byteBuffer.get(n2 + 2);
            n6 = (n6 << 8) + (by2 & 0xFF);
            int n7 = CompressLZF.hash(n6);
            int n8 = nArray[n7];
            nArray[n7] = n2;
            if (n8 < n2 && n8 > 0 && (n7 = n2 - n8 - 1) < 8192 && byteBuffer.get(n8 + 2) == by2 && byteBuffer.get(n8 + 1) == (byte)(n6 >> 8) && byteBuffer.get(n8) == (byte)(n6 >> 16)) {
                int n9;
                int n10 = n4 - n2 - 2;
                if (n10 > 264) {
                    n10 = 264;
                }
                if (n5 == 0) {
                    --n3;
                } else {
                    byArray[n3 - n5 - 1] = (byte)(n5 - 1);
                    n5 = 0;
                }
                for (n9 = 3; n9 < n10 && byteBuffer.get(n8 + n9) == byteBuffer.get(n2 + n9); ++n9) {
                }
                if ((n9 -= 2) < 7) {
                    byArray[n3++] = (byte)((n7 >> 8) + (n9 << 5));
                } else {
                    byArray[n3++] = (byte)((n7 >> 8) + 224);
                    byArray[n3++] = (byte)(n9 - 7);
                }
                byArray[n3++] = (byte)n7;
                ++n3;
                n6 = CompressLZF.first(byteBuffer, n2 += n9);
                n6 = CompressLZF.next(n6, byteBuffer, n2);
                nArray[CompressLZF.hash((int)n6)] = n2++;
                n6 = CompressLZF.next(n6, byteBuffer, n2);
                nArray[CompressLZF.hash((int)n6)] = n2++;
                continue;
            }
            byArray[n3++] = byteBuffer.get(n2++);
            if (++n5 != 32) continue;
            byArray[n3 - n5 - 1] = (byte)(n5 - 1);
            n5 = 0;
            ++n3;
        }
        while (n2 < n4) {
            byArray[n3++] = byteBuffer.get(n2++);
            if (++n5 != 32) continue;
            byArray[n3 - n5 - 1] = (byte)(n5 - 1);
            n5 = 0;
            ++n3;
        }
        byArray[n3 - n5 - 1] = (byte)(n5 - 1);
        if (n5 == 0) {
            --n3;
        }
        return n3;
    }

    @Override
    public void expand(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        if (n2 < 0 || n4 < 0 || n5 < 0) {
            throw new IllegalArgumentException();
        }
        do {
            int n6;
            if ((n6 = byArray[n2++] & 0xFF) < 32) {
                System.arraycopy(byArray, n2, byArray2, n4, ++n6);
                n4 += n6;
                n2 += n6;
                continue;
            }
            int n7 = n6 >> 5;
            if (n7 == 7) {
                n7 += byArray[n2++] & 0xFF;
            }
            n6 = -((n6 & 0x1F) << 8) - 1;
            n6 -= byArray[n2++] & 0xFF;
            n6 += n4;
            if (n4 + (n7 += 2) >= byArray2.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            for (int i2 = 0; i2 < n7; ++i2) {
                byArray2[n4++] = byArray2[n6++];
            }
        } while (n4 < n5);
    }

    public static void expand(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        do {
            int n2;
            int n3;
            if ((n3 = byteBuffer.get() & 0xFF) < 32) {
                ++n3;
                for (n2 = 0; n2 < n3; ++n2) {
                    byteBuffer2.put(byteBuffer.get());
                }
            } else {
                n2 = n3 >> 5;
                if (n2 == 7) {
                    n2 += byteBuffer.get() & 0xFF;
                }
                n2 += 2;
                n3 = -((n3 & 0x1F) << 8) - 1;
                n3 -= byteBuffer.get() & 0xFF;
                n3 += byteBuffer2.position();
                for (int i2 = 0; i2 < n2; ++i2) {
                    byteBuffer2.put(byteBuffer2.get(n3++));
                }
            }
        } while (byteBuffer2.position() < byteBuffer2.capacity());
    }

    @Override
    public int getAlgorithm() {
        return 1;
    }
}

